/*
 * Decompiled with CFR 0.152.
 */
package colim;

import colim.COLIM_DEFS;
import colim.COLIM_GRAPH;
import colim.COLIM_VECTOR;
import colim.INT_VECTOR;
import colim.SET_DIAGRAM;

public class GRAPH_DIAGRAM
implements COLIM_DEFS {
    private SET_DIAGRAM f_node_diagram = new SET_DIAGRAM();
    private SET_DIAGRAM f_edge_diagram = new SET_DIAGRAM();
    private INT_VECTOR f_coprod_source = new INT_VECTOR();
    private INT_VECTOR f_coprod_target = new INT_VECTOR();
    private COLIM_GRAPH f_colim_graph;
    private boolean f_colimit_valid;

    public GRAPH_DIAGRAM() {
        this.f_coprod_source.push_back(0);
        this.f_coprod_target.push_back(0);
        this.f_colimit_valid = false;
    }

    public int insert_object(COLIM_GRAPH cOLIM_GRAPH, String string) {
        int n = this.f_node_diagram.coproduct_size();
        int n2 = this.f_node_diagram.insert_object(cOLIM_GRAPH.f_node, string);
        int n3 = this.f_edge_diagram.insert_object(cOLIM_GRAPH.f_edge, string);
        for (int i = 0; i < cOLIM_GRAPH.f_edge.size(); ++i) {
            this.f_coprod_source.push_back(cOLIM_GRAPH.f_source.item(i) + n);
            this.f_coprod_target.push_back(cOLIM_GRAPH.f_target.item(i) + n);
        }
        this.f_colimit_valid = false;
        return n2;
    }

    public int insert_morphism(INT_VECTOR iNT_VECTOR, INT_VECTOR iNT_VECTOR2, int n, int n2) {
        int n3 = this.f_node_diagram.insert_morphism(iNT_VECTOR, n, n2);
        int n4 = this.f_edge_diagram.insert_morphism(iNT_VECTOR2, n, n2);
        this.f_colimit_valid = false;
        return n3;
    }

    public COLIM_GRAPH get_colimit_graph() {
        if (!this.f_colimit_valid) {
            this.compute_colimit();
        }
        return this.f_colim_graph;
    }

    public COLIM_VECTOR get_colimit_nodes() {
        return this.f_node_diagram.get_colimit_set();
    }

    public COLIM_VECTOR get_colimit_edges() {
        return this.f_edge_diagram.get_colimit_set();
    }

    public Object get_source(int n) {
        return this.f_node_diagram.get_element(this.f_coprod_source.item(n));
    }

    public Object get_target(int n) {
        return this.f_node_diagram.get_element(this.f_coprod_target.item(n));
    }

    public SET_DIAGRAM get_node_diagram() {
        return this.f_node_diagram;
    }

    public SET_DIAGRAM get_edge_diagram() {
        return this.f_edge_diagram;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("\nsort diagram:\n");
        stringBuffer.append(this.f_node_diagram.toString());
        stringBuffer.append("\nedge_diagram:\n");
        stringBuffer.append(this.f_edge_diagram.toString());
        COLIM_GRAPH cOLIM_GRAPH = new COLIM_GRAPH(this.f_node_diagram.get_coproduct_set(), this.f_edge_diagram.get_coproduct_set(), this.f_coprod_source, this.f_coprod_target);
        stringBuffer.append("\ncoproduct:\n");
        stringBuffer.append(cOLIM_GRAPH.toString());
        stringBuffer.append("\n");
        return new String(stringBuffer);
    }

    private void compute_colimit() {
        int n;
        int n2;
        this.f_colim_graph = new COLIM_GRAPH();
        INT_VECTOR iNT_VECTOR = this.f_node_diagram.get_colimit_indices();
        for (int i = 0; i < iNT_VECTOR.size(); ++i) {
            COLIM_VECTOR cOLIM_VECTOR = new COLIM_VECTOR();
            int n3 = this.f_colim_graph.insert_node((Object)cOLIM_VECTOR);
        }
        INT_VECTOR iNT_VECTOR2 = this.f_edge_diagram.get_colimit_indices();
        for (n2 = 0; n2 < iNT_VECTOR2.size(); ++n2) {
            COLIM_VECTOR cOLIM_VECTOR = new COLIM_VECTOR();
            int n4 = this.f_node_diagram.get_colimit_pos(this.f_coprod_source.item(iNT_VECTOR2.item(n2)));
            int n5 = this.f_node_diagram.get_colimit_pos(this.f_coprod_target.item(iNT_VECTOR2.item(n2)));
            if (n4 != -1 && n5 != -1) {
                n = this.f_colim_graph.insert_edge((Object)cOLIM_VECTOR, n4, n5);
                continue;
            }
            this.f_edge_diagram.delete_element(iNT_VECTOR2.item(n2));
        }
        for (n2 = 1; n2 < this.f_node_diagram.coproduct_size(); ++n2) {
            int n6 = this.f_node_diagram.get_colimit_pos(n2);
            if (n6 == -1) continue;
            COLIM_VECTOR cOLIM_VECTOR = (COLIM_VECTOR)((Object)this.f_colim_graph.node_attr(n6));
            cOLIM_VECTOR.push_back(this.f_node_diagram.get_element(n2));
        }
        for (n2 = 1; n2 < this.f_edge_diagram.coproduct_size(); ++n2) {
            n = this.f_edge_diagram.get_colimit_pos(n2);
            if (n == -1) continue;
            COLIM_VECTOR cOLIM_VECTOR = (COLIM_VECTOR)((Object)this.f_colim_graph.edge_attr(n));
            cOLIM_VECTOR.push_back(this.f_edge_diagram.get_element(n2));
        }
        this.f_colimit_valid = true;
    }
}

