/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.gui.impl;

import agg.attribute.AttrInstance;
import agg.attribute.AttrInstanceMember;
import agg.attribute.AttrManager;
import agg.attribute.AttrMember;
import agg.attribute.AttrTuple;
import agg.attribute.AttrType;
import agg.attribute.gui.AttrEditorManager;
import agg.attribute.gui.impl.BasicTupleEditor;
import agg.attribute.handler.AttrHandlerException;
import agg.attribute.handler.HandlerExpr;
import agg.attribute.util.RowDragEvent;
import agg.attribute.util.RowDragListener;
import agg.attribute.util.TableRowDragger;
import agg.attribute.view.AttrViewEvent;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class ExtendedTupleEditorSupport
extends BasicTupleEditor
implements ListSelectionListener,
RowDragListener {
    protected Action deleteAction;
    protected Action evaluateAction;
    protected Action resetAction;
    protected Action showAllAction;
    protected Action hideAllAction;
    protected Vector tupleActions;
    protected Vector memberActions;
    protected boolean rowSelectionEnabled;
    protected boolean rowDraggingEnabled;
    protected TableRowDragger rowDragger;
    protected boolean rowDraggingDisablingRequested;
    protected JTextArea outputTextArea;
    protected JScrollPane outputScrollPane;
    protected JPanel toolBarPanel;
    protected JSplitPane tableAndOutputSplitPane;

    public ExtendedTupleEditorSupport(AttrManager m, AttrEditorManager em) {
        super(m, em);
    }

    protected void createTableView() {
        super.createTableView();
        this.tableView.getTableHeader().setReorderingAllowed(true);
        this.setRowSelectionEnabled(true);
        this.setRowDraggingEnabled(true);
    }

    protected void genericCreateAllViews() {
        this.createTableView();
        this.createOutputTextArea();
        this.createToolBar();
    }

    public void setRowSelectionEnabled(boolean b) {
        if (b) {
            this.tableView.setRowSelectionAllowed(true);
            this.tableView.setColumnSelectionAllowed(false);
            this.tableView.setSelectionMode(0);
            if (!this.rowSelectionEnabled) {
                this.rowSelectionEnabled = true;
                this.tableView.getSelectionModel().addListSelectionListener(this);
            }
        } else {
            this.tableView.setRowSelectionAllowed(false);
            this.tableView.setColumnSelectionAllowed(false);
            if (this.rowSelectionEnabled) {
                this.rowSelectionEnabled = false;
                this.tableView.getSelectionModel().removeListSelectionListener(this);
            }
        }
    }

    public void setRowDraggingEnabled(boolean b) {
        if (b) {
            if (this.rowDragger == null) {
                this.rowDragger = new TableRowDragger(this.tableView);
            }
            if (!this.rowDraggingEnabled) {
                this.rowDraggingEnabled = true;
                this.rowDragger.addRowDragListener(this);
            }
        } else if (this.rowDraggingEnabled) {
            if (this.isDraggingActive()) {
                this.rowDraggingDisablingRequested = true;
            } else {
                this.rowDraggingEnabled = false;
                this.rowDragger.removeRowDragListener(this);
            }
        }
    }

    protected void setTupleActionsEnabled(boolean b) {
        Enumeration en = this.tupleActions.elements();
        while (en.hasMoreElements()) {
            ((Action)en.nextElement()).setEnabled(b);
        }
    }

    protected void setMemberActionsEnabled(boolean b) {
        Enumeration en = this.memberActions.elements();
        while (en.hasMoreElements()) {
            ((Action)en.nextElement()).setEnabled(b);
        }
    }

    protected void addTupleAction(Action a) {
        if (this.tupleActions == null) {
            this.tupleActions = new Vector(4);
        }
        this.tupleActions.addElement(a);
    }

    protected void addMemberAction(Action a) {
        if (this.memberActions == null) {
            this.memberActions = new Vector(4);
        }
        this.memberActions.addElement(a);
    }

    protected Action getResetAction() {
        if (this.resetAction != null) {
            return this.resetAction;
        }
        AbstractAction action = new AbstractAction("Reset"){

            public void actionPerformed(ActionEvent ev) {
                if (ExtendedTupleEditorSupport.this.tuple == null) {
                    return;
                }
                ExtendedTupleEditorSupport.this.viewSetting.resetTuple(ExtendedTupleEditorSupport.this.tuple);
            }
        };
        action.putValue("ShortDescription", "Back to the original layout.");
        this.addTupleAction(action);
        this.resetAction = action;
        return action;
    }

    protected Action getShowAllAction() {
        if (this.showAllAction != null) {
            return this.showAllAction;
        }
        AbstractAction action = new AbstractAction("Show All"){

            public void actionPerformed(ActionEvent ev) {
                if (ExtendedTupleEditorSupport.this.tuple == null) {
                    return;
                }
                ExtendedTupleEditorSupport.this.viewSetting.setAllVisible(ExtendedTupleEditorSupport.this.tuple, true);
            }
        };
        action.putValue("ShortDescription", "Makes all tuple members visible.");
        this.addTupleAction(action);
        this.showAllAction = action;
        return action;
    }

    protected Action getHideAllAction() {
        if (this.hideAllAction != null) {
            return this.hideAllAction;
        }
        AbstractAction action = new AbstractAction("Hide All"){

            public void actionPerformed(ActionEvent ev) {
                if (ExtendedTupleEditorSupport.this.tuple == null) {
                    return;
                }
                ExtendedTupleEditorSupport.this.viewSetting.setAllVisible(ExtendedTupleEditorSupport.this.tuple, false);
            }
        };
        action.putValue("ShortDescription", "Hides all tuple members.");
        this.addTupleAction(action);
        this.hideAllAction = action;
        return action;
    }

    protected Action getDeleteAction() {
        if (this.deleteAction != null) {
            return this.deleteAction;
        }
        AbstractAction action = new AbstractAction("Delete"){

            public void actionPerformed(ActionEvent ev) {
                if (ExtendedTupleEditorSupport.this.tuple == null) {
                    return;
                }
                AttrType type = ((AttrInstance)ExtendedTupleEditorSupport.this.tuple).getType();
                int slot = ExtendedTupleEditorSupport.this.tableView.getSelectedRow();
                if (slot >= type.getNumberOfEntries(ExtendedTupleEditorSupport.this.viewSetting)) {
                    return;
                }
                type.deleteMemberAt(ExtendedTupleEditorSupport.this.viewSetting, slot);
            }
        };
        action.putValue("ShortDescription", "Removes the selected member");
        this.addMemberAction(action);
        this.deleteAction = action;
        return action;
    }

    protected Action getEvaluateAction() {
        if (this.evaluateAction != null) {
            return this.evaluateAction;
        }
        AbstractAction action = new AbstractAction("Evaluate"){

            public void actionPerformed(ActionEvent ev) {
                AttrInstanceMember member = ExtendedTupleEditorSupport.this.getSelectedMember();
                if (member == null) {
                    return;
                }
                HandlerExpr expr = member.getExpr();
                if (expr == null) {
                    return;
                }
                try {
                    expr.evaluate(((AttrInstance)ExtendedTupleEditorSupport.this.tuple).getContext());
                    member.setExpr(expr);
                }
                catch (AttrHandlerException ex) {
                    ExtendedTupleEditorSupport.this.setMessage(ex.getMessage());
                }
            }
        };
        action.putValue("ShortDescription", "Evaluates the expression");
        this.addMemberAction(action);
        this.evaluateAction = action;
        return action;
    }

    protected void createOutputTextArea() {
        this.outputTextArea = new JTextArea(5, 5);
        this.outputTextArea.setEditable(false);
        this.outputTextArea.setLineWrap(false);
        this.outputScrollPane = new JScrollPane(this.outputTextArea, 20, 30);
        this.outputScrollPane.setMinimumSize(new Dimension(60, 15));
        this.outputScrollPane.setPreferredSize(new Dimension(100, 80));
    }

    public void displayValidityReport() {
        if (this.tuple == null) {
            return;
        }
        this.setMessage("");
        int row = this.tableView.getSelectedRow();
        if (row < this.tuple.getNumberOfEntries() && row >= 0) {
            this.displayValidityReport(row);
        }
    }

    public void displayValidityReport(int row) {
        this.displayValidityReport(this.tableModel.getMember(this.tuple, row));
    }

    public void displayValidityReport(AttrMember m) {
        this.setMessage(m.getValidityReport());
    }

    public void setMessage(String text) {
        if (this.outputTextArea == null) {
            return;
        }
        if (text != null) {
            this.outputTextArea.setText(text.replaceAll("\n", "  "));
        } else {
            this.outputTextArea.setText(text);
        }
    }

    protected abstract void createToolBar();

    public void draggingStarted(RowDragEvent ev) {
        this.setMessage("...Moving row...");
    }

    public void draggingStopped(RowDragEvent ev) {
        if (this.rowDraggingDisablingRequested) {
            this.rowDraggingDisablingRequested = false;
            this.setRowDraggingEnabled(false);
        }
        this.displayValidityReport();
    }

    public void draggingMoved(RowDragEvent ev) {
        int src = ev.getSourceRow();
        int dest = ev.getTargetRow();
        src = Math.min(src, this.tuple.getNumberOfEntries() - 1);
        if ((dest = Math.min(dest, this.tuple.getNumberOfEntries() - 1)) == -1 || src == -1) {
            return;
        }
        if (dest == src) {
            return;
        }
        if (src < dest) {
            ++dest;
        }
        this.viewSetting.moveSlotInserting(this.tuple, src, dest);
    }

    protected boolean isDraggingActive() {
        if (!this.rowDraggingEnabled) {
            return false;
        }
        return this.rowDragger.isDraggingActive();
    }

    protected void memberRowSelected(int row) {
        this.displayValidityReport();
        this.setMemberActionsEnabled(true);
    }

    protected void newRowSelected() {
        this.setMessage("A new member can be added in this row.");
        this.setMemberActionsEnabled(false);
    }

    public void valueChanged(ListSelectionEvent ev) {
        if (this.tuple == null) {
            return;
        }
        if (this.isDraggingActive()) {
            return;
        }
        int row = ev.getFirstIndex();
        if (row < this.tuple.getNumberOfEntries() && row >= 0) {
            this.memberRowSelected(row);
        } else if (row == this.tuple.getNumberOfEntries()) {
            this.newRowSelected();
        }
    }

    public void setTuple(AttrTuple anAttrTuple) {
        super.setTuple(anAttrTuple);
        this.setTupleActionsEnabled(anAttrTuple != null);
        this.setMemberActionsEnabled(false);
    }

    public void attributeChanged(AttrViewEvent event) {
        super.attributeChanged(event);
        if (!this.isDraggingActive()) {
            this.displayValidityReport();
        }
    }
}

