/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.gui.impl;

import agg.attribute.AttrManager;
import agg.attribute.gui.AttrEditor;
import agg.attribute.gui.AttrEditorManager;
import agg.attribute.gui.impl.AbstractEditor;
import agg.attribute.handler.AttrHandler;
import agg.attribute.handler.gui.HandlerCustomizingEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ScrollPaneConstants;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.table.AbstractTableModel;

public class ManagerCustomizingEditor
extends AbstractEditor
implements AttrEditor,
ScrollPaneConstants {
    protected JTable handlerList;
    protected JPanel handlerListP;
    protected Box messageBox;
    protected String[][] handlerData;
    protected String[] headers = null;

    public ManagerCustomizingEditor(AttrManager m, AttrEditorManager em) {
        super(m, em);
    }

    protected void genericCreateAllViews() {
        if (this.headers == null) {
            String[] h = new String[]{"Name", "Class", "Editor Class"};
            this.headers = h;
        }
        AttrHandler[] handlers = this.getAttrManager().getHandlers();
        this.handlerData = new String[handlers.length][];
        for (int i = 0; i < handlers.length; ++i) {
            AttrHandler h = handlers[i];
            HandlerCustomizingEditor handlerEditor = this.getHandlerEditorManager().getCustomizingEditor(h);
            String handlerEditorName = "(None)";
            if (handlerEditor != null) {
                handlerEditorName = handlerEditor.getClass().getName();
            }
            String[] row = new String[]{h.getName(), h.getClass().getName(), handlerEditorName};
            this.handlerData[i] = row;
        }
        AbstractTableModel model = new AbstractTableModel(){

            public Object getValueAt(int row, int column) {
                return ManagerCustomizingEditor.this.handlerData[row][column];
            }

            public int getRowCount() {
                return ManagerCustomizingEditor.this.handlerData.length;
            }

            public int getColumnCount() {
                return 3;
            }

            public String getColumnName(int column) {
                return ManagerCustomizingEditor.this.headers[column];
            }
        };
        this.handlerList = new JTable(this.handlerData, this.headers);
        this.handlerList.getTableHeader().setReorderingAllowed(false);
        JScrollPane tabScrollPane = new JScrollPane(this.handlerList);
        tabScrollPane.setPreferredSize(new Dimension(800, 100));
        JScrollPane listScrollPane = new JScrollPane(tabScrollPane, 20, 30);
        listScrollPane.setBorder(new BevelBorder(1));
        listScrollPane.setPreferredSize(new Dimension(250, 100));
        this.handlerListP = new JPanel();
        this.handlerListP.setLayout(new BorderLayout());
        this.handlerListP.add((Component)listScrollPane, "Center");
        this.handlerListP.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(), "Registered Attribute Handlers", 1, 2));
        this.messageBox = Box.createVerticalBox();
        this.messageBox.add(new JLabel("For now, just displaying."));
        this.messageBox.add(new JLabel("Registration of handlers at runtime would be nice ..."));
    }

    protected void arrangeMainPanel() {
    }

    protected void genericCustomizeMainLayout() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)this.handlerListP, "North");
        this.mainPanel.add((Component)this.messageBox, "Center");
    }
}

