/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.gui.impl;

import agg.attribute.AttrConditionTuple;
import agg.attribute.AttrEvent;
import agg.attribute.AttrInstance;
import agg.attribute.AttrInstanceMember;
import agg.attribute.AttrMember;
import agg.attribute.AttrTuple;
import agg.attribute.AttrTypeMember;
import agg.attribute.AttrVariableMember;
import agg.attribute.gui.AttrTupleEditor;
import agg.attribute.gui.impl.TupleTableModelConstants;
import agg.attribute.handler.AttrHandler;
import agg.attribute.handler.AttrHandlerException;
import agg.attribute.handler.HandlerExpr;
import agg.attribute.handler.impl.javaExpr.JexHandler;
import agg.attribute.impl.AttrSession;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.DeclTuple;
import agg.attribute.impl.ValueMember;
import javax.swing.table.AbstractTableModel;

public class TupleTableModel
extends AbstractTableModel
implements TupleTableModelConstants {
    protected static final int COLUMN_INDEX = 0;
    protected static final int COLUMN_TITLE = 1;
    protected static final int COLUMN_CLASS = 2;
    protected static final int COLUMN_EDITABLE = 3;
    protected static final int N_COLUMN_PROPERTIES = 4;
    protected boolean isExtensible = false;
    protected int[] columnArray = new int[]{3, 4};
    protected Object[][] columnData = new Object[10][4];
    protected AttrTupleEditor editor = null;
    protected AttrHandler defaultHandler = null;
    protected int currentColumn;
    protected boolean valueChanged;
    protected boolean typeValueChanged;

    public TupleTableModel(AttrTupleEditor editor) {
        this.editor = editor;
        String handlerName = JexHandler.getLabelName();
        this.defaultHandler = editor.getAttrManager().getHandler(handlerName);
        this.initColumnProperties();
    }

    public void setColumnArray(int[] keys) {
        int i;
        if (keys == null) {
            keys = new int[]{};
        }
        this.columnArray = keys;
        for (i = 0; i < 10; ++i) {
            this.columnData[i][0] = new Integer(-1);
        }
        for (i = 0; i < this.columnArray.length; ++i) {
            this.columnData[this.columnArray[i]][0] = new Integer(i);
        }
    }

    public void setExtensible(boolean b) {
        this.isExtensible = b;
    }

    public boolean isExtensible() {
        return this.isExtensible;
    }

    public void setColumnTitle(int key, String title) {
        this.setColumnProperty(key, 1, title);
    }

    public void setColumnClass(int key, Class clazz) {
        this.setColumnProperty(key, 2, clazz);
    }

    public void setColumnEditable(int key, boolean b) {
        this.setColumnProperty(key, 3, new Boolean(b));
    }

    public AttrMember getMember(AttrTuple tuple, int row) {
        return tuple.getMemberAt(this.editor.getViewSetting(), row);
    }

    public final int getItemKeyAt(int column) {
        return this.columnArray[column];
    }

    public final int getColumnAtKey(int key) {
        return (Integer)this.columnData[key][0];
    }

    public void attributeChanged(AttrEvent event) {
        if (event == null) {
            this.valueChanged = false;
        }
        this.fireTableDataChanged();
    }

    protected void setColumnProperty(int key, int propertyKey, Object property) {
        this.columnData[key][propertyKey] = property;
    }

    protected Object getColumnProperty(int key, int propertyKey) {
        return this.columnData[key][propertyKey];
    }

    public int getRowCount() {
        AttrTuple tuple = this.editor.getTuple();
        if (tuple == null) {
            return 0;
        }
        int nMembers = tuple.getNumberOfEntries(this.editor.getViewSetting());
        if (this.isExtensible()) {
            ++nMembers;
        }
        return nMembers;
    }

    protected void initColumnProperties() {
        Class<?> stringClass = "".getClass();
        Class<?> booleanClass = Boolean.TRUE.getClass();
        this.setColumnTitle(0, "???");
        this.setColumnClass(0, null);
        this.setColumnEditable(0, false);
        this.setColumnTitle(1, "Handler");
        this.setColumnClass(1, stringClass);
        this.setColumnEditable(1, false);
        this.setColumnTitle(2, "Type");
        this.setColumnClass(2, stringClass);
        this.setColumnEditable(2, true);
        this.setColumnTitle(3, "Name");
        this.setColumnClass(3, stringClass);
        this.setColumnEditable(3, true);
        this.setColumnTitle(4, "Expression");
        this.setColumnClass(4, stringClass);
        this.setColumnEditable(4, true);
        this.setColumnTitle(9, "Yields");
        this.setColumnClass(9, stringClass);
        this.setColumnEditable(9, false);
        this.setColumnTitle(8, "OK");
        this.setColumnClass(8, booleanClass);
        this.setColumnEditable(8, false);
        this.setColumnTitle(6, "In");
        this.setColumnClass(6, booleanClass);
        this.setColumnEditable(6, true);
        this.setColumnTitle(7, "Out");
        this.setColumnClass(7, booleanClass);
        this.setColumnEditable(7, true);
        this.setColumnTitle(5, "Shown");
        this.setColumnClass(5, booleanClass);
        this.setColumnEditable(5, true);
    }

    protected Object getItem(AttrMember member, int key, AttrTuple tuple, int row) {
        AttrInstanceMember m = (AttrInstanceMember)member;
        if (m == null) {
            return null;
        }
        switch (key) {
            case 1: {
                return m.getDeclaration().getHandler().getName();
            }
            case 2: {
                return m.getDeclaration().getTypeName();
            }
            case 3: {
                return m.getDeclaration().getName();
            }
            case 5: {
                return new Boolean(this.editor.getViewSetting().isVisible(tuple, row));
            }
            case 4: {
                return m.getExprAsText();
            }
            case 8: {
                return new Boolean(m.isValid() && m.getDeclaration().isValid());
            }
            case 9: {
                return new Boolean(m.isValid() && m.getDeclaration().isValid());
            }
            case 6: {
                return new Boolean(((AttrVariableMember)m).isInputParameter());
            }
            case 7: {
                return new Boolean(((AttrVariableMember)m).isOutputParameter());
            }
        }
        return null;
    }

    protected Object getItemOfNewRow(int key, AttrTuple tuple, int row) {
        switch (key) {
            default: 
        }
        return null;
    }

    protected void setItem(Object aValue, AttrMember member, int key, AttrTuple tuple, int row) {
        AttrInstanceMember m = (AttrInstanceMember)member;
        switch (key) {
            case 1: {
                AttrSession.stdoutPrintln(AttrSession.logTrace, "Handler");
                m.getDeclaration().setHandler((AttrHandler)aValue);
                break;
            }
            case 2: {
                AttrSession.stdoutPrintln(AttrSession.logTrace, "Type");
                m.getDeclaration().setType((String)aValue);
                break;
            }
            case 3: {
                AttrSession.stdoutPrintln(AttrSession.logTrace, "Name");
                m.getDeclaration().setName((String)aValue);
                if (!m.isSet()) break;
                if (((DeclTuple)((DeclMember)m.getDeclaration()).getHoldingTuple()).isClassName(m.getExprAsText())) {
                    m.setExpr(null);
                    break;
                }
                ((ValueMember)m).checkValidity(m.getExpr());
                if (m.isValid()) break;
                m.setExpr(null);
                break;
            }
            case 5: {
                AttrSession.stdoutPrintln(AttrSession.logTrace, "Visibility");
                this.editor.getViewSetting().setVisibleAt(tuple, (Boolean)aValue, row);
                break;
            }
            case 4: {
                AttrSession.stdoutPrintln(AttrSession.logTrace, "Expr");
                HandlerExpr expr = m.getExpr();
                String newText = (String)aValue;
                if (newText.equals("")) {
                    m.setExprAsText(newText);
                    break;
                }
                if (expr != null && newText != null && newText.equals(((Object)expr).toString())) break;
                try {
                    newText = this.isStaticMethodCall((String)aValue);
                    HandlerExpr expression = ((ValueMember)m).getHandler().newHandlerExpr(((ValueMember)m).getDeclaration().getType(), newText);
                    ((ValueMember)m).checkValidity(expression);
                    if (m.isValid()) {
                        m.setExprAsText(newText);
                        break;
                    }
                    System.out.println("TupleTableModel.setItem:: Validity Report:  " + m.getValidityReport());
                }
                catch (AttrHandlerException ex) {
                    System.out.println("TupleTableModel.setItem::  AttrHandlerException:  " + ex);
                }
                break;
            }
            case 6: {
                AttrSession.stdoutPrintln(AttrSession.logTrace, "Is_Input_Parameter");
                ((AttrVariableMember)m).setInputParameter((Boolean)aValue);
                break;
            }
            case 7: {
                AttrSession.stdoutPrintln(AttrSession.logTrace, "Is_Out_Parameter");
                ((AttrVariableMember)m).setOutputParameter((Boolean)aValue);
                break;
            }
        }
        AttrSession.logPrintln(AttrSession.logTrace, "TupleTableModel:\n<-setItem");
    }

    private String isStaticMethodCall(String aValue) {
        if (aValue.indexOf("$") == 0) {
            int ind = aValue.substring(1).indexOf("$");
            if (ind > 0) {
                String clstr = aValue.substring(1, ind + 1);
                try {
                    Class<?> c = Class.forName(clstr);
                    String tst = clstr.substring(clstr.indexOf(".") + 1);
                    while (tst.indexOf(".") != -1) {
                        clstr = tst.concat("");
                        tst = clstr.substring(clstr.indexOf(".") + 1);
                    }
                    clstr = tst.concat("");
                    String result = clstr + aValue.substring(ind + 2);
                    return result;
                }
                catch (ClassNotFoundException ex) {}
            }
        } else {
            String tst = aValue;
            String pname = null;
            String tmp = "";
            while (tst.indexOf(".") != -1) {
                String next = tst.substring(0, tst.indexOf("."));
                Package p = Package.getPackage(tmp + next);
                if (p != null) {
                    pname = p.getName();
                    tmp = p.getName();
                } else {
                    tmp = tmp + next;
                }
                tmp = tmp + ".";
                tst = tst.substring(tst.indexOf(".") + 1, tst.length());
            }
            if (pname != null) {
                String result = aValue.replaceFirst(pname + ".", "");
                String clstr = result.substring(0, result.indexOf("."));
                try {
                    Class<?> c = Class.forName(pname + "." + clstr);
                    return result;
                }
                catch (ClassNotFoundException ex) {
                    // empty catch block
                }
            }
        }
        return aValue;
    }

    protected void setItemOfNewRow(Object aValue, int key, AttrTuple tuple, int row) {
        AttrSession.logPrintln(AttrSession.logTrace, "TupleTableModel:\n->setItemOfNewRow\nnumber of entries: " + tuple.getNumberOfEntries());
        if (tuple instanceof AttrConditionTuple) {
            ((AttrConditionTuple)tuple).addCondition((String)aValue);
            return;
        }
        AttrTypeMember typeMember = ((AttrInstance)tuple).getType().addMember();
        typeMember.setHandler(this.defaultHandler);
        int lastIndex = tuple.getNumberOfEntries() - 1;
        AttrInstanceMember m = (AttrInstanceMember)tuple.getMemberAt(lastIndex);
        this.setItem(aValue, m, key, tuple, row);
        AttrSession.logPrintln(AttrSession.logTrace, "TupleTableModel:\n<-setItemOfNewRow");
    }

    protected String getItemLabel(int key) {
        String label = (String)this.getColumnProperty(key, 1);
        return label;
    }

    protected Class getItemClass(int key) {
        Class c = (Class)this.getColumnProperty(key, 2);
        return c;
    }

    protected boolean isItemEditable(AttrMember member, int key) {
        return (Boolean)this.getColumnProperty(key, 3);
    }

    protected boolean isNewRowEditable(int key) {
        return (Boolean)this.getColumnProperty(key, 3);
    }

    public final int getColumnCount() {
        return this.columnArray.length;
    }

    public final Object getValueAt(int row, int column) {
        AttrTuple tuple = this.editor.getTuple();
        if (tuple == null) {
            return null;
        }
        if (row >= tuple.getNumberOfEntries()) {
            return this.getItemOfNewRow(this.getItemKeyAt(column), tuple, row);
        }
        return this.getItem(this.getMember(tuple, row), this.getItemKeyAt(column), tuple, row);
    }

    public final String getColumnName(int column) {
        return this.getItemLabel(this.getItemKeyAt(column));
    }

    public final int getChangedColumn() {
        return this.currentColumn;
    }

    public final boolean isColumnValueChanged() {
        return this.valueChanged;
    }

    public final boolean isTypeColumnValueChanged() {
        return this.typeValueChanged;
    }

    public final boolean isCellEditable(int row, int column) {
        AttrTuple tuple = this.editor.getTuple();
        if (tuple == null) {
            return false;
        }
        if (row >= tuple.getNumberOfEntries()) {
            return this.isNewRowEditable(this.getItemKeyAt(column));
        }
        return this.isItemEditable(this.getMember(tuple, row), this.getItemKeyAt(column));
    }

    public final void setValueAt(Object aValue, int row, int column) {
        Object oldvalue = this.getValueAt(row, column);
        AttrTuple tuple = this.editor.getTuple();
        this.currentColumn = column;
        if (tuple == null) {
            return;
        }
        int key = this.getItemKeyAt(column);
        if (row >= tuple.getNumberOfEntries()) {
            this.valueChanged = true;
            this.typeValueChanged = false;
            this.setItemOfNewRow(aValue, this.getItemKeyAt(column), tuple, row);
        } else {
            if (oldvalue == null) {
                this.valueChanged = true;
                this.typeValueChanged = false;
            } else if (!oldvalue.equals(aValue)) {
                this.valueChanged = true;
                this.typeValueChanged = true;
            } else {
                this.valueChanged = false;
                this.typeValueChanged = false;
            }
            this.setItem(aValue, this.getMember(tuple, row), this.getItemKeyAt(column), tuple, row);
        }
        AttrSession.logPrintln(AttrSession.logTrace, "TupleTableModel:\n<-setValueAt");
    }

    public final Class getColumnClass(int column) {
        return this.getItemClass(this.getItemKeyAt(column));
    }
}

