/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.handler.gui.impl;

import agg.attribute.handler.AttrHandler;
import agg.attribute.handler.AttrHandlerException;
import agg.attribute.handler.HandlerExpr;
import agg.attribute.handler.HandlerType;
import agg.attribute.handler.gui.HandlerExprEditor;
import agg.attribute.handler.gui.impl.AbstractHandlerEditor;
import agg.attribute.impl.AttrSession;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ColorValueEditor
extends AbstractHandlerEditor
implements HandlerExprEditor {
    Color editedColor = null;
    HandlerType editedType = null;
    AttrHandler handler = null;

    public ColorValueEditor(AttrHandler h) {
        this.handler = h;
    }

    public Component getRendererComponent(HandlerType type, HandlerExpr exprToRender, Dimension availableSpace) {
        if (type == null) {
            return null;
        }
        if (type.getClazz() != Color.black.getClass()) {
            return null;
        }
        Color col = (Color)((Object)exprToRender);
        JLabel label = this.createColorLabel(col);
        if (availableSpace != null) {
            label.setPreferredSize(availableSpace);
        }
        return label;
    }

    public Component getEditorComponent(HandlerType type, HandlerExpr exprToEdit, Dimension availableSpace) {
        if (type == null) {
            return null;
        }
        this.editedType = type;
        if (type.getClazz() != Color.black.getClass()) {
            return null;
        }
        Color col = (Color)((Object)exprToEdit);
        Box box = Box.createHorizontalBox();
        JButton editB = new JButton("Choose");
        editB.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent ev) {
                ColorValueEditor.this.editedColor = JColorChooser.showDialog(null, "Choose-A-Color", ColorValueEditor.this.editedColor);
            }
        });
        JButton minusB = new JButton("-");
        editB.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent ev) {
                ColorValueEditor.this.editedColor = ColorValueEditor.this.editedColor.darker();
            }
        });
        JButton plusB = new JButton("+");
        editB.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent ev) {
                ColorValueEditor.this.editedColor = ColorValueEditor.this.editedColor.brighter();
            }
        });
        box.add(this.createColorLabel(col));
        box.add(minusB);
        box.add(plusB);
        box.add(editB);
        JPanel mainP = new JPanel(new BorderLayout());
        mainP.add((Component)box, "Center");
        if (availableSpace != null) {
            mainP.setPreferredSize(availableSpace);
        }
        return mainP;
    }

    protected JLabel createColorLabel(Color col) {
        String colorRGB = "null";
        if (col != null) {
            colorRGB = col.toString();
        }
        JLabel label = new JLabel(colorRGB);
        if (col != null) {
            label.setBackground(col);
        }
        return label;
    }

    public HandlerExpr getEditedExpr() {
        if (this.editedColor == null) {
            return null;
        }
        HandlerExpr expr = null;
        try {
            expr = this.handler.newHandlerValue(this.editedType, this.editedColor);
        }
        catch (AttrHandlerException ex) {
            AttrSession.warn((Object)this, "Couldn't create HandlerExpr", true);
        }
        return expr;
    }
}

