/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.handler.impl.javaExpr;

import agg.attribute.AttrVariableMember;
import agg.attribute.handler.AttrHandlerException;
import agg.attribute.handler.HandlerExpr;
import agg.attribute.handler.SymbolTable;
import agg.attribute.handler.impl.javaExpr.JexHandler;
import agg.attribute.handler.impl.javaExpr.JexType;
import agg.attribute.impl.AttrSession;
import agg.attribute.impl.ContextView;
import agg.attribute.parser.javaExpr.Jex;
import agg.attribute.parser.javaExpr.Node;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;

public class JexExpr
implements HandlerExpr {
    protected static Jex parser = new Jex();
    protected JexHandler handler;
    protected JexType type;
    protected Object value;
    protected Node ast;
    protected int property = 0;
    public static final long serialVersionUID = 268212822469784946L;

    public JexExpr() {
    }

    public JexExpr(String exprString, boolean asValue, JexType type) throws AttrHandlerException {
        AttrSession.logPrintln(AttrSession.logTrace, "JexExpr:\n->Constructor");
        if (asValue) {
            this.assignValue(exprString, type);
        } else {
            this.type = type;
            this.property = parser.parse(exprString.trim());
            this.ast = parser.getAST();
            AttrSession.logPrintln(AttrSession.logTrace, "konstant: " + this.isConstant() + "\nvariable: " + this.isVariable() + "\nkomplex: " + this.isComplex());
            if (AttrSession.logTrace) {
                this.ast.dump("JexExpr: ");
            }
            if (this.isConstant()) {
                this.evaluate(null);
            }
        }
        AttrSession.logPrintln(AttrSession.logTrace, "JexExpr:\n<-Construktor");
    }

    public JexExpr(Object value, JexType type) throws AttrHandlerException {
        this.assignValue(value, type);
    }

    protected void assignValue(Object value, JexType type) throws AttrHandlerException {
        AttrSession.logPrintln(AttrSession.logTrace, "JexExpr:\n->assignValue");
        Class clazz = type.getClazz();
        if (value != null && !clazz.isInstance(value)) {
            throw new AttrHandlerException(value.toString() + " is not an instance of " + clazz.toString());
        }
        this.type = type;
        this.value = value;
        this.property = 1;
        AttrSession.logPrintln(AttrSession.logTrace, "JexExpr:\n<-assignValue");
    }

    public static Jex getParser() {
        return parser;
    }

    protected JexHandler getHandler() {
        if (this.type != null) {
            return this.type.handler;
        }
        return null;
    }

    public String toString() {
        return this.getString();
    }

    public boolean equals(HandlerExpr expr) {
        JexExpr testObject = (JexExpr)expr;
        boolean result = true;
        if (testObject == null || this.getHandler() != testObject.getHandler() || !this.type.equals(testObject.type)) {
            result = false;
        } else if (this.value != null && testObject.value != null) {
            result = this.value.equals(testObject.value);
        } else if (this.value == null && testObject.value == null) {
            if (this.ast == null && testObject.ast == null) {
                return true;
            }
            if (this.ast != null && testObject.ast != null) {
                result = this.ast.equals(testObject.ast);
                result = this.ast.toString().equals(testObject.ast.toString());
            } else {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    public Object getValue() {
        return this.value;
    }

    public JexType getType() {
        return this.type;
    }

    protected void copyFrom(HandlerExpr expr) {
        JexExpr from = (JexExpr)expr;
        this.type = from.type;
        this.value = from.value;
        this.property = from.property;
        if (from.ast != null) {
            this.ast = from.ast.copy();
        } else {
            this.ast = null;
            this.property = from.property;
        }
    }

    public HandlerExpr getCopy() {
        JexExpr copy = new JexExpr();
        copy.copyFrom(this);
        return copy;
    }

    public void check(SymbolTable symtab) throws AttrHandlerException {
        if (this.property == 1) {
            return;
        }
        if (this.getHandler() != null && this.type != null) {
            this.getHandler().adaptParser();
            parser.check(this.getString(), this.type.getClazz(), symtab);
        }
    }

    public void evaluate(SymbolTable symtab) throws AttrHandlerException {
        AttrSession.logPrintln(AttrSession.logTrace, "JexExpr:\n->evaluate()");
        AttrSession.logPrintln(AttrSession.logTrace, "JexExpr: text " + this.getString() + " vor interpret aufruf");
        AttrSession.logPrintln(AttrSession.logTrace, "JexExpr: value " + this.value + " vor interpret aufruf");
        AttrSession.logPrintln(AttrSession.logTrace, "JexExpr: symtab " + symtab + " vor interpret aufruf");
        if (AttrSession.logTrace) {
            if (symtab instanceof ContextView) {
                ContextView context = (ContextView)symtab;
                AttrSession.logAttrInstance(context.getVariables(), "JexExpr: Variablen");
                AttrSession.logPrintln("JexExpr: Variablen:" + context.getVariables().getNumberOfEntries());
                for (int i = 0; i < context.getVariables().getNumberOfEntries(); ++i) {
                    AttrSession.logPrintln("JexExpr: Variablen bei " + i + ": " + ((AttrVariableMember)context.getVariables().getMemberAt(i)).getExprAsText());
                }
            } else {
                AttrSession.logPrintln("JexExpr: symtab ist kein ContextView");
            }
        }
        if (this.value == null) {
            this.property = 1;
            if (this.getHandler() != null && this.type != null) {
                this.getHandler().adaptParser();
                if (this.mustRewrite(symtab)) {
                    this.value = null;
                    try {
                        AttrSession.logPrintln(AttrSession.logJexParser, "JexExpr.evaluate: rewrite");
                        parser.rewrite(this.getAST(), this.type.getClazz(), symtab);
                        this.property = 3;
                    }
                    catch (AttrHandlerException ex) {
                        AttrSession.logPrintln(AttrSession.logJexParser, "JexExpr.evaluate:  rewriting failed. " + ex.getMessage());
                        throw ex;
                    }
                }
                try {
                    AttrSession.logPrintln(AttrSession.logJexParser, "JexExpr.evaluate: interpret");
                    this.value = parser.interpret(this.ast, this.type.getClazz(), symtab);
                }
                catch (AttrHandlerException ex) {
                    AttrSession.logPrintln(AttrSession.logJexParser, "JexExpr.evaluate:  interpretting failed. " + ex.getMessage());
                    throw ex;
                }
                if (this.value != null) {
                    this.ast = null;
                }
            } else {
                this.value = null;
            }
        }
        AttrSession.logPrintln(AttrSession.logTrace, "JexExpr: value " + this.value + " nach evaluate");
        AttrSession.logPrintln(AttrSession.logTrace, "JexExpr:\n<-evaluate()");
    }

    protected boolean mustRewrite(SymbolTable symtab) {
        Vector v = new Vector();
        this.getAllVariables(v);
        boolean result = false;
        for (int i = 0; i < v.size() && !result; ++i) {
            String s = (String)v.elementAt(i);
            HandlerExpr he = symtab.getExpr(s);
            if (he == null) continue;
            result = !he.isConstant();
        }
        return result;
    }

    public boolean isConstant() {
        return this.property == 1;
    }

    public boolean isVariable() {
        return this.property == 2;
    }

    public boolean isComplex() {
        return this.property == 3;
    }

    protected boolean isAssignableTo(JexExpr expr, SymbolTable symtab) {
        JexExpr currentAssignment;
        if (expr == null || symtab == null) {
            return false;
        }
        return this.isConstant() && expr.isVariable() && ((currentAssignment = (JexExpr)symtab.getExpr(expr.getString())) == null || this.value != null && this.value.equals(currentAssignment.value));
    }

    public boolean isUnifiableWith(HandlerExpr expr, SymbolTable symtab) {
        if (this.type == null) {
            System.out.println("JexExpr.isUnifiableWith ::  type: " + this.type + "   failed!");
            return false;
        }
        JexExpr testObject = (JexExpr)expr;
        if (testObject == null || this.getHandler() != testObject.getHandler() || !this.type.equals(testObject.type)) {
            return false;
        }
        AttrSession.logPrintln(AttrSession.logMapping, "JexExpr: Expr not null, Handler are equal, Type are equal");
        boolean result = true;
        result = result && this.isConstant();
        result = result && expr.isConstant();
        result = result && this.equals(expr);
        result = result || this.isAssignableTo(testObject, symtab);
        result = result || testObject.isAssignableTo(this, symtab);
        return result;
    }

    public String getString() {
        String result;
        if (this.value != null) {
            result = this.value.toString();
            if (this.value instanceof String) {
                result = "\"" + result + "\"";
            }
        } else {
            result = this.ast != null ? this.ast.getString() : "null";
        }
        return result;
    }

    public Node getAST() {
        return this.ast;
    }

    public void getAllVariables(Vector v) {
        if (this.getAST() != null) {
            this.getAST().getAllVariablesinExpression(v);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        String text;
        ObjectInputStream.GetField gf = ois.readFields();
        this.handler = (JexHandler)gf.get("handler", null);
        this.type = (JexType)gf.get("type", null);
        this.value = gf.get("value", null);
        this.property = gf.get("property", 0);
        this.ast = (Node)gf.get("ast", null);
        if (this.ast == null && this.value == null && (text = (String)gf.get("text", null)) != null) {
            JexExpr newExpr = null;
            try {
                newExpr = new JexExpr(text, false, this.type);
            }
            catch (AttrHandlerException ahe) {
                throw new RuntimeException(ahe.getMessage());
            }
            this.ast = newExpr.ast;
            this.property = newExpr.property;
        }
    }
}

