/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.handler.impl.javaExpr;

import agg.attribute.handler.AttrHandler;
import agg.attribute.handler.AttrHandlerException;
import agg.attribute.handler.HandlerExpr;
import agg.attribute.handler.HandlerType;
import agg.attribute.handler.impl.javaExpr.JexExpr;
import agg.attribute.handler.impl.javaExpr.JexType;
import agg.attribute.impl.AttrSession;
import agg.attribute.parser.javaExpr.ClassResolver;
import agg.attribute.parser.javaExpr.ClassResolverException;
import agg.attribute.parser.javaExpr.SimpleNode;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;

public class JexHandler
implements AttrHandler {
    static final long serialVersionUID = 9042008410571344426L;
    protected ClassResolver classResolver = new ClassResolver();

    public static String getLabelName() {
        return "Java Expr";
    }

    public ClassResolver getClassResolver() {
        return this.classResolver;
    }

    public String getName() {
        return JexHandler.getLabelName();
    }

    public HandlerType newHandlerType(String typeString) throws AttrHandlerException {
        Class clazz;
        try {
            clazz = this.classResolver.forName(typeString);
        }
        catch (ClassResolverException ex) {
            throw new AttrHandlerException(ex.getMessage());
        }
        if (clazz == null) {
            throw new AttrHandlerException("Type not found");
        }
        return new JexType(this, typeString, clazz);
    }

    public HandlerExpr newHandlerExpr(HandlerType type, String exprString) throws AttrHandlerException {
        AttrSession.logPrintln(AttrSession.logTrace, "JexHandler:\n->newHandlerExpr");
        SimpleNode.setClassResolver(this.classResolver);
        try {
            JexExpr jexExpr = new JexExpr(exprString, false, (JexType)type);
            return jexExpr;
        }
        catch (AttrHandlerException ex1) {
            throw ex1;
        }
        finally {
            AttrSession.logPrintln(AttrSession.logTrace, "JexHandler:\n<-newHandlerExpr");
        }
    }

    public HandlerExpr newHandlerValue(HandlerType type, Object value) throws AttrHandlerException {
        return new JexExpr(value, (JexType)type);
    }

    public void appendPackage(String packageName) {
        Vector packages = this.classResolver.getPackages();
        packages.addElement(packageName);
        this.classResolver.setPackages(packages);
    }

    public void adaptParser() {
        SimpleNode.setClassResolver(this.classResolver);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

