/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.impl;

import agg.attribute.AttrConditionTuple;
import agg.attribute.AttrContext;
import agg.attribute.AttrInstance;
import agg.attribute.AttrMember;
import agg.attribute.AttrVariableTuple;
import agg.attribute.impl.VerboseControl;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class AttrSession
extends VerboseControl {
    protected static String osName = System.getProperty("os.name");
    protected static String osArch = System.getProperty("os.arch");
    static boolean wasSystemAnalysed = false;
    static boolean isWin32 = false;
    protected static byte stdoutIndentCount = 0;
    protected static boolean stdoutBeginOfLine = true;
    protected static ByteArrayOutputStream redirectStream;
    protected static PrintStream stdout;

    public static boolean isWin32() {
        if (!wasSystemAnalysed) {
            wasSystemAnalysed = true;
            if ((osName + osArch).toLowerCase().indexOf("win") != -1) {
                System.out.println("AttrManager: System recognized as Win32.");
                isWin32 = true;
            }
            if ((osName + osArch).toLowerCase().indexOf("sunos") != -1) {
                System.out.println("AttrManager: System recognized as SunOS.");
                isWin32 = false;
            }
        }
        return isWin32;
    }

    public AttrSession() {
        if (VerboseControl.logShowLogWindow) {
            // empty if block
        }
    }

    public static void logPrintln(String msg) {
        System.out.println(msg);
    }

    public static void errPrintln(String msg) {
        System.out.println(msg);
    }

    public static void logPrintln(boolean logTopic, String msg) {
        if (logTopic) {
            AttrSession.logPrintln(msg);
        }
    }

    public static void errPrintln(boolean logTopic, String msg) {
        if (logTopic) {
            AttrSession.errPrintln(msg);
        }
    }

    public static void warn(Object sender, String msg) {
        AttrSession.warn(sender, msg, null, false);
    }

    public static void warn(Object sender, String msg, boolean showStack) {
        AttrSession.warn(sender, msg, null, showStack);
    }

    public static void warn(Object sender, String msg, Exception ex) {
        AttrSession.warn(sender, msg, ex, true);
    }

    public static void warn(Object sender, String msg, Exception ex, boolean showStack) {
        if (!logWarning) {
            return;
        }
        String stack = "";
        if (showStack) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            stack = "\n- Stack trace:\n" + sw;
        }
        String warnText = "========== WARNING FROM THE ATTRIBUTE COMPONENT ==========\n- Issued from: " + sender + " : " + sender.getClass().getName() + "\n- Message: " + msg + (ex != null ? "\n- Exception: " + ex.getMessage() + stack : "") + "\n----------------------------------------------------------";
        AttrSession.errPrintln(warnText);
    }

    public static void stdoutPrint(boolean debugTopic, String msg) {
        if (debugTopic) {
            System.out.print(msg);
            stdoutBeginOfLine = msg.charAt(msg.length() - 1) == '\n';
        }
    }

    public static void stdoutPrintln(boolean debugTopic, String msg) {
        if (debugTopic) {
            System.out.println(msg);
            stdoutBeginOfLine = true;
        }
    }

    public static void stdoutPrintOnEnter(boolean debugTopic, String msg) {
        if (debugTopic) {
            stdoutIndentCount = (byte)(stdoutIndentCount + 1);
            AttrSession.stdoutPrintIndented(msg);
        }
    }

    public static void stdoutPrintOnExit(boolean debugTopic, String msg) {
        if (debugTopic) {
            AttrSession.stdoutPrintIndented(msg);
            stdoutIndentCount = (byte)(stdoutIndentCount - 1);
        }
    }

    public static void stdoutPrintIndented(boolean debugTopic, String msg) {
        if (debugTopic) {
            AttrSession.stdoutPrintIndented(msg);
        }
    }

    protected static void stdoutPrintIndented(String msg) {
        StringBuffer spaces = new StringBuffer(stdoutIndentCount);
        for (int i = 0; i < stdoutIndentCount; ++i) {
            spaces.append(' ');
        }
        System.out.print(spaces);
        System.out.print(msg);
    }

    protected static void grabStdOutput() {
        stdout = System.out;
        redirectStream = new ByteArrayOutputStream();
        System.setOut(new PrintStream(redirectStream));
    }

    protected static void releaseStdOutput() {
        System.setOut(stdout);
        AttrSession.logPrintln(redirectStream.toString());
    }

    public static void logAttrInstance(AttrInstance instance, String msg) {
        AttrSession.logPrintln("Beginning --> " + msg);
        System.out.print(instance);
        int number = instance.getNumberOfEntries();
        AttrSession.logPrintln(" has " + number + " members");
        for (int i = 0; i < number; ++i) {
            AttrMember am = instance.getMemberAt(i);
            System.out.print("Member #" + i);
            System.out.print(" with name \"" + am.getName());
            System.out.println("\" and value: " + instance.getValueAsString(i));
        }
        AttrSession.logPrintln("Ending    <-- " + msg);
    }

    public static void logAttrInstance(boolean topic, AttrInstance instance, String msg) {
        if (topic) {
            AttrSession.logAttrInstance(instance, msg);
        }
    }

    public static void logAttrContext(AttrContext context, String msg) {
        AttrSession.logPrintln("Beginning --> " + msg);
        System.out.print(context);
        String str = " allows: \n";
        str = str + "complex expressions: " + context.doesAllowComplexExpressions() + "\n";
        str = str + "empty values: " + context.doesAllowEmptyValues() + "\n";
        str = str + "new variables: " + context.doesAllowNewVariables();
        System.out.println(str);
        str = "This context has ";
        AttrConditionTuple act = context.getConditions();
        int conditions = act.getNumberOfEntries();
        str = str + "#" + conditions + " conditions.";
        System.out.println(str);
        AttrSession.logAttrInstance(act, "im Context");
        str = "This context has ";
        AttrVariableTuple avt = context.getVariables();
        int variables = avt.getNumberOfEntries();
        str = str + "#" + variables + " varibles.";
        System.out.println(str);
        AttrSession.logAttrInstance(avt, "im Context");
        AttrSession.logPrintln("Ending    <-- " + msg);
    }

    public static void logAttrContext(boolean topic, AttrContext context, String msg) {
        if (topic) {
            AttrSession.logAttrContext(context, msg);
        }
    }
}

