/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.impl;

import agg.attribute.AttrContext;
import agg.attribute.AttrException;
import agg.attribute.AttrInstance;
import agg.attribute.AttrManager;
import agg.attribute.AttrMapping;
import agg.attribute.AttrType;
import agg.attribute.handler.AttrHandler;
import agg.attribute.handler.AvailableHandlers;
import agg.attribute.impl.AttrImplException;
import agg.attribute.impl.AttrObject;
import agg.attribute.impl.AttrSession;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.DeclTuple;
import agg.attribute.impl.TupleMapping;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.attribute.view.AttrViewSetting;
import agg.attribute.view.impl.OpenViewSetting;

public class AttrTupleManager
extends AttrObject
implements AttrManager {
    protected AttrHandler[] handlers = AvailableHandlers.newInstances();
    protected AttrViewSetting defaultOpenView;
    protected AttrViewSetting defaultMaskedView;
    protected AttrViewSetting fixedViewSetting;
    protected ContextView defaultContext;
    protected boolean isCorrectInputEnforced = false;
    private String errorMsg = "";
    private boolean variableContext = false;
    protected static AttrTupleManager myDefaultInstance = new AttrTupleManager();

    public static AttrManager getDefaultManager() {
        return myDefaultInstance;
    }

    public AttrTupleManager() {
        new AttrSession();
        this.setDebug(true);
        this.defaultOpenView = new OpenViewSetting(this);
        this.defaultMaskedView = this.defaultOpenView.getMaskedView();
        this.fixedViewSetting = new OpenViewSetting(this);
        this.defaultContext = new ContextView(this, 0);
        this.defaultContext.setAllowVarDeclarations(false);
        this.defaultContext.setAllowComplexExpr(false);
        this.defaultContext.setAllowEmptyValues(false);
        this.defaultContext.setAllowInitialExpr(true);
    }

    public AttrContext newContext(int mapStyle) {
        ContextView c = new ContextView(this, mapStyle, null);
        c.setVariableContext(this.variableContext);
        return c;
    }

    public AttrContext newContext(int mapStyle, AttrContext parent) {
        ContextView c = new ContextView(this, mapStyle, parent);
        c.setVariableContext(this.variableContext);
        return c;
    }

    public AttrContext newLeftContext(AttrContext context) {
        ContextView c = new ContextView(this, context, true);
        c.setVariableContext(this.variableContext);
        return c;
    }

    public AttrContext newRightContext(AttrContext context) {
        ContextView c = new ContextView(this, context, false);
        c.setVariableContext(this.variableContext);
        return c;
    }

    public void setVariableContext(boolean b) {
        this.variableContext = b;
    }

    public boolean isVariableContext() {
        return this.variableContext;
    }

    public AttrHandler getHandler(String name) {
        for (int i = 0; i < this.handlers.length; ++i) {
            if (!this.handlers[i].getName().equals(name)) continue;
            return this.handlers[i];
        }
        return null;
    }

    public AttrType newType() {
        return new DeclTuple(this);
    }

    public AttrInstance newInstance(AttrType type) {
        return this.newInstance((DeclTuple)type, null);
    }

    public AttrInstance newInstance(AttrType type, AttrContext context) {
        if (context == null) {
            context = this.defaultContext;
        }
        return new ValueTuple(this, (DeclTuple)type, (ContextView)context);
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void clearErrorMsg() {
        this.errorMsg = "";
    }

    public void checkIfReadyToMatch(AttrContext ruleContext) throws AttrException {
        if (ruleContext == null) {
            throw new AttrException("Null context supplied.");
        }
        ContextView context = (ContextView)ruleContext;
        String text = "";
        CondTuple conds = (CondTuple)context.getConditions();
        for (int k = 0; k < conds.getSize(); ++k) {
            CondMember cm = conds.getCondMemberAt(k);
            if (cm.getMark() == 2 || cm.getMark() == 3 || !cm.isFalse()) continue;
            text = "Condition:  " + cm.getExprAsText() + "  failed!";
        }
        if (text.length() > 0) {
            this.errorMsg = text;
            throw new AttrException(text);
        }
    }

    public AttrMapping newMapping(AttrContext mappingContext, AttrInstance source, AttrInstance target) throws AttrException {
        this.errorMsg = "";
        try {
            return new TupleMapping((ContextView)mappingContext, (ValueTuple)source, (ValueTuple)target);
        }
        catch (AttrImplException ex1) {
            this.errorMsg = ((ContextView)mappingContext).getErrorMsg() + "\nAttributes don't match.";
            throw new AttrException(ex1.getMessage() + "\n" + this.errorMsg);
        }
    }

    public void checkIfReadyToTransform(AttrContext matchContext) throws AttrException {
        this.errorMsg = "";
        if (matchContext == null) {
            throw new AttrException("Null context supplied.");
        }
        ContextView context = (ContextView)matchContext;
        String text = "";
        VarTuple vars = (VarTuple)matchContext.getVariables();
        for (int k = 0; k < vars.getSize(); ++k) {
            VarMember vm = vars.getVarMemberAt(k);
            if (vm.getMark() == 2 || vm.isDefinite()) continue;
            text = "Variable:  " + vm.getName() + "  is not defined!";
        }
        CondTuple conds = (CondTuple)matchContext.getConditions();
        for (int k = 0; k < conds.getSize(); ++k) {
            CondMember cm = conds.getCondMemberAt(k);
            if (cm.getMark() == 2 || cm.getMark() == 3 || cm.isTrue()) continue;
            text = "Condition:  " + cm.getExprAsText() + "  is not satisfied!";
        }
        if (text.length() > 0) {
            this.errorMsg = text;
            throw new AttrException(text);
        }
    }

    public void checkIfReadyToTransform(AttrContext matchContext, boolean checkVariables) throws AttrException {
        if (!checkVariables) {
            try {
                this.checkIfReadyToTransform(matchContext);
            }
            catch (AttrException ex) {
                this.errorMsg = ex.getMessage();
            }
        } else {
            this.errorMsg = "";
            if (matchContext == null) {
                throw new AttrException("Null context supplied.");
            }
            ContextView context = (ContextView)matchContext;
            String text = "";
            VarTuple vars = (VarTuple)matchContext.getVariables();
            for (int k = 0; k < vars.getSize(); ++k) {
                VarMember vm = vars.getVarMemberAt(k);
                if (vm.getMark() == 2 || vm.isDefinite()) continue;
                text = "Variable:  " + vm.getName() + "  is not defined!";
            }
            if (text.length() > 0) {
                this.errorMsg = text;
                throw new AttrException(text);
            }
        }
    }

    public AttrViewSetting newViewSetting() {
        return new OpenViewSetting(this);
    }

    public AttrViewSetting getDefaultOpenView() {
        return this.defaultOpenView;
    }

    public AttrViewSetting getDefaultMaskedView() {
        return this.defaultMaskedView;
    }

    public AttrViewSetting getFixedViewSetting() {
        return this.fixedViewSetting;
    }

    public void setDebug(boolean b) {
        AttrSession.setDebug(b);
    }

    public AttrHandler[] getHandlers() {
        AttrHandler[] handlersCopy = new AttrHandler[this.handlers.length];
        System.arraycopy(this.handlers, 0, handlersCopy, 0, this.handlers.length);
        return handlersCopy;
    }

    public boolean isCorrectInputEnforced() {
        return this.isCorrectInputEnforced;
    }

    public void setCorrectInputEnforced(boolean b) {
        this.isCorrectInputEnforced = b;
    }
}

