/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.impl;

import agg.attribute.AttrEvent;
import agg.attribute.AttrObserver;
import agg.attribute.AttrTuple;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.ManagedObject;
import agg.attribute.impl.TupleEvent;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Vector;

public abstract class ChainedObserver
extends ManagedObject
implements AttrObserver,
AttrTuple {
    protected static final int MAX_SIZE_OF_EVENT_STACK = 100;
    protected static int sizeOfEventStack = 0;
    private transient Vector observers = new Vector(10, 10);

    public ChainedObserver(AttrTupleManager m) {
        super(m);
    }

    private void removeNullObserver() {
        for (int i = 0; i < this.observers.size(); ++i) {
            WeakReference wr = (WeakReference)this.observers.elementAt(i);
            if (wr.get() != null) continue;
            this.observers.removeElementAt(i);
            --i;
        }
    }

    public Enumeration getObservers() {
        Vector tmp = new Vector();
        this.removeNullObserver();
        for (int i = 0; i < this.observers.size(); ++i) {
            WeakReference wr = (WeakReference)this.observers.elementAt(i);
            if (wr.get() == null) continue;
            tmp.addElement(wr.get());
        }
        return tmp.elements();
    }

    public void addObserver(AttrObserver attrObs) {
        this.removeNullObserver();
        boolean found = false;
        for (int i = 0; i < this.observers.size() && !found; ++i) {
            WeakReference wr = (WeakReference)this.observers.elementAt(i);
            found = attrObs == (AttrObserver)wr.get();
        }
        if (!found) {
            this.observers.addElement(new WeakReference<AttrObserver>(attrObs));
        }
    }

    public boolean contains(AttrObserver attrObs) {
        return this.findObserver(attrObs) != -1;
    }

    public void addObserverAtPos(AttrObserver attrObs, int pos) {
        this.observers.insertElementAt(new WeakReference<AttrObserver>(attrObs), pos);
    }

    protected int findObserver(AttrObserver obj) {
        if (obj == null || this.observers == null) {
            return -1;
        }
        this.removeNullObserver();
        for (int i = 0; i < this.observers.size(); ++i) {
            WeakReference wr = (WeakReference)this.observers.elementAt(i);
            if (wr.get() == null || !wr.get().equals(obj)) continue;
            return i;
        }
        return -1;
    }

    public void removeObserver(AttrObserver attrObs) {
        int pos = this.findObserver(attrObs);
        if (pos != -1) {
            this.observers.removeElementAt(pos);
        }
    }

    protected void fireAttrChanged(int id, int index) {
        this.fireAttrChanged(id, index, index);
    }

    protected void fireAttrChanged(int id, int index0, int index1) {
        this.fireAttrChanged(new TupleEvent(this, id, index0, index1));
    }

    protected void fireAttrChanged(TupleEvent evt) {
        if (evt == null) {
            return;
        }
        this.removeNullObserver();
        Enumeration en = this.getObservers();
        while (en.hasMoreElements()) {
            TupleEvent childEvt;
            AttrObserver obs = (AttrObserver)en.nextElement();
            if (obs == null || (childEvt = this.filterEvent(obs, evt)) == null) continue;
            obs.attributeChanged(childEvt);
        }
    }

    protected abstract void propagateEvent(TupleEvent var1);

    protected TupleEvent filterEvent(AttrObserver obs, TupleEvent e) {
        return e;
    }

    public boolean isPersistentFor(AttrTuple at) {
        return true;
    }

    public void attributeChanged(AttrEvent evt) {
        if (++sizeOfEventStack > 100) {
            throw new RuntimeException("Infinite event recursion occured.");
        }
        TupleEvent event = (TupleEvent)evt;
        int msg = event.getID();
        if (msg == 0) {
            this.updateGeneralChange(event);
        } else if (msg == 10) {
            this.updateMemberAdded(event);
        } else if (msg == 20) {
            this.updateMemberDeleted(event);
        } else if (msg == 40) {
            this.updateMemberModified(event);
        } else if (msg == 50) {
            this.updateMemberRenamed(event);
        } else if (msg == 60) {
            this.updateMemberRetyped(event);
        } else if (msg == 70) {
            this.updateValueModified(event);
        } else if (msg == 80) {
            this.updateValueCorrectness(event);
        } else {
            this.updateUnknownChange(event);
        }
        --sizeOfEventStack;
    }

    protected void updateGeneralChange(TupleEvent event) {
        this.propagateEvent(event);
    }

    protected void updateMemberAdded(TupleEvent event) {
        this.propagateEvent(event);
    }

    protected void updateMemberDeleted(TupleEvent event) {
        this.propagateEvent(event);
    }

    protected void updateMemberModified(TupleEvent event) {
        this.propagateEvent(event);
    }

    protected void updateMemberRenamed(TupleEvent event) {
        this.propagateEvent(event);
    }

    protected void updateMemberRetyped(TupleEvent event) {
        this.propagateEvent(event);
    }

    protected void updateValueModified(TupleEvent event) {
        this.propagateEvent(event);
    }

    protected void updateValueCorrectness(TupleEvent event) {
        this.propagateEvent(event);
    }

    protected void updateUnknownChange(TupleEvent event) {
        this.propagateEvent(event);
    }

    private void setObservers(Vector observer) {
        this.observers = new Vector();
        if (observer == null || observer.size() == 0) {
            return;
        }
        Enumeration en = observer.elements();
        while (en.hasMoreElements()) {
            Object e = en.nextElement();
            if (e == null) continue;
            this.observers.addElement(new WeakReference(e));
        }
    }
}

