/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.impl;

import agg.attribute.AttrConditionMember;
import agg.attribute.AttrConditionTuple;
import agg.attribute.AttrInstance;
import agg.attribute.handler.AttrHandler;
import agg.attribute.handler.AttrHandlerException;
import agg.attribute.handler.HandlerType;
import agg.attribute.handler.impl.javaExpr.JexHandler;
import agg.attribute.impl.AttrImplException;
import agg.attribute.impl.AttrMsgCode;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.LoneTuple;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.VarTuple;
import agg.util.XMLHelper;
import java.util.Enumeration;
import java.util.Vector;

public class CondTuple
extends LoneTuple
implements AttrConditionTuple,
AttrMsgCode {
    protected static String boolHandlerName = JexHandler.getLabelName();
    protected static final String boolTypeName = "boolean";
    protected static final String trueVal = "true";
    protected static final String falseVal = "false";
    protected static final String namePrefix = "c";
    protected AttrHandler condHandler = null;
    protected HandlerType boolType = null;
    protected int condNum = 0;
    String failedCondAsString;

    public CondTuple(AttrTupleManager manager, ContextView context, CondTuple parent) {
        super(manager, context, parent);
        this.getContextView().setAllowVarDeclarations(true);
        this.getContextView().setAllowComplexExpr(true);
        this.initClass();
        if (parent != null) {
            int i;
            if (this.getSize() == 0 && this.parent.getSize() > 0) {
                for (i = 0; i < this.parent.getSize(); ++i) {
                    CondMember m = (CondMember)this.parent.getMemberAt(i);
                    this.addCondition(m.getExprAsText());
                }
            }
            for (i = 0; i < this.getSize(); ++i) {
                CondMember cond = this.getCondMemberAt(i);
                CondMember condParent = parent.getCondMemberAt(i);
                if (condParent == null || cond.getExprAsText() == null) continue;
                cond.setMark(condParent.getMark());
            }
            this.getContextView().setVariableContext(parent.getContextView().isVariableContext());
        }
    }

    protected void initClass() {
        if (this.boolType == null) {
            String errMsg = "";
            this.condHandler = this.manager.getHandler(boolHandlerName);
            try {
                this.boolType = this.condHandler.newHandlerType(boolTypeName);
            }
            catch (AttrHandlerException ex) {
                errMsg = ex.getMessage();
            }
            if (this.boolType == null) {
                errMsg = errMsg + "\nFinding a boolean type for condition expressions failed!\n";
                throw new AttrImplException(1, errMsg);
            }
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected String getNextName() {
        return namePrefix + this.condNum++;
    }

    protected String getNameFor(int index) {
        return namePrefix + index;
    }

    protected ValueMember newMember(DeclMember decl) {
        return new CondMember(this, decl);
    }

    public CondMember getCondMemberAt(int index) {
        return (CondMember)this.getMemberAt(index);
    }

    public AttrConditionMember addCondition(String expr) {
        if (expr.equals("")) {
            return null;
        }
        this.getTupleType().addMember(this.condHandler, boolTypeName, this.getNextName());
        CondMember cm = this.getCondMemberAt(this.getSize() - 1);
        cm.setExprAsText(expr);
        if (cm.getErrorMsg().indexOf("Parsing error") != -1) {
            this.errorMsg = cm.getErrorMsg();
        }
        return cm;
    }

    public boolean isDefinite() {
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.getCondMemberAt(i).isDefinite()) continue;
            return false;
        }
        return true;
    }

    public boolean isDefinite(String name) {
        for (int i = 0; i < this.getSize(); ++i) {
            CondMember cm = this.getCondMemberAt(i);
            Vector v = cm.getAllVariables();
            if (!v.contains(name) || cm.isDefinite()) continue;
            return false;
        }
        return true;
    }

    public boolean contains(String expr) {
        for (int i = 0; i < this.getSize(); ++i) {
            CondMember cm = this.getCondMemberAt(i);
            if (!cm.getExprAsText().equals(expr)) continue;
            return true;
        }
        return false;
    }

    public boolean isEvaluable(VarTuple vars) {
        for (int i = 0; i < this.getSize(); ++i) {
            CondMember cm = this.getCondMemberAt(i);
            if (cm.isEvaluable(vars)) continue;
            return false;
        }
        return true;
    }

    public boolean isTrue() {
        this.failedCondAsString = "";
        for (int i = 0; i < this.getSize(); ++i) {
            CondMember cm = this.getCondMemberAt(i);
            if (cm.isTrue()) continue;
            this.failedCondAsString = cm.getExprAsText();
            return false;
        }
        return true;
    }

    public boolean isTrue(String name) {
        this.failedCondAsString = "";
        for (int i = 0; i < this.getSize(); ++i) {
            CondMember cm = this.getCondMemberAt(i);
            Vector v = cm.getAllVariables();
            if (!v.contains(name) || cm.isTrue()) continue;
            this.failedCondAsString = cm.getExprAsText();
            return false;
        }
        return true;
    }

    public boolean isFalse() {
        this.failedCondAsString = "";
        for (int i = 0; i < this.getSize(); ++i) {
            CondMember member = this.getCondMemberAt(i);
            if (!member.isDefinite() || member.isTrue()) continue;
            this.failedCondAsString = member.getExprAsText();
            return true;
        }
        return false;
    }

    public boolean isFalse(String name) {
        this.failedCondAsString = "";
        for (int i = 0; i < this.getSize(); ++i) {
            CondMember member = this.getCondMemberAt(i);
            Vector v = member.getAllVariables();
            if (!v.contains(name) || !member.isDefinite() || member.isTrue()) continue;
            this.failedCondAsString = member.getExprAsText();
            return true;
        }
        return false;
    }

    public String getFailedConditionAsString() {
        String s = this.failedCondAsString;
        this.failedCondAsString = "";
        return s;
    }

    public void setVariableContext(boolean b) {
        this.getContextView().setVariableContext(b);
    }

    public Vector getAllVariables() {
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < this.getSize(); ++i) {
            CondMember member = this.getCondMemberAt(i);
            Vector names = member.getAllVariables();
            for (int j = 0; j < names.size(); ++j) {
                String name = (String)names.elementAt(j);
                if (result.contains(name)) continue;
                result.addElement(name);
            }
        }
        return result;
    }

    public boolean usesVariable(String var) {
        for (int i = 0; i < this.getSize(); ++i) {
            CondMember member = this.getCondMemberAt(i);
            Vector names = member.getAllVariables();
            if (!names.contains(var)) continue;
            return true;
        }
        return false;
    }

    public boolean compareTo(AttrInstance another) {
        CondTuple vt = (CondTuple)another;
        if (!this.type.compareTo(vt.getTupleType())) {
            return false;
        }
        int length = this.getSize();
        for (int i = 0; i < length; ++i) {
            CondMember v = this.getCondMemberAt(i);
            CondMember v1 = vt.getCondMemberAt(i);
            if (v.getExpr() == null && v1.getExpr() == null) continue;
            if (v.getExpr() == null && v1.getExpr() != null) {
                return false;
            }
            if (v.getExpr() != null && v1.getExpr() == null) {
                return false;
            }
            if (v.getExprAsText().equals(v1.getExprAsText())) continue;
            return false;
        }
        return true;
    }

    public void XwriteObject(XMLHelper h) {
        int num = this.getSize();
        for (int i = 0; i < num; ++i) {
            CondMember val = this.getCondMemberAt(i);
            h.openSubTag("Condition");
            h.openSubTag("Value");
            h.addAttrValue("String", val.getExprAsText());
            h.close();
            h.close();
        }
    }

    public void XreadObject(XMLHelper h) {
        Enumeration en = h.getEnumeration("", null, true, "Condition");
        while (en.hasMoreElements()) {
            h.peekElement(en.nextElement());
            if (h.getDocumentVersion().equals("1.0")) {
                if (h.readSubTag("Value")) {
                    Object obj = h.getAttrValue("String");
                    if (obj instanceof String) {
                        String test = (String)obj;
                        String objStr = new String(test);
                        while (test.indexOf(10) != -1) {
                            objStr = test.replaceAll("\n", "");
                            test = new String(objStr);
                        }
                        while (test.indexOf("  ") != -1) {
                            objStr = test.replaceAll("  ", " ");
                            test = new String(objStr);
                        }
                        CondMember cond = (CondMember)this.addCondition(objStr);
                        if (cond == null || cond.getErrorMsg().indexOf("Parsing error") != -1) {
                            // empty if block
                        }
                    }
                    h.close();
                }
            } else {
                this.addCondition(h.readAttr("value"));
            }
            h.close();
        }
    }
}

