/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.impl;

import agg.attribute.handler.AttrHandler;
import agg.attribute.handler.HandlerExpr;
import agg.attribute.impl.AttrImplException;
import agg.attribute.impl.AttrSession;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.ManagedObject;
import agg.attribute.impl.NoSuchVariableException;
import agg.attribute.impl.TupleMapping;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.util.Debug;
import agg.util.Disposable;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class ContextCore
extends ManagedObject
implements Serializable,
Disposable {
    static final long serialVersionUID = 4267479295340570839L;
    protected int mapStyle;
    protected ContextCore parent = null;
    protected Hashtable mappings = new Hashtable();
    protected CondTuple conditions;
    protected VarTuple variables;
    protected transient boolean isFrozen = false;
    protected transient Vector delayedMappingRemovals = null;
    private transient String errorMsg;
    private transient boolean variableContext = false;

    public ContextCore(AttrTupleManager manager, int mapStyle) {
        this(manager, mapStyle, null);
    }

    public ContextCore(AttrTupleManager manager, int mapStyle, ContextCore parent) {
        super(manager);
        this.mapStyle = mapStyle;
        this.parent = parent;
        this.errorMsg = "";
        VarTuple parentVars = null;
        CondTuple parentCond = null;
        if (parent != null) {
            this.variableContext = parent.isVariableContext();
            parentVars = parent.getVariables();
            parentCond = parent.getConditions();
        }
        this.variables = new VarTuple(manager, new ContextView(manager, this), parentVars);
        this.conditions = new CondTuple(manager, new ContextView(manager, this), parentCond);
    }

    public void dispose() {
        if (this.delayedMappingRemovals != null) {
            this.delayedMappingRemovals.removeAllElements();
        }
        this.delayedMappingRemovals = null;
        this.manager = null;
        this.parent = null;
        if (this.conditions != null) {
            this.conditions.dispose();
            this.conditions = null;
        }
        if (this.variables != null) {
            this.variables.dispose();
            this.variables = null;
        }
        Debug.println("ContextCore: disposed of ", this);
    }

    protected final void finalize() {
        if (this.delayedMappingRemovals != null || this.manager != null || this.parent != null || this.conditions != null || this.variables != null) {
            this.dispose();
        }
        Debug.println("ContextCore: Muelleimer ", this);
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void clearErrorMsg() {
        this.errorMsg = "";
    }

    public CondTuple getConditions() {
        return this.conditions;
    }

    public VarTuple getVariables() {
        return this.variables;
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public void freeze() {
        if (this.delayedMappingRemovals == null) {
            this.delayedMappingRemovals = new Vector(30);
        }
        this.isFrozen = true;
    }

    public void defreeze() {
        this.isFrozen = false;
        this.performDelayedRemove();
    }

    public void setVariableContext(boolean b) {
        this.variableContext = b;
        if (this.parent != null) {
            this.parent.setVariableContext(b);
        }
    }

    public boolean isVariableContext() {
        return this.variableContext;
    }

    public int getAllowedMapping() {
        return this.mapStyle;
    }

    public void addMapping(TupleMapping mapping) {
        ValueTuple target = mapping.getTarget();
        Vector<TupleMapping> mappingsToTarget = (Vector<TupleMapping>)this.mappings.get(target);
        if (mappingsToTarget == null) {
            mappingsToTarget = new Vector<TupleMapping>();
            this.mappings.put(target, mappingsToTarget);
        }
        mappingsToTarget.addElement(mapping);
    }

    protected Hashtable getMapping() {
        return this.mappings;
    }

    public Vector getMappingsToTarget(ValueTuple target) {
        Vector mappingsToValue = (Vector)this.mappings.get(target);
        return mappingsToValue;
    }

    public boolean removeMapping(TupleMapping mapping) {
        ValueTuple target = mapping.getTarget();
        Vector mappingsToTarget = (Vector)this.mappings.get(target);
        if (mappingsToTarget == null) {
            return false;
        }
        if (this.isFrozen()) {
            if (!mappingsToTarget.contains(mapping)) {
                return false;
            }
            this.delayedMappingRemovals.addElement(mapping);
        } else {
            mapping.removeNow();
        }
        return mappingsToTarget.removeElement(mapping);
    }

    private void performDelayedRemove() {
        if (this.delayedMappingRemovals != null) {
            int size = this.delayedMappingRemovals.size();
            for (int i = 0; i < size; ++i) {
                ((TupleMapping)this.delayedMappingRemovals.elementAt(i)).removeNow();
            }
            this.delayedMappingRemovals.removeAllElements();
        }
    }

    public boolean isDeclared(String name) {
        this.logPrintln(AttrSession.logContext, "isDeclared(" + name + ") -> " + this.getVariables().isDeclared(name));
        return this.getVariables().isDeclared(name);
    }

    public boolean addDecl(AttrHandler handler, String type, String name) {
        this.logPrintln(AttrSession.logContext, "addDecl(" + handler + ", " + type + ", " + name + ")");
        try {
            this.getVariables().declare(handler, type, name);
            return true;
        }
        catch (AttrImplException ex) {
            return false;
        }
    }

    public void removeDecl(String name) {
        this.logPrintln(AttrSession.logContext, "removeDecl(" + name + ")");
        this.getVariables().deleteLeafDeclaration(name);
    }

    public DeclMember getDecl(String name) throws NoSuchVariableException {
        DeclMember t = this.getVariables().getTupleType().getDeclMemberAt(name);
        this.logPrintln(AttrSession.logContext, "getType(" + name + ") -> " + t);
        return t;
    }

    public boolean canSetValue(String name, ValueMember value) {
        Debug.println("ContextCore.canSetValue  :  " + name + " <--  " + value);
        boolean doesBreakCondition = false;
        this.errorMsg = "";
        VarMember prevValue = this.getVariables().getVarMemberAt(name);
        if (prevValue == null) {
            System.out.println("ContextCore.canSetValue ::No such variable: " + name);
            this.errorMsg = "No such variable: " + name;
            return false;
        }
        Debug.println("ContextCore.canSetValue:::  " + ((ValueMember)prevValue).getExpr());
        if (((ValueMember)prevValue).getExpr() == null) {
            return !doesBreakCondition;
        }
        if (prevValue.equals(value)) {
            return true;
        }
        this.errorMsg = "Cannot set attribute value.";
        Debug.println("ContextCore.canSetValue :: return false");
        Debug.DEBUG = false;
        return false;
    }

    public void setValue(String name, ValueMember value) throws NoSuchVariableException {
        Debug.println("ContextCore.setValue :: (" + name + " <-- " + value + ")");
        this.logPrintln(AttrSession.logContext, "setValue(" + name + ", " + value + ")");
        VarMember vm = this.getVariables().getVarMemberAt(name);
        if (vm == null) {
            throw new NoSuchVariableException(name);
        }
        HandlerExpr he = value.getExpr();
        vm.unifyWith(he);
        if (value.getExprAsText().equals("null")) {
            vm.setExprAsText("null");
        }
        Debug.println("ContextCore.setValue :: (" + name + " = " + vm.getExpr() + ")");
    }

    public void removeValue(String name) throws NoSuchVariableException {
        if (this.isDeclared(name)) {
            this.getVariables().getVarMemberAt(name).undoUnification();
        }
    }

    public ValueMember getValue(String name) {
        VarMember value = this.getVariables().getVarMemberAt(name);
        if (value == null) {
            throw new NoSuchVariableException(name);
        }
        return value;
    }
}

