/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.impl;

import agg.attribute.AttrTuple;
import agg.attribute.AttrTypeMember;
import agg.attribute.handler.AttrHandler;
import agg.attribute.handler.AttrHandlerException;
import agg.attribute.handler.HandlerType;
import agg.attribute.impl.AttrMsgCode;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.DeclTuple;
import agg.attribute.impl.Member;
import agg.util.XMLHelper;

public class DeclMember
extends Member
implements AttrMsgCode,
AttrTypeMember {
    static final long serialVersionUID = -1967468240702798334L;
    protected DeclTuple tuple;
    protected HandlerType type;
    protected String typeName;
    protected String name;
    protected AttrHandler handler;
    protected boolean isNameValid = false;
    protected String handlerMessage;
    protected boolean visible;

    public DeclMember(DeclTuple tuple) {
        this.tuple = tuple;
        this.visible = true;
    }

    public DeclMember(DeclTuple tuple, AttrHandler handler, String typeString, String name) {
        this(tuple);
        this.setName(name);
        this.retype(handler, typeString);
    }

    protected void retype(AttrHandler handler, String typeName) {
        this.handler = handler;
        this.typeName = typeName.replaceAll(" ", "");
        this.type = null;
        this.handlerMessage = null;
        if (handler == null) {
            return;
        }
        try {
            this.type = handler.newHandlerType(this.typeName);
        }
        catch (AttrHandlerException ex) {
            this.handlerMessage = ex.getMessage();
        }
        this.fireChanged(60);
    }

    public void delete() {
        this.getTuple().deleteMemberAt(this.getTuple().getIndexForMember(this));
    }

    public void setNameValid(boolean b) {
        this.isNameValid = b;
    }

    public boolean isValid() {
        return this.isNameValid && this.type != null;
    }

    public String getValidityReport() {
        if (this.isValid()) {
            return null;
        }
        String report = "-------- DECLARATION : --------\n";
        if (this.handler == null) {
            report = report + "No attribute handler.\n";
        }
        if (this.typeName == null) {
            report = report + "No type.\n";
        }
        if (this.handlerMessage != null) {
            report = report + this.handlerMessage + "\n";
        }
        if (this.name == null) {
            report = report + "No name.\n";
        } else if (!this.isNameValid) {
            report = report + "Name is not unique or a Java data class name.\n";
        }
        return report;
    }

    public AttrHandler getHandler() {
        return this.handler;
    }

    public void setHandler(AttrHandler h) {
        this.handler = h;
        if (this.typeName != null) {
            this.retype(h, this.typeName);
        }
    }

    public HandlerType getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setType(String typeName) {
        this.typeName = typeName.replaceAll(" ", "");
        if (this.handler != null) {
            this.retype(this.handler, this.typeName);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.getTuple() == null) {
            return;
        }
        String prevName = this.name;
        this.name = name.replaceAll(" ", "");
        this.getTuple().checkNameValidity(this.name);
        this.fireChanged(50);
    }

    public void setVisible(boolean vis) {
        this.visible = vis;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public AttrTuple getHoldingTuple() {
        return this.getTuple();
    }

    protected DeclTuple getTuple() {
        return this.tuple;
    }

    protected AttrTupleManager getManager() {
        return this.getTuple().getManager();
    }

    public boolean compareTo(AttrTypeMember mem) {
        if (mem != null) {
            if (this.getTypeName() != null && this.getName() != null && mem.getTypeName() != null && mem.getName() != null) {
                return this.getHandler().getName().equals(mem.getHandler().getName()) && this.getTypeName().equals(mem.getTypeName()) && this.getName().equals(mem.getName());
            }
            return this.getHandler().getName().equals(mem.getHandler().getName());
        }
        return false;
    }

    public void XwriteObject(XMLHelper h) {
        h.openNewElem("AttrType", this);
        h.addAttr("typename", this.getTypeName());
        h.addAttr("attrname", this.getName());
        if (this.visible) {
            h.addAttr("visible", "true");
        } else {
            h.addAttr("visible", "false");
        }
        h.close();
    }

    public void XreadObject(XMLHelper h) {
        if (h.isTag("AttrType", this)) {
            h.close();
        }
    }
}

