/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.impl;

import agg.attribute.AttrMember;
import agg.attribute.AttrObserver;
import agg.attribute.AttrTuple;
import agg.attribute.AttrType;
import agg.attribute.AttrTypeMember;
import agg.attribute.handler.AttrHandler;
import agg.attribute.handler.AttrHandlerException;
import agg.attribute.handler.impl.javaExpr.JexHandler;
import agg.attribute.impl.AttrMsgCode;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.TupleEvent;
import agg.attribute.impl.TupleObject;
import agg.attribute.impl.ValueTuple;
import agg.attribute.view.AttrViewSetting;
import agg.attribute.view.impl.OpenViewSetting;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclTuple
extends TupleObject
implements AttrType,
AttrMsgCode,
XMLObject {
    protected static AttrViewSetting fixedFormSetting;
    private OpenViewSetting view = null;
    protected Vector<DeclTuple> parents = new Vector(5);
    private Vector<DeclTuple> directParents = new Vector(5);
    protected boolean loneDeclaration = false;

    public DeclTuple(AttrTupleManager manager) {
        this(manager, null);
    }

    public DeclTuple(AttrTupleManager manager, DeclTuple parent) {
        super(manager, parent);
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        String s = "";
        if (this.view != null) {
            this.view.removeFormat(this);
            s = this.view.getClass().getName() + " " + this.view.hashCode();
        }
        this.view = null;
    }

    @Override
    protected void finalize() {
        super.finalize();
        String result = "";
        int resulti = 0;
        for (int i = 0; i < this.getSize(); ++i) {
            resulti += this.getMemberAt(i).hashCode();
        }
        result = result + resulti + "\n";
    }

    protected void removeParents() {
        for (int i = 0; i < this.parents.size(); ++i) {
            this.parents.get(i).removeObserver(this);
        }
        this.parents.clear();
        this.parent = null;
    }

    protected Vector<DeclTuple> getParents() {
        return this.parents;
    }

    protected DeclTuple getParent(int index) {
        if (index < this.directParents.size()) {
            return this.directParents.get(index);
        }
        return null;
    }

    public void setView(OpenViewSetting ovs) {
        this.view = ovs;
    }

    public OpenViewSetting getView() {
        return this.view;
    }

    @Override
    public int getSize() {
        return this.getParentsSize() + this.rawGetSize();
    }

    public int getParentSize(DeclTuple p) {
        if (this.parents.contains(p)) {
            return p.getSize();
        }
        return 0;
    }

    protected int getParentsSize() {
        int s = 0;
        if (this.parents.isEmpty()) {
            return 0;
        }
        for (int i = 0; i < this.parents.size(); ++i) {
            s += this.parents.get(i).rawGetSize();
        }
        return s;
    }

    public Vector<DeclTuple> getDirectParents() {
        return this.directParents;
    }

    private void showParents(Vector<DeclTuple> parentList) {
        if (parentList == this.parents) {
            System.out.println("DeclTuple:: All Relatives of  \"" + this.hashCode() + "\"" + "  :  " + parentList.size());
        } else if (parentList == this.directParents) {
            System.out.println("DeclTuple:: Direct Relatives of  \"" + this.hashCode() + "\"" + "  :  " + parentList.size());
        }
        for (int i = 0; i < parentList.size(); ++i) {
            TupleObject p = parentList.get(i);
            System.out.print("\"" + p.hashCode() + "\", ");
        }
        System.out.println("\n***************************");
    }

    protected int toLeafIndex(int rootIndex) {
        return rootIndex - this.getParentsSize();
    }

    protected int toRootIndex(int leafIndex) {
        return leafIndex + this.getParentsSize();
    }

    protected AttrMember getLeafMemberAt(int rootIndex) {
        return this.rawGetMemberAt(this.toLeafIndex(rootIndex));
    }

    protected DeclMember getDeclMemberAt(int index) {
        return (DeclMember)this.getMemberAt(index);
    }

    protected DeclMember getDeclMemberAt(String name) {
        return (DeclMember)this.getMemberAt(name);
    }

    protected DeclMember newMember() {
        return new DeclMember(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteLeafMemberAt(int rootIndex) {
        DeclTuple declTuple = this;
        synchronized (declTuple) {
            this.rawDeleteMemberAt(this.toLeafIndex(rootIndex));
            this.fireAttrChanged(20, rootIndex);
        }
    }

    @Override
    protected AttrViewSetting getForm() {
        return fixedFormSetting;
    }

    @Override
    protected void setForm(AttrViewSetting formSetting) {
        fixedFormSetting = formSetting;
    }

    @Override
    public DeclTuple getTupleType() {
        return this;
    }

    public void checkNameValidity(String name) {
        if (name == null) {
            return;
        }
        if (this.isClassName(name)) {
            this.getDeclMemberAt(name).setNameValid(false);
            return;
        }
        int first = -1;
        boolean valid = true;
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.getMemberAt(i) == null || !name.equals(this.getMemberAt(i).getName())) continue;
            if (first == -1) {
                first = i;
                continue;
            }
            valid = false;
            this.getDeclMemberAt(i).setNameValid(false);
        }
        if (first != -1) {
            this.getDeclMemberAt(first).setNameValid(valid);
        }
    }

    public boolean isClassName(String name) {
        String result = null;
        boolean isClass = false;
        try {
            Class<?> c = Class.forName(name);
            result = name;
            isClass = true;
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        if (!isClass) {
            AttrHandler[] attrHandlers = AttrTupleManager.getDefaultManager().getHandlers();
            for (int h = 0; h < attrHandlers.length; ++h) {
                AttrHandler attrh = attrHandlers[h];
                Vector packs = ((JexHandler)attrh).getClassResolver().getPackages();
                for (int pi = 0; pi < packs.size(); ++pi) {
                    String pack = (String)packs.get(pi);
                    try {
                        Class<?> c = Class.forName(pack + "." + name);
                        result = pack + "." + name;
                        isClass = true;
                        break;
                    }
                    catch (ClassNotFoundException ex) {
                        continue;
                    }
                }
                if (isClass) break;
            }
        }
        return result != null;
    }

    public boolean containsName(String name) {
        return this.getIndexForName(name) > -1;
    }

    public boolean containsMember(DeclMember m) {
        return m.getHoldingTuple() == this;
    }

    public boolean isLeafMember(String name) {
        return this.getLeafMemberAt(this.getIndexForName(name)) != null;
    }

    @Override
    protected DeclTuple getParentInCharge(int index) {
        int s = 0;
        for (int i = 0; i < this.parents.size(); ++i) {
            if (index >= (s += this.parents.get(i).rawGetSize())) continue;
            return this.parents.get(i);
        }
        return this;
    }

    @Override
    public AttrMember getMemberAt(int index) {
        if (index == -1) {
            return null;
        }
        return this.getParentInCharge(index).getLeafMemberAt(index);
    }

    @Override
    public AttrMember getMemberAt(String name) {
        return this.getMemberAt(this.getIndexForName(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttrTypeMember addMember() {
        DeclTuple declTuple = this;
        synchronized (declTuple) {
            DeclMember member = this.newMember();
            this.addMember(member);
            this.fireAttrChanged(10, this.getSize() - 1);
            return member;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttrTypeMember addMember(AttrHandler handler, String type, String name) {
        DeclTuple declTuple = this;
        synchronized (declTuple) {
            if (handler == null) {
                return null;
            }
            if (type == null) {
                return null;
            }
            DeclMember member = this.newMember();
            this.addMember(member);
            int newIndex = this.getSize() - 1;
            member.setName(name);
            member.retype(handler, type);
            this.fireAttrChanged(10, newIndex);
            return member;
        }
    }

    @Override
    public void deleteMemberAt(int index) {
        this.getParentInCharge(index).deleteLeafMemberAt(index);
    }

    @Override
    public void deleteMemberAt(AttrViewSetting viewSetting, int slot) {
        this.deleteMemberAt(this.ensureNonNull(viewSetting).convertSlotToIndex(this, slot));
    }

    @Override
    public void deleteMemberAt(String name) {
        this.deleteMemberAt(this.getIndexForName(name));
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        int num = this.getNumberOfEntries();
        for (int i = 0; i < num; ++i) {
            DeclMember mem = (DeclMember)this.getMemberAt(i);
            h.addObject("", mem, true);
        }
    }

    @Override
    public void XreadObject(XMLHelper h) {
        String handlerName = JexHandler.getLabelName();
        AttrHandler handler = this.getAttrManager().getHandler(handlerName);
        Enumeration en = h.getEnumeration("", null, true, "AttrType");
        while (en.hasMoreElements()) {
            h.peekElement(en.nextElement());
            String t = h.readAttr("typename");
            String n = h.readAttr("attrname");
            String vis = h.readAttr("visible");
            if (t.length() != 0 || n.length() != 0) {
                AttrTypeMember mem = this.addMember(handler, t, n);
                if (vis.equals("true") || vis.equals("")) {
                    ((DeclMember)mem).setVisible(true);
                } else {
                    ((DeclMember)mem).setVisible(false);
                }
                if (mem.getType() == null) {
                    System.out.println("DeclTuple.XreadObject: WARNING!\nThe type of an attribute member is empty.\nPlease check attribute declarations\nor check in AGG GUI the part of the attribute editor\n<Customize/ Handler / Searched Packages>  \nand append the missed package.");
                }
                if (mem.getName() == null || mem.getName().length() == 0) {
                    System.out.println("DeclTuple.XreadObject: WARNING!\nThe name of an attribute member is empty.\nPlease check attribute declarations.");
                }
                h.loadObject(mem);
            } else if (t.length() == 0 && n.length() == 0) {
                System.out.println("DeclTuple.XreadObject: WARNING!\nAn attribute member could not be created, \nbecause type and name of the member are empty.");
            }
            h.close();
        }
    }

    @Override
    public int getIndexForName(String name) {
        int size = this.getSize();
        for (int i = 0; i < size; ++i) {
            String n;
            DeclMember dm = this.getDeclMemberAt(i);
            if (dm == null || (n = dm.getName()) == null || !n.equals(name)) continue;
            return i;
        }
        return -1;
    }

    public int isLegalType(AttrHandler handler, String typeName) {
        int msgCode = 0;
        try {
            if (handler.newHandlerType(typeName) == null) {
                msgCode = 1;
            }
        }
        catch (AttrHandlerException ex) {
            msgCode = 1;
        }
        return msgCode;
    }

    public int isLegalName(String text) {
        int msgCode = 0;
        if (this.containsName(text)) {
            msgCode = 2;
        }
        return msgCode;
    }

    public void renameMemberAt(int index, String name) {
        DeclMember member = this.getDeclMemberAt(index);
        member.setName(name);
    }

    public void retypeMemberAt(int index, AttrHandler handler, String type) {
        DeclMember member = this.getDeclMemberAt(index);
        member.setHandler(handler);
        member.setType(type);
    }

    public void removeEntryAt(int index) {
        this.deleteMemberAt(index);
    }

    @Override
    public int getNumberOfEntries() {
        return this.getSize();
    }

    @Override
    public String getTypeAsString(int entryIndex) {
        Object type = null;
        if (this.getDeclMemberAt(entryIndex) != null) {
            type = this.getDeclMemberAt(entryIndex).getType();
        }
        if (type == null) {
            return "";
        }
        return type.toString();
    }

    @Override
    public String getNameAsString(int entryIndex) {
        if (this.getDeclMemberAt(entryIndex) != null) {
            return this.getDeclMemberAt(entryIndex).getName();
        }
        return "";
    }

    @Override
    public String getValueAsString(int entryIndex) {
        return "";
    }

    @Override
    public void addObserver(AttrObserver attrObs) {
        if (!super.contains(attrObs)) {
            if (attrObs instanceof AttrViewSetting) {
                super.addObserverAtPos(attrObs, 0);
            } else {
                super.addObserver(attrObs);
            }
        }
    }

    @Override
    public void updateMemberAdded(TupleEvent e) {
        AttrTuple tuple = e.getSource();
        if (tuple != null && this.parents.contains(tuple)) {
            this.propagateEvent(e);
        }
    }

    @Override
    public void updateMemberDeleted(TupleEvent e) {
        AttrTuple tuple = e.getSource();
        if (tuple != null && this.parents.contains(tuple)) {
            this.propagateEvent(e);
        }
    }

    @Override
    public String toString() {
        String result = "\n-----------------------------------------------------\n";
        result = result + this.getClass().getName() + "@" + this.hashCode() + "\n";
        int size = this.getSize();
        result = 0 < size ? result + "Tuple enthaelt " + size + " Member" : result + "Tuple ist leer";
        result = result + "\n";
        for (int i = 0; i < size; ++i) {
            result = result + this.getMemberAt(i) + "\n";
        }
        int resulti = 0;
        for (int i = 0; i < this.getSize(); ++i) {
            resulti += this.getMemberAt(i).hashCode();
        }
        result = result + resulti + "\n";
        result = result + "-----------------------------------------------------";
        return result;
    }

    @Override
    public void addEntry(AttrHandler handler, String type, String name) {
        this.addMember(handler, type, name);
    }

    @Override
    public void deleteEntry(String name) {
        this.deleteMemberAt(name);
    }

    @Override
    public boolean compareTo(AttrType tuple) {
        int size = this.getNumberOfEntries();
        boolean isEqual = this.getClass().equals(tuple.getClass());
        for (int n = 0; n < size && isEqual; ++n) {
            DeclMember mem = (DeclMember)this.getMemberAt(n);
            if (mem == null) continue;
            isEqual = mem.compareTo((DeclMember)((DeclTuple)tuple).getMemberAt(mem.getName()));
        }
        return isEqual;
    }

    private DeclMember getEntryAt(int index) {
        return (DeclMember)this.getMemberAt(index);
    }

    private DeclMember getEntryAt(String name) {
        return (DeclMember)this.getMemberAt(name);
    }

    public void setParent(DeclTuple newParent) {
        this.addParent(newParent);
        Enumeration en = this.getObservers();
        while (en.hasMoreElements()) {
            AttrObserver obs = (AttrObserver)en.nextElement();
            if (obs instanceof ValueTuple) {
                ValueTuple currentValueTuple = (ValueTuple)obs;
                currentValueTuple.refreshParents();
                continue;
            }
            if (!(obs instanceof OpenViewSetting)) continue;
            OpenViewSetting myOpenView = (OpenViewSetting)obs;
            myOpenView.resetTuple(this);
        }
    }

    public boolean addParent(DeclTuple p) {
        if (p != null && !this.parents.contains(p)) {
            p.addObserver(this);
            this.parent = p;
            for (int i = 0; i < p.getParents().size(); ++i) {
                DeclTuple pi = p.getParents().get(i);
                if (this.parents.contains(pi)) continue;
                this.parents.add(pi);
                pi.addObserver(this);
            }
            this.parents.add(p);
            this.directParents.add(p);
            this.refreshObservers();
            return true;
        }
        return false;
    }

    public void removeParent(DeclTuple p) {
        if (p != null && this.parents.contains(p)) {
            DeclTuple pi;
            int i;
            if (this.directParents.contains(p)) {
                this.directParents.remove(p);
            }
            boolean canremove = true;
            for (i = 0; i < this.directParents.size(); ++i) {
                pi = this.directParents.get(i);
                if (!pi.getParents().contains(p)) continue;
                canremove = false;
                break;
            }
            if (canremove) {
                p.removeObserver(this);
                this.parents.remove(p);
            }
            for (i = 0; i < p.getParents().size(); ++i) {
                pi = p.getParents().get(i);
                if (!this.parents.contains(pi)) continue;
                canremove = true;
                for (int j = 0; j < this.directParents.size(); ++j) {
                    DeclTuple itspj = this.directParents.get(j);
                    if (!itspj.getParents().contains(pi)) continue;
                    canremove = false;
                    break;
                }
                if (!canremove) continue;
                pi.removeObserver(this);
                this.parents.remove(pi);
            }
            if (this.parent == p) {
                this.parent = !this.directParents.isEmpty() ? (TupleObject)this.directParents.lastElement() : null;
            }
        }
        this.refreshObservers();
    }

    public void refreshParents() {
        this.refreshParentsAfterRemove();
    }

    public void refreshParentsAfterAdd() {
        for (int i = 0; i < this.directParents.size(); ++i) {
            DeclTuple pi = this.directParents.get(i);
            for (int j = 0; j < pi.getParents().size(); ++j) {
                DeclTuple pj = pi.getParents().get(j);
                int indx = this.parents.indexOf(pi);
                if (!this.parents.contains(pj)) {
                    this.parents.add(indx, pj);
                    pj.addObserver(this);
                    continue;
                }
                int indx1 = this.parents.indexOf(pj);
                if (indx1 <= indx) continue;
                this.parents.remove(pj);
                this.parents.add(indx, pj);
            }
        }
        this.refreshObservers();
    }

    public void refreshParentsAfterRemove() {
        DeclTuple pi;
        int i;
        Vector<DeclTuple> parCopy = new Vector<DeclTuple>(this.parents);
        this.removeParents();
        for (i = 0; i < this.directParents.size(); ++i) {
            pi = this.directParents.get(i);
            this.parents.add(pi);
            pi.addObserver(this);
        }
        for (i = 0; i < this.directParents.size(); ++i) {
            pi = this.directParents.get(i);
            for (int j = 0; j < pi.getParents().size(); ++j) {
                DeclTuple pj = pi.getParents().get(j);
                if (this.parents.contains(pj)) continue;
                int indx = this.parents.indexOf(pi);
                this.parents.add(indx, pj);
                pj.addObserver(this);
            }
        }
        this.refreshObservers();
    }

    public void refreshObservers() {
        Enumeration en = this.getObservers();
        while (en.hasMoreElements()) {
            AttrObserver obs = (AttrObserver)en.nextElement();
            if (obs instanceof ValueTuple) {
                ValueTuple currentValueTuple = (ValueTuple)obs;
                currentValueTuple.refreshParents();
                this.fireAttrChanged(0, 0);
                continue;
            }
            if (!(obs instanceof OpenViewSetting)) continue;
            OpenViewSetting myOpenView = (OpenViewSetting)obs;
            myOpenView.resetTuple(this);
            this.fireAttrChanged(0, 0);
        }
    }
}

