/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.impl;

import agg.attribute.AttrMapping;
import agg.attribute.impl.AttrImplException;
import agg.attribute.impl.AttrMsgCode;
import agg.attribute.impl.AttrObject;
import agg.attribute.impl.AttrSession;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.ValueTuple;
import java.util.Vector;

public class TupleMapping
extends AttrObject
implements AttrMapping,
AttrMsgCode {
    static final long serialVersionUID = 5592548875776404533L;
    protected ValueTuple source;
    protected ValueTuple target;
    protected ContextView context;
    protected String[] assignedVariables;

    public TupleMapping(ContextView mappingContext, ValueTuple src, ValueTuple tar) {
        this.logPrintln(AttrSession.logTrace, "TupleMapping:\n->new TupleMapping");
        if (mappingContext.getAllowedMapping() == 0) {
            this.logPrintln(AttrSession.logMapping, "creating TupleMapping for a plain mapping");
            if (!src.getType().compareTo(tar.getType())) {
                throw new AttrImplException(9, "Types must be equal.");
            }
        } else if (mappingContext.getAllowedMapping() == 1) {
            this.logPrintln(AttrSession.logMapping, "creating TupleMapping for a match mapping");
            if (!src.getType().compareTo(tar.getType()) && !tar.getTupleType().isSubclassOf(src.getTupleType())) {
                throw new AttrImplException("Target type must be subtype of source or equal.");
            }
        }
        String[] variables = null;
        this.context = mappingContext;
        this.logPrintln(AttrSession.logContextOfInstances, "mappingContext = " + this.getAllowedMappingAsString(mappingContext) + " " + mappingContext);
        this.logPrintln(AttrSession.logContextOfInstances, "src.context = " + this.getAllowedMappingAsString(src.getContextView()) + " " + src.getContextView());
        this.logPrintln(AttrSession.logContextOfInstances, "tar.context = " + this.getAllowedMappingAsString(tar.getContextView()) + " " + tar.getContextView());
        if (this.context == null) {
            this.context = src.getContextView();
        }
        try {
            if (this.context.getAllowedMapping() == 1) {
                variables = src.matchTo(tar, this.context);
            }
        }
        catch (AttrImplException ex1) {
            throw new AttrImplException("TupleMapping: attribute exception\n" + ex1.getMessage());
        }
        this.source = src;
        this.target = tar;
        this.assignedVariables = variables;
        this.context.addMapping(this);
        this.logPrintln(AttrSession.logTrace, "TuppleMapping:\n<-new TuppleMapping");
    }

    public void adoptEntriesWhereEmpty(ValueTuple src, ValueTuple tar) {
        try {
            if (this.context.getAllowedMapping() == 0) {
                tar.adoptEntriesWhereEmpty(src);
            }
        }
        catch (AttrImplException ex1) {
            throw new AttrImplException("TupleMapping: attribute exception\n" + ex1.getMessage());
        }
    }

    public Vector getAssignedVariables() {
        int nn = this.assignedVariables == null ? -1 : this.assignedVariables.length;
        Vector<String> v = new Vector<String>(1);
        for (int i = 0; i < nn; ++i) {
            v.add(this.assignedVariables[i]);
        }
        return v;
    }

    public boolean next() {
        return false;
    }

    public void remove() {
        this.context.removeMapping(this);
    }

    public void removeNow() {
        if (this.assignedVariables != null) {
            for (int i = 0; i < this.assignedVariables.length; ++i) {
                this.context.removeValue(this.assignedVariables[i]);
            }
        }
    }

    public ValueTuple getSource() {
        return this.source;
    }

    public ValueTuple getTarget() {
        return this.target;
    }

    protected String getAllowedMappingAsString(ContextView context) {
        if (context == null) {
            return "";
        }
        return context.getAllowedMapping() == 1 ? " (match)" : " (plain)";
    }
}

