/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.impl;

import agg.attribute.AttrMember;
import agg.attribute.AttrTuple;
import agg.attribute.AttrType;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.ChainedObserver;
import agg.attribute.impl.DeclTuple;
import agg.attribute.impl.TupleEvent;
import agg.attribute.view.AttrViewSetting;
import agg.util.Disposable;
import java.util.Vector;

public abstract class TupleObject
extends ChainedObserver
implements AttrTuple,
Disposable {
    protected TupleObject parent;
    protected Vector members = new Vector(10, 10);

    public TupleObject(AttrTupleManager manager, TupleObject parent) {
        super(manager);
        this.assignParent(parent);
    }

    protected void finalize() {
    }

    public void dispose() {
        if (this.parent != null) {
            this.parent.removeObserver(this);
        }
        this.members.clear();
    }

    protected void assignParent(TupleObject newParent) {
        if (this.parent != null) {
            this.parent.removeObserver(this);
        }
        this.parent = newParent;
        if (this.parent != null) {
            this.parent.addObserver(this);
        }
    }

    protected void propagateEvent(TupleEvent e) {
        this.fireAttrChanged(e.cloneWithNewSource(this));
    }

    public void memberChanged(int code, AttrMember member) {
        this.fireAttrChanged(code, this.getIndexForMember(member));
    }

    protected synchronized int rawGetSize() {
        if (this.members == null) {
            this.members = new Vector(10, 10);
        }
        return this.members.size();
    }

    protected synchronized AttrMember rawGetMemberAt(int index) {
        if (this.members.size() == 0 || index < 0) {
            return null;
        }
        if (index >= this.members.size()) {
            index = 0;
        }
        return (AttrMember)this.members.elementAt(index);
    }

    protected synchronized void rawAddMember(AttrMember member) {
        if (member != null) {
            this.members.addElement(member);
        }
    }

    protected synchronized void rawDeleteMemberAt(int index) {
        if (index >= this.members.size()) {
            return;
        }
        this.members.removeElementAt(index);
    }

    public abstract DeclTuple getTupleType();

    public AttrType getType() {
        return this.getTupleType();
    }

    protected AttrViewSetting getForm() {
        return this.getTupleType().getForm();
    }

    protected void setForm(AttrViewSetting formSetting) {
        this.getTupleType().setForm(formSetting);
    }

    protected AttrViewSetting ensureNonNull(AttrViewSetting viewSetting) {
        if (viewSetting == null) {
            return this.manager.getDefaultMaskedView();
        }
        return viewSetting;
    }

    protected int getIndexInView(AttrViewSetting viewSetting, int slot) {
        return this.ensureNonNull(viewSetting).convertSlotToIndex(this, slot);
    }

    protected TupleObject getParent() {
        return this.parent;
    }

    public int getParentSize() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.getSize();
    }

    protected TupleObject getParentInCharge(int index) {
        if (index >= this.getParentSize()) {
            return this;
        }
        return this.parent.getParentInCharge(index);
    }

    protected void addMember(AttrMember member) {
        this.rawAddMember(member);
    }

    protected void deleteMemberAt(int index) {
        this.rawDeleteMemberAt(index);
    }

    public boolean isSubclassOf(TupleObject maybeParent) {
        if (this.parent == null) {
            return false;
        }
        if (this.parent == maybeParent) {
            return true;
        }
        return this.parent.isSubclassOf(maybeParent);
    }

    public int getSize() {
        return this.rawGetSize();
    }

    public boolean isValid() {
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.getMemberAt(i).isValid()) continue;
            return false;
        }
        return true;
    }

    public AttrMember getMemberAt(int index) {
        return this.rawGetMemberAt(index);
    }

    public AttrMember getMemberAt(AttrViewSetting viewSetting, int slot) {
        return this.getMemberAt(this.ensureNonNull(viewSetting).convertSlotToIndex(this, slot));
    }

    public AttrMember getMemberAt(String name) {
        return this.getMemberAt(this.getIndexForName(name));
    }

    public int getIndexForName(String name) {
        return this.getTupleType().getIndexForName(name);
    }

    public int getIndexForMember(AttrMember m) {
        if (m == null) {
            return -1;
        }
        int size = this.getSize();
        for (int i = 0; i < size; ++i) {
            if (m != this.getMemberAt(i)) continue;
            return i;
        }
        return -1;
    }

    public int getNumberOfEntries() {
        return this.getSize();
    }

    public String getTypeAsString(int index) {
        return this.getType().getTypeAsString(index);
    }

    public String getNameAsString(int index) {
        return this.getType().getNameAsString(index);
    }

    public String getValueAsString(int index) {
        return "";
    }

    public int getNumberOfEntries(AttrViewSetting viewSetting) {
        return this.ensureNonNull(viewSetting).getSize(this);
    }

    public String getTypeAsString(AttrViewSetting viewSetting, int entryIndex) {
        return this.getTypeAsString(this.getIndexInView(viewSetting, entryIndex));
    }

    public String getNameAsString(AttrViewSetting viewSetting, int entryIndex) {
        return this.getNameAsString(this.getIndexInView(viewSetting, entryIndex));
    }

    public String getValueAsString(AttrViewSetting viewSetting, int entryIndex) {
        return this.getValueAsString(this.getIndexInView(viewSetting, entryIndex));
    }
}

