/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.impl;

import agg.attribute.AttrContext;
import agg.attribute.AttrInstanceMember;
import agg.attribute.AttrTuple;
import agg.attribute.AttrTypeMember;
import agg.attribute.handler.AttrHandler;
import agg.attribute.handler.AttrHandlerException;
import agg.attribute.handler.HandlerExpr;
import agg.attribute.handler.HandlerType;
import agg.attribute.impl.AttrImplException;
import agg.attribute.impl.AttrMsgCode;
import agg.attribute.impl.AttrSession;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.Member;
import agg.attribute.impl.NoSuchVariableException;
import agg.attribute.impl.TupleMapping;
import agg.attribute.impl.ValueTuple;
import agg.attribute.parser.javaExpr.SimpleNode;
import agg.util.XMLHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ValueMember
extends Member
implements AttrInstanceMember,
AttrMsgCode {
    public static final String EMPTY_VALUE_SYMBOL = "";
    protected DeclMember decl;
    protected ValueTuple tuple;
    protected HandlerExpr expression;
    protected String expressionText;
    protected Object expressionObject;
    protected transient Exception currentException;
    protected transient String errorMsg;
    protected boolean isTransient;

    public ValueMember(ValueTuple tuple, DeclMember decl) {
        this.tuple = tuple;
        this.decl = decl;
        if (decl == null) {
            Thread.dumpStack();
        }
        this.rawSetExpr(null);
        this.checkValidity();
        this.errorMsg = EMPTY_VALUE_SYMBOL;
        this.isTransient = false;
        this.logPrintln(AttrSession.logContextOfInstances, "Member created for Tuple:" + tuple);
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public boolean isValid() {
        return this.currentException == null;
    }

    public String getValidityReport() {
        if (this.isValid() && this.getDeclaration().isValid()) {
            return null;
        }
        String report = this.getDeclaration().getValidityReport();
        if (this.isValid()) {
            return report;
        }
        if (report == null) {
            report = EMPTY_VALUE_SYMBOL;
        }
        if (this.currentException != null) {
            report = report + this.currentException.getMessage();
        }
        return report;
    }

    public AttrTypeMember getDeclaration() {
        return this.getDecl();
    }

    public Object getExprAsObject() {
        if (this.getExpr() != null) {
            return this.getExpr().getValue();
        }
        return null;
    }

    public HandlerExpr getExpr() {
        return this.rawGetExpr();
    }

    public String getExprAsText() {
        if (this.getExpr() == null) {
            return this.expressionText;
        }
        return ((Object)this.getExpr()).toString();
    }

    public void setExpr(HandlerExpr expr) {
        if (expr == null) {
            this.expressionText = null;
            this.expressionObject = null;
        }
        this.setCheckedExpr(expr);
        this.fireChanged(70);
    }

    public void setExprAsObject(Object obj) {
        this.rawSetExprAsObject(obj);
        this.fireChanged(70);
    }

    protected void rawSetExprAsObject(Object obj) {
        try {
            this.expressionText = null;
            this.expressionObject = obj;
            if (this.getType() != null && obj != null) {
                this.expression = this.getHandler().newHandlerValue(this.getType(), obj);
            }
            this.checkValidity();
        }
        catch (AttrHandlerException ex) {
            this.currentException = ex;
        }
    }

    public void setExprAsText(String exprText) {
        ContextView context;
        String s = exprText;
        if (s.length() == 0 && ((context = this.getContext()) == null || context.doesAllowEmptyValues())) {
            this.setExpr(null);
            return;
        }
        if (s.length() != 0 && s.charAt(0) == '(') {
            char ch = s.charAt(0);
            for (int i = 1; i < s.length(); ++i) {
                if (s.charAt(i) != ')') continue;
                if (i == s.length() - 1) {
                    String ss;
                    s = ss = s.substring(1, s.length() - 1);
                    i = s.length() + 1;
                    continue;
                }
                i = s.length() + 1;
            }
        }
        if (!s.equals(exprText)) {
            this.rawSetExprAsText(s);
        } else {
            this.rawSetExprAsText(exprText);
        }
        if (this.currentException == null) {
            this.fireChanged(70);
        }
    }

    protected void rawSetExprAsText(String exprText) {
        String lastExpressionText = this.expressionText;
        HandlerExpr lastExpression = this.expression;
        Object lastExpressionObject = this.expressionObject;
        this.currentException = null;
        try {
            this.expressionText = exprText;
            this.expressionObject = null;
            HandlerExpr test = null;
            if (exprText != null && exprText.length() != 0) {
                test = this.getHandler().newHandlerExpr(this.getType(), exprText);
                this.checkValidity(test);
                if (this.currentException == null) {
                    this.expression = test;
                    this.expressionText = exprText;
                } else {
                    this.fireChanged(80);
                    this.expression = test;
                    return;
                }
            }
            this.checkValidity();
            if (this.currentException == null && this.getContext().getAllowedMapping() == 2 && test != null) {
                this.apply(test);
                if (this.currentException != null) {
                    this.expression = null;
                    this.expressionText = EMPTY_VALUE_SYMBOL;
                    this.expressionObject = null;
                    this.fireChanged(80);
                }
            }
        }
        catch (AttrHandlerException ex) {
            this.currentException = ex;
            this.errorMsg = ex.getMessage();
            AttrSession.logPrintln(AttrSession.logTrace, "ValueMember:\t rawSetExprAsText AttrHandlerException " + ex);
            this.expressionText = lastExpressionText;
            this.expressionObject = lastExpressionObject;
            this.expression = lastExpression;
        }
        AttrSession.logPrintln(AttrSession.logTrace, "ValueMember:\t rawSetExprAsText Expression " + this.expression + " " + this.hashCode() + " " + this.getClass());
        AttrSession.logPrintln(AttrSession.logTrace, "ValueMember:\n<-rawSetExprAsText");
    }

    public void setExprAsEvaluatedText(String exprText) {
        try {
            this.expressionText = exprText;
            this.expressionObject = null;
            this.expression = this.getHandler().newHandlerExpr(this.getType(), exprText);
            this.expression.evaluate(this.getContext());
            this.expressionText = null;
            this.expressionObject = this.expression.getValue();
            this.checkValidity();
            this.fireChanged(70);
        }
        catch (AttrHandlerException ex) {
            this.currentException = ex;
            this.expression = null;
        }
    }

    public void typeChanged() {
        boolean prevValidity = this.isValid();
        this.expression = null;
        try {
            if (this.expressionText != null) {
                this.expression = this.getHandler().newHandlerExpr(this.getType(), this.expressionText);
            } else if (this.expressionObject != null) {
                this.expression = this.getHandler().newHandlerValue(this.getType(), this.expressionObject);
            }
        }
        catch (Exception ex) {
            this.currentException = ex;
            this.expressionText = null;
            this.expressionObject = null;
        }
        this.checkValidity();
        if (prevValidity != this.isValid()) {
            this.fireChanged(80);
        }
    }

    public boolean isEmpty() {
        return this.getExpr() == null;
    }

    public boolean isSet() {
        return !this.isEmpty();
    }

    protected void apply(HandlerExpr expr) {
        if (expr != null && !((Object)expr).toString().equals("null")) {
            HandlerExpr oldExpr = this.getExpr();
            HandlerExpr exp = null;
            this.expression = expr.getCopy();
            try {
                Hashtable mappings = this.getContext().getMapping();
                Enumeration en = mappings.elements();
                while (en.hasMoreElements()) {
                    Vector v = (Vector)en.nextElement();
                    for (int i = 0; i < v.size(); ++i) {
                        TupleMapping tm = (TupleMapping)v.elementAt(i);
                    }
                }
                exp = this.expression;
                if (exp != null) {
                    exp.evaluate(this.getContext());
                }
                if (exp != null && exp.getValue() == null) {
                    this.expressionText = EMPTY_VALUE_SYMBOL;
                    this.expression = null;
                    this.expressionObject = null;
                } else if (exp != null && exp.getValue() != null) {
                    this.fireChanged(70);
                }
            }
            catch (AttrHandlerException ex1) {
                this.expression = oldExpr;
                throw new AttrImplException(8, ex1.getMessage() + "\n" + expr + "  don't match to  " + this.expression);
            }
            catch (Exception ex) {
                this.expression = oldExpr;
                throw new AttrImplException(8, ex.getMessage() + "\n" + expr + "  don't match to  " + this.expression);
            }
        }
    }

    public void apply(ValueMember rightSide, AttrContext context) {
        if (this.getName().equals("HASHCODE")) {
            return;
        }
        this.logPrintln(AttrSession.logTrace, "ValueMember:\n->apply");
        this.logPrintln(AttrSession.logTrace, "rechte Regelseite: " + rightSide);
        this.logPrintln(AttrSession.logTrace, "Text " + this.expressionText);
        this.logPrintln(AttrSession.logTrace, "Object " + this.expressionObject);
        if (rightSide != null && rightSide.getExpr() != null) {
            HandlerExpr oldExpr = this.getExpr();
            HandlerExpr exp = null;
            this.expression = rightSide.getExpr().getCopy();
            AttrSession.logPrintln(AttrSession.logJexParser, "ValueMember.apply:: after rightSide.getExpr().getCopy(): value = " + this.getExpr().getValue());
            try {
                if (AttrSession.logTrace) {
                    String debug = EMPTY_VALUE_SYMBOL;
                    debug = oldExpr.isConstant() ? "konstant" : (oldExpr.isComplex() ? "komplex" : (oldExpr.isVariable() ? "variable" : "kommischerweise weder noch !!!"));
                    this.logPrintln("linke expression ist: " + debug + "\n^^^^^ ist wahrscheinlich rechte expression");
                    this.logPrintln("alte Expression: " + oldExpr + "\tneue Expression: " + this.getExpr());
                }
                this.logPrintln(AttrSession.logTrace, "Komplex oder Variable ");
                Hashtable mappings = ((ContextView)context).getMapping();
                this.logPrintln(AttrSession.logTrace, "mappings geholt " + mappings);
                Enumeration en = mappings.elements();
                while (en.hasMoreElements()) {
                    Vector v = (Vector)en.nextElement();
                    for (int i = 0; i < v.size(); ++i) {
                        TupleMapping tm = (TupleMapping)v.elementAt(i);
                        this.logPrintln(AttrSession.logTrace, "TuppleMapping geholt");
                    }
                }
                this.logPrintln(AttrSession.logTrace, "ende mit TuppleMapping check");
                exp = this.getExpr();
                if (exp != null) {
                    AttrSession.logPrintln(AttrSession.logJexParser, "ValueMember.apply : try exp.evaluate( context )");
                    AttrSession.logPrintln(AttrSession.logJexParser, "ValueMember.apply:: befor exp.evaluate(): value = " + exp.getValue());
                    exp.evaluate(context);
                    AttrSession.logPrintln(AttrSession.logJexParser, "ValueMember.apply:: after exp.evaluate(): value = " + exp.getValue());
                }
                if (exp != null && exp.getValue() == null) {
                    this.setExprAsText(exp.getString());
                } else if (exp != null && exp.getValue() != null) {
                    this.fireChanged(70);
                }
            }
            catch (AttrHandlerException ex1) {
                this.expression = oldExpr;
                AttrSession.logPrintln(AttrSession.logJexParser, "ValueMember.apply : EXPR_EVAL_ERR");
                throw new AttrImplException(8, ex1.getMessage() + "\n" + rightSide.getExpr() + "  don't match to  " + this.expression);
            }
            catch (Exception ex) {
                this.expression = oldExpr;
                AttrSession.logPrintln(AttrSession.logJexParser, "ValueMember.apply : EXPR_EVAL_ERR");
                throw new AttrImplException(8, ex.getMessage() + "\n" + rightSide.getExpr() + "  don't match to  " + this.expression);
            }
        }
        this.logPrintln(AttrSession.logTrace, "ValueMember:\n<-apply");
    }

    public void apply(ValueMember rightSide, AttrContext context, boolean allowVariableWithoutValue) {
        if (this.getName().equals("HASHCODE")) {
            return;
        }
        if (!allowVariableWithoutValue) {
            this.apply(rightSide, context);
            return;
        }
        if (rightSide != null && rightSide.getExpr() != null) {
            HandlerExpr oldExpr = this.getExpr();
            HandlerExpr exp = null;
            this.expression = rightSide.getExpr().getCopy();
            try {
                AttrSession.logPrintln(AttrSession.logJexParser, "Komplex oder Variable ");
                Hashtable mappings = ((ContextView)context).getMapping();
                AttrSession.logPrintln(AttrSession.logJexParser, "mappings geholt " + mappings);
                Enumeration en = mappings.elements();
                while (en.hasMoreElements()) {
                    Vector v = (Vector)en.nextElement();
                    for (int i = 0; i < v.size(); ++i) {
                        TupleMapping tm = (TupleMapping)v.elementAt(i);
                        AttrSession.logPrintln(AttrSession.logJexParser, "TuppleMapping geholt");
                    }
                }
                AttrSession.logPrintln(AttrSession.logJexParser, "ende mit TuppleMapping check");
                exp = this.getExpr();
                if (exp != null) {
                    exp.evaluate(context);
                }
                if (exp != null && exp.getValue() == null) {
                    this.setExprAsText(exp.getString());
                } else if (exp != null && exp.getValue() != null) {
                    this.fireChanged(70);
                }
            }
            catch (AttrHandlerException ex1) {
                AttrSession.logPrintln(AttrSession.logJexParser, "ValueMember.apply : EXPR_EVAL_ERR");
                AttrSession.logPrintln(AttrSession.logJexParser, "ValueMember.apply : do setExprAsText(exp.getString()");
                AttrSession.logPrintln(AttrSession.logJexParser, "ValueMember.apply : exp = " + exp);
                AttrSession.logPrintln(AttrSession.logJexParser, "ValueMember.apply : exp.getValue() = " + exp.getValue());
                if (exp != null && exp.getValue() == null && allowVariableWithoutValue) {
                    this.setExprAsText(exp.getString());
                    this.setTransient(rightSide.isTransient());
                }
                throw new AttrImplException(8, ex1.getMessage());
            }
            catch (Exception ex) {
                this.expression = oldExpr;
                throw new AttrImplException(8, ex.getMessage());
            }
        }
        AttrSession.logPrintln(AttrSession.logJexParser, "ValueMember:\n<-apply");
    }

    public boolean canMatchTo(ValueMember target, ContextView context) {
        if (this.getName().equals("HASHCODE")) {
            return true;
        }
        this.errorMsg = EMPTY_VALUE_SYMBOL;
        HandlerExpr src = this.getExpr();
        HandlerExpr tar = null;
        if (target != null) {
            tar = target.getExpr();
        }
        this.logPrintln(AttrSession.logMapping, "starting canMatchTo");
        if (tar != null) {
            if (src == null) {
                return true;
            }
            boolean result = false;
            result = result || tar.isVariable();
            result = result || tar.isComplex();
            boolean r3 = !src.isVariable();
            r3 = r3 || context.canSetValue(((Object)src).toString(), target);
            boolean r2 = r3 && src.isUnifiableWith(tar, context);
            boolean bl = result = result || r2;
            if (result) {
                this.logPrintln(AttrSession.logMapping, this + " can match " + target);
                return true;
            }
            this.logPrintln(AttrSession.logMapping, this + " cannot match " + target);
            this.errorMsg = context.getErrorMsg();
            if (!src.isUnifiableWith(tar, context)) {
                this.logPrintln(AttrSession.logMapping, "Is not unifiable. Look isUnifiableWith(...) at JexExpr");
                this.errorMsg = !this.errorMsg.equals(EMPTY_VALUE_SYMBOL) ? this.errorMsg + "\nSource attribute " + ((Object)src).toString() + " does not unify with target attribute " + ((Object)tar).toString() + "." : "Source attribute does not unify target attribute.";
            } else {
                this.errorMsg = this.getName() + " cannot match " + target.getName();
            }
            if (src.isVariable() && !context.canSetValue(((Object)src).toString(), target)) {
                this.logPrintln(AttrSession.logMapping, "Cannot set value in context.");
                this.errorMsg = !this.errorMsg.equals(EMPTY_VALUE_SYMBOL) ? this.errorMsg + "\nCannot set value for variable " + ((Object)src).toString() + " in context." : "Cannot set value in context.";
            } else {
                this.errorMsg = this.getName() + " cannot match " + target.getName();
            }
            return false;
        }
        if (context.getAllowedMapping() == 1) {
            this.errorMsg = "Target attribute is not set.";
            System.out.println("ValueMember.canMatchTo:: MATCH_MAP: return false:: errorMsg: " + this.errorMsg);
            return false;
        }
        if (context.getAllowedMapping() == 0) {
            return true;
        }
        System.out.println("ValueMember.canMatchTo:: return false");
        return false;
    }

    public String matchTo(ValueMember target, ContextView context) {
        if (this.getName().equals("HASHCODE")) {
            return null;
        }
        this.logPrintln(AttrSession.logTrace, "ValueMember:\n->match to");
        HandlerExpr srcExpr = this.getExpr();
        String varName = null;
        if (srcExpr != null && srcExpr.isVariable()) {
            varName = ((Object)srcExpr).toString();
            this.logPrintln(AttrSession.logMapping, this + " matches with " + target);
            try {
                context.setValue(varName, target);
            }
            catch (NoSuchVariableException e) {
                // empty catch block
            }
        }
        this.logPrintln(AttrSession.logTrace, "ValueMember:\n<-match to");
        return varName;
    }

    public void copy(ValueMember fromInstance) {
        HandlerExpr srcExpr = fromInstance.getExpr();
        HandlerExpr tarExpr = null;
        if (srcExpr != null && (tarExpr = srcExpr.getCopy()) != null) {
            this.expression = tarExpr;
            this.expressionText = fromInstance.expressionText != null ? fromInstance.expressionText.toString() : null;
            this.expressionObject = this.expression.getValue();
            this.checkValidity();
            this.setTransient(fromInstance.isTransient());
        }
    }

    public boolean equals(ValueMember testObject) {
        if (this.getName().equals("HASHCODE")) {
            return true;
        }
        if (testObject == null) {
            return false;
        }
        if (this.getExpr() != null) {
            return this.getExpr().equals(testObject.getExpr());
        }
        if (this.expressionText != null) {
            return this.expressionText.equals(testObject.expressionText);
        }
        if (this.expressionObject != null) {
            return this.expressionObject.equals(testObject.expressionObject);
        }
        return testObject.expressionText == null && testObject.expressionObject == null && testObject.getExpr() == null;
    }

    public boolean compareTo(ValueMember member) {
        if (this.getName().equals("HASHCODE")) {
            return true;
        }
        if (member == null) {
            return false;
        }
        if (this.getExpr() != null) {
            if (member.getExpr() != null) {
                return ((Object)this.getExpr()).toString().equals(((Object)member.getExpr()).toString());
            }
            return false;
        }
        if (this.expressionText != null) {
            return this.expressionText.equals(member.expressionText);
        }
        return false;
    }

    public String toString() {
        if (this.getExpr() != null) {
            return ((Object)this.getExpr()).toString();
        }
        if (this.expressionText != null) {
            return this.expressionText;
        }
        if (this.expressionObject != null) {
            return this.expressionObject.toString();
        }
        return EMPTY_VALUE_SYMBOL;
    }

    public AttrTuple getHoldingTuple() {
        return this.getTuple();
    }

    protected ValueTuple getTuple() {
        return this.tuple;
    }

    protected ContextView getContext() {
        return (ContextView)this.getTuple().getContext();
    }

    protected DeclMember getDecl() {
        return this.decl;
    }

    public AttrHandler getHandler() {
        return this.getDecl().getHandler();
    }

    protected HandlerType getType() {
        return this.getDecl().getType();
    }

    public String getName() {
        return this.getDecl().getName();
    }

    public Vector getAllVariableNamesOfExpression() {
        Vector resultVector = new Vector();
        if (this.getExpr() != null) {
            this.getExpr().getAllVariables(resultVector);
        }
        return resultVector;
    }

    public Vector getChildrenOfExpression() {
        Vector<SimpleNode> resultVector = new Vector<SimpleNode>();
        if (this.getExpr() != null && this.getExpr().getAST() != null) {
            SimpleNode node = (SimpleNode)this.getExpr().getAST();
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                resultVector.addElement((SimpleNode)node.jjtGetChild(i));
            }
        }
        return resultVector;
    }

    protected HandlerExpr rawGetExpr() {
        return this.expression;
    }

    protected void rawSetExpr(HandlerExpr expr) {
        this.expression = expr;
    }

    protected void setCheckedExpr(HandlerExpr expr) {
        this.rawSetExpr(expr);
        this.checkValidity();
    }

    public void checkValidity() {
        try {
            this.checkInContext(this.getExpr(), this.getContext());
            this.currentException = null;
        }
        catch (Exception ex) {
            this.currentException = ex;
            this.errorMsg = ex.getMessage();
        }
    }

    public void checkValidity(HandlerExpr hExpr) {
        try {
            this.checkInContext(hExpr, this.getContext());
            this.currentException = null;
        }
        catch (Exception ex) {
            this.currentException = ex;
            this.errorMsg = ex.getMessage();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkInContext(HandlerExpr hExpr, AttrContext ctx) {
        ContextView context = (ContextView)ctx;
        if (hExpr == null) {
            if (context != null && context.doesAllowEmptyValues()) return;
            throw new AttrImplException(13);
        }
        String exprText = ((Object)hExpr).toString();
        AttrHandler handler = this.getHandler();
        HandlerType type = this.getType();
        if (context == null) {
            if (!hExpr.isConstant()) {
                throw new AttrImplException(4);
            }
        } else if (!context.doesAllowComplexExpressions()) {
            if (hExpr.isComplex()) {
                throw new AttrImplException(5);
            }
        } else if (context.getAllowedMapping() == 2) {
            // empty if block
        }
        if (hExpr.isVariable()) {
            this.logPrintln(AttrSession.logSetValue, "Variable: " + exprText);
            if (context.isDeclared(exprText)) {
                try {
                    hExpr.check(context);
                    return;
                }
                catch (AttrHandlerException ex) {
                    throw new AttrImplException(7, ex.getMessage());
                }
            } else {
                if (!context.doesAllowNewVariables()) throw new AttrImplException(6);
                this.logPrintln(AttrSession.logSetValue, "Declaring: " + exprText);
                context.addDecl(handler, ((Object)type).toString(), exprText);
            }
            return;
        } else if (hExpr.isComplex()) {
            try {
                hExpr.check(context);
                return;
            }
            catch (AttrHandlerException ex) {
                this.errorMsg = ex.getMessage();
                this.currentException = ex;
                throw new AttrImplException(7, ex.getMessage());
            }
        } else if (!hExpr.isConstant()) return;
    }

    public String getAttrHandlerExceptionMsg() {
        if (this.currentException != null) {
            String msg = this.currentException.getMessage();
            return msg;
        }
        return EMPTY_VALUE_SYMBOL;
    }

    public void setTransient(boolean trans) {
        this.isTransient = trans;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void XwriteObject(XMLHelper h) {
        if (this.decl == null || this.decl.getType() == null) {
            return;
        }
        h.openSubTag("Attribute");
        h.addObject("type", this.decl, false);
        HandlerExpr ex = this.getExpr();
        if (h.getDocumentVersion().equals("1.0")) {
            if (ex.isConstant()) {
                Object v = ex.getValue();
                h.openSubTag("Value");
                if (((Object)this.decl.getType()).toString().equals("String")) {
                    h.addAttrValue("String", v);
                } else {
                    h.addAttrValue(((Object)this.decl.getType()).toString(), v);
                }
                h.close();
                h.addAttr("constant", "true");
            } else if (ex.isVariable()) {
                String v = ex.getString();
                h.openSubTag("Value");
                h.addAttrValue("string", v);
                h.close();
                h.addAttr("variable", "true");
            } else {
                String v = ex.getString();
                h.openSubTag("Value");
                h.addAttrValue("String", v);
                h.close();
            }
        } else if (ex.isConstant()) {
            Object v = ex.getValue();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(os);
                oos.writeObject(v);
                h.addAttr("value", h.escapeString(os.toString()));
            }
            catch (IOException e) {
                h.addAttr("value", h.escapeString(v.toString()));
            }
            h.addAttr("constant", "true");
        } else {
            h.addAttr("value", ex.getString());
        }
        h.close();
    }

    public void XreadObject(XMLHelper h) {
        String readError;
        block48: {
            if (this.decl == null || this.decl.getType() == null) {
                System.out.println("ValueMember.XreadObject: WARNING!\n\t Attribute  \"" + this.decl.getName() + "\" :  type declaration of attribute value is null.");
                return;
            }
            readError = null;
            if (h.getDocumentVersion().equals("1.0")) {
                if (h.readAttr("constant") != EMPTY_VALUE_SYMBOL) {
                    if (h.readSubTag("Value")) {
                        Object obj = null;
                        if (((Object)this.decl.getType()).toString().equals("String")) {
                            obj = h.getAttrValue("String");
                            if (obj == null) {
                                obj = h.getAttrValue("string");
                            }
                            if (obj == null) {
                                obj = new String();
                            } else if (obj instanceof String) {
                                String objStr = this.formString((String)obj);
                                obj = objStr;
                            }
                        } else {
                            obj = h.getAttrValue(((Object)this.decl.getType()).toString());
                        }
                        if (obj == null) {
                            h.close();
                            return;
                        }
                        if (obj instanceof String && ((String)obj).equals("null")) {
                            this.setExprAsText((String)obj);
                            this.checkValidity();
                            h.close();
                            return;
                        }
                        String valueAsString = EMPTY_VALUE_SYMBOL;
                        if (((Object)this.decl.getType()).toString().equals("char")) {
                            valueAsString = ((Character)obj).toString();
                            this.setExprAsText("'" + valueAsString.charAt(0) + "'");
                        } else if (((Object)this.decl.getType()).toString().equals("int")) {
                            valueAsString = ((Integer)obj).toString();
                            this.setExprAsEvaluatedText(valueAsString);
                        } else if (((Object)this.decl.getType()).toString().equals("boolean")) {
                            valueAsString = ((Boolean)obj).toString();
                            this.setExprAsEvaluatedText(valueAsString);
                        } else if (((Object)this.decl.getType()).toString().equals("float")) {
                            valueAsString = ((Float)obj).toString();
                            this.setExprAsEvaluatedText(valueAsString);
                        } else if (((Object)this.decl.getType()).toString().equals("double")) {
                            valueAsString = ((Double)obj).toString();
                            this.setExprAsEvaluatedText(valueAsString);
                        } else if (((Object)this.decl.getType()).toString().equals("long")) {
                            valueAsString = ((Long)obj).toString();
                            this.setExprAsEvaluatedText(valueAsString);
                        } else if (((Object)this.decl.getType()).toString().equals("short")) {
                            valueAsString = ((Short)obj).toString();
                            this.setExprAsEvaluatedText(valueAsString);
                        } else if (((Object)this.decl.getType()).toString().equals("byte")) {
                            valueAsString = ((Byte)obj).toString();
                            this.setExprAsEvaluatedText(valueAsString);
                        } else if (((Object)this.decl.getType()).toString().equals("String")) {
                            this.setExprAsObject(obj);
                        } else {
                            this.setExprAsObject(obj);
                        }
                        this.checkValidity();
                        h.close();
                    } else {
                        System.out.println("ValueMember.XreadObject:  Tag  <Value>  of  '" + this.getName() + "'  not found");
                    }
                } else if (h.readAttr("variable") != EMPTY_VALUE_SYMBOL) {
                    if (h.readSubTag("Value")) {
                        Object obj = h.getAttrValue("String");
                        if (obj == null) {
                            obj = h.getAttrValue("string");
                        }
                        if (obj == null) {
                            h.close();
                            return;
                        }
                        if (obj instanceof String) {
                            this.setExprAsText((String)obj);
                            this.checkValidity();
                        }
                        h.close();
                    }
                } else if (h.readSubTag("Value")) {
                    Object obj = h.getAttrValue("String");
                    if (obj == null) {
                        h.close();
                        return;
                    }
                    if (obj instanceof String) {
                        String objStr = this.formString((String)obj);
                        this.setExprAsText(objStr);
                    }
                    h.close();
                }
            } else {
                String val = h.readAttr("value");
                if (h.readAttr("constant") != EMPTY_VALUE_SYMBOL) {
                    String v = h.unescapeString(val);
                    byte[] buf = v.getBytes();
                    ByteArrayInputStream is = new ByteArrayInputStream(buf);
                    try {
                        ObjectInputStream ois = new ObjectInputStream(is);
                        Object vo = ois.readObject();
                        if (((Object)this.decl.getType()).toString().equals("int") || ((Object)this.decl.getType()).toString().equals("boolean") || ((Object)this.decl.getType()).toString().equals("float") || ((Object)this.decl.getType()).toString().equals("double") || ((Object)this.decl.getType()).toString().equals("long") || ((Object)this.decl.getType()).toString().equals("short")) {
                            this.setExprAsEvaluatedText(vo.toString());
                            this.checkValidity();
                            break block48;
                        }
                        this.setExprAsObject(vo);
                        this.checkValidity();
                    }
                    catch (Exception e) {}
                } else {
                    this.setExprAsText(val);
                    this.checkValidity();
                }
            }
        }
        if (readError != null && !readError.equals(EMPTY_VALUE_SYMBOL)) {
            System.out.println("ValueMember.XreadObject: " + readError);
        }
    }

    private String formString(String s) {
        String test = s;
        String objStr = new String(test);
        while (test.indexOf(10) != -1) {
            objStr = test.replaceAll("\n", EMPTY_VALUE_SYMBOL);
            test = new String(objStr);
        }
        while (test.indexOf("  ") != -1) {
            objStr = test.replaceAll("  ", " ");
            test = new String(objStr);
        }
        return objStr;
    }
}

