/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.impl;

import agg.attribute.AttrContext;
import agg.attribute.AttrInstance;
import agg.attribute.AttrTypeMember;
import agg.attribute.impl.AttrImplException;
import agg.attribute.impl.AttrMsgCode;
import agg.attribute.impl.AttrSession;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.DeclTuple;
import agg.attribute.impl.TupleEvent;
import agg.attribute.impl.TupleObject;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.VarMember;
import agg.attribute.view.impl.OpenViewSetting;
import agg.util.XMLHelper;
import java.util.Enumeration;
import java.util.Vector;

public class ValueTuple
extends TupleObject
implements AttrInstance,
AttrMsgCode {
    protected DeclTuple type;
    private ContextView context = null;
    protected transient String errorMsg;

    public ValueTuple(AttrTupleManager manager, DeclTuple type) {
        this(manager, type, null, null);
    }

    public ValueTuple(AttrTupleManager manager, DeclTuple type, ContextView context) {
        this(manager, type, context, null);
    }

    public ValueTuple(AttrTupleManager manager, DeclTuple type, ContextView context, ValueTuple parent) {
        super(manager, null);
        this.setContextView(context);
        this.setType(type);
        this.logPrintln(AttrSession.logContextOfInstances, "Created with context = " + this.getContextView());
        if (this.getContextView() == null) {
            this.warn("Context = null", new RuntimeException());
        }
        this.errorMsg = "";
    }

    protected void propagateEvent(TupleEvent e) {
        OpenViewSetting myOpenView = (OpenViewSetting)this.manager.getDefaultOpenView();
        if (e.id == 10) {
            this.refreshParents();
            myOpenView.reorderTuple(this);
        }
        if (e.id == 20) {
            this.refreshParents();
            myOpenView.reorderTuple(this);
        }
        this.fireAttrChanged(e.cloneWithNewSource(this));
    }

    public void refreshParents() {
        if (this.type != null) {
            Vector memberCopy = new Vector(this.members);
            this.members.clear();
            for (int i = 0; i < this.type.getSize(); ++i) {
                DeclMember currentDecl = this.type.getDeclMemberAt(i);
                if (currentDecl == null) continue;
                boolean oldEntry = false;
                for (int j = 0; j < memberCopy.size(); ++j) {
                    if (((ValueMember)memberCopy.get(j)).getDecl() != currentDecl) continue;
                    ValueMember vm = (ValueMember)memberCopy.get(j);
                    this.members.add(vm);
                    oldEntry = true;
                    break;
                }
                if (oldEntry || currentDecl == null) continue;
                this.members.add(this.newMember(currentDecl));
            }
        }
    }

    protected void setContextView(ContextView view) {
        this.context = view;
    }

    protected ContextView getContextView() {
        return this.context;
    }

    protected void assignParent(TupleObject newParent) {
        super.assignParent(newParent);
        if (this.parent != null) {
            this.copyEntries((ValueTuple)this.parent);
        }
    }

    protected void setType(DeclTuple type) {
        this.type = type;
        if (type != null) {
            type.addObserver(this);
            this.adaptToType();
            if (this.parent != null) {
                this.copyEntries((AttrInstance)((Object)this.parent));
            }
        }
    }

    protected void adaptToType() {
        for (int i = 0; i < this.getTupleType().getSize(); ++i) {
            if (this.getTupleType().getDeclMemberAt(i) == null) continue;
            this.addMember(this.newMember(this.getTupleType().getDeclMemberAt(i)));
        }
    }

    protected ValueMember newMember(DeclMember decl) {
        return new ValueMember(this, decl);
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public AttrContext getContext() {
        return this.getContextView();
    }

    public void log() {
        String line = "";
        for (int i = 0; i < this.getNumberOfEntries(); ++i) {
            line = line + this.getLogEntry(i);
        }
        this.logPrintln(line);
    }

    protected String getLogEntry(int index) {
        return "\n    " + index + ". (" + this.getTypeAsString(index) + ") " + this.getNameAsString(index) + " = " + this.getValueAsString(index);
    }

    public DeclTuple getTupleType() {
        return this.type;
    }

    public void updateMemberAdded(TupleEvent e) {
        if (e.getSource() instanceof DeclTuple) {
            this.addMember(this.newMember(this.getTupleType().getDeclMemberAt(e.getIndex())));
        }
        this.propagateEvent(e);
    }

    public void updateMemberDeleted(TupleEvent e) {
        if (e.getSource() instanceof DeclTuple) {
            this.deleteMemberAt(e.getIndex());
            this.propagateEvent(e);
        }
    }

    public void updateMemberRetyped(TupleEvent e) {
        ValueMember m;
        if (e.getSource() instanceof DeclTuple && (m = this.getValueMemberAt(e.getIndex())) != null) {
            m.typeChanged();
        }
        this.propagateEvent(e);
    }

    public void updateMemberValueChanged(TupleEvent e) {
        ValueMember val = (ValueMember)e.getSource().getMemberAt(e.getIndex());
        this.getValueMemberAt(e.getIndex()).copy(val);
        this.propagateEvent(e);
    }

    public ValueMember getValueMemberAt(int index) {
        return (ValueMember)this.getMemberAt(index);
    }

    public ValueMember getValueMemberAt(String name) {
        return (ValueMember)this.getMemberAt(name);
    }

    public String getValueAsString(int entryIndex) {
        if (this.getMemberAt(entryIndex) != null) {
            return this.getMemberAt(entryIndex).toString();
        }
        return "";
    }

    public void copy(AttrInstance source) {
        ValueTuple from = (ValueTuple)source;
        if (!this.type.compareTo(from.getTupleType())) {
            System.out.println("ValueTuple.copy(AttrInstance)::  Tried to copy from an AttrInstance with a different type!");
            throw new AttrImplException("Tried to copy from an AttrInstance with a different type!");
        }
        this.manager = from.manager;
        int length = from.getSize();
        for (int i = 0; i < length; ++i) {
            ValueMember val = this.getValueMemberAt(i);
            ValueMember valfrom = from.getValueMemberAt(i);
            if (val == null) continue;
            val.copy(valfrom);
            if (valfrom instanceof VarMember) {
                ((VarMember)val).setMark(((VarMember)valfrom).getMark());
                continue;
            }
            if (!(valfrom instanceof CondMember)) continue;
            ((CondMember)val).setMark(((CondMember)valfrom).getMark());
        }
    }

    private boolean contains(ValueMember m) {
        int length = this.getSize();
        for (int i = 0; i < length; ++i) {
            ValueMember val = this.getValueMemberAt(i);
            if (val.getHoldingTuple() != m.getHoldingTuple() || !val.compareTo(m)) continue;
            return true;
        }
        return false;
    }

    public void copyEntries(AttrInstance source) {
        DeclTuple dstType;
        ValueTuple from = (ValueTuple)source;
        DeclTuple srcType = from.getTupleType();
        if (!(srcType.compareTo(dstType = this.type) || srcType.isSubclassOf(dstType) || dstType.isSubclassOf(srcType))) {
            return;
        }
        int length = Math.min(srcType.getSize(), dstType.getSize());
        for (int i = 0; i < length; ++i) {
            ValueMember val = this.getValueMemberAt(i);
            ValueMember valfrom = from.getValueMemberAt(i);
            if (val == null || valfrom == null) continue;
            val.copy(valfrom);
        }
    }

    public void copyEntriesToSimilarMembers(AttrInstance source) {
        DeclTuple dstType;
        ValueTuple from = (ValueTuple)source;
        DeclTuple srcType = from.getTupleType();
        if (!(srcType.compareTo(dstType = this.type) || srcType.isSubclassOf(dstType) || dstType.isSubclassOf(srcType))) {
            return;
        }
        for (int i = 0; i < dstType.getSize(); ++i) {
            ValueMember val = this.getValueMemberAt(i);
            ValueMember valfrom = from.getValueMemberAt(val.getName());
            if (val == null || valfrom == null || !val.getDeclaration().getTypeName().equals(valfrom.getDeclaration().getTypeName())) continue;
            val.copy(valfrom);
        }
    }

    public void adoptEntriesWhereEmpty(AttrInstance source) {
        DeclTuple dstType;
        ValueTuple from = (ValueTuple)source;
        DeclTuple srcType = from.getTupleType();
        if (!(srcType.compareTo(dstType = this.type) || srcType.isSubclassOf(dstType) || dstType.isSubclassOf(srcType))) {
            throw new RuntimeException("The copy source has a wrong type.\n");
        }
        int length = Math.min(srcType.getSize(), dstType.getSize());
        for (int i = 0; i < length; ++i) {
            ValueMember dst = this.getValueMemberAt(i);
            ValueMember src = from.getValueMemberAt(i);
            if (src == null || !dst.isEmpty() || src.isEmpty()) continue;
            dst.copy(src);
        }
    }

    public void apply(AttrInstance rightSide, AttrContext context, AttrInstance g) {
        this.logPrintln(AttrSession.logTrace, "ValueTuple:\n->apply");
        if (g == null) {
            this.logPrintln(AttrSession.logTrace, "g ist null");
        } else {
            this.logPrintln(AttrSession.logTrace, "" + g);
        }
        AttrContext matchContext = context;
        ValueTuple rightTuple = (ValueTuple)rightSide;
        this.logPrintln(AttrSession.logContextOfInstances, "G-context = " + this.context);
        this.logPrintln(AttrSession.logContextOfInstances, "R-context = " + rightTuple.context);
        this.logPrintln(AttrSession.logContextOfInstances, "Match context = " + context);
        if (matchContext == null) {
            matchContext = rightTuple.getContext();
        }
        for (int i = 0; i < Math.min(this.getSize(), ((ValueTuple)rightSide).getSize()); ++i) {
            ValueMember left = this.getValueMemberAt(i);
            ValueMember right = rightTuple.getValueMemberAt(i);
            this.logPrintln(AttrSession.logTrace, "apply auf links " + left + " rechts " + right);
            if (left == null) continue;
            left.apply(right, matchContext);
        }
        this.logPrintln(AttrSession.logTrace, "\n<-apply");
    }

    public void apply(AttrInstance rightSide, AttrContext context, AttrInstance g, boolean allowVariableWithoutValue) {
        if (!allowVariableWithoutValue) {
            this.apply(rightSide, context, g);
            return;
        }
        AttrContext matchContext = context;
        ValueTuple rightTuple = (ValueTuple)rightSide;
        if (matchContext == null) {
            matchContext = rightTuple.getContext();
        }
        for (int i = 0; i < this.getSize(); ++i) {
            ValueMember left = this.getValueMemberAt(i);
            ValueMember right = rightTuple.getValueMemberAt(i);
            if (left == null) continue;
            left.apply(right, matchContext, allowVariableWithoutValue);
        }
    }

    public void apply(AttrInstance rightSide, AttrContext context) {
        this.apply(rightSide, context, null);
    }

    public void apply(AttrInstance rightSide, AttrContext context, boolean allowVariableWithoutValue) {
        this.apply(rightSide, context, null, allowVariableWithoutValue);
    }

    public int getNumberOfFreeVariables(AttrContext ctx) {
        ContextView context = (ContextView)ctx;
        int nFree = 0;
        Vector<String> names = new Vector<String>(10, 10);
        for (int i = 0; i < this.getSize(); ++i) {
            String varName;
            ValueMember val = this.getValueMemberAt(i);
            if (val == null || val.isValid() || val.getExpr() == null || !val.getExpr().isVariable() || names.contains(varName = ((Object)val.getExpr()).toString())) continue;
            names.addElement(varName);
            if (context != null && context.getExpr(varName) == null) continue;
            ++nFree;
        }
        return nFree;
    }

    public void XwriteObject(XMLHelper h) {
        int num = this.getSize();
        for (int i = 0; i < num; ++i) {
            ValueMember val = this.getValueMemberAt(i);
            if (val == null || !val.isSet()) continue;
            h.addObject("", val, true);
        }
    }

    public void XreadObject(XMLHelper h) {
        int num = this.getSize();
        Enumeration en = h.getEnumeration("", null, true, "Attribute");
        while (en.hasMoreElements()) {
            h.peekElement(en.nextElement());
            AttrTypeMember type = (AttrTypeMember)h.getObject("type", null, false);
            if (type != null) {
                String name = type.getName();
                ValueMember mem = this.getValueMemberAt(name);
                h.enrichObject(mem);
            }
            h.close();
        }
    }

    public boolean canMatchTo(ValueTuple target, ContextView context) {
        for (int i = 0; i < this.getSize(); ++i) {
            String name = this.getNameAsString(i);
            ValueMember src = this.getValueMemberAt(name);
            ValueMember tar = target.getValueMemberAt(name);
            if (src == null || src.canMatchTo(tar, context)) continue;
            this.errorMsg = src.getErrorMsg();
            return false;
        }
        return true;
    }

    public String[] matchTo(ValueTuple target, ContextView context) {
        this.logPrintln(AttrSession.logTrace, "ValueTuple:\n->matchTo");
        Vector<String> matches = new Vector<String>();
        String match = null;
        if (!this.canMatchTo(target, context)) {
            this.errorMsg = this.errorMsg + "\nAttribute don't match.";
            throw new AttrImplException(9);
        }
        this.logPrintln(AttrSession.logMapping, "try to match to " + this.getSize() + " members");
        for (int i = 0; i < this.getSize(); ++i) {
            ValueMember src = this.getValueMemberAt(i);
            ValueMember tar = target.getValueMemberAt(i);
            if (src != null) {
                match = src.matchTo(tar, context);
            }
            if (match == null) continue;
            matches.addElement(match);
        }
        this.logPrintln(AttrSession.logMapping, "matches= " + matches);
        Object[] assignedVariables = new String[matches.size()];
        matches.copyInto(assignedVariables);
        this.logPrintln(AttrSession.logTrace, "ValueTuple:\n<-matchTo");
        return assignedVariables;
    }

    public void logPrintln(boolean logTopic, String msg) {
        super.logPrintln(logTopic, msg);
        if (logTopic) {
            for (int i = 0; i < this.getSize(); ++i) {
                System.out.println(this.getValueMemberAt(i));
            }
        }
    }

    public String toString() {
        String result = super.toString() + " ";
        for (int i = 0; i < this.getSize(); ++i) {
            result = result + this.getValueMemberAt(i) + "\n";
        }
        return result;
    }

    public void setValueAt(String valueText, int index) {
        if (this.getValueMemberAt(index) != null) {
            this.getValueMemberAt(index).setExprAsText(valueText);
        }
    }

    public void setValueAt(ValueMember value, int index) {
        if (this.getValueMemberAt(index) != null) {
            this.getValueMemberAt(index).copy(value);
        }
    }

    public boolean isValueSetAt(String name) {
        if (this.getValueMemberAt(name) != null) {
            return !this.getValueMemberAt(name).isEmpty();
        }
        return false;
    }

    public boolean isValueSetAt(int index) {
        if (this.getValueMemberAt(index) != null) {
            return !this.getValueMemberAt(index).isEmpty();
        }
        return false;
    }

    public Object getValueAt(String name) {
        if (this.getValueMemberAt(name) != null) {
            return this.getValueMemberAt(name).getExprAsObject();
        }
        return null;
    }

    public void setValueAt(Object value, String name) {
        if (this.getValueMemberAt(name) != null) {
            this.getValueMemberAt(name).setExprAsObject(value);
        }
    }

    public void setExprValueAt(String expr, String name) {
        if (this.getValueMemberAt(name) != null) {
            this.getValueMemberAt(name).setExprAsEvaluatedText(expr);
        }
    }

    public void setExprAt(String expr, String name) {
        if (this.getValueMemberAt(name) != null) {
            this.getValueMemberAt(name).setExprAsText(expr);
        }
    }

    public ValueMember getEntryAt(int index) {
        return this.getValueMemberAt(index);
    }

    public ValueMember getEntryAt(String name) {
        return this.getValueMemberAt(name);
    }

    public Vector getAllVariableNamesOfExpressions() {
        Vector<String> resultVector = new Vector<String>();
        for (int i = 0; i < this.getSize(); ++i) {
            ValueMember member = this.getValueMemberAt(i);
            if (!member.isSet() || !member.getExpr().isComplex()) continue;
            Vector names = member.getAllVariableNamesOfExpression();
            for (int j = 0; j < names.size(); ++j) {
                String name = (String)names.elementAt(j);
                if (resultVector.contains(name)) continue;
                resultVector.addElement(name);
            }
        }
        return resultVector;
    }

    public Vector getAllVariableNames() {
        Vector<String> resultVector = new Vector<String>();
        for (int i = 0; i < this.getSize(); ++i) {
            ValueMember member = this.getValueMemberAt(i);
            Vector names = member.getAllVariableNamesOfExpression();
            for (int j = 0; j < names.size(); ++j) {
                String name = (String)names.elementAt(j);
                if (resultVector.contains(name)) continue;
                resultVector.addElement(name);
            }
        }
        return resultVector;
    }

    public boolean compareTo(AttrInstance another) {
        ValueTuple vt = (ValueTuple)another;
        if (!this.type.compareTo(vt.getTupleType())) {
            return false;
        }
        int length = this.getSize();
        for (int i = 0; i < length; ++i) {
            ValueMember v = this.getValueMemberAt(i);
            ValueMember v1 = vt.getValueMemberAt(i);
            if (v.getExpr() == null && v1.getExpr() == null) continue;
            if (v.getExpr() == null && v1.getExpr() != null) {
                return false;
            }
            if (v.getExpr() != null && v1.getExpr() == null) {
                return false;
            }
            if (v.getExpr().equals(v1.getExpr())) continue;
            return false;
        }
        return true;
    }
}

