/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.impl;

import agg.attribute.AttrVariableMember;
import agg.attribute.handler.AttrHandlerException;
import agg.attribute.handler.HandlerExpr;
import agg.attribute.impl.AttrImplException;
import agg.attribute.impl.AttrSession;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.VarTuple;
import java.util.Observable;

public class VarMember
extends ValueMember
implements AttrVariableMember {
    public static final int LHS = 0;
    public static final int RHS = 1;
    public static final int NAC = 2;
    protected int refCnt = 0;
    protected boolean isIn = false;
    protected boolean isOut = false;
    private int mark;
    private transient String errorMsg = "";
    public static final long serialVersionUID = 3905403576345689583L;

    public VarMember(VarTuple tuple, DeclMember decl) {
        super(tuple, decl);
        this.isTransient = false;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void delete() {
        this.getDeclaration().delete();
    }

    public boolean isInputParameter() {
        return this.isIn;
    }

    public void setInputParameter(boolean in) {
        this.isIn = in;
    }

    public boolean isOutputParameter() {
        return this.isOut;
    }

    public void setOutputParameter(boolean out) {
        this.isOut = out;
    }

    public int getReferenceCount() {
        return this.refCnt;
    }

    public boolean isUnifiableWith(HandlerExpr srcExpr) {
        if (this.isEmpty() || this.getExpr().equals(srcExpr)) {
            return true;
        }
        this.errorMsg = this.getExpr() + "  is not unifiable with  " + srcExpr;
        return false;
    }

    public boolean unifyWith(HandlerExpr srcExpr) {
        if (!this.isUnifiableWith(srcExpr)) {
            return false;
        }
        if (this.isEmpty() && (srcExpr != null || this.getExpr().equals(srcExpr))) {
            this.expression = srcExpr.getCopy();
            this.incrementCount();
        }
        return true;
    }

    public void copy(ValueMember fromInstance) {
        super.copy(fromInstance);
        VarMember fromVar = (VarMember)fromInstance;
        this.refCnt = fromVar.refCnt;
        this.isIn = fromVar.isIn;
        this.isOut = fromVar.isOut;
        this.setTransient(fromVar.isTransient());
        this.setMark(fromVar.getMark());
    }

    public void undoUnification() {
        this.decrementCount();
    }

    public void setExprAsObject(Object value) throws AttrImplException {
        System.out.println("VarMember.setExprAsObject...  var:" + this.getName() + "  to  " + value);
        super.setExprAsObject(value);
        this.startCount();
    }

    public void setExprAsText(String exprText) throws AttrImplException {
        super.setExprAsText(exprText);
        this.startCount();
        if (this.getExpr() != null && this.getExpr().isComplex() && exprText.indexOf("new ") == 0) {
            this.apply(this.getExpr());
        }
    }

    public void setExprAsEvaluatedText(String exprText) {
        super.setExprAsEvaluatedText(exprText);
        this.startCount();
    }

    public HandlerExpr getExpr() {
        return super.getExpr();
    }

    public boolean isDefinite() {
        return this.getEvaluationResult() != null;
    }

    public void setMark(int m) {
        this.mark = m;
    }

    public int getMark() {
        return this.mark;
    }

    public void update(Observable o, Object arg) {
        System.out.println("Observable:  " + o);
        System.out.println("arg:  " + arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HandlerExpr getEvaluationResult() {
        this.logPrintln(AttrSession.logTrace, "VarMember:\n->getEvaluationResult()");
        if (!this.isValid() || this.getExpr() == null) {
            return null;
        }
        HandlerExpr ex = this.getExpr().getCopy();
        try {
            if (ex.isConstant()) {
                ex.evaluate(this.getContext());
            }
            HandlerExpr handlerExpr = ex;
            return handlerExpr;
        }
        catch (AttrHandlerException ex1) {
            HandlerExpr handlerExpr = null;
            return handlerExpr;
        }
        finally {
            this.logPrintln(AttrSession.logTrace, "VarMember:\n<-getEvaluationResult()");
        }
    }

    protected void startCount() {
        this.refCnt = 1;
    }

    protected void incrementCount() {
        ++this.refCnt;
    }

    protected void decrementCount() {
        --this.refCnt;
        if (this.refCnt == 0) {
            this.expression = null;
        }
    }

    public String toString() {
        return "VarMember " + this.getExprAsText() + " refCnt: " + this.refCnt + " in: " + this.isIn + " out: " + this.isOut + " hash: " + this.hashCode();
    }
}

