/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.impl;

import agg.attribute.AttrInstance;
import agg.attribute.AttrVariableTuple;
import agg.attribute.handler.AttrHandler;
import agg.attribute.handler.impl.javaExpr.JexHandler;
import agg.attribute.impl.AttrImplException;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.DeclTuple;
import agg.attribute.impl.LoneTuple;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.util.XMLHelper;
import java.util.Enumeration;
import java.util.Vector;

public class VarTuple
extends LoneTuple
implements AttrVariableTuple {
    static final long serialVersionUID = 1133219076552845488L;
    protected final int FIXED_VALUE = -1;
    private static transient int COUNTER = 0;
    private String errorMsg;

    public VarTuple(AttrTupleManager manager, ContextView context, ValueTuple parent) {
        super(manager, context, parent);
        this.getContextView().setAllowVarDeclarations(true);
        this.getContextView().setAllowComplexExpr(true);
        if (this.parent != null) {
            int i;
            if (this.getSize() == 0 && this.parent.getSize() > 0) {
                for (i = 0; i < this.parent.getSize(); ++i) {
                    VarMember m = (VarMember)this.parent.getMemberAt(i);
                    this.declare(m.getHandler(), m.getDeclaration().getTypeName(), m.getName());
                    if (!m.isSet()) continue;
                    ((VarMember)this.getMemberAt(i)).setExprAsText(m.getExprAsText());
                }
            }
            for (i = 0; i < this.getSize(); ++i) {
                VarMember var = (VarMember)this.getMemberAt(i);
                VarMember varp = (VarMember)parent.getMemberAt(var.getName());
                var.setInputParameter(varp.isInputParameter());
                if (varp == null) continue;
                var.setMark(varp.getMark());
            }
            this.getContextView().setVariableContext(parent.getContextView().isVariableContext());
        }
        ++COUNTER;
        this.errorMsg = "";
    }

    public void dispose() {
        super.dispose();
        if (this.type != null) {
            this.type.dispose();
        }
        if (this.getContextView() != null) {
            this.setContextView(null);
        }
    }

    protected void finalize() {
        super.finalize();
        --COUNTER;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    protected ValueMember newMember(DeclMember decl) {
        if (decl == null) {
            Thread.dumpStack();
        }
        if (decl != null) {
            return new VarMember(this, decl);
        }
        return null;
    }

    protected String getLogEntry(int index) {
        return super.getLogEntry(index) + (this.getVarMemberAt(index).isInputParameter() ? " In " : " ") + (this.getVarMemberAt(index).isOutputParameter() ? " Out " : " ");
    }

    public VarMember getVarMemberAt(int index) {
        return (VarMember)this.getMemberAt(index);
    }

    public VarMember getVarMemberAt(String name) {
        return (VarMember)this.getMemberAt(name);
    }

    public boolean isDeclared(String name) {
        return this.getTupleType().containsName(name);
    }

    public boolean isDeclared(String type, String name) {
        if (this.getTupleType().containsName(name)) {
            VarMember vm = (VarMember)this.getMemberAt(name);
            return vm.getDeclaration().getTypeName().equals(type);
        }
        return false;
    }

    public void declare(AttrHandler handler, String type, String name) {
        if (this.getTupleType().isClassName(name)) {
            throw new AttrImplException("Class name  " + name + "  can not be used as a member name.");
        }
        this.getTupleType().addMember(handler, type, name);
    }

    public void deleteLeafDeclaration(String name) {
        DeclTuple decl = this.getTupleType();
        if (decl.getParentInCharge(decl.getIndexForName(name)) != decl) {
            throw new AttrImplException("Can't delete a declaration which was made \nin a parent context.");
        }
        decl.deleteMemberAt(name);
    }

    public boolean isDeclared(Vector varNames) {
        for (int i = 0; i < varNames.size(); ++i) {
            if (this.getTupleType().containsName((String)varNames.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean hasInputParameter() {
        int size = this.getSize();
        if (size == 0) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (!this.getVarMemberAt(i).isInputParameter()) continue;
            return true;
        }
        return false;
    }

    public boolean areInputParametersSet() {
        int size = this.getSize();
        if (size == 0) {
            return true;
        }
        for (int i = 0; i < size; ++i) {
            if (!this.getVarMemberAt(i).isInputParameter() || this.getVarMemberAt(i).isSet()) continue;
            return false;
        }
        return true;
    }

    public void unsetInputParameters() {
        int size = this.getSize();
        for (int i = 0; i < size; ++i) {
            VarMember vm = this.getVarMemberAt(i);
            if (!vm.isInputParameter() || !vm.isSet()) continue;
            vm.setExpr(null);
        }
    }

    public void unsetVariables() {
        int size = this.getSize();
        for (int i = 0; i < size; ++i) {
            VarMember vm = this.getVarMemberAt(i);
            if (!vm.isSet()) continue;
            vm.setExpr(null);
        }
    }

    public boolean isDefinite() {
        for (int i = 0; i < this.getSize(); ++i) {
            VarMember m = this.getVarMemberAt(i);
            if (m.isDefinite()) continue;
            DeclTuple decl = ((ValueTuple)this.getParent()).getTupleType();
            if (m.getReferenceCount() == 0) {
                if (decl.getIndexForName(m.getName()) != -1) {
                    if (decl.getParentInCharge(decl.getIndexForName(m.getName())) == decl) {
                        decl.deleteMemberAt(m.getName());
                        --i;
                        continue;
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    public Vector getUndefiniteVariables() {
        Vector<String> undefVars = new Vector<String>(2);
        for (int i = 0; i < this.getSize(); ++i) {
            VarMember m = this.getVarMemberAt(i);
            if (m.isDefinite()) continue;
            undefVars.addElement(m.getName());
        }
        return undefVars;
    }

    public Vector getVariableNames() {
        Vector<String> names = new Vector<String>();
        for (int i = 0; i < this.getSize(); ++i) {
            String varName;
            VarMember v = this.getVarMemberAt(i);
            if (v == null || names.contains(varName = v.getName())) continue;
            names.addElement(varName);
        }
        return names;
    }

    public boolean compareTo(AttrInstance another) {
        VarTuple vt = (VarTuple)another;
        if (!this.type.compareTo(vt.getTupleType())) {
            return false;
        }
        int length = this.getSize();
        for (int i = 0; i < length; ++i) {
            VarMember v = this.getVarMemberAt(i);
            VarMember v1 = vt.getVarMemberAt(i);
            if (v.getExpr() == null && v1.getExpr() == null) continue;
            if (v.getExpr() == null && v1.getExpr() != null) {
                return false;
            }
            if (v.getExpr() != null && v1.getExpr() == null) {
                return false;
            }
            if (v.getExpr().equals(v1.getExpr())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String s = "VarTuple  hash: " + this.hashCode() + "  [\n";
        for (int i = 0; i < this.getSize(); ++i) {
            VarMember v = this.getVarMemberAt(i);
            if (v == null) continue;
            s = s.concat(this.getVarMemberAt(i).getName() + ": " + this.getVarMemberAt(i).toString());
            s = s.concat("\n");
        }
        s = s.concat("\n ]");
        return s;
    }

    public void showVariables() {
        System.out.println("Attr. context variables: ");
        for (int i = 0; i < this.getSize(); ++i) {
            VarMember v = this.getVarMemberAt(i);
            if (v == null) continue;
            System.out.println(v.getDeclaration().getTypeName() + " : " + v.getName() + " : " + v + " : " + v.getMark());
        }
        System.out.println("================================");
    }

    public void XwriteObject(XMLHelper h) {
        int num = this.getSize();
        for (int i = 0; i < num; ++i) {
            String inout;
            VarMember val = this.getVarMemberAt(i);
            if (val == null) continue;
            h.openSubTag("Parameter");
            if (val.isSet()) {
                if (val.getExpr().isConstant()) {
                    h.addAttr("value", val.getExpr().getValue().toString());
                } else {
                    h.addAttr("expr", val.getExpr().getString());
                }
            }
            h.addAttr("name", val.getName());
            h.addAttr("type", val.getDecl().getTypeName());
            boolean isin = val.isInputParameter();
            boolean isout = val.isOutputParameter();
            String string = isin && isout ? "inout" : (isin ? "input" : (inout = isout ? "output" : ""));
            if (inout != "") {
                h.addAttr("PTYPE", inout);
            }
            h.close();
        }
    }

    public void XreadObject(XMLHelper h) {
        Enumeration en = h.getEnumeration("", null, true, "Parameter");
        while (en.hasMoreElements()) {
            h.peekElement(en.nextElement());
            String name = h.readAttr("name");
            if (!this.isDeclared(name)) {
                String type = h.readAttr("type");
                String handlerName = JexHandler.getLabelName();
                AttrHandler handler = this.getAttrManager().getHandler(handlerName);
                this.declare(handler, type, name);
                VarMember var = this.getVarMemberAt(name);
                String inout = h.readAttr("PTYPE");
                boolean isin = false;
                boolean isout = false;
                if (inout.equals("inout")) {
                    isout = true;
                    isin = true;
                } else if (inout.equals("input")) {
                    isin = true;
                } else if (inout.equals("output")) {
                    isout = true;
                }
                var.setInputParameter(isin);
                var.setOutputParameter(isout);
                String value = h.readAttr("value");
                if (value != null && !value.equals("")) {
                    if (type.equals("String")) {
                        var.setExprAsText("\"" + value + "\"");
                    } else if (type.equals("Character") || type.equals("char")) {
                        var.setExprAsText("'" + value.charAt(0) + "'");
                    } else {
                        var.setExprAsText(value);
                    }
                    var.checkValidity();
                } else {
                    String expr = h.readAttr("expr");
                    if (expr != null && !expr.equals("")) {
                        var.setExprAsText(expr);
                        var.checkValidity();
                    }
                }
            }
            h.close();
        }
    }
}

