/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.parser.javaExpr;

import agg.attribute.parser.javaExpr.ASTClassName;
import agg.attribute.parser.javaExpr.ASTMemberException;
import agg.attribute.parser.javaExpr.Jex;
import agg.attribute.parser.javaExpr.Node;
import agg.attribute.parser.javaExpr.SimpleNode;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ASTAllocationExpression
extends SimpleNode {
    static final long serialVersionUID = 1L;
    Constructor constructor = null;

    ASTAllocationExpression(String id) {
        super(id);
    }

    public static Node jjtCreate(String id) {
        return new ASTAllocationExpression(id);
    }

    protected boolean isConstantExpr() {
        return false;
    }

    protected String getMethodName() {
        String name = ((ASTClassName)this.jjtGetChild((int)0)).name;
        if (this.constructor == null) {
            return "\"" + name + "\"";
        }
        return "[" + this.constructor.toString() + "]";
    }

    public void checkContext() {
        int nChildren = this.jjtGetNumChildren();
        SimpleNode constrName = (SimpleNode)this.jjtGetChild(0);
        Class[] paramClasses = new Class[nChildren - 1];
        try {
            constrName.checkContext();
            this.takeNodeClassFrom(constrName);
            for (int i = 1; i < nChildren; ++i) {
                SimpleNode param = (SimpleNode)this.jjtGetChild(i);
                param.checkContext();
                paramClasses[i - 1] = param.getNodeClass();
            }
            if (nChildren == 1) {
                paramClasses = null;
            }
            this.constructor = this.getNodeClass().getConstructor(paramClasses);
        }
        catch (NoSuchMethodException ex1) {
            throw new ASTMemberException("No constructor " + this.getMethodName() + " with these argument types in class " + this.getNodeClass().toString() + Jex.addMessage(ex1));
        }
        catch (SecurityException ex2) {
            throw new ASTMemberException("Security violation while looking up constructor " + this.getMethodName() + " in class " + this.getNodeClass().toString() + Jex.addMessage(ex2));
        }
    }

    public void interpret() {
        if (this.constructor == null) {
            this.checkContext();
        }
        int nChildren = this.jjtGetNumChildren();
        Object[] params = new Object[nChildren - 1];
        for (int i = 1; i < nChildren; ++i) {
            this.jjtGetChild(i).interpret();
            params[i - 1] = stack[top--];
        }
        if (nChildren == 1) {
            params = null;
        }
        try {
            ASTAllocationExpression.stack[++ASTAllocationExpression.top] = this.constructor.newInstance(params);
        }
        catch (IllegalAccessException ex1) {
            throw new ASTMemberException("Cannot access constructor " + this.getMethodName() + Jex.addMessage(ex1));
        }
        catch (IllegalArgumentException ex2) {
            throw new ASTMemberException("Illegal arguments to constructor " + this.getMethodName() + Jex.addMessage(ex2));
        }
        catch (InvocationTargetException ex3) {
            throw new ASTMemberException("Error while instantiating with constructor " + this.getMethodName() + Jex.addMessage(ex3));
        }
        catch (InstantiationException ex4) {
            throw new ASTMemberException("Trying to call constructor " + this.getMethodName() + " for an interface or an abstract class." + Jex.addMessage(ex4));
        }
    }

    public String getString() {
        String argList = "";
        int nChildren = this.jjtGetNumChildren();
        Node constructor = this.jjtGetChild(0);
        for (int i = 1; i < nChildren; ++i) {
            if (i > 1) {
                argList = argList + ",";
            }
            argList = argList + this.jjtGetChild(i).getString();
        }
        return "new " + constructor.getString() + "(" + argList + ")";
    }

    public Node copy() {
        Node copy = super.copy();
        ((ASTAllocationExpression)copy).constructor = this.constructor;
        return copy;
    }
}

