/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.parser.javaExpr;

import agg.attribute.parser.javaExpr.ASTEmptyDimension;
import agg.attribute.parser.javaExpr.ASTWrongTypeException;
import agg.attribute.parser.javaExpr.Node;
import agg.attribute.parser.javaExpr.SimpleNode;
import java.lang.reflect.Array;

public class ASTArrayAllocation
extends SimpleNode {
    static final long serialVersionUID = 1L;
    Class componentClass = null;
    int nDimensions = 0;

    ASTArrayAllocation(String id) {
        super(id);
    }

    public static Node jjtCreate(String id) {
        return new ASTArrayAllocation(id);
    }

    protected boolean isConstantExpr() {
        return false;
    }

    public void checkContext() {
        int i;
        int nChildren = this.jjtGetNumChildren();
        SimpleNode componentNode = (SimpleNode)this.jjtGetChild(0);
        componentNode.checkContext();
        this.componentClass = componentNode.getNodeClass();
        this.nDimensions = nChildren - 1;
        for (i = 1; i < nChildren; ++i) {
            SimpleNode lengthNode = (SimpleNode)this.jjtGetChild(i);
            lengthNode.checkContext();
            if (lengthNode.getNodeClass() == Integer.TYPE) continue;
            String reqSig = "An array length must be of type integer (int).";
            String foundSig = "Tried to pass an object of type\n'" + lengthNode.getNodeClass() + "' as array length.";
            throw new ASTWrongTypeException(reqSig, foundSig);
        }
        int[] dimArray = new int[this.nDimensions];
        dimArray[0] = 1;
        for (i = 1; i < this.nDimensions; ++i) {
            dimArray[i] = 0;
        }
        Object arrayInst = Array.newInstance(this.componentClass, dimArray);
        Class<?> resultClass = arrayInst.getClass();
        this.setNodeClass(resultClass);
    }

    public void interpret() {
        int nChildren = this.jjtGetNumChildren();
        SimpleNode componentNode = (SimpleNode)this.jjtGetChild(0);
        boolean isLengthAllowed = true;
        int[] lengthList = new int[nChildren - 1];
        componentNode.interpret();
        this.componentClass = (Class)stack[top--];
        for (int i = 1; i < nChildren; ++i) {
            int length;
            SimpleNode lengthNode = (SimpleNode)this.jjtGetChild(i);
            lengthNode.interpret();
            lengthList[i - 1] = length = ((Integer)stack[top--]).intValue();
            if (length < 0) {
                throw new RuntimeException("An array length must be a non-negative integer number (int) or empty.\nTried to pass a value of " + length + " as length.");
            }
            if (length == 0) {
                if (i == 1) {
                    throw new RuntimeException("A positive array length value is required\nat least for the first dimension.");
                }
                isLengthAllowed = false;
                continue;
            }
            if (isLengthAllowed) continue;
            throw new RuntimeException("A positive array length value is illegal after a previous\ndimension length was empty.");
        }
        ASTArrayAllocation.stack[++ASTArrayAllocation.top] = Array.newInstance(this.componentClass, lengthList);
    }

    public String getString() {
        String dimString = "";
        Node constructorName = this.jjtGetChild(0);
        int nChildren = this.jjtGetNumChildren();
        for (int i = 1; i < nChildren; ++i) {
            Node dimension = this.jjtGetChild(i);
            dimString = dimension instanceof ASTEmptyDimension ? dimString + "[]" : dimString + "[" + dimension.getString() + "]";
        }
        return "new " + constructorName.getString() + dimString;
    }

    public Node copy() {
        Node copy = super.copy();
        ((ASTArrayAllocation)copy).componentClass = this.componentClass;
        ((ASTArrayAllocation)copy).nDimensions = this.nDimensions;
        return copy;
    }
}

