/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.parser.javaExpr;

import agg.attribute.parser.javaExpr.ASTMemberException;
import agg.attribute.parser.javaExpr.ASTWrongTypeException;
import agg.attribute.parser.javaExpr.Node;
import agg.attribute.parser.javaExpr.SimpleNode;
import java.lang.reflect.Array;

public class ASTArrayIndex
extends SimpleNode {
    static final long serialVersionUID = 1L;

    ASTArrayIndex(String id) {
        super(id);
    }

    public static Node jjtCreate(String id) {
        return new ASTArrayIndex(id);
    }

    public static Class getClassForName(String name) {
        Class clazz = null;
        if (classResolver == null) {
            try {
                clazz = Class.forName(name);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        } else {
            clazz = classResolver.forName(name);
        }
        return clazz;
    }

    protected static int getNumDimensions(Class arrayClass) {
        String classText = arrayClass.getName();
        int nDim = 0;
        while (classText.charAt(nDim++) == '[') {
        }
        return --nDim;
    }

    protected static Class getComponentClass(Class arrayClass) {
        String classText = arrayClass.getName();
        String compClassName = "";
        int ptr = 0;
        Class compClass = null;
        while (classText.charAt(ptr++) == '[') {
        }
        switch (classText.charAt(--ptr)) {
            case 'L': {
                while (classText.charAt(++ptr) != ';') {
                    compClassName = compClassName + classText.charAt(ptr);
                }
                compClass = ASTArrayIndex.getClassForName(compClassName);
                break;
            }
            case 'B': {
                compClass = Byte.TYPE;
                break;
            }
            case 'S': {
                compClass = Short.TYPE;
                break;
            }
            case 'I': {
                compClass = Integer.TYPE;
                break;
            }
            case 'J': {
                compClass = Long.TYPE;
                break;
            }
            case 'F': {
                compClass = Float.TYPE;
                break;
            }
            case 'D': {
                compClass = Double.TYPE;
                break;
            }
            case 'C': {
                compClass = Character.TYPE;
                break;
            }
            case 'Z': {
                compClass = Boolean.TYPE;
                break;
            }
        }
        if (compClass == null) {
            throw new ASTMemberException("Couldn't find the component type for the array class:\n'" + arrayClass.getName() + "'.\nWas looking for: '" + compClassName + "'.\nPlease consider extending the list of searched packages\n" + "(click the 'Config' button).");
        }
        return compClass;
    }

    public void checkContext(SimpleNode arrayNode) throws ASTWrongTypeException {
        Class<?> resultClass;
        SimpleNode indexNode = (SimpleNode)this.jjtGetChild(0);
        Class arrayClass = arrayNode.getNodeClass();
        if (!arrayClass.isArray()) {
            throw new ASTWrongTypeException(null, "Referencing a non-array object as an array,\nor the array object has less dimensions than referenced.");
        }
        indexNode.checkContext();
        if (indexNode.getNodeClass() != Integer.TYPE) {
            String reqSig = "An index must be an integer number (int).";
            String foundSig = "Tried to pass an object of type\n'" + indexNode.getNodeClass() + "' as index.";
            throw new ASTWrongTypeException(reqSig, foundSig);
        }
        Class<?> componentClass = ASTArrayIndex.getComponentClass(arrayClass);
        int nDim = ASTArrayIndex.getNumDimensions(arrayClass) - 1;
        if (nDim == 0) {
            resultClass = componentClass;
        } else {
            int[] dimArray = new int[nDim];
            dimArray[0] = 1;
            for (int i = 1; i < nDim; ++i) {
                dimArray[i] = 0;
            }
            Object arrayInst = Array.newInstance(componentClass, dimArray);
            resultClass = arrayInst.getClass();
        }
        this.setNodeClass(resultClass);
    }

    public void interpret(SimpleNode arrayNode) {
        SimpleNode indexNode = (SimpleNode)this.jjtGetChild(0);
        Object array = stack[top];
        indexNode.interpret();
        int index = (Integer)stack[top--];
        int length = Array.getLength(array);
        if (index < 0) {
            throw new RuntimeException("Array index [" + index + "] is negative.");
        }
        if (index >= length) {
            throw new RuntimeException("Array index [" + index + "] exceeds length of array [" + length + "].");
        }
        Object result = Array.get(array, index);
        ASTArrayIndex.stack[++ASTArrayIndex.top] = result;
    }

    public String getString() {
        return "[" + this.jjtGetChild(0) + "]";
    }
}

