/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.parser.javaExpr;

import agg.attribute.parser.javaExpr.ASTMemberException;
import agg.attribute.parser.javaExpr.ASTMemberName;
import agg.attribute.parser.javaExpr.ASTWrongTypeException;
import agg.attribute.parser.javaExpr.Jex;
import agg.attribute.parser.javaExpr.MemberNode;
import agg.attribute.parser.javaExpr.Node;
import agg.attribute.parser.javaExpr.SimpleNode;
import java.lang.reflect.Array;
import java.lang.reflect.Field;

public class ASTField
extends MemberNode {
    static final long serialVersionUID = 1L;
    protected Field field = null;

    ASTField(String id) {
        super(id);
    }

    public static Node jjtCreate(String id) {
        return new ASTField(id);
    }

    protected String getFieldName() {
        Class c = this.getNodeClass();
        String name = ((ASTMemberName)this.jjtGetChild((int)0)).name;
        name = c == null ? "\"" + name + "\"" : (this.field == null ? (name.equals("length") ? "[int length]" : "\"" + name + "\" : ???") : "[" + this.field.toString() + "]");
        return name;
    }

    public String toString() {
        return this.identifier + " " + this.getFieldName();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
    }

    public void checkContext(SimpleNode recipient) throws ASTWrongTypeException {
        Class recClass = recipient.getNodeClass();
        String fieldName = ((ASTMemberName)this.jjtGetChild((int)0)).name;
        if (recClass.isArray() && fieldName.equals("length")) {
            this.setNodeClass(Integer.TYPE);
            return;
        }
        try {
            this.field = recClass.getField(fieldName);
            this.setNodeClass(this.field.getType());
        }
        catch (NoSuchFieldException ex1) {
            throw new ASTMemberException("No field " + this.getFieldName() + " in class " + recClass.toString() + Jex.addMessage(ex1));
        }
        catch (SecurityException ex2) {
            throw new ASTMemberException("Security violation while looking up field " + this.getFieldName() + " in class " + recClass.toString() + Jex.addMessage(ex2));
        }
    }

    public void interpret(SimpleNode recipient) {
        Class recClass = recipient.getNodeClass();
        String fieldName = ((ASTMemberName)this.jjtGetChild((int)0)).name;
        if (recClass.isArray()) {
            if (fieldName.equals("length")) {
                ASTField.stack[++ASTField.top] = new Integer(Array.getLength(stack[top - 1]));
            }
            return;
        }
        if (this.field == null) {
            this.checkContext(recipient);
        }
        try {
            ASTField.stack[++ASTField.top] = this.field.get(stack[top - 1]);
        }
        catch (IllegalAccessException ex1) {
            throw new ASTMemberException("Cannot access field " + this.getFieldName() + Jex.addMessage(ex1));
        }
        catch (IllegalArgumentException ex2) {
            throw new ASTMemberException("Accessing field " + this.getFieldName() + " of an object of the wrong class." + Jex.addMessage(ex2));
        }
        catch (NullPointerException ex3) {
            throw new ASTMemberException("Accessing field " + this.getFieldName() + " of a null object" + Jex.addMessage(ex3));
        }
    }

    public String getString() {
        return this.jjtGetChild(0).getString();
    }

    public Node copy() {
        Node copy = super.copy();
        ((ASTField)copy).field = this.field;
        return copy;
    }
}

