/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.parser.javaExpr;

import agg.attribute.handler.HandlerExpr;
import agg.attribute.handler.HandlerType;
import agg.attribute.impl.AttrSession;
import agg.attribute.parser.javaExpr.ASTExpression;
import agg.attribute.parser.javaExpr.ASTIdNotDeclaredException;
import agg.attribute.parser.javaExpr.ASTMissingValueException;
import agg.attribute.parser.javaExpr.Node;
import agg.attribute.parser.javaExpr.ObjectConstNode;
import agg.attribute.parser.javaExpr.SimpleNode;
import java.util.Vector;

public class ASTId
extends SimpleNode {
    static final long serialVersionUID = 1L;
    String name;
    boolean isClass = false;

    ASTId(String id) {
        super(id);
    }

    public static Node jjtCreate(String id) {
        return new ASTId(id);
    }

    protected boolean isConstantExpr() {
        return false;
    }

    public String toString() {
        Class clazz = this.getNodeClass();
        String cname = "";
        if (this.isClass) {
            cname = cname + "(Class name) ";
        }
        cname = cname + "\"" + this.name + "\"";
        if (clazz != null) {
            cname = cname + " [" + clazz.toString() + "]";
        }
        return this.identifier + " " + cname;
    }

    public void checkContext() {
        Class clazz = null;
        HandlerType tabEntry = null;
        if (classResolver != null) {
            clazz = classResolver.forName(this.name);
        } else {
            try {
                clazz = Class.forName(this.name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            this.isClass = false;
            if (symtab == null) {
                AttrSession.logPrintln(AttrSession.logJexParser, "ASTId: symtab is null.");
                throw new ASTIdNotDeclaredException(this.name);
            }
            tabEntry = symtab.getType(this.name);
            if (tabEntry == null) {
                AttrSession.logPrintln(AttrSession.logJexParser, "ASTId: symtab.getType(" + this.name + ") is null.");
                throw new ASTIdNotDeclaredException(this.name);
            }
            clazz = tabEntry.getClazz();
            if (clazz == null) {
                AttrSession.logPrintln(AttrSession.logJexParser, "ASTId: symtab.getType(" + this.name + ").getClazz() is null.");
                throw new ASTIdNotDeclaredException(this.name);
            }
        } else {
            this.isClass = true;
        }
        this.setNodeClass(clazz);
    }

    public void interpret() {
        Object value = null;
        HandlerExpr tabEntry = null;
        this.checkContext();
        if (this.isClass) {
            value = this.getNodeClass();
        } else if (symtab == null || (tabEntry = symtab.getExpr(this.name)) == null || (value = tabEntry.getValue()) == null) {
            if (symtab == null) {
                AttrSession.logPrintln(AttrSession.logJexParser, "ASTId: symtab is null.");
            } else {
                tabEntry = symtab.getExpr(this.name);
                if (tabEntry == null) {
                    AttrSession.logPrintln(AttrSession.logJexParser, "ASTId: symtab.getExpr(" + this.name + ") is null.");
                } else {
                    value = tabEntry.getValue();
                    if (value == null) {
                        AttrSession.logPrintln(AttrSession.logJexParser, "ASTId: symtab.getExpr(" + this.name + ").getValue() is null.");
                    }
                }
            }
            throw new ASTMissingValueException(this.name);
        }
        ++top;
        Node obj = ObjectConstNode.jjtCreate(this.identifier + " to ObjectConstNode");
        ((ObjectConstNode)obj).obj = value;
        obj.jjtSetParent(this.jjtGetParent());
        ((ObjectConstNode)obj).setNodeClass(this.getNodeClass());
        this.jjtGetParent().replaceChildWith(this, obj);
        this.jjtSetParent(null);
        if (value != null) {
            obj.interpret();
        }
    }

    public void rewrite() {
        this.checkContext();
        HandlerExpr newExpr = symtab.getExpr(this.name);
        if (newExpr == null) {
            AttrSession.logPrintln(AttrSession.logJexParser, "ASTId: symtab.getExpr(" + this.name + ") is null.");
            throw new ASTMissingValueException(this.name);
        }
        Node newTree = newExpr.getAST();
        if (newTree instanceof ASTExpression && this.jjtGetParent() instanceof ASTExpression) {
            Node tmp = newTree.jjtGetChild(0);
            ((ASTExpression)newTree).children.removeElement(tmp);
            tmp.jjtSetParent(null);
            newTree = tmp;
        }
        newTree.jjtSetParent(this.jjtGetParent());
        this.jjtGetParent().replaceChildWith(this, newTree);
        this.jjtSetParent(null);
    }

    public String getString() {
        return this.name;
    }

    public void getAllVariablesinExpression(Vector v) {
        v.addElement(this.name);
    }

    public Node copy() {
        Node copy = ((SimpleNode)this).copy();
        ((ASTId)copy).name = new String(this.name);
        ((ASTId)copy).isClass = this.isClass;
        return copy;
    }
}

