/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.parser.javaExpr;

import agg.attribute.parser.javaExpr.ClassResolverException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Hashtable;
import java.util.Vector;

public class ClassResolver
implements Serializable {
    protected Vector packages;
    protected static Hashtable primitives;
    public static final long serialVersionUID = 5146841301451537847L;

    public ClassResolver() {
        this.init();
        this.packages = new Vector(16);
        this.packages.addElement("java.lang");
        this.packages.addElement("java.util");
        this.packages.addElement("com.objectspace.jgl");
    }

    private void init() {
        if (primitives == null) {
            primitives = new Hashtable(16);
            primitives.put("byte", Byte.TYPE);
            primitives.put("short", Short.TYPE);
            primitives.put("int", Integer.TYPE);
            primitives.put("long", Long.TYPE);
            primitives.put("float", Float.TYPE);
            primitives.put("double", Double.TYPE);
            primitives.put("char", Character.TYPE);
            primitives.put("boolean", Boolean.TYPE);
            primitives.put("void", Void.TYPE);
        }
    }

    protected int[] getArrayDimensions(String text) {
        int nDimensions = 0;
        int ptr = 0;
        while (ptr < text.length()) {
            while (ptr < text.length() && Character.isWhitespace(text.charAt(ptr))) {
                ++ptr;
            }
            if (ptr >= text.length()) continue;
            if (text.charAt(ptr++) == '[') {
                while (ptr < text.length() && (Character.isWhitespace(text.charAt(ptr)) || Character.isDigit(text.charAt(ptr)))) {
                    ++ptr;
                }
                if (ptr < text.length() && text.charAt(ptr++) == ']') {
                    ++nDimensions;
                    continue;
                }
                return null;
            }
            return null;
        }
        int[] dimArray = new int[nDimensions];
        for (int i = 0; i < nDimensions; ++i) {
            dimArray[i] = 1;
        }
        return dimArray;
    }

    protected Class getArrayClass(String name) {
        int iBeginDim = name.indexOf("[");
        String componentText = name.substring(0, iBeginDim).trim();
        String dimensionText = name.substring(iBeginDim, name.length());
        Class componentClass = this.forName(componentText);
        if (componentClass == null) {
            return null;
        }
        int[] dimensions = this.getArrayDimensions(dimensionText);
        if (dimensions == null) {
            throw new ClassResolverException("Syntax error in array dimensions.");
        }
        Object arrayInst = Array.newInstance(componentClass, dimensions);
        Class<?> arrayClass = arrayInst.getClass();
        return arrayClass;
    }

    public Class forName(String name) {
        this.init();
        if (name.indexOf("[") != -1) {
            return this.getArrayClass(name);
        }
        if (name.indexOf(46) != -1) {
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        Class prim = (Class)primitives.get(name);
        if (prim != null) {
            return prim;
        }
        try {
            return Class.forName(name);
        }
        catch (Exception e) {
            for (int i = 0; i < this.packages.size(); ++i) {
                try {
                    return Class.forName((String)this.packages.elementAt(i) + "." + name);
                }
                catch (Exception e2) {
                    continue;
                }
            }
            return null;
        }
    }

    public Vector getPackages() {
        return this.packages;
    }

    public void setPackages(Vector packages) {
        this.packages = packages;
    }

    public String toString() {
        return this.hashCode() + " " + this.getPackages().toString();
    }
}

