/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.parser.javaExpr;

import agg.attribute.handler.AttrHandlerException;
import agg.attribute.handler.SymbolTable;
import agg.attribute.impl.AttrSession;
import agg.attribute.parser.javaExpr.ASTIdNotDeclaredException;
import agg.attribute.parser.javaExpr.ASTMemberException;
import agg.attribute.parser.javaExpr.ASTMissingValueException;
import agg.attribute.parser.javaExpr.ASTWrongTypeException;
import agg.attribute.parser.javaExpr.ClassResolver;
import agg.attribute.parser.javaExpr.JexParser;
import agg.attribute.parser.javaExpr.Node;
import agg.attribute.parser.javaExpr.ParseError;
import agg.attribute.parser.javaExpr.SimpleNode;
import java.awt.Color;
import java.awt.Frame;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class Jex
implements ActionListener {
    static final long serialVersionUID = 1L;
    public static final int PARSE_ERROR = 0;
    public static final int IS_CONSTANT = 1;
    public static final int IS_VARIABLE = 2;
    public static final int IS_COMPLEX = 3;
    protected TextField typeTF;
    protected static JexParser parser;
    protected PrintStream out;
    protected PrintStream err;
    protected ByteArrayOutputStream redirect;
    protected PrintStream redirectOut;
    protected boolean isOutput = false;
    protected Object variableExpression;
    protected static Object refObj;

    public static void main(String[] args) {
        Jex me = new Jex();
        SimpleNode.setClassResolver(new ClassResolver());
        Frame frame = new Frame("Jex-Test");
        me.typeTF = new TextField("", 30);
        me.typeTF.setBackground(Color.WHITE);
        me.typeTF.addActionListener(me);
        frame.add(me.typeTF);
        frame.pack();
        frame.setVisible(true);
    }

    public void fullTest(String line) {
        try {
            Object result = this.test_interpret(line, null, null);
        }
        catch (AttrHandlerException ex1) {
            System.out.println(ex1.getMessage());
            ex1.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        String line = this.typeTF.getText();
        if (line.compareTo("q") == 0) {
            System.exit(0);
        }
        this.fullTest(line);
    }

    protected int getExprProperty() {
        SimpleNode node = (SimpleNode)JexParser.jjtree.rootNode();
        int result = 3;
        if (node.isConstantExpr()) {
            result = 1;
        } else if (node.jjtGetNumChildren() == 1) {
            node = (SimpleNode)node.jjtGetChild(0);
            if (node.identifier.equals("PrimaryExpression") && node.jjtGetNumChildren() == 1) {
                node = (SimpleNode)node.jjtGetChild(0);
                if (node.identifier.equals("Id")) {
                    result = 2;
                }
            }
        }
        return result;
    }

    protected void newStdOutStream() {
        FileOutputStream fdOut = new FileOutputStream(FileDescriptor.out);
        System.setOut(new PrintStream(new BufferedOutputStream(fdOut, 128), true));
    }

    protected void newStdErrStream() {
        FileOutputStream fdErr = new FileOutputStream(FileDescriptor.err);
        System.setErr(new PrintStream(new BufferedOutputStream(fdErr, 128), true));
    }

    protected void antiRedirect() {
        this.newStdOutStream();
        this.newStdErrStream();
    }

    protected void swapPrintStream() {
        PrintStream swapOut = System.out;
        PrintStream swapErr = System.err;
        System.setOut(this.out);
        System.setErr(this.err);
        this.out = swapOut;
        this.err = swapErr;
    }

    protected void redirectToString() {
        this.out = System.out;
        this.err = System.err;
        this.redirect = new ByteArrayOutputStream();
        this.redirectOut = new PrintStream(this.redirect);
        System.setOut(this.redirectOut);
        System.setErr(this.redirectOut);
    }

    protected void restoreOutputStream() {
        if (this.redirect != null && this.redirectOut != null) {
            System.setOut(this.out);
            System.setErr(this.err);
            if (this.isOutput) {
                System.out.println(this.redirect.toString());
            }
            this.redirect = null;
            this.redirectOut = null;
        }
    }

    public static String addMessage(Exception ex) {
        String msg = ex.getMessage();
        if (msg == null || msg.equals("null")) {
            return "";
        }
        return "\n  (" + msg + ")";
    }

    public void parseOutputOn() {
        this.isOutput = true;
    }

    public void parseOutputOff() {
        this.isOutput = false;
    }

    public int parse(String text) throws AttrHandlerException {
        AttrSession.logPrintln(AttrSession.logTrace, "Jex:\n->parse");
        AttrSession.logPrintln(AttrSession.logTrace, "Jex: text " + text);
        AttrSession.logPrintln(AttrSession.logJexParser, "Jex:\n->parse");
        AttrSession.logPrintln(AttrSession.logJexParser, "Jex: text " + text);
        try {
            int n = this.parse_(text);
            return n;
        }
        catch (Exception ex1) {
            if (this.redirect != null) {
                throw new AttrHandlerException(this.redirect.toString() + Jex.addMessage(ex1));
            }
            throw new AttrHandlerException(Jex.addMessage(ex1));
        }
        finally {
            AttrSession.logPrintln(AttrSession.logTrace, "Jex:\n<-parse");
            AttrSession.logPrintln(AttrSession.logJexParser, "Jex:\n<-parse");
        }
    }

    protected String getPropertyText(int code) {
        if (code == 1) {
            return "Constant expression";
        }
        if (code == 2) {
            return "Variable";
        }
        if (code == 3) {
            return "Complex expression";
        }
        return "Parse error";
    }

    protected int parse_(String text) throws ParseError {
        AttrSession.logPrintln(AttrSession.logTrace, "Jex:\n->\tparse_");
        AttrSession.logPrintln(AttrSession.logTrace, "Jex: text " + text);
        AttrSession.logPrintln(AttrSession.logJexParser, "Jex:\n->\tparse_");
        AttrSession.logPrintln(AttrSession.logJexParser, "Jex: text " + text);
        int result = 0;
        String line = text + " ";
        byte[] bytes = line.getBytes();
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        if (parser == null) {
            parser = new JexParser(stream);
        } else {
            JexParser.ReInit(stream);
            JexParser.jjtree.reset();
            SimpleNode.top = -1;
        }
        AttrSession.logPrintln(AttrSession.logJexParser, "Parsing [" + text + "] ...");
        JexParser.CompilationUnit();
        JexParser.jjtree.rootNode().dump("  ");
        result = this.getExprProperty();
        AttrSession.logPrintln(AttrSession.logJexParser, " Expression property: " + this.getPropertyText(result));
        AttrSession.logPrintln(AttrSession.logTrace, "Jex:\n<-\tparse_");
        AttrSession.logPrintln(AttrSession.logJexParser, "Jex:\n<-\tparse_");
        return result;
    }

    public void check(Node ast, Class type, SymbolTable symtab) throws AttrHandlerException {
        block12: {
            AttrSession.logPrintln(AttrSession.logJexParser, "Jex.check:   " + ast + "   " + type);
            try {
                SimpleNode.setSymbolTable(symtab);
                try {
                    AttrSession.logPrintln(AttrSession.logJexParser, "Type-Checking ...");
                    ast.checkContext();
                    this.variableExpression = ast;
                }
                catch (ASTIdNotDeclaredException ex1) {
                    AttrSession.logPrintln(AttrSession.logJexParser, "Variable \"" + ex1.getMessage() + "\" is not declared");
                    throw ex1;
                }
                catch (ASTWrongTypeException ex2) {
                    AttrSession.logPrintln(AttrSession.logJexParser, "Wrong type.\n");
                    if (ex2.getExpected() != null) {
                        AttrSession.logPrintln(AttrSession.logJexParser, "Required signature: " + ex2.getExpected());
                    }
                    AttrSession.logPrintln(AttrSession.logJexParser, "Encountered: " + ex2.getFound());
                    throw ex2;
                }
                catch (ASTMemberException ex3) {
                    AttrSession.logPrintln(AttrSession.logJexParser, "Exception:\n" + ex3.getMessage());
                    throw ex3;
                }
                catch (Exception ex) {
                    AttrSession.logPrintln(AttrSession.logJexParser, "Exception:\n" + ex.getMessage());
                    throw new RuntimeException(ex.getMessage());
                }
                if (type == null || type == Void.TYPE) break block12;
                Class resultType = ((SimpleNode)ast).getNodeClass();
                boolean assignable = this.isAssignable(type, resultType);
                if (assignable) {
                    AttrSession.logPrintln(AttrSession.logJexParser, "Types are assignable");
                    break block12;
                }
                AttrSession.logPrintln(AttrSession.logJexParser, "Wrong expression type.");
                AttrSession.logPrintln(AttrSession.logJexParser, "Required: " + type.getName());
                AttrSession.logPrintln(AttrSession.logJexParser, "Found: " + resultType.getName());
                throw new ASTWrongTypeException();
            }
            catch (Exception ex1) {
                if (this.redirect != null) {
                    throw new AttrHandlerException(this.redirect.toString());
                }
                throw new AttrHandlerException(ex1.getMessage());
            }
        }
    }

    public void check(String text, Class type, SymbolTable symtab) throws AttrHandlerException {
        try {
            this.check_(text, type, symtab);
        }
        catch (Exception ex1) {
            if (this.redirect != null) {
                throw new AttrHandlerException(this.redirect.toString());
            }
            throw new AttrHandlerException(ex1.getMessage());
        }
    }

    public void check_(String text, Class type, SymbolTable symtab) throws ParseError {
        Class resultType;
        this.parse_(text);
        SimpleNode.setSymbolTable(symtab);
        try {
            AttrSession.logPrintln(AttrSession.logJexParser, "Type-Checking ...");
            JexParser.jjtree.rootNode().checkContext();
            JexParser.jjtree.rootNode().dump("  ");
        }
        catch (ASTIdNotDeclaredException ex1) {
            AttrSession.logPrintln(AttrSession.logJexParser, "Variable \"" + ex1.getMessage() + "\" is not declared");
            throw ex1;
        }
        catch (ASTWrongTypeException ex2) {
            AttrSession.logPrintln(AttrSession.logJexParser, "Wrong type.\n");
            if (ex2.getExpected() != null) {
                AttrSession.logPrintln(AttrSession.logJexParser, "Required signature: " + ex2.getExpected());
            }
            AttrSession.logPrintln(AttrSession.logJexParser, "Encountered: " + ex2.getFound());
            throw ex2;
        }
        catch (ASTMemberException ex3) {
            AttrSession.logPrintln(AttrSession.logJexParser, "Exception:\n" + ex3.getMessage());
            throw ex3;
        }
        catch (Exception ex) {
            AttrSession.logPrintln(AttrSession.logJexParser, "Exception:\n" + ex.getMessage());
            throw new RuntimeException(ex.getMessage());
        }
        if (type != null && type != Void.TYPE && !this.isAssignable(type, resultType = ((SimpleNode)JexParser.jjtree.rootNode()).getNodeClass())) {
            AttrSession.logPrintln(AttrSession.logJexParser, "Wrong expression type.\n Required: " + type.getName() + "\n Found: " + resultType.getName());
            throw new ASTWrongTypeException();
        }
    }

    protected boolean isAssignable(Class to, Class from) {
        if (to.isPrimitive() || from.isPrimitive()) {
            if (to == Byte.TYPE || to == Short.TYPE || to == Integer.TYPE || to == Long.TYPE) {
                return from == Byte.TYPE || from == Short.TYPE || from == Integer.TYPE || from == Long.TYPE;
            }
            if (to == Float.TYPE || to == Double.TYPE) {
                return from == Float.TYPE || from == Double.TYPE;
            }
            return to == from;
        }
        return to.isAssignableFrom(from) || from.isInstance(refObj);
    }

    protected Object test_interpret(String text, Class type, SymbolTable symtab) throws AttrHandlerException {
        Object result;
        try {
            result = this.interpret_(text, type, symtab);
        }
        catch (ParseError ex1) {
            if (this.redirect != null) {
                throw new AttrHandlerException(this.redirect.toString() + Jex.addMessage(ex1));
            }
            throw new AttrHandlerException(Jex.addMessage(ex1));
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public Object interpret(Node ast, Class type, SymbolTable symtab) throws AttrHandlerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Object interpret(String text, Class type, SymbolTable symtab) throws AttrHandlerException {
        AttrSession.logPrintln(AttrSession.logTrace, "Jex: \n->interpret()");
        AttrSession.logPrintln(AttrSession.logJexParser, "Jex: \n->interpret()");
        try {
            Object object = this.interpret_(text, type, symtab);
            return object;
        }
        catch (Exception ex1) {
            AttrSession.logPrintln(AttrSession.logTrace, "Jex: AttrHandlerException geworfen");
            AttrSession.logPrintln(AttrSession.logJexParser, "Jex: AttrHandlerException geworfen");
            if (this.redirect != null) {
                throw new AttrHandlerException(this.redirect.toString());
            }
            throw new AttrHandlerException(ex1.getMessage());
        }
        finally {
            AttrSession.logPrintln(AttrSession.logTrace, "Jex: \n<-interpret()");
            AttrSession.logPrintln(AttrSession.logJexParser, "Jex: \n<-interpret()");
        }
    }

    public Object interpret_(String text, Class type, SymbolTable symtab) throws ParseError {
        if (JexParser.jjtree.rootNode() != null) {
            JexParser.jjtree.rootNode().dump("");
        }
        Object result = null;
        this.check_(text, type, symtab);
        try {
            AttrSession.logPrintln(AttrSession.logJexParser, "Evaluating ...");
            JexParser.jjtree.rootNode().interpret();
            result = JexParser.jjtree.rootNode().getRootResult();
            String resultString = result == null ? "null" : result.toString();
            AttrSession.logPrintln(AttrSession.logJexParser, "Result = " + resultString);
            JexParser.jjtree.rootNode().dump("");
            AttrSession.logPrintln(AttrSession.logJexParser, "Result = " + resultString);
            Object object = result;
            return object;
        }
        catch (ASTIdNotDeclaredException ex1) {
            AttrSession.logPrintln(AttrSession.logJexParser, "Variable \"" + ex1.getMessage() + "\" is not declared");
            throw ex1;
        }
        catch (ASTMissingValueException ex2) {
            AttrSession.logPrintln(AttrSession.logJexParser, "Missing value for variable \"" + ex2.getMessage() + "\".");
            throw ex2;
        }
        catch (ASTMemberException ex3) {
            AttrSession.logPrintln(AttrSession.logJexParser, "ASTMemberException " + ex3.getMessage());
            throw ex3;
        }
        catch (Exception ex) {
            AttrSession.logPrintln(AttrSession.logJexParser, "Exception:\n" + ex.getMessage());
            throw new RuntimeException(ex.getMessage());
        }
        finally {
            AttrSession.logPrintln(AttrSession.logTrace, "Jex:\n<-interpret_");
            AttrSession.logPrintln(AttrSession.logJexParser, "Jex:\n<-interpret_");
        }
    }

    public void rewrite(Node ast, Class type, SymbolTable symtab) throws AttrHandlerException {
        try {
            this.check(ast, type, symtab);
        }
        catch (AttrHandlerException ahe) {
            AttrSession.logPrintln(AttrSession.logJexParser, "Type-checking causes an error. Rewriting failed. " + ahe.getMessage());
            throw ahe;
        }
        ast.rewrite();
        if (ast.getError().length() != 0) {
            throw new AttrHandlerException(ast.getError());
        }
    }

    public Node getAST() {
        return JexParser.jjtree.rootNode();
    }

    public Object getVariableExpression() {
        return this.variableExpression;
    }

    static {
        refObj = new Object();
    }
}

