/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.parser.javaExpr;

import agg.attribute.impl.AttrSession;
import agg.attribute.parser.javaExpr.ASTMemberException;
import agg.attribute.parser.javaExpr.ASTMemberName;
import agg.attribute.parser.javaExpr.ASTWrongTypeException;
import agg.attribute.parser.javaExpr.Jex;
import agg.attribute.parser.javaExpr.MemberNode;
import agg.attribute.parser.javaExpr.Node;
import agg.attribute.parser.javaExpr.SimpleNode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;

public class OpMemberNode
extends MemberNode {
    static final long serialVersionUID = 1L;
    protected Method method = null;
    protected Object receivingObj;
    protected Object returnObj;

    OpMemberNode(String id) {
        super(id);
    }

    public static Node jjtCreate(String id) {
        return new OpMemberNode(id);
    }

    protected boolean isConstantExpr() {
        return false;
    }

    protected String getMethodName() {
        Class c = this.getNodeClass();
        String name = ((ASTMemberName)this.jjtGetChild((int)0)).name;
        if (c == null) {
            return "\"" + name + "\"";
        }
        return "[" + this.method.toString() + "]";
    }

    public String toString() {
        return this.identifier + " " + this.getMethodName();
    }

    public void dump(String prefix) {
        AttrSession.logPrintln(AttrSession.logJexParser, this.toString(prefix));
        if (this.children != null) {
            Enumeration e = this.children.elements();
            e.nextElement();
            while (e.hasMoreElements()) {
                SimpleNode n = (SimpleNode)e.nextElement();
                n.dump(prefix + " ");
            }
        }
    }

    protected static boolean areParamsCompatible(Class[] sigTypes, Class[] realTypes) {
        if (realTypes == null) {
            return sigTypes.length == 0;
        }
        if (sigTypes.length == realTypes.length) {
            for (int i = 0; i < sigTypes.length; ++i) {
                if (sigTypes[i].isAssignableFrom(realTypes[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected static Method getMethod(Class clazz, String name, Class[] paramTypes) {
        Method result = null;
        try {
            result = clazz.getMethod(name, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            Method[] allMethods = clazz.getMethods();
            for (int i = 0; i < allMethods.length; ++i) {
                Method tmpMethod = allMethods[i];
                if (!tmpMethod.getName().equals(name) || !OpMemberNode.areParamsCompatible(tmpMethod.getParameterTypes(), paramTypes)) continue;
                result = tmpMethod;
            }
        }
        return result;
    }

    protected void findMethod(SimpleNode recipient) throws ASTWrongTypeException {
        Class recClass = recipient.getNodeClass();
        String methodName = ((ASTMemberName)this.jjtGetChild((int)0)).name;
        int nChildren = this.jjtGetNumChildren();
        Class[] paramTypes = new Class[nChildren - 1];
        for (int i = 1; i < nChildren; ++i) {
            SimpleNode param = (SimpleNode)this.jjtGetChild(i);
            param.checkContext();
            paramTypes[i - 1] = param.getNodeClass();
        }
        if (nChildren == 1) {
            paramTypes = null;
        }
        this.method = OpMemberNode.getMethod(recClass, methodName, paramTypes);
        if (this.method == null) {
            String paramText;
            if (paramTypes != null) {
                paramText = "for parameter types \n (";
                for (int i = 0; i < paramTypes.length; ++i) {
                    paramText = paramText + paramTypes[i].toString();
                    if (i >= paramTypes.length - 1) continue;
                    paramText = paramText + ", ";
                }
                paramText = paramText + ")";
            } else {
                paramText = "with an empty parameter list";
            }
            throw new ASTMemberException("No public method " + this.getMethodName() + "\n  " + paramText + "\n  in class " + recClass.toString() + " .");
        }
    }

    public void invoke(SimpleNode recipient) {
        if (this.method == null) {
            this.checkContext(recipient);
        }
        int nChildren = this.jjtGetNumChildren();
        Object[] params = new Object[nChildren - 1];
        for (int i = 1; i < nChildren; ++i) {
            this.jjtGetChild(i).interpret();
            params[i - 1] = stack[top--];
        }
        if (nChildren == 1) {
            params = null;
        }
        this.receivingObj = stack[top];
        try {
            this.returnObj = this.method.invoke(this.receivingObj, params);
            AttrSession.logPrintln(AttrSession.logJexParser, "OpMemberNode: receivingObj=" + this.receivingObj);
            AttrSession.logPrintln(AttrSession.logJexParser, "OpMemberNode: returnObj=" + this.returnObj);
        }
        catch (IllegalAccessException ex1) {
            throw new ASTMemberException("Cannot access method " + this.getMethodName() + Jex.addMessage(ex1));
        }
        catch (IllegalArgumentException ex2) {
            throw new ASTMemberException("Illegal arguments to method " + this.getMethodName() + Jex.addMessage(ex2));
        }
        catch (InvocationTargetException ex3) {
            if (ex3.getTargetException() != null) {
                throw new ASTMemberException("Error while invoking method " + this.getMethodName() + "  " + Jex.addMessage((Exception)ex3.getTargetException()));
            }
            throw new ASTMemberException("Error while invoking method " + this.getMethodName() + Jex.addMessage(ex3));
        }
        catch (NullPointerException ex4) {
            throw new ASTMemberException("Invoking method " + this.getMethodName() + " on a null object." + Jex.addMessage(ex4));
        }
    }

    public void checkContext(SimpleNode recipient) throws ASTWrongTypeException {
        this.findMethod(recipient);
        this.setNodeClass(this.method.getReturnType());
    }

    public void interpret(SimpleNode recipient) {
        this.invoke(recipient);
        OpMemberNode.stack[++OpMemberNode.top] = this.returnObj;
    }

    public Node copy() {
        Node copy = super.copy();
        ((OpMemberNode)copy).method = this.method;
        ((OpMemberNode)copy).receivingObj = this.receivingObj;
        ((OpMemberNode)copy).returnObj = this.returnObj;
        return copy;
    }
}

