/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.parser.javaExpr;

import agg.attribute.handler.SymbolTable;
import agg.attribute.impl.AttrSession;
import agg.attribute.parser.javaExpr.ASTMissingValueException;
import agg.attribute.parser.javaExpr.ClassResolver;
import agg.attribute.parser.javaExpr.Node;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SimpleNode
implements Node {
    static final long serialVersionUID = 1L;
    protected Node parent;
    protected Vector children;
    protected String identifier;
    protected Object info;
    private String error;
    protected static Object[] stack = new Object[2048];
    protected static int top = -1;
    protected static boolean neverCalled = true;
    protected static SymbolTable symtab = null;
    protected static Hashtable numberTypes = new Hashtable();
    protected static Hashtable constructors = new Hashtable();
    protected static Hashtable refMethods = new Hashtable();
    protected static Class stringClass;
    protected static Class objectClass;
    private Class nodeClass = null;
    protected static ClassResolver classResolver;

    public SimpleNode(String id) {
        this.identifier = id;
        SimpleNode.typeInit();
        this.error = "";
    }

    public static Node jjtCreate(String id) {
        return new SimpleNode(id);
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
        if (this.children != null) {
            this.children.trimToSize();
        }
    }

    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node n) {
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.addElement(n);
    }

    public Node jjtGetChild(int i) {
        return (Node)this.children.elementAt(i);
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.size();
    }

    public void setInfo(Object i) {
        this.info = i;
    }

    public Object getInfo() {
        return this.info;
    }

    public String toString() {
        Class c = this.getNodeClass();
        if (c == null) {
            return this.identifier;
        }
        return this.identifier + " [" + c.toString() + "]";
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        AttrSession.logPrintln(AttrSession.logJexParser, this.toString(prefix));
        if (this.children != null) {
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                SimpleNode n = (SimpleNode)e.nextElement();
                n.dump(prefix + " ");
            }
        }
    }

    public void interpret() {
        this.error = "SimpleNode.interpret FAILED!";
    }

    public String getError() {
        return this.error;
    }

    protected static void typeInit() {
        if (neverCalled) {
            neverCalled = false;
            int codeNr = 0;
            codeNr = 0;
            numberTypes.put(Byte.TYPE, new Integer(codeNr++));
            numberTypes.put(Short.TYPE, new Integer(codeNr++));
            numberTypes.put(Long.TYPE, new Integer(codeNr++));
            numberTypes.put(Integer.TYPE, new Integer(codeNr++));
            numberTypes.put(Float.TYPE, new Integer(codeNr++));
            numberTypes.put(Double.TYPE, new Integer(codeNr++));
            try {
                stringClass = Class.forName("java.lang.String");
                objectClass = Class.forName("java.lang.Object");
            }
            catch (Exception e) {
                throw (RuntimeException)e;
            }
        }
    }

    public Class getNodeClass() {
        return this.nodeClass;
    }

    protected void setNodeClass(Class nodeClass) {
        this.nodeClass = nodeClass;
    }

    protected void takeNodeClassFrom(SimpleNode node) {
        this.setNodeClass(node.getNodeClass());
    }

    public boolean isAction() {
        return this.identifier.equals("Action");
    }

    public boolean isMember() {
        return this.identifier.equals("Method") || this.identifier.equals("Action") || this.identifier.equals("Field");
    }

    public boolean isArrayIndex() {
        return this.identifier.equals("ArrayIndex");
    }

    public boolean hasStringType() {
        return this.getNodeClass() == stringClass;
    }

    public boolean hasNumberType() {
        return numberTypes.containsKey(this.nodeClass);
    }

    protected int typeCode() {
        return SimpleNode.typeCode(this.getNodeClass());
    }

    protected static int typeCode(Class cls) {
        return (Integer)numberTypes.get(cls);
    }

    protected Class commonNumberType(SimpleNode n1, SimpleNode n2) {
        int numType2;
        int numType1 = (Integer)numberTypes.get(n1.getNodeClass());
        return numType1 > (numType2 = ((Integer)numberTypes.get(n2.getNodeClass())).intValue()) ? n1.getNodeClass() : n2.getNodeClass();
    }

    protected boolean isConstantExpr() {
        int nChildren = this.jjtGetNumChildren();
        for (int i = 0; i < nChildren; ++i) {
            SimpleNode child = (SimpleNode)this.jjtGetChild(i);
            if (child.isConstantExpr()) continue;
            return false;
        }
        return true;
    }

    public void checkContext() {
        throw new Error();
    }

    public static void setSymbolTable(SymbolTable st) {
        symtab = st;
    }

    public static SymbolTable getSymbolTable() {
        return symtab;
    }

    public static void setClassResolver(ClassResolver cr) {
        classResolver = cr;
    }

    public Object getRootResult() {
        return stack[top];
    }

    public String getString() {
        return this.toString();
    }

    public void rewrite() {
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            this.error = "";
            try {
                this.jjtGetChild(i).interpret();
                if (this.jjtGetChild(i).getError().length() == 0) continue;
                AttrSession.logPrintln(AttrSession.logJexParser, " SimpleNode.rewrite  : interpret  FAILED!");
                this.error = this.jjtGetChild(i).getError();
                break;
            }
            catch (ASTMissingValueException amve) {
                this.jjtGetChild(i).rewrite();
            }
        }
    }

    public void replaceChildWith(Node old, Node newNode) {
        int pos = this.children.indexOf(old);
        this.children.insertElementAt(newNode, pos);
        this.children.removeElement(old);
    }

    public void getAllVariablesinExpression(Vector v) {
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            this.jjtGetChild(i).getAllVariablesinExpression(v);
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Node copy() {
        Node copy = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(this);
            oos.flush();
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(in);
            copy = (Node)ois.readObject();
            oos.close();
            ois.close();
        }
        catch (IOException ioe) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return copy;
    }

    static {
        classResolver = null;
    }
}

