/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.util;

import agg.attribute.util.RowDragEvent;
import agg.attribute.util.RowDragListener;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTable;

public class TableRowDragger {
    protected transient Vector listener = new Vector(10, 10);
    protected JTable tableView;
    protected boolean draggingStarted = false;
    protected int draggedRow = -1;
    protected Cursor defaultCursor;
    protected Cursor moveCursor = Cursor.getPredefinedCursor(1);

    public TableRowDragger(JTable table) {
        this.tableView = table;
        MouseMotionAdapter dragMotionListener = new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                int row = TableRowDragger.this.tableView.rowAtPoint(e.getPoint());
                if (row == -1) {
                    return;
                }
                if (TableRowDragger.this.draggedRow != -1) {
                    if (!TableRowDragger.this.draggingStarted && row != -1) {
                        TableRowDragger.this.draggingStarted = true;
                        TableRowDragger.this.defaultCursor = TableRowDragger.this.tableView.getCursor();
                        TableRowDragger.this.tableView.setCursor(TableRowDragger.this.moveCursor);
                        TableRowDragger.this.fireDraggingStarted(TableRowDragger.this.draggedRow);
                    } else if (TableRowDragger.this.draggingStarted && row != TableRowDragger.this.draggedRow) {
                        TableRowDragger.this.fireDraggingMoved(TableRowDragger.this.draggedRow, row);
                        TableRowDragger.this.draggedRow = row;
                    }
                }
            }
        };
        MouseAdapter dragStartStopListener = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int row = TableRowDragger.this.tableView.rowAtPoint(e.getPoint());
                if (row != -1) {
                    TableRowDragger.this.draggedRow = row;
                }
            }

            public void mouseReleased(MouseEvent e) {
                TableRowDragger.this.draggedRow = -1;
                if (TableRowDragger.this.draggingStarted) {
                    TableRowDragger.this.draggingStarted = false;
                    TableRowDragger.this.tableView.setCursor(TableRowDragger.this.defaultCursor);
                    TableRowDragger.this.fireDraggingStopped();
                }
            }
        };
        this.tableView.addMouseListener(dragStartStopListener);
        this.tableView.addMouseMotionListener(dragMotionListener);
    }

    public boolean isDraggingActive() {
        return this.draggingStarted;
    }

    public void addRowDragListener(RowDragListener li) {
        if (!this.listener.contains(li)) {
            this.listener.addElement(li);
        }
    }

    public void removeRowDragListener(RowDragListener li) {
        this.listener.removeElement(li);
    }

    protected void fireDraggingStarted(int row) {
        RowDragEvent ev = new RowDragEvent(this, 0, row, row);
        Enumeration en = this.listener.elements();
        while (en.hasMoreElements()) {
            RowDragListener li = (RowDragListener)en.nextElement();
            li.draggingStarted(ev);
        }
    }

    protected void fireDraggingStopped() {
        RowDragEvent ev = new RowDragEvent(this, 0, -1, -1);
        Enumeration en = this.listener.elements();
        while (en.hasMoreElements()) {
            RowDragListener li = (RowDragListener)en.nextElement();
            li.draggingStopped(ev);
        }
    }

    protected void fireDraggingMoved(int src, int dest) {
        RowDragEvent ev = new RowDragEvent(this, 0, src, dest);
        Enumeration en = this.listener.elements();
        while (en.hasMoreElements()) {
            RowDragListener li = (RowDragListener)en.nextElement();
            li.draggingMoved(ev);
        }
    }
}

