/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.view.impl;

import agg.attribute.AttrTuple;
import agg.attribute.AttrType;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.TupleObject;
import agg.attribute.view.AttrViewObserver;
import agg.attribute.view.AttrViewSetting;
import agg.attribute.view.impl.OpenViewSetting;
import agg.attribute.view.impl.TupleFormat;
import agg.attribute.view.impl.ViewSetting;

public class MaskedViewSetting
extends ViewSetting {
    static final long serialVersionUID = -7941882634203060406L;
    protected OpenViewSetting openView;

    public MaskedViewSetting(OpenViewSetting ov) {
        super(ov.getManager());
        this.openView = ov;
    }

    protected TupleFormat getFormat(AttrTuple attr) {
        return ((ViewSetting)this.getOpenView()).getFormat(attr);
    }

    protected void removeFormat(AttrType type) {
        ((ViewSetting)this.getOpenView()).removeFormat(type);
    }

    public AttrViewSetting getOpenView() {
        return this.openView;
    }

    public AttrViewSetting getMaskedView() {
        return this;
    }

    public void addObserver(AttrViewObserver o, AttrTuple attr) {
        this.openView.ensureBeingAttrObserver(attr);
        this.addObserverForTuple(o, attr);
    }

    public void removeObserver(AttrViewObserver o, AttrTuple attr) {
        this.removeObserverForTuple(o, attr);
        this.openView.stopObservingIfNeedless(attr);
    }

    public int convertIndexToSlot(AttrTuple attr, int index) {
        TupleFormat f = this.getFormat(attr);
        return f.getVisibleSlotForIndex(index);
    }

    public int convertSlotToIndex(AttrTuple attr, int slot) {
        TupleFormat f = this.getFormat(attr);
        return f.getIndexAtVisibleSlot(slot);
    }

    public int getSize(AttrTuple attr) {
        return this.getFormat(attr).getVisibleSize();
    }

    public boolean isVisible(AttrTuple attr, int slot) {
        return this.getFormat(attr).isVisible(slot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisibleAt(AttrTuple attr, boolean b, int slot) {
        TupleFormat f;
        TupleFormat tupleFormat = f = this.getFormat(attr);
        synchronized (tupleFormat) {
            f.setVisible(b, f.getTotalSlot(slot));
            ((DeclMember)((TupleObject)attr).getTupleType().getMemberAt(slot)).setVisible(b);
            this.fireAttrChanged(((TupleObject)attr).getTupleType(), 220, slot, slot);
            this.openView.fireAttrChanged(((TupleObject)attr).getTupleType(), 0, 0, 0);
        }
    }

    public void setAllVisible(AttrTuple attr, boolean b) {
        this.openView.setAllVisible(attr, b);
    }

    public void setVisible(AttrTuple attr) {
        this.openView.setVisible(attr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveSlotInserting(AttrTuple attr, int srcSlot, int destSlot) {
        TupleFormat f;
        TupleFormat tupleFormat = f = this.getFormat(attr);
        synchronized (tupleFormat) {
            f.moveSlotInserting(f.getTotalSlot(srcSlot), f.getTotalSlot(destSlot));
            this.fireAttrChanged(((TupleObject)attr).getTupleType(), 210, srcSlot, destSlot);
            this.openView.fireAttrChanged(((TupleObject)attr).getTupleType(), 0, 0, 0);
        }
    }

    public void resetTuple(AttrTuple attr) {
        this.openView.resetTuple(attr);
    }
}

