/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.view.impl;

import agg.attribute.AttrEvent;
import agg.attribute.AttrObserver;
import agg.attribute.AttrTuple;
import agg.attribute.AttrType;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.DeclTuple;
import agg.attribute.impl.TupleObject;
import agg.attribute.view.AttrViewObserver;
import agg.attribute.view.AttrViewSetting;
import agg.attribute.view.impl.MaskedViewSetting;
import agg.attribute.view.impl.TupleFormat;
import agg.attribute.view.impl.ViewSetting;
import java.util.Hashtable;
import java.util.Vector;

public class OpenViewSetting
extends ViewSetting
implements AttrObserver {
    protected Hashtable formatTab;
    protected MaskedViewSetting maskedView = new MaskedViewSetting(this);
    protected int lastOpenDeletedSlot0 = -1;
    protected int lastOpenDeletedSlot1 = -1;
    protected int lastMaskedDeletedSlot0 = -1;
    protected int lastMaskedDeletedSlot1 = -1;
    static final long serialVersionUID = 4242537253046200014L;

    public OpenViewSetting(AttrTupleManager m) {
        super(m);
        this.formatTab = new Hashtable(50);
    }

    protected TupleFormat rawGetFormat(AttrTuple attr) {
        DeclTuple type = ((TupleObject)attr).getTupleType();
        TupleFormat format = (TupleFormat)this.formatTab.get(type);
        return format;
    }

    protected TupleFormat rawAddFormatFor(AttrTuple attr) {
        DeclTuple type = ((TupleObject)attr).getTupleType();
        TupleFormat format = new TupleFormat(type.getNumberOfEntries());
        this.formatTab.put(type, format);
        return format;
    }

    protected TupleFormat getFormat(AttrTuple attr) {
        TupleFormat format = this.rawGetFormat(attr);
        if (format == null) {
            format = this.rawAddFormatFor(attr);
        }
        return format;
    }

    public synchronized void removeFormat(AttrType type) {
        DeclTuple typ = ((TupleObject)((Object)type)).getTupleType();
        Object o = null;
        o = this.formatTab.remove(typ);
    }

    protected boolean hasObserversForTuple(AttrTuple attr) {
        Vector observers1 = this.getObserversForTuple(attr);
        Vector observers2 = this.maskedView.getObserversForTuple(attr);
        return observers1 != null && !observers1.isEmpty() || observers2 != null && !observers2.isEmpty();
    }

    public void ensureBeingAttrObserver(AttrTuple attr) {
        DeclTuple type = ((TupleObject)attr).getTupleType();
        if (!this.hasObserversForTuple(attr)) {
            type.addObserver(this);
            attr.addObserver(this);
            this.getFormat(attr);
        }
    }

    public void stopObservingIfNeedless(AttrTuple attr) {
        DeclTuple type = ((TupleObject)attr).getTupleType();
        if (!this.hasObserversForTuple(attr)) {
            attr.removeObserver(this);
        }
    }

    public AttrViewSetting getOpenView() {
        return this;
    }

    public AttrViewSetting getMaskedView() {
        return this.maskedView;
    }

    public void addObserver(AttrViewObserver o, AttrTuple attr) {
        this.ensureBeingAttrObserver(attr);
        this.addObserverForTuple(o, attr);
    }

    public void removeObserver(AttrViewObserver o, AttrTuple attr) {
        this.removeObserverForTuple(o, attr);
        this.stopObservingIfNeedless(attr);
    }

    public int convertIndexToSlot(AttrTuple attr, int index) {
        TupleFormat f = this.getFormat(attr);
        return f.getTotalSlotForIndex(index);
    }

    public int convertSlotToIndex(AttrTuple attr, int slot) {
        TupleFormat f = this.getFormat(attr);
        return f.getIndexAtTotalSlot(slot);
    }

    public int getSize(AttrTuple attr) {
        return attr.getNumberOfEntries();
    }

    public boolean isVisible(AttrTuple attr, int slot) {
        TupleFormat f = this.getFormat(attr);
        return f.isVisible(slot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisibleAt(AttrTuple attr, boolean b, int slot) {
        TupleFormat f;
        TupleFormat tupleFormat = f = this.getFormat(attr);
        synchronized (tupleFormat) {
            f.setVisible(b, slot);
            ((DeclMember)((TupleObject)attr).getTupleType().getMemberAt(slot)).setVisible(b);
            this.fireAttrChanged(((TupleObject)attr).getTupleType(), 220, slot, slot);
            this.maskedView.fireAttrChanged(((TupleObject)attr).getTupleType(), 0, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllVisible(AttrTuple attr, boolean b) {
        TupleFormat f;
        TupleFormat tupleFormat = f = this.getFormat(attr);
        synchronized (tupleFormat) {
            for (int i = 0; i < attr.getNumberOfEntries(); ++i) {
                f.setVisible(b, i);
                ((DeclMember)((TupleObject)attr).getTupleType().getMemberAt(i)).setVisible(b);
            }
            this.fireAttrChanged(((TupleObject)attr).getTupleType(), 0, 0, 0);
            this.maskedView.fireAttrChanged(((TupleObject)attr).getTupleType(), 0, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(AttrTuple attr) {
        TupleFormat f;
        TupleFormat tupleFormat = f = this.getFormat(attr);
        synchronized (tupleFormat) {
            for (int i = 0; i < attr.getNumberOfEntries(); ++i) {
                boolean b = ((DeclMember)((TupleObject)attr).getTupleType().getMemberAt(i)).isVisible();
                f.setVisible(b, i);
            }
            this.fireAttrChanged(((TupleObject)attr).getTupleType(), 0, 0, 0);
            this.maskedView.fireAttrChanged(((TupleObject)attr).getTupleType(), 0, 0, 0);
        }
    }

    public void moveSlotInserting(AttrTuple attr, int srcSlot, int destSlot) {
        this.getFormat(attr).moveSlotInserting(srcSlot, destSlot);
        this.fireAttrChanged(((TupleObject)attr).getTupleType(), 210, srcSlot, destSlot);
        if (this.isVisible(attr, destSlot)) {
            this.maskedView.fireAttrChanged(((TupleObject)attr).getTupleType(), 0, 0, 0);
        }
    }

    public void resetTuple(AttrTuple attr) {
        DeclTuple type = ((TupleObject)attr).getTupleType();
        this.removeFormat(type);
        TupleFormat format = this.getFormat(type);
        this.fireAttrChanged(((TupleObject)attr).getTupleType(), 0, 0, 0);
        this.maskedView.fireAttrChanged(((TupleObject)attr).getTupleType(), 0, 0, 0);
    }

    private Hashtable getIndexOfSameMember(AttrTuple attr) {
        DeclTuple type = ((TupleObject)attr).getTupleType();
        Hashtable t = new Hashtable();
        int length = type.getNumberOfEntries();
        for (int i = 0; i < length; ++i) {
            DeclMember mi = (DeclMember)type.getMemberAt(i);
            Vector<Integer> v = new Vector<Integer>(5);
            for (int j = 0; j < length; ++j) {
                DeclMember mj = (DeclMember)type.getMemberAt(j);
                if (i >= j || mi == null || mj == null || mi.getHoldingTuple() != mj.getHoldingTuple() || !mi.compareTo(mj)) continue;
                System.out.println(i + " | " + j + ":  " + mi.getHoldingTuple().hashCode() + "  ==  " + mj.getHoldingTuple().hashCode());
                v.add(new Integer(j));
            }
            if (v.isEmpty() || t.get(mi) != null) continue;
            t.put(mi, v);
        }
        return t;
    }

    public void reorderTuple(AttrTuple attr) {
        DeclTuple type = ((TupleObject)attr).getTupleType();
        this.removeFormat(type);
        this.getFormat(type);
        this.fireAttrChanged(((TupleObject)attr).getTupleType(), 0, 0, 0);
        this.maskedView.fireAttrChanged(((TupleObject)attr).getTupleType(), 0, 0, 0);
    }

    public void attributeChanged(AttrEvent event) {
        AttrTuple attr = event.getSource();
        int id = event.getID();
        int index0 = event.getIndex0();
        int index1 = event.getIndex1();
        switch (id) {
            case 10: {
                if (attr instanceof AttrType) {
                    TupleFormat form = this.getFormat(attr);
                    for (int i = index0; i <= index1; ++i) {
                        form.addMember(i);
                    }
                }
                this.propagateAttrEvent(event);
                this.maskedView.propagateAttrEvent(event);
                break;
            }
            case 20: {
                if (attr instanceof AttrType) {
                    TupleFormat form = this.getFormat(attr);
                    this.lastOpenDeletedSlot0 = this.convertIndexToSlot(attr, index0);
                    this.lastOpenDeletedSlot1 = this.convertIndexToSlot(attr, index1);
                    this.lastMaskedDeletedSlot0 = this.maskedView.convertIndexToSlot(attr, index0);
                    this.lastMaskedDeletedSlot1 = this.maskedView.convertIndexToSlot(attr, index1);
                    for (int i = index0; i <= index1; ++i) {
                        form.deleteMember(i);
                    }
                }
                this.notifyObservers(attr, id, this.lastOpenDeletedSlot0, this.lastOpenDeletedSlot1);
                this.maskedView.notifyObservers(attr, id, this.lastMaskedDeletedSlot0, this.lastMaskedDeletedSlot1);
                break;
            }
            default: {
                this.propagateAttrEvent(event);
                this.maskedView.propagateAttrEvent(event);
            }
        }
    }

    public boolean isPersistentFor(AttrTuple at) {
        return true;
    }
}

