/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.view.impl;

import agg.attribute.impl.AttrObject;
import agg.attribute.view.impl.SlotSequence;
import java.io.Serializable;

public class TupleFormat
extends AttrObject
implements Serializable {
    static final long serialVersionUID = 2585332603986553230L;
    public static final int HIDDEN = -1;
    protected SlotSequence visibleSlots = new SlotSequence();
    protected SlotSequence allSlots = new SlotSequence();
    private static transient int COUNTER = 0;

    public TupleFormat(int size) {
        for (int i = 0; i < size; ++i) {
            this.addMember(i);
        }
        ++COUNTER;
    }

    protected void finalize() {
        --COUNTER;
    }

    public void addMember(int index) {
        this.allSlots.incrementAllGreaterThan(index - 1);
        this.allSlots.addSlot(index);
        this.visibleSlots.incrementAllGreaterThan(index - 1);
        this.visibleSlots.addSlot(index);
    }

    public void deleteMember(int index) {
        this.allSlots.deleteSlotForIndex(index);
        this.allSlots.decrementAllGreaterThan(index);
        this.visibleSlots.deleteSlotForIndex(index);
        this.visibleSlots.decrementAllGreaterThan(index);
    }

    public int getVisibleSize() {
        return this.visibleSlots.getSize();
    }

    public boolean isVisible(int slot) {
        int index = this.allSlots.getIndexAt(slot);
        return this.visibleSlots.getSlotForIndex(index) != -1;
    }

    public int getIndexAtVisibleSlot(int slot) {
        return this.visibleSlots.getIndexAt(slot);
    }

    public int getIndexAtTotalSlot(int slot) {
        return this.allSlots.getIndexAt(slot);
    }

    public int getTotalSlotForIndex(int index) {
        return this.allSlots.getSlotForIndex(index);
    }

    public int getVisibleSlotForIndex(int index) {
        return this.visibleSlots.getSlotForIndex(index);
    }

    public void moveSlotInserting(int srcSlot, int destSlot) {
        this.allSlots.moveSlotInserting(srcSlot, destSlot);
        if (srcSlot < destSlot) {
            --destSlot;
        }
        if (this.isVisible(destSlot)) {
            int index = this.allSlots.getIndexAt(destSlot);
            this.visibleSlots.deleteSlotForIndex(index);
            this.insertIndexInVisible(index);
        }
    }

    protected void insertIndexInVisible(int index) {
        int visibleDestSlot;
        int totalDestSlot = this.allSlots.getSlotForIndex(index);
        for (visibleDestSlot = 0; visibleDestSlot < this.visibleSlots.getSize() && this.getTotalSlot(visibleDestSlot) < totalDestSlot; ++visibleDestSlot) {
        }
        this.visibleSlots.addSlot(index);
        this.visibleSlots.moveSlotInserting(this.visibleSlots.getSize() - 1, visibleDestSlot);
    }

    protected int getVisibleSlot(int totalSlot) {
        int index = this.allSlots.getIndexAt(totalSlot);
        return this.visibleSlots.getSlotForIndex(index);
    }

    protected int getTotalSlot(int visibleSlot) {
        int index = this.visibleSlots.getIndexAt(visibleSlot);
        return this.allSlots.getSlotForIndex(index);
    }

    public boolean setVisible(boolean v, int slot) {
        int index = this.allSlots.getIndexAt(slot);
        boolean isVisible = this.isVisible(slot);
        if (v && !isVisible) {
            this.insertIndexInVisible(index);
            return true;
        }
        if (!v && isVisible) {
            this.visibleSlots.deleteSlotForIndex(index);
            return true;
        }
        return false;
    }

    public String toString() {
        String tmp = null;
        try {
            tmp = "open: " + this.allSlots.toString() + "; mask: " + this.visibleSlots.toString();
        }
        catch (NullPointerException e) {
            tmp = "open: ???; mask: ???";
        }
        return tmp;
    }
}

