/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.view.impl;

import agg.attribute.AttrEvent;
import agg.attribute.AttrTuple;
import agg.attribute.AttrType;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.ManagedObject;
import agg.attribute.impl.TupleObject;
import agg.attribute.view.AttrViewObserver;
import agg.attribute.view.AttrViewSetting;
import agg.attribute.view.impl.TupleFormat;
import agg.attribute.view.impl.TupleViewEvent;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class ViewSetting
extends ManagedObject
implements AttrViewSetting {
    static final long serialVersionUID = -582744399860233794L;
    protected transient Hashtable observerTab = new Hashtable(200);

    public ViewSetting(AttrTupleManager m) {
        super(m);
    }

    public void dispose() {
    }

    public void finalize() {
    }

    protected abstract TupleFormat getFormat(AttrTuple var1);

    protected abstract void removeFormat(AttrType var1);

    protected Vector getObserversForTuple(AttrTuple attr) {
        if (this.observerTab == null) {
            this.observerTab = new Hashtable(200);
        }
        return (Vector)this.observerTab.get(attr);
    }

    protected void addObserverForTuple(AttrViewObserver o, AttrTuple attr) {
        Vector<WeakReference<AttrViewObserver>> observers = this.getObserversForTuple(attr);
        if (observers == null) {
            observers = new Vector<WeakReference<AttrViewObserver>>(4);
            this.observerTab.put(attr, observers);
        }
        if (!this.contains(observers, o)) {
            observers.addElement(new WeakReference<AttrViewObserver>(o));
        }
    }

    protected void removeObserverForTuple(AttrViewObserver o, AttrTuple attr) {
        Vector observers = this.getObserversForTuple(attr);
        if (observers == null) {
            return;
        }
        if (!this.contains(observers, o)) {
            this.removeElement(observers, o);
        }
    }

    private WeakReference find(Vector observers, AttrViewObserver o) {
        boolean found = false;
        WeakReference wr = null;
        Enumeration oben = observers.elements();
        while (oben.hasMoreElements() && !found) {
            wr = (WeakReference)oben.nextElement();
            AttrViewObserver ob = (AttrViewObserver)wr.get();
            if (ob == null) {
                observers.removeElement(wr);
                continue;
            }
            if (o == ob) {
                found = true;
                continue;
            }
            wr = null;
        }
        return wr;
    }

    private void removeElement(Vector observers, AttrViewObserver o) {
        WeakReference wr = this.find(observers, o);
        if (wr != null) {
            observers.removeElement(wr);
        }
    }

    private boolean contains(Vector observers, AttrViewObserver o) {
        return this.find(observers, o) != null;
    }

    protected void notifyObservers(AttrTuple attr, int id, int slot0, int slot1) {
        Vector observers = this.getObserversForTuple(attr);
        if (observers == null) {
            return;
        }
        TupleViewEvent evt = new TupleViewEvent(attr, id, slot0, slot1, this);
        Enumeration en = observers.elements();
        while (en.hasMoreElements()) {
            WeakReference wr = (WeakReference)en.nextElement();
            AttrViewObserver obs = (AttrViewObserver)wr.get();
            if (obs == null) {
                observers.removeElement(wr);
                continue;
            }
            obs.attributeChanged(evt);
        }
    }

    protected void fireAttrChanged(TupleObject attr, int id, int slot0, int slot1) {
        this.notifyObservers(attr, id, slot0, slot1);
        Enumeration objEnum = attr.getObservers();
        while (objEnum.hasMoreElements()) {
            Object obj = objEnum.nextElement();
            if (!(obj instanceof AttrTuple)) continue;
            this.fireAttrChanged((TupleObject)obj, id, slot0, slot1);
        }
    }

    protected void propagateAttrEvent(AttrEvent event) {
        AttrTuple attr = event.getSource();
        if (attr == null) {
            return;
        }
        int id = event.getID();
        int index0 = event.getIndex0();
        int index1 = event.getIndex1();
        if (id == 0) {
            this.notifyObservers(attr, id, index0, index1);
        } else {
            int slot0 = this.convertIndexToSlot(attr, event.getIndex0());
            int slot1 = this.convertIndexToSlot(attr, event.getIndex1());
            this.notifyObservers(attr, id, slot0, slot1);
        }
    }

    public void moveSlotAppending(AttrTuple attr, int srcSlot, int destSlot) {
        this.moveSlotInserting(attr, srcSlot, destSlot + 1);
    }

    public String toString(AttrTuple attr) {
        return this.getFormat(attr).toString();
    }
}

