/*
 * Decompiled with CFR 0.152.
 */
package agg.cons;

import agg.attribute.AttrConditionTuple;
import agg.attribute.AttrContext;
import agg.attribute.AttrInstanceMember;
import agg.attribute.handler.HandlerExpr;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.DeclTuple;
import agg.attribute.impl.TupleMapping;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.cons.Evaluable;
import agg.util.Debug;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Type;
import java.util.Enumeration;
import java.util.Vector;

public class AtomConstraint
extends OrdinaryMorphism
implements Evaluable,
XMLObject {
    private boolean valid;
    private int old_tick;
    private boolean old_val;
    private boolean evaluable;
    private String atomicName;
    private Vector conclusions = new Vector(1);
    private int indxOfValidConclusion;
    private MorphCompletionStrategy strategy;

    public AtomConstraint(Graph orig, Graph img, AttrContext context, String name) {
        super(orig, img, context);
        this.getOriginal().setAttrContext(this.getAttrManager().newLeftContext(context));
        this.getImage().setAttrContext(this.getAttrManager().newRightContext(context));
        this.valid = this.isValid();
        this.old_tick = -1;
        this.old_val = false;
        this.atomicName = "";
        if (name != null && !name.equals("")) {
            this.atomicName = name;
        }
        this.conclusions.addElement(this);
        this.indxOfValidConclusion = -1;
    }

    public boolean isValid() {
        this.valid = false;
        for (int j = 0; j < this.conclusions.size(); ++j) {
            AtomConstraint atom = (AtomConstraint)this.conclusions.elementAt(j);
            if (!atom.isInjective() || !atom.isTotal()) {
                return false;
            }
            Enumeration nodes = atom.getOriginal().getElements();
            while (nodes.hasMoreElements()) {
                GraphObject orig = (GraphObject)nodes.nextElement();
                ValueTuple val = (ValueTuple)orig.getAttribute();
                ValueTuple img_val = (ValueTuple)this.getImage(orig).getAttribute();
                int n = val.getNumberOfEntries();
                for (int i = 0; i < n; ++i) {
                    HandlerExpr expr2;
                    if (!val.isValueSetAt(i)) continue;
                    ValueMember value = val.getValueMemberAt(i);
                    HandlerExpr expr1 = value.getExpr();
                    if (expr1 == (expr2 = (value = img_val.getValueMemberAt(i)).getExpr())) continue;
                    if (expr1 != null && expr2 != null && !((Object)expr1).toString().equals(((Object)expr2).toString())) {
                        return false;
                    }
                    if (expr1 == null || expr1.isConstant() || expr1.isVariable()) continue;
                    return false;
                }
            }
            VarTuple vars = (VarTuple)this.getAttrContext().getVariables();
            CondTuple conds = (CondTuple)this.getAttrContext().getConditions();
            for (int i = 0; i < conds.getSize(); ++i) {
                CondMember cond = conds.getCondMemberAt(i);
                Vector condVars = cond.getAllVariables();
                if (cond.isValid()) continue;
                return false;
            }
        }
        this.valid = true;
        return true;
    }

    public boolean isEvaluable() {
        return this.evaluable;
    }

    public void setMorphismCompletionStrategy(MorphCompletionStrategy s) {
        this.strategy = s;
    }

    private void setEvaluable(OrdinaryMorphism m) {
        this.evaluable = true;
        VarTuple vars = (VarTuple)m.getAttrContext().getVariables();
        CondTuple conds = (CondTuple)m.getAttrContext().getConditions();
        for (int i = 0; i < conds.getSize(); ++i) {
            CondMember cond = conds.getCondMemberAt(i);
            if (cond.isEvaluable(vars)) continue;
            this.evaluable = false;
        }
    }

    private void setEvaluable(OrdinaryMorphism m, Graph g) {
        this.evaluable = true;
        VarTuple vars = (VarTuple)m.getAttrContext().getVariables();
        Vector varnames = g.getVariableNamesOfAttributes();
        CondTuple conds = (CondTuple)m.getAttrContext().getConditions();
        for (int i = 0; i < conds.getSize(); ++i) {
            CondMember cond = conds.getCondMemberAt(i);
            if (cond.isEvaluable(vars)) continue;
            Vector condVars = cond.getAllVariables();
            for (int j = 0; j < condVars.size(); ++j) {
                String n = (String)condVars.elementAt(j);
                VarMember var = vars.getVarMemberAt(n);
                if (var.isSet() || !varnames.contains(n)) continue;
                this.evaluable = false;
            }
        }
        Enumeration e = g.getElements();
        while (e.hasMoreElements()) {
            GraphObject o = (GraphObject)e.nextElement();
            GraphObject img = m.getImage(o);
            ValueTuple val = (ValueTuple)o.getAttribute();
            for (int i = 0; i < val.getSize(); ++i) {
                ValueTuple valImg;
                ValueMember valmImg;
                ValueMember valm = val.getValueMemberAt(i);
                if (!valm.isSet() || !valm.getExpr().isConstant() || img == null || (valmImg = (valImg = (ValueTuple)img.getAttribute()).getValueMemberAt(i)).isSet() && valmImg.getExpr().equals(valm.getExpr())) continue;
                this.evaluable = false;
            }
        }
    }

    public boolean eval(Object o) {
        return this.eval(o, -1);
    }

    public boolean eval(Object o, int tick) {
        if (tick != -1 && tick == this.old_tick) {
            return this.old_val;
        }
        this.old_tick = tick;
        this.old_val = this.eval((Graph)o);
        return this.old_val;
    }

    public boolean eval(Object o, boolean negation) {
        return this.eval(o, -1, negation);
    }

    public boolean eval(Object o, int tick, boolean negation) {
        if (tick != -1 && tick == this.old_tick) {
            return this.old_val;
        }
        this.old_tick = tick;
        this.old_val = this.eval((Graph)o, negation);
        return this.old_val;
    }

    private boolean eval(Graph g) {
        return this.eval(g, false);
    }

    private boolean eval(Graph g, boolean negation) {
        if (!this.valid) {
            return false;
        }
        Graph p = ((AtomConstraint)this.conclusions.elementAt(0)).getOriginal();
        if (!p.isEmpty() && g.isEmpty()) {
            return true;
        }
        MorphCompletionStrategy helpStrategy = (MorphCompletionStrategy)this.strategy.clone();
        MorphCompletionStrategy helpStrategy1 = (MorphCompletionStrategy)this.strategy.clone();
        this.indxOfValidConclusion = -1;
        boolean premiseFound = false;
        boolean result = true;
        BaseFactory bf = BaseFactory.theFactory();
        ((AttrTupleManager)AttrTupleManager.getDefaultManager()).setVariableContext(false);
        this.adoptEntriesWhereEmpty();
        AtomConstraint conclusion0 = (AtomConstraint)this.conclusions.elementAt(0);
        OrdinaryMorphism s = bf.createMorphism(conclusion0.getOriginal(), g, true);
        OrdinaryMorphism matchP = bf.createMatchfromMorph(s, conclusion0.getAttrContext());
        if (matchP.getImage().getVariableNamesOfAttributes().size() != 0) {
            ((ContextView)matchP.getAttrContext()).setVariableContext(true);
        }
        matchP.setCompletionStrategy(helpStrategy1);
        while (matchP.nextCompletionWithConstantsChecking()) {
            premiseFound = true;
            this.setEvaluable(matchP, matchP.getSource());
            result = false;
            boolean allConclusionsOK = false;
            for (int i = 0; i < this.conclusions.size(); ++i) {
                boolean conclusionOK = false;
                AtomConstraint atom = (AtomConstraint)this.conclusions.elementAt(i);
                OrdinaryMorphism t = matchP.completeDiagram(atom);
                if (t != null) {
                    t.setCompletionStrategy(helpStrategy);
                    if (t.getImage().getVariableNamesOfAttributes().size() != 0) {
                        ((ContextView)t.getAttrContext()).setVariableContext(true);
                    }
                    if (t.isTotal() || t.nextCompletionWithConstantsChecking()) {
                        conclusionOK = true;
                        OrdinaryMorphism t2 = matchP.completeDiagram(atom);
                        if (t2 != null) {
                            Debug.DEBUG = false;
                            OrdinaryMorphism t2match = bf.createMatchfromMorph(t2, atom.getAttrContext());
                            if (t2match != null) {
                                t2match.setCompletionStrategy(helpStrategy);
                                Debug.DEBUG = false;
                                if (t2match.getImage().getVariableNamesOfAttributes().size() != 0) {
                                    ((ContextView)t2match.getAttrContext()).setVariableContext(true);
                                }
                                if (t2match.isTotal() || t2match.nextCompletionWithConstantsChecking()) {
                                    AttrContext ac1 = t2match.getAttrContext();
                                    for (int k = 0; k < ac1.getConditions().getNumberOfEntries(); ++k) {
                                        AttrInstanceMember am = (AttrInstanceMember)ac1.getConditions().getMemberAt(k);
                                        if (!((CondMember)am).isDefinite() || ((CondMember)am).isTrue()) continue;
                                        conclusionOK = false;
                                        break;
                                    }
                                    if (conclusionOK) {
                                        this.indxOfValidConclusion = i;
                                    }
                                    this.setEvaluable(t2match, t2match.getSource());
                                } else {
                                    conclusionOK = false;
                                }
                                Debug.DEBUG = false;
                            } else {
                                conclusionOK = false;
                            }
                        } else {
                            conclusionOK = false;
                        }
                    } else {
                        conclusionOK = false;
                    }
                    BaseFactory.theFactory().destroyMorphism(t);
                    t = null;
                } else {
                    conclusionOK = false;
                }
                boolean bl = allConclusionsOK = allConclusionsOK || conclusionOK;
                if (conclusionOK && !negation) break;
            }
            if (result = allConclusionsOK) continue;
            break;
        }
        this.unsetAllTransientAttrValuesOfOverlapGrah(matchP);
        return result;
    }

    protected boolean checkType(Type orig, Type image) {
        return orig.compareTo(image);
    }

    public AtomConstraint createNextConclusion(Graph img) {
        AtomConstraint conclusion = new AtomConstraint(this.getOriginal(), img, AttrTupleManager.getDefaultManager().newContext(0), this.atomicName);
        DeclTuple declTuple = ((ValueTuple)((Object)conclusion.getAttrContext().getVariables())).getTupleType();
        Enumeration e = conclusion.getSource().getElements();
        while (e.hasMoreElements()) {
            GraphObject o = (GraphObject)e.nextElement();
            ValueTuple vt = (ValueTuple)o.getAttribute();
            for (int i = 0; i < vt.getNumberOfEntries(); ++i) {
                ValueMember vm = vt.getEntryAt(i);
                if (!vm.isSet() || !vm.getExpr().isVariable()) continue;
                String varName = vm.getExprAsText();
                String varType = vm.getDeclaration().getTypeName();
                if (declTuple.containsName(varName)) continue;
                declTuple.addMember(vm.getDeclaration().getHandler(), varType, varName);
            }
        }
        this.conclusions.addElement(conclusion);
        return conclusion;
    }

    public boolean destroyConclusion(AtomConstraint conclusion) {
        if (conclusion == (AtomConstraint)this.conclusions.elementAt(0)) {
            System.out.println("AtomConstraint.destroyConclusion:: CANNOT DESTROY THE FIRST CONCLUSION!");
            return false;
        }
        if (this.conclusions.contains(conclusion)) {
            this.conclusions.removeElement(conclusion);
            conclusion.dispose();
        }
        return true;
    }

    public Enumeration getConclusions() {
        return this.conclusions.elements();
    }

    public AtomConstraint getConclusion(int indx) {
        if (indx >= 0 && indx < this.conclusions.size()) {
            return (AtomConstraint)this.conclusions.elementAt(indx);
        }
        return null;
    }

    public AtomConstraint getValidConclusion() {
        if (this.indxOfValidConclusion >= 0 && this.indxOfValidConclusion < this.conclusions.size()) {
            return (AtomConstraint)this.conclusions.elementAt(this.indxOfValidConclusion);
        }
        return null;
    }

    public void setAtomicName(String n) {
        this.atomicName = n;
    }

    public String getAtomicName() {
        return this.atomicName;
    }

    public boolean compareTo(AtomConstraint a) {
        if (!this.atomicName.equals(a.getAtomicName())) {
            return false;
        }
        Enumeration e = a.getConclusions();
        Vector<AtomConstraint> another = new Vector<AtomConstraint>(10);
        while (e.hasMoreElements()) {
            another.add((AtomConstraint)e.nextElement());
        }
        if (this.conclusions.size() != another.size()) {
            return false;
        }
        block1: for (int i = 0; i < this.conclusions.size(); ++i) {
            AtomConstraint c = (AtomConstraint)this.conclusions.elementAt(i);
            for (int j = another.size() - 1; j >= 0; --j) {
                AtomConstraint c1 = (AtomConstraint)another.elementAt(j);
                if (!c.compareTo((OrdinaryMorphism)c1)) continue;
                another.remove(c1);
                continue block1;
            }
        }
        return another.size() == 0;
    }

    public void adoptEntriesWhereEmpty() {
        Enumeration conclusions = this.getConclusions();
        while (conclusions.hasMoreElements()) {
            AtomConstraint morph = (AtomConstraint)conclusions.nextElement();
            Enumeration e = morph.getDomain();
            while (e.hasMoreElements()) {
                GraphObject obj = (GraphObject)e.nextElement();
                GraphObject img = morph.getImage(obj);
                ContextView context = (ContextView)morph.getAttrContext();
                Vector mappings = context.getMappingsToTarget((ValueTuple)img.getAttribute());
                if (mappings == null) continue;
                ((TupleMapping)mappings.elementAt(0)).adoptEntriesWhereEmpty((ValueTuple)obj.getAttribute(), (ValueTuple)img.getAttribute());
            }
        }
    }

    private void unsetAllTransientAttrValuesOfOverlapGrah(OrdinaryMorphism m) {
        VarTuple vars = (VarTuple)m.getAttrContext().getVariables();
        Enumeration e1 = m.getImage().getElements();
        while (e1.hasMoreElements()) {
            GraphObject obj = (GraphObject)e1.nextElement();
            ValueTuple value = (ValueTuple)obj.getAttribute();
            for (int i = 0; i < value.getNumberOfEntries(); ++i) {
                ValueMember valuem = value.getValueMemberAt(i);
                if (valuem.getExpr() == null || !valuem.getExpr().isVariable() || !valuem.isTransient()) continue;
                valuem.setExpr(null);
            }
        }
    }

    public void XwriteObject(XMLHelper h) {
        h.openNewElem("Graphconstraint_Atomic", this);
        h.addAttr("name", this.getAtomicName());
        if (this.conclusions.size() > 0) {
            h.openSubTag("Premise");
            AtomConstraint atom = (AtomConstraint)this.conclusions.elementAt(0);
            h.addObjectSub(atom.getOriginal());
            h.close();
            for (int i = 0; i < this.conclusions.size(); ++i) {
                h.openSubTag("Conclusion");
                atom = (AtomConstraint)this.conclusions.elementAt(i);
                h.addObjectSub(atom.getImage());
                atom.writeMorphism(h);
                AttrConditionTuple condt = this.getAttrContext().getConditions();
                int num = condt.getNumberOfEntries();
                if (num > 0) {
                    h.openSubTag("AttrCondition");
                    h.addObject("", condt, true);
                    h.close();
                }
                h.close();
            }
        }
        h.close();
    }

    public void XreadObject(XMLHelper h) {
        if (h.isTag("Graphconstraint_Atomic", this)) {
            this.setAtomicName(h.readAttr("name"));
            if (h.readSubTag("Premise")) {
                Graph orig = (Graph)h.getObject("", this.getSource(), true);
                h.close();
                int i = -1;
                Enumeration en = h.getEnumeration("", null, true, "Conclusion");
                while (en.hasMoreElements()) {
                    h.peekElement(en.nextElement());
                    if (++i == 0) {
                        h.getObject("", this.getTarget(), true);
                        this.readMorphism(h);
                        if (h.readSubTag("AttrCondition")) {
                            AttrConditionTuple condt = this.getAttrContext().getConditions();
                            if (condt != null) {
                                h.enrichObject(condt);
                            }
                            h.close();
                        }
                    } else if (i > 0) {
                        Graph image = new Graph(this.getSource().getTypeSet());
                        image = (Graph)h.getObject("", image, true);
                        AtomConstraint atom = this.createNextConclusion(image);
                        atom.readMorphism(h);
                        if (h.readSubTag("AttrCondition")) {
                            AttrConditionTuple condt = this.getAttrContext().getConditions();
                            if (condt != null) {
                                h.enrichObject(condt);
                            }
                            h.close();
                        }
                    }
                    h.close();
                }
            } else {
                h.getObject("", this.getSource(), true);
                h.getObject("", this.getTarget(), true);
                this.readMorphism(h);
            }
            h.close();
        }
    }

    private void showMappedObjects(OrdinaryMorphism m) {
        Enumeration e = m.getDomain();
        while (e.hasMoreElements()) {
            GraphObject obj = (GraphObject)e.nextElement();
            GraphObject img = m.getImage(obj);
            System.out.println(obj + "  -->  " + img);
        }
    }
}

