/*
 * Decompiled with CFR 0.152.
 */
package agg.cons;

import agg.cons.Formula;
import com.objectspace.jgl.HashSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ConstraintLayer {
    private Hashtable constraintLayer;
    private Enumeration constraints;
    private Vector constraintsVec;

    public ConstraintLayer(Enumeration constraints) {
        this.constraints = constraints;
        this.constraintsVec = new Vector(0);
        while (constraints.hasMoreElements()) {
            this.constraintsVec.addElement(constraints.nextElement());
        }
        this.initConstraintLayer();
    }

    public ConstraintLayer(Vector constraints) {
        this.constraintsVec = constraints;
        this.constraints = this.constraintsVec.elements();
        this.initConstraintLayer();
    }

    public void addLayer(Formula constraint, int layer) {
        constraint.addLayer(layer);
        this.constraintLayer.put(constraint, constraint.getLayer());
    }

    private void initConstraintLayer() {
        this.constraintLayer = new Hashtable();
        for (int i = 0; i < this.constraintsVec.size(); ++i) {
            Object constraint = this.constraintsVec.elementAt(i);
            if (constraint instanceof Formula) {
                Vector layer = ((Formula)constraint).getLayer();
                if (layer == null) continue;
                this.constraintLayer.put(constraint, layer);
                continue;
            }
            if (!(constraint instanceof String)) continue;
            this.constraintLayer.put(constraint, new Integer(0));
        }
    }

    public Hashtable getConstraintLayer() {
        return this.constraintLayer;
    }

    public Integer getStartLayer() {
        int startLayer = Integer.MAX_VALUE;
        Integer result = null;
        Enumeration keys = this.getConstraintLayer().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Vector layer = (Vector)this.getConstraintLayer().get(key);
            if (layer == null) continue;
            if (layer.isEmpty()) {
                startLayer = 0;
                result = new Integer(0);
                continue;
            }
            Integer l = (Integer)layer.get(0);
            if (l >= startLayer) continue;
            startLayer = l;
            result = l;
        }
        return result;
    }

    public Hashtable invertLayer() {
        Hashtable<Integer, HashSet> inverted = new Hashtable<Integer, HashSet>();
        Enumeration keys = this.constraintLayer.keys();
        while (keys.hasMoreElements()) {
            HashSet invertedValue;
            Object key = keys.nextElement();
            Vector layer = (Vector)this.constraintLayer.get(key);
            if (layer == null) continue;
            Integer l = new Integer(0);
            if (!layer.isEmpty()) {
                l = (Integer)layer.get(0);
            }
            if ((invertedValue = (HashSet)inverted.get(l)) == null) {
                invertedValue = new HashSet();
                invertedValue.add(key);
                inverted.put(l, invertedValue);
                continue;
            }
            invertedValue.add(key);
        }
        return inverted;
    }

    public String toString() {
        String resultString = "Formula:\t\tLayer:\n";
        Enumeration keys = this.constraintLayer.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            resultString = resultString + ((Formula)key).getName() + "\t\t";
            Vector valueVec = (Vector)this.constraintLayer.get(key);
            for (int i = 0; i < valueVec.size(); ++i) {
                Integer value = (Integer)valueVec.get(i);
                resultString = resultString + value.toString() + "  ";
            }
            resultString = resultString + "\n";
        }
        return resultString;
    }
}

