/*
 * Decompiled with CFR 0.152.
 */
package agg.cons;

import agg.attribute.AttrContext;
import agg.attribute.AttrInstanceMember;
import agg.attribute.handler.AttrHandlerException;
import agg.attribute.handler.HandlerExpr;
import agg.attribute.handler.HandlerType;
import agg.attribute.handler.SymbolTable;
import agg.attribute.handler.impl.javaExpr.JexExpr;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.TupleMapping;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.attribute.parser.javaExpr.ASTExpression;
import agg.attribute.parser.javaExpr.ASTPrimaryExpression;
import agg.attribute.parser.javaExpr.SimpleNode;
import agg.cons.AtomApplCond;
import agg.cons.AtomConstraint;
import agg.cons.EvalSet;
import agg.util.Debug;
import agg.xt_basis.Arc;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.TypeException;
import com.objectspace.jgl.Pair;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

public class Convert {
    private Rule rule;
    private AtomConstraint atom;

    public Convert(Rule r, AtomConstraint a) {
        this.rule = r;
        this.atom = a;
    }

    public Pair pushout(OrdinaryMorphism r, OrdinaryMorphism m) {
        OrdinaryMorphism morph;
        int k;
        Link l;
        BaseFactory bf = BaseFactory.theFactory();
        Graph P = r.getOriginal();
        if (P != m.getOriginal()) {
            System.err.println("Argh!  Convert.pushout() called with morphisms from different sources");
            return null;
        }
        Graph G3 = bf.createGraph(r.getImage().getTypeSet());
        G3.setName(r.getName());
        OrdinaryMorphism p1 = bf.createMorphism(m.getImage(), G3);
        p1.setName("p1_morphism");
        OrdinaryMorphism p2 = bf.createMorphism(r.getImage(), G3);
        p2.setName("p2_morphism");
        HashMap hash = new HashMap();
        Enumeration en = P.getElements();
        while (en.hasMoreElements()) {
            hash.put(en.nextElement(), new Link());
        }
        en = r.getImage().getElements();
        while (en.hasMoreElements()) {
            hash.put(en.nextElement(), new Link());
        }
        en = m.getImage().getElements();
        while (en.hasMoreElements()) {
            hash.put(en.nextElement(), new Link());
        }
        Link empty = new Link();
        hash.put(null, empty);
        en = P.getElements();
        while (en.hasMoreElements()) {
            GraphObject go = (GraphObject)en.nextElement();
            GraphObject img1 = r.getImage(go);
            GraphObject img2 = m.getImage(go);
            if (img2 == null) {
                System.err.println("Argh!  Convert.pushout() FAILED! (m match is corrupt)");
                return null;
            }
            l = (Link)hash.get(go);
            l.link((Link)hash.get(img1)).link((Link)hash.get(img2));
            if (img1 != null || !go.isNode()) continue;
            Node n = (Node)go;
            Enumeration arcs = n.getIncomingArcs();
            while (arcs.hasMoreElements()) {
                empty.link((Link)hash.get(arcs.nextElement()));
            }
            arcs = n.getOutgoingArcs();
            while (arcs.hasMoreElements()) {
                empty.link((Link)hash.get(arcs.nextElement()));
            }
        }
        empty = empty.find();
        for (k = 0; k < 2; ++k) {
            morph = k == 0 ? p1 : p2;
            en = morph.getOriginal().getNodes();
            while (en.hasMoreElements()) {
                Node n = (Node)en.nextElement();
                l = ((Link)hash.get(n)).find();
                if (l == empty) continue;
                Node n2 = (Node)l.get();
                if (n2 == null) {
                    try {
                        n2 = G3.createNode(n);
                        n2.setContextUsage(n.getContextUsage());
                        if (this.checkAttributeValue(n, n2)) {
                            morph.addMapping(n, n2);
                            if (morph.getImage(n) != n2) {
                                // empty if block
                            }
                        }
                        l.set(n2);
                        continue;
                    }
                    catch (TypeException ex) {
                        return null;
                    }
                }
                if (!this.checkAttributeValue(n, n2)) continue;
                morph.addMapping(n, n2);
                if (morph.getImage(n) == n2) continue;
            }
        }
        for (k = 0; k < 2; ++k) {
            morph = k == 0 ? p1 : p2;
            en = morph.getOriginal().getArcs();
            while (en.hasMoreElements()) {
                Arc a = (Arc)en.nextElement();
                l = ((Link)hash.get(a)).find();
                if (l == empty) continue;
                Arc a2 = (Arc)l.get();
                if (a2 == null) {
                    GraphObject src = morph.getImage(a.getSource());
                    GraphObject tgt = morph.getImage(a.getTarget());
                    if (src == null || tgt == null) continue;
                    try {
                        a2 = G3.createArc(a, (Node)src, (Node)tgt);
                        a2.setContextUsage(a.getContextUsage());
                        if (this.checkAttributeValue(a, a2)) {
                            morph.addMapping(a, a2);
                            if (morph.getImage(a) != a2) {
                                // empty if block
                            }
                        }
                        l.set(a2);
                        continue;
                    }
                    catch (TypeException e) {
                        return null;
                    }
                }
                if (!this.checkAttributeValue(a, a2)) continue;
                morph.addMapping(a, a2);
                if (morph.getImage(a) == a2) continue;
            }
        }
        en = G3.getElements();
        AttrContext ac = m.getAttrContext();
        for (int i = 0; i < ac.getVariables().getNumberOfEntries(); ++i) {
            AttrInstanceMember am = (AttrInstanceMember)ac.getVariables().getMemberAt(i);
        }
        while (en.hasMoreElements()) {
            GraphObject inv;
            GraphObject o = (GraphObject)en.nextElement();
            Enumeration inv_p1 = p1.getInverseImage(o);
            Enumeration inv_p2 = p2.getInverseImage(o);
            if (!inv_p2.hasMoreElements()) {
                inv = (GraphObject)inv_p1.nextElement();
                o.getAttribute().copyEntries(inv.getAttribute());
                continue;
            }
            inv = (GraphObject)inv_p2.nextElement();
            ((ValueTuple)o.getAttribute()).apply(inv.getAttribute(), ac, true);
        }
        return new Pair(p1, p2);
    }

    public Vector convert() {
        BaseFactory bf = BaseFactory.theFactory();
        Vector<EvalSet> ret = new Vector<EvalSet>();
        if (!this.atom.isValid()) {
            return ret;
        }
        this.atom.adoptEntriesWhereEmpty();
        this.renameVariables(this.rule, this.atom);
        Graph R = this.rule.getRight();
        Graph P = this.atom.getOriginal();
        boolean leftgraph = true;
        boolean disjunion = true;
        Enumeration all_s = null;
        all_s = this.atom.getOverlappings(R, leftgraph, disjunion);
        Debug.PARSING = false;
        while (all_s.hasMoreElements()) {
            ValueMember mimg;
            ValueMember m;
            int i;
            ValueTuple valimg;
            ValueTuple val;
            GraphObject img;
            GraphObject o;
            Pair morphs = (Pair)all_s.nextElement();
            OrdinaryMorphism p = (OrdinaryMorphism)morphs.first;
            OrdinaryMorphism s = (OrdinaryMorphism)morphs.second;
            if (!p.isInjective()) continue;
            Enumeration e = p.getDomain();
            while (e.hasMoreElements()) {
                o = (GraphObject)e.nextElement();
                img = p.getImage(o);
                val = (ValueTuple)o.getAttribute();
                valimg = (ValueTuple)img.getAttribute();
                for (i = 0; i < val.getSize(); ++i) {
                    m = val.getValueMemberAt(i);
                    mimg = valimg.getValueMemberAt(i);
                    if (mimg.getExpr() == null || !mimg.getExpr().isComplex()) continue;
                    if (m.getExpr() != null) {
                        if (m.getExpr().isVariable() || m.getExpr().isConstant()) {
                            mimg.setExprAsText(m.getExprAsText());
                            continue;
                        }
                        if (!m.getExpr().isComplex()) continue;
                        mimg.setExpr(null);
                        continue;
                    }
                    mimg.setExpr(null);
                }
            }
            e = s.getDomain();
            while (e.hasMoreElements()) {
                o = (GraphObject)e.nextElement();
                img = s.getImage(o);
                val = (ValueTuple)o.getAttribute();
                valimg = (ValueTuple)img.getAttribute();
                for (i = 0; i < val.getSize(); ++i) {
                    m = val.getValueMemberAt(i);
                    mimg = valimg.getValueMemberAt(i);
                    if (mimg.getExpr() == null || !mimg.getExpr().isComplex()) continue;
                    if (m.getExpr() != null) {
                        if (m.getExpr().isVariable() || m.getExpr().isConstant()) {
                            mimg.setExprAsText(m.getExprAsText());
                            continue;
                        }
                        if (!m.getExpr().isComplex()) continue;
                        mimg.setExpr(null);
                        continue;
                    }
                    mimg.setExpr(null);
                }
            }
            OrdinaryMorphism pmatch = bf.createMorphfromMorph(p, this.atom.getAttrContext());
            if (pmatch == null) continue;
            AttrContext ac = pmatch.getAttrContext();
            Vector<AtomApplCond> v = new Vector<AtomApplCond>();
            EvalSet set = null;
            Enumeration conclusions = this.atom.getConclusions();
            while (conclusions.hasMoreElements()) {
                AtomConstraint conclusion = (AtomConstraint)conclusions.nextElement();
                this.adoptEntriesWhereEmpty(pmatch);
                Pair po = this.pushout(conclusion, pmatch);
                if (po == null) continue;
                OrdinaryMorphism t = (OrdinaryMorphism)po.first;
                OrdinaryMorphism q = (OrdinaryMorphism)po.second;
                if (!t.isTotal() || !q.isTotal()) continue;
                t.setAttrContext(conclusion.getAttrContext());
                this.adoptEntriesWhereEmpty(t);
                v.add(new AtomApplCond(conclusion, s, t, q));
            }
            set = new EvalSet(v);
            if (set == null) continue;
            ret.add(set);
        }
        return ret;
    }

    private boolean checkAttributeValue(GraphObject from, GraphObject to) {
        ValueTuple valueFrom = (ValueTuple)from.getAttribute();
        ValueTuple valueTo = (ValueTuple)to.getAttribute();
        for (int i = 0; i < valueFrom.getSize(); ++i) {
            ValueMember mFrom = valueFrom.getValueMemberAt(i);
            ValueMember mTo = valueTo.getValueMemberAt(i);
            if (!mFrom.isSet() || !mTo.isSet() || !mFrom.getExpr().isConstant() && !mTo.getExpr().isConstant() || mFrom.getExprAsText().equals(mTo.getExprAsText())) continue;
            return false;
        }
        return true;
    }

    private void adoptEntriesWhereEmpty(OrdinaryMorphism morph) {
        Enumeration e = morph.getDomain();
        while (e.hasMoreElements()) {
            GraphObject obj = (GraphObject)e.nextElement();
            GraphObject img = morph.getImage(obj);
            ContextView context = (ContextView)morph.getAttrContext();
            Vector mappings = context.getMappingsToTarget((ValueTuple)img.getAttribute());
            if (mappings == null) continue;
            ((TupleMapping)mappings.elementAt(0)).adoptEntriesWhereEmpty((ValueTuple)obj.getAttribute(), (ValueTuple)img.getAttribute());
        }
    }

    private void renameVariables(Rule r, AtomConstraint atomic) {
        Rule m1 = r;
        Enumeration conclusions = atomic.getConclusions();
        if (conclusions.hasMoreElements()) {
            AtomConstraint m2 = (AtomConstraint)conclusions.nextElement();
            int index = 1;
            String mark = String.valueOf(index);
            VarTuple varsm1 = (VarTuple)m1.getAttrContext().getVariables();
            VarTuple varsm2 = (VarTuple)m2.getAttrContext().getVariables();
            for (int i = 0; i < varsm1.getSize(); ++i) {
                VarMember vm1 = varsm1.getVarMemberAt(i);
                VarMember vm2 = varsm2.getVarMemberAt(vm1.getName());
                if (vm2 == null || !vm1.getDeclaration().getTypeName().equals(vm2.getDeclaration().getTypeName())) continue;
                String from = vm2.getName();
                String to = vm2.getName() + mark;
                while (varsm2.getVarMemberAt(to) != null) {
                    mark = String.valueOf(index++);
                    to = vm2.getName() + mark;
                }
                vm2.getDeclaration().setName(to);
                this.setAttributeVariable(m2.getSource(), from, to, varsm2);
                this.setAttributeVariable(m2.getTarget(), from, to, varsm2);
                CondTuple conds = (CondTuple)m2.getAttrContext().getConditions();
                this.renameVariableInCondition(conds, from, to);
                while (conclusions.hasMoreElements()) {
                    AtomConstraint mc = (AtomConstraint)conclusions.nextElement();
                    VarTuple varsmc = (VarTuple)mc.getAttrContext().getVariables();
                    this.setAttributeVariable(mc.getTarget(), from, to, varsmc);
                    conds = (CondTuple)mc.getAttrContext().getConditions();
                    this.renameVariableInCondition(conds, from, to);
                }
            }
        }
    }

    private void renameVariableInCondition(CondTuple conds, String from, String to) {
        for (int j = 0; j < conds.getSize(); ++j) {
            CondMember cm = conds.getCondMemberAt(j);
            String condStr = cm.getExprAsText();
            Vector v1 = cm.getAllVariables();
            if (!v1.contains(from)) continue;
            JexExpr oldExpr = (JexExpr)cm.getExpr();
            Vector variables = new Vector();
            oldExpr.getAllVariables(variables);
            this.findPrimaryAndReplace((SimpleNode)oldExpr.getAST(), from, to, null);
        }
    }

    private void setAttributeVariable(Graph g, String from, String to, VarTuple vars) {
        Enumeration e = g.getElements();
        while (e.hasMoreElements()) {
            GraphObject obj = (GraphObject)e.nextElement();
            ValueTuple fromObj = (ValueTuple)obj.getAttribute();
            for (int i = 0; i < fromObj.getSize(); ++i) {
                ValueMember fromVM = fromObj.getValueMemberAt(i);
                if (!fromVM.isSet()) continue;
                if (fromVM.getExpr().isVariable()) {
                    if (!fromVM.getExprAsText().equals(from) || vars.getVarMemberAt(to) == null) continue;
                    fromVM.setExprAsText(to);
                    continue;
                }
                if (!fromVM.getExpr().isComplex()) continue;
                VarMember toVM = vars.getVarMemberAt(to);
                JexExpr oldExpr = (JexExpr)fromVM.getExpr();
                Vector variables = new Vector();
                oldExpr.getAllVariables(variables);
                this.findPrimaryAndReplace((SimpleNode)oldExpr.getAST(), from, to, vars);
            }
        }
    }

    private void findPrimaryAndReplace(SimpleNode node, String from, String to, VarTuple vars) {
        for (int j = 0; j < node.jjtGetNumChildren(); ++j) {
            SimpleNode n = (SimpleNode)node.jjtGetChild(j);
            if (n instanceof ASTPrimaryExpression) {
                SimpleNode test;
                HandlerExpr expression;
                HandlerType t;
                VarMember vm;
                int i;
                for (int j1 = 0; j1 < n.jjtGetNumChildren(); ++j1) {
                    SimpleNode n1 = (SimpleNode)n.jjtGetChild(j1);
                    if (!(n1 instanceof ASTExpression)) continue;
                    this.findPrimaryAndReplace(n1, from, to, vars);
                }
                String ident = ((ASTPrimaryExpression)n).getIdentifier();
                if (!n.getString().equals(from)) continue;
                SymbolTable symbs = SimpleNode.getSymbolTable();
                boolean to_found = false;
                ContextView context = (ContextView)symbs;
                VarTuple vt = (VarTuple)context.getVariables();
                for (i = 0; i < vt.getSize(); ++i) {
                    vm = vt.getVarMemberAt(i);
                    if (!vm.getName().equals(to)) continue;
                    to_found = true;
                    t = vm.getDeclaration().getType();
                    try {
                        expression = vm.getHandler().newHandlerExpr(t, to);
                        test = (SimpleNode)expression.getAST().jjtGetChild(0);
                        node.replaceChildWith(n, test);
                        continue;
                    }
                    catch (AttrHandlerException ex) {
                        // empty catch block
                    }
                }
                if (to_found || vars == null) continue;
                for (i = 0; i < vars.getSize(); ++i) {
                    vm = vars.getVarMemberAt(i);
                    if (!vm.getName().equals(to)) continue;
                    to_found = true;
                    t = vm.getDeclaration().getType();
                    try {
                        expression = vm.getHandler().newHandlerExpr(t, to);
                        test = (SimpleNode)expression.getAST().jjtGetChild(0);
                        node.replaceChildWith(n, test);
                        continue;
                    }
                    catch (AttrHandlerException ex) {
                        // empty catch block
                    }
                }
                if (to_found) continue;
                System.out.println("Something wrong again:  " + to + "  NOT FOUND! CANNOT replace.");
                continue;
            }
            this.findPrimaryAndReplace(n, from, to, vars);
        }
    }

    class Link {
        private Link up = null;
        private GraphObject o = null;

        public Link find() {
            Link l = this;
            while (l.up != null) {
                l = l.up;
            }
            Link m = this;
            while (m.up != null) {
                Link n = m.up;
                m.up = l;
                m = n;
            }
            return l;
        }

        public Link link(Link other) {
            Link pt;
            Link po = other.find();
            po.up = pt = this.find();
            return pt;
        }

        public GraphObject get() {
            return this.find().o;
        }

        public void set(GraphObject go) {
            this.find().o = go;
        }
    }
}

