/*
 * Decompiled with CFR 0.152.
 */
package agg.cons;

import agg.cons.AtomConstraint;
import agg.cons.Evaluable;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import java.io.Serializable;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.Vector;

public class Formula
implements Evaluable,
XMLObject,
Serializable {
    public static final int NOP = 0;
    public static final int TRUE = 1;
    public static final int FALSE = 2;
    public static final int NOT = 3;
    public static final int AND = 4;
    public static final int OR = 5;
    public static final int UNDEF = 6;
    private Evaluable sub1;
    private Evaluable sub2;
    private int op;
    private int running_tick;
    private String name;
    private boolean evaluable = true;
    private Vector layer = new Vector(5);

    private void init(int _op, Evaluable e1, Evaluable e2) {
        this.op = _op;
        this.sub1 = e1;
        this.sub2 = e2;
    }

    public Formula(boolean v) {
        this.init(v ? 1 : 2, null, null);
        this.running_tick = 0;
        this.name = "Formula";
        this.evaluable = true;
    }

    public Formula(Vector vars, String s) {
        this.setFormula(vars, s);
        this.running_tick = 0;
        this.name = "Formula";
        this.evaluable = true;
    }

    public Formula(Vector vars, int op) {
        this.running_tick = 0;
        if (op != 4 && op != 5) {
            this.init(6, null, null);
            return;
        }
        if (vars.isEmpty()) {
            this.init(1, null, null);
        } else {
            String s = "1";
            for (int i = 1; i < vars.size(); ++i) {
                s = s + (op == 4 ? " && " : " || ");
                s = s + Integer.toString(i + 1);
            }
            this.setFormula(vars, s);
        }
        this.name = "Formula";
        this.evaluable = true;
    }

    public void setName(String str) {
        this.name = str;
    }

    public String getName() {
        return this.name;
    }

    public void setFormula(Vector vars, String s) {
        Formula that = this.get_multiple(vars, new StringCharacterIterator(s));
        if (that != null) {
            this.init(that.op, that.sub1, that.sub2);
        } else {
            this.init(6, null, null);
        }
    }

    public String getAsString(Vector v) {
        HashMap m = new HashMap();
        Vector names = new Vector();
        for (int i = 0; i < v.size(); ++i) {
            if (v.get(i) instanceof Evaluable) {
                m.put(v.get(i), Integer.toString(i + 1, 10));
                continue;
            }
            System.err.println("Formula.getAsString: got a non-Evaluable; index=" + i);
        }
        return this.getAsString(v, m);
    }

    public String getAsString(Vector v, Vector names) {
        HashMap m = new HashMap();
        if (names.size() != v.size()) {
            System.err.println("Formula.getAsString: bad names vector");
            return this.getAsString(v);
        }
        for (int i = 0; i < v.size(); ++i) {
            if (v.get(i) instanceof Evaluable) {
                m.put(v.get(i), names.get(i));
                continue;
            }
            System.err.println("Formula.getAsString: got a non-Evaluable; index=" + i);
        }
        return this.getAsString(v, m);
    }

    public boolean compareTo(Formula f) {
        String form1;
        if (!this.getName().equals(f.getName())) {
            return false;
        }
        Vector vec = new Vector();
        String form = this.getAsString(vec);
        return form.equals(form1 = f.getAsString(vec));
    }

    private boolean isValid(Evaluable e) {
        if (e == null) {
            return false;
        }
        if (!(e instanceof Formula)) {
            return true;
        }
        return ((Formula)e).isValid();
    }

    public boolean isValid() {
        this.evaluable = true;
        switch (this.op) {
            case 6: {
                return false;
            }
            case 1: 
            case 2: {
                return true;
            }
            case 0: 
            case 3: {
                return this.isValid(this.sub1);
            }
            case 4: 
            case 5: {
                return this.isValid(this.sub1) && this.isValid(this.sub2);
            }
        }
        return false;
    }

    private void setEvaluable(Evaluable e) {
        if (e instanceof AtomConstraint) {
            this.evaluable = this.evaluable && ((AtomConstraint)e).isEvaluable();
        } else if (e instanceof Formula) {
            this.evaluable = this.evaluable && ((Formula)e).isEvaluable();
        }
    }

    public boolean isEvaluable() {
        return this.evaluable;
    }

    public boolean eval(Object o) {
        return this.eval(o, -1);
    }

    public boolean eval(Object o, int tick) {
        if (tick == -1) {
            if (this.running_tick < 0) {
                this.running_tick = 0;
            }
            tick = this.running_tick++;
        }
        switch (this.op) {
            case 0: {
                if (this.sub1 != null) {
                    boolean result = this.sub1.eval(o, tick);
                    this.setEvaluable(this.sub1);
                    return result;
                }
                return false;
            }
            case 3: {
                if (this.sub1 != null) {
                    boolean result = !this.sub1.eval(o, tick, true);
                    this.setEvaluable(this.sub1);
                    return result;
                }
                return false;
            }
            case 4: {
                if (this.sub1 != null && this.sub2 != null) {
                    boolean result = this.sub1.eval(o, tick) && this.sub2.eval(o, tick);
                    this.setEvaluable(this.sub1);
                    this.setEvaluable(this.sub2);
                    return result;
                }
                return false;
            }
            case 5: {
                boolean result;
                if (this.sub1 != null) {
                    result = this.sub1.eval(o, tick);
                    this.setEvaluable(this.sub1);
                    if (result) {
                        return result;
                    }
                }
                if (this.sub2 != null) {
                    result = this.sub2.eval(o, tick);
                    this.setEvaluable(this.sub2);
                    if (result) {
                        return result;
                    }
                }
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    public boolean eval(Object o, boolean negation) {
        return this.eval(o, -1, negation);
    }

    public boolean eval(Object o, int tick, boolean negation) {
        if (tick == -1) {
            if (this.running_tick < 0) {
                this.running_tick = 0;
            }
            tick = this.running_tick++;
        }
        switch (this.op) {
            case 0: {
                if (this.sub1 != null) {
                    boolean result = this.sub1.eval(o, tick, negation);
                    this.setEvaluable(this.sub1);
                    return result;
                }
                return false;
            }
            case 3: {
                if (this.sub1 != null) {
                    boolean result = !this.sub1.eval(o, tick, true);
                    this.setEvaluable(this.sub1);
                    return result;
                }
                return false;
            }
            case 4: {
                if (this.sub1 != null && this.sub2 != null) {
                    boolean result = this.sub1.eval(o, tick, false) && this.sub2.eval(o, tick, false);
                    this.setEvaluable(this.sub1);
                    this.setEvaluable(this.sub2);
                    return result;
                }
                return false;
            }
            case 5: {
                boolean result;
                if (this.sub1 != null) {
                    result = this.sub1.eval(o, tick, false);
                    this.setEvaluable(this.sub1);
                    if (result) {
                        return result;
                    }
                }
                if (this.sub2 != null) {
                    result = this.sub2.eval(o, tick, false);
                    this.setEvaluable(this.sub2);
                    if (result) {
                        return result;
                    }
                }
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void patchOutEvaluable(Evaluable e, boolean subst) {
        switch (this.op) {
            case 4: 
            case 5: {
                if (this.sub2 != e) ** GOTO lbl6
                this.sub2 = new Formula(subst);
                ** GOTO lbl8
lbl6:
                // 1 sources

                if (this.sub2 != null && this.sub2 instanceof Formula) {
                    ((Formula)this.sub2).patchOutEvaluable(e, subst);
                }
            }
lbl8:
            // 5 sources

            case 0: 
            case 3: {
                if (this.sub1 == e) {
                    this.sub1 = new Formula(subst);
                    break;
                }
                if (this.sub1 == null || !(this.sub1 instanceof Formula)) break;
                ((Formula)this.sub1).patchOutEvaluable(e, subst);
            }
        }
    }

    private Formula(int _op, Evaluable e1, Evaluable e2) {
        this.init(_op, e1, e2);
    }

    private String getAsString(Vector v, HashMap map) {
        switch (this.op) {
            case 6: {
                return "";
            }
            case 3: {
                return "!" + ((Formula)this.sub1).getAsString(v, map);
            }
            case 2: {
                return "false";
            }
            case 1: {
                return "true";
            }
            case 4: 
            case 5: {
                String s1 = ((Formula)this.sub1).getAsString(v, map);
                String s2 = ((Formula)this.sub2).getAsString(v, map);
                return "(" + s1 + (this.op == 4 ? " && " : " || ") + s2 + ")";
            }
            case 0: {
                String name;
                if (this.sub1 instanceof Formula) {
                    return "(" + ((Formula)this.sub1).getAsString(v, map) + ")";
                }
                if (!map.containsKey(this.sub1)) {
                    int i = v.size();
                    v.add(this.sub1);
                    name = Integer.toString(i + 1, 10);
                    map.put(this.sub1, name);
                } else {
                    name = (String)map.get(this.sub1);
                }
                return name;
            }
        }
        return "";
    }

    private void skipWS(StringCharacterIterator i) {
        char c = i.current();
        while (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
            c = i.next();
        }
    }

    private Formula get_multiple(Vector vars, StringCharacterIterator i) {
        char c;
        Formula ret = this.get_one(vars, i);
        while (ret != null && (c = i.current()) != '\uffff') {
            if (c == '&' || c == '|') {
                while (i.current() == c) {
                    i.next();
                }
                Formula f2 = this.get_one(vars, i);
                if (f2 == null) {
                    ret = null;
                    continue;
                }
                ret = new Formula(c == '&' ? 4 : 5, ret, f2);
                continue;
            }
            if (c == ')') break;
            ret = null;
        }
        return ret;
    }

    private Formula get_one(Vector vars, StringCharacterIterator i) {
        this.skipWS(i);
        char c = i.current();
        if (c == '(') {
            c = i.next();
            if (c == '\uffff') {
                return null;
            }
            Formula f = this.get_multiple(vars, i);
            if (i.current() != ')') {
                f = null;
            } else {
                c = i.next();
            }
            this.skipWS(i);
            return f;
        }
        if (c == '!') {
            c = i.next();
            Formula f = this.get_one(vars, i);
            if (f == null) {
                return null;
            }
            return new Formula(3, f, null);
        }
        if (c >= '0' && c <= '9') {
            int v = 0;
            while (c >= '0' && c <= '9') {
                v = v * 10 + (c - 48);
                c = i.next();
            }
            this.skipWS(i);
            if (--v < 0 || v >= vars.size()) {
                return null;
            }
            return new Formula(0, (Evaluable)vars.get(v), null);
        }
        if (c == 'f' || c == 't') {
            while (i.current() >= 'a' && i.current() <= 'z') {
                i.next();
            }
            this.skipWS(i);
            return new Formula(c == 't');
        }
        return null;
    }

    public int getOperation() {
        return this.op;
    }

    public boolean isNOT(Evaluable var, Vector vars) {
        boolean b = false;
        switch (this.op) {
            case 6: {
                return false;
            }
            case 2: {
                return false;
            }
            case 1: {
                return false;
            }
            case 3: {
                b = ((Formula)this.sub1).isNOT(var, vars);
                return b;
            }
            case 4: 
            case 5: {
                b = ((Formula)this.sub1).isNOT(var, vars);
                if (!b) {
                    b = ((Formula)this.sub2).isNOT(var, vars);
                }
                return b;
            }
            case 0: {
                if (this.sub1 instanceof Formula) {
                    b = ((Formula)this.sub1).isNOT(var, vars);
                } else if (vars.contains(this.sub1) && this.sub1 == var) {
                    b = true;
                }
                return b;
            }
        }
        return b;
    }

    public Vector getLayer() {
        return this.layer;
    }

    public String getLayerAsString() {
        String str = "";
        for (int k = 0; k < this.layer.size(); ++k) {
            int l = (Integer)this.layer.get(k);
            str = str + String.valueOf(l);
            if (k >= this.layer.size() - 1) continue;
            str = str + ",";
        }
        return str;
    }

    public void addLayer(int l) {
        boolean added = false;
        for (int i = 0; i < this.layer.size(); ++i) {
            if (l > (Integer)this.layer.get(i)) continue;
            this.layer.add(i, new Integer(l));
            added = true;
            break;
        }
        if (!added) {
            this.layer.add(new Integer(l));
        }
    }

    public void setLayer(Vector l) {
        this.layer = l;
    }

    public void XreadObject(XMLHelper h) {
        if (h.isTag("Formula", this)) {
            if (this.layer == null) {
                this.layer = new Vector(5);
            }
            if (h.readSubTag("Layer")) {
                String size = h.readAttr("Size");
                int nn = new Integer(size);
                for (int i = 0; i < nn; ++i) {
                    String l = h.readAttr("Layer");
                    this.layer.add(new Integer(l));
                    ++i;
                }
                h.close();
            }
            h.close();
        }
    }

    public void XwriteObject(XMLHelper h) {
        h.openNewElem("Formula", this);
        h.openSubTag("Layer");
        h.addAttr("Size", String.valueOf(this.layer.size()));
        for (int i = 0; i < this.layer.size(); ++i) {
            h.addAttr("Layer", ((Integer)this.layer.get(i)).toString());
        }
        h.close();
        h.close();
    }
}

