/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.attribute.AttrInstance;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.attribute.view.AttrViewEvent;
import agg.attribute.view.AttrViewObserver;
import agg.attribute.view.AttrViewSetting;
import agg.editor.impl.Arrow;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdType;
import agg.editor.impl.GraphPanel;
import agg.editor.impl.Line;
import agg.editor.impl.Loop;
import agg.layout.LayoutArc;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.TypeException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

public class EdArc
extends EdGraphObject
implements AttrViewObserver,
XMLObject {
    private static final BasicStroke stroke = new BasicStroke(1.0f);
    private Arc bArc;
    private EdGraphObject from;
    private EdGraphObject to;
    private boolean directed = true;
    private Point anchor;
    private transient int anchorID = 0;
    private transient boolean hasDefaultAnchor;
    private transient Point textLocation;
    protected Point textOffset;
    private transient Dimension textSize;
    private transient Point srcMultiplicityLocation;
    private transient Dimension srcMultiplicitySize;
    private transient Point srcMultiplicityOffset;
    private transient Point trgMultiplicityLocation;
    private transient Dimension trgMultiplicitySize;
    private transient Point trgMultiplicityOffset;
    private transient int partOfText;
    private Color conflictColor = Color.red;
    private Color dependencyColor = Color.blue;
    private LayoutArc lArc;

    public EdArc(Arc bArc, EdType eType, EdGraphObject from, EdGraphObject to) {
        super(eType);
        this.bArc = bArc;
        this.from = from;
        this.to = to;
        this.directed = bArc.isDirected();
        this.setCritical(bArc.isCritical());
        this.anchor = null;
        this.hasDefaultAnchor = true;
        this.x = 0;
        this.y = 0;
        this.w = 0;
        this.h = 0;
        this.textOffset = new Point(0, -22);
        this.textLocation = new Point();
        this.textSize = new Dimension();
        this.srcMultiplicityLocation = new Point();
        this.srcMultiplicitySize = new Dimension();
        this.srcMultiplicityOffset = new Point();
        this.trgMultiplicityLocation = new Point();
        this.trgMultiplicitySize = new Dimension();
        this.trgMultiplicityOffset = new Point();
        if (this.bArc != null && this.getView() != null) {
            this.getView().addObserver(this, this.bArc.getAttribute());
            this.setAttrObserver(true);
        }
        this.lArc = new LayoutArc(this);
    }

    public EdArc(Graph bGraph, EdType eType, EdGraphObject from, EdGraphObject to) throws TypeException {
        this(bGraph, eType, from, to, null);
    }

    public EdArc(Graph bGraph, EdType eType, EdGraphObject from, EdGraphObject to, Point anchor) throws TypeException {
        this(bGraph != null ? bGraph.createArc(eType.bType, (Node)from.getBasisObject(), (Node)to.getBasisObject()) : null, eType, from, to);
        this.setAnchor(anchor);
    }

    public LayoutArc getLArc() {
        return this.lArc;
    }

    public final Arc getBasisArc() {
        return this.bArc;
    }

    public final GraphObject getBasisObject() {
        return this.bArc;
    }

    public final boolean isNode() {
        return false;
    }

    public final boolean isArc() {
        return true;
    }

    public final EdNode getNode() {
        return null;
    }

    public final EdArc getArc() {
        return this;
    }

    public final boolean isLine() {
        return !this.from.equals(this.to);
    }

    public boolean hasAnchor() {
        return this.anchor != null && !this.hasDefaultAnchor;
    }

    public Point getAnchor() {
        if (this.anchor != null) {
            return this.anchor;
        }
        if (this.isLine()) {
            return new Point(this.getX(), this.getY());
        }
        return null;
    }

    public Point getAnchor(int id) {
        if (this.anchor != null) {
            return this.anchor;
        }
        if (!this.isLine()) {
            Loop loop = this.toLoop();
            return loop.getAnchor(id);
        }
        return null;
    }

    public int getAnchorID() {
        return this.anchorID;
    }

    public boolean isDirected() {
        if (this.bArc != null) {
            this.directed = this.bArc.isDirected();
            return this.directed;
        }
        return this.directed;
    }

    public boolean isVisible() {
        if (this.bArc != null) {
            this.visible = this.bArc.isVisible();
            return this.visible;
        }
        return this.visible;
    }

    public Vector getAttributes() {
        Vector attrs = new Vector();
        if (this.bArc != null) {
            AttrInstance attributes = this.bArc.getAttribute();
            if (this.getView() != null) {
                AttrViewSetting mvs = this.getView().getMaskedView();
                int number = mvs.getSize(attributes);
                for (int i = 0; i < number; ++i) {
                    Vector<String> tmpAttrVector = new Vector<String>();
                    int index = mvs.convertSlotToIndex(attributes, i);
                    tmpAttrVector.addElement(attributes.getTypeAsString(index));
                    tmpAttrVector.addElement(attributes.getNameAsString(index));
                    tmpAttrVector.addElement(attributes.getValueAsString(index));
                    attrs.addElement(tmpAttrVector);
                }
            } else {
                attrs = this.setAttributes(this.bArc);
            }
        }
        return attrs;
    }

    public Vector setAttributes(Arc bArc) {
        Vector attrs = new Vector();
        if (bArc == null) {
            return attrs;
        }
        int nattrs = bArc.getAttribute().getNumberOfEntries();
        if (nattrs != 0) {
            for (int i = 0; i < nattrs; ++i) {
                Vector<String> attr = new Vector<String>();
                attr.addElement(bArc.getAttribute().getTypeAsString(i));
                attr.addElement(bArc.getAttribute().getNameAsString(i));
                attr.addElement(bArc.getAttribute().getValueAsString(i));
                attrs.addElement(attr);
            }
        }
        return attrs;
    }

    public Vector setAttributes(GraphObject obj) {
        return this.setAttributes((Arc)obj);
    }

    public void setBasisArc(Arc bArc) {
        this.bArc = bArc;
    }

    public EdGraphObject getSource() {
        return this.from;
    }

    public void setSource(EdGraphObject en) {
        this.from = en;
    }

    public EdGraphObject getTarget() {
        return this.to;
    }

    public void setTarget(EdGraphObject en) {
        this.to = en;
    }

    public void setDirected(boolean direct) {
        this.directed = direct;
        if (this.bArc != null) {
            this.bArc.setDirected(direct);
        }
    }

    public void setAnchor(Point newAnchor) {
        this.anchor = newAnchor;
        if (this.anchor == null) {
            this.hasDefaultAnchor = true;
        } else if (this.isLine()) {
            this.setXY(this.anchor.x, this.anchor.y);
            this.hasDefaultAnchor = false;
        } else {
            this.setAnchor(1, newAnchor);
        }
    }

    public void setAnchor(int id, Point newAnchor) {
        this.anchor = newAnchor;
        if (this.anchor == null) {
            this.hasDefaultAnchor = true;
        } else if (!this.isLine() && id == 1) {
            this.setXY(this.anchor.x, this.anchor.y);
            this.hasDefaultAnchor = false;
        }
    }

    public void setReps(boolean nDirected, boolean nVisible, boolean nSelect) {
        this.setDirected(nDirected);
        this.setVisible(nVisible);
        this.setSelected(nSelect);
    }

    public EdArc copy() {
        EdArc newArc = new EdArc(this.bArc, this.eType, this.from, this.to);
        newArc.setAnchor(this.getAnchor());
        return newArc;
    }

    public final Line toLine() {
        Line line = new Line(this.from.getX(), this.from.getY(), this.to.getX(), this.to.getY());
        if (this.anchor != null) {
            line.setAnchor(new Point(this.anchor.x, this.anchor.y));
        }
        return line;
    }

    public final Loop toLoop() {
        Loop loop = new Loop(this.x, this.y, this.w, this.h);
        return loop;
    }

    public Dimension getTextSize(FontMetrics fm) {
        this.textSize.setSize(new Dimension(super.getTextWidth(fm), super.getTextHeight(fm)));
        return this.textSize;
    }

    public Point getTextOffset() {
        return this.textOffset;
    }

    public void setTextOffset(int xOffset, int yOffset) {
        this.textOffset.x = xOffset;
        this.textOffset.y = yOffset;
    }

    public void translateTextOffset(int dx, int dy) {
        if (this.partOfText == 0) {
            this.textOffset.translate(dx, dy);
        } else if (this.partOfText == 1) {
            this.srcMultiplicityOffset.translate(dx, dy);
        } else if (this.partOfText == 2) {
            this.trgMultiplicityOffset.translate(dx, dy);
        }
    }

    public boolean inside(int X, int Y) {
        this.anchorID = 0;
        if (this.isLine()) {
            Rectangle r = new Rectangle(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h);
            return r.contains(X, Y);
        }
        Loop loop = this.toLoop();
        if (loop.contains(new Point(X, Y))) {
            if (loop.anchorID == 1) {
                this.anchor = loop.anchor;
                this.anchorID = loop.anchorID;
            }
            return true;
        }
        return false;
    }

    public boolean insideTextOfArc(int X, int Y, FontMetrics fm) {
        Rectangle r = this.getTextRectangle(fm);
        if (r != null && r.contains(X, Y)) {
            this.partOfText = 0;
            return true;
        }
        if (this.isElementOfTypeGraph()) {
            if (this.insideTextOfMultiplicity(X, Y, "source")) {
                this.partOfText = 1;
                return true;
            }
            if (this.insideTextOfMultiplicity(X, Y, "target")) {
                this.partOfText = 2;
                return true;
            }
            return false;
        }
        return false;
    }

    private Rectangle getTextRectangle(FontMetrics fm) {
        Dimension d = this.getTextSize(fm);
        int tw = (int)d.getWidth();
        int th = (int)d.getHeight();
        if (this.isLine()) {
            int tx = 0;
            int ty = 0;
            int x1 = this.from.getX();
            int y1 = this.from.getY();
            int x2 = this.to.getX();
            int y2 = this.to.getY();
            if (this.anchor != null) {
                tx = this.anchor.x;
                ty = this.anchor.y;
            } else {
                tx = this.getX();
                ty = this.getY();
            }
            this.textLocation.x = (tx -= tw / 2) + this.textOffset.x;
            this.textLocation.y = ty + this.textOffset.y;
            return new Rectangle(this.textLocation.x, this.textLocation.y, tw, th);
        }
        this.textLocation.x = this.x + this.textOffset.x;
        this.textLocation.y = this.y + this.textOffset.y;
        return new Rectangle(this.textLocation.x, this.textLocation.y, tw, th);
    }

    private boolean insideTextOfMultiplicity(int X, int Y, String key) {
        if (key.equals("target")) {
            Rectangle r = new Rectangle(this.trgMultiplicityLocation.x + this.trgMultiplicityOffset.x, this.trgMultiplicityLocation.y + this.trgMultiplicityOffset.y - (int)this.trgMultiplicitySize.getHeight(), (int)this.trgMultiplicitySize.getWidth(), (int)this.trgMultiplicitySize.getHeight());
            return r != null && r.contains(X, Y);
        }
        if (key.equals("source")) {
            Rectangle r = new Rectangle(this.srcMultiplicityLocation.x + this.srcMultiplicityOffset.x, this.srcMultiplicityLocation.y + this.srcMultiplicityOffset.y - (int)this.srcMultiplicitySize.getHeight(), (int)this.srcMultiplicitySize.getWidth(), (int)this.srcMultiplicitySize.getHeight());
            return r != null && r.contains(X, Y);
        }
        return false;
    }

    public void drawGraphic(Graphics grs, double scale) {
        Graphics2D g = (Graphics2D)grs;
        g.setStroke(stroke);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.backgroundColor != Color.white) {
            g.setPaint(this.backgroundColor);
            if (!this.from.equals(this.to)) {
                this.drawBackgroundLine(g);
            } else {
                this.drawBackgroundLoop(g);
            }
        }
        if (this.isSelected()) {
            g.setPaint(this.getSelectColor());
        } else if (this.isCritical()) {
            g.setPaint(this.criticalColor);
        } else {
            g.setPaint(this.getColor());
        }
        if (!this.from.equals(this.to)) {
            this.drawArcAsLine(g, scale, true);
        } else {
            this.drawArcAsLoop(g, scale, true);
        }
        if (this.errorMode) {
            this.showErrorAnchor(g);
        }
    }

    public void drawText(Graphics grs, double scale) {
        Graphics2D g = (Graphics2D)grs;
        g.setPaint(this.getColor());
        if (this.isLine()) {
            int ty;
            int tx;
            int tw = (int)this.getTextSize(g.getFontMetrics()).getWidth();
            if (this.anchor != null) {
                tx = this.anchor.x;
                ty = this.anchor.y;
            } else {
                tx = this.getX();
                ty = this.getY();
            }
            this.textLocation.x = (tx -= tw / 2) + this.textOffset.x;
            this.textLocation.y = ty + this.textOffset.y;
        } else {
            this.textLocation.x = this.x + this.textOffset.x;
            this.textLocation.y = this.y + this.textOffset.y;
        }
        this.showText(g, this.textLocation.x, this.textLocation.y);
    }

    public void eraseText(Graphics grs, double scale) {
        Graphics2D g = (Graphics2D)grs;
        g.setPaint(Color.white);
        if (this.isLine()) {
            Rectangle r = this.getTextRectangle(g.getFontMetrics());
            g.fillRect(r.x, r.y, r.width, r.height);
        } else {
            Rectangle r = this.getTextRectangle(g.getFontMetrics());
            g.fillRect(r.x, r.y, r.width, r.height);
        }
    }

    public void eraseGraphic(Graphics grs, double scale) {
        Graphics2D g = (Graphics2D)grs;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setPaint(Color.white);
        this.eraseMoveAnchor(g);
        if (this.isLine()) {
            this.eraseArcAsLine(g, scale, true);
        } else {
            this.eraseArcAsLoop(g, scale, true);
        }
    }

    public int getWidthOfLoop() {
        if (this.getWidth() == 0) {
            return 14;
        }
        return this.getWidth();
    }

    public int getHeightOfLoop() {
        if (this.getHeight() == 0) {
            return 14;
        }
        return this.getHeight();
    }

    public void showMoveAnchor(Graphics g) {
        if (!this.from.equals(this.to)) {
            this.showMoveAnchorOfLine(g);
        } else {
            this.showMoveAnchorOfLoop(g);
        }
    }

    public void eraseMoveAnchor(Graphics g) {
        if (!this.from.equals(this.to)) {
            this.eraseMoveAnchorOfLine(g);
        } else {
            this.eraseMoveAnchorOfLoop(g);
        }
    }

    public void attributeChanged(AttrViewEvent ev) {
        if (ev.getID() == 0 || ev.getID() == 20 || ev.getID() == 60 || ev.getID() == 50 || ev.getID() == 220 || ev.getID() == 210) {
            if (this.myGraphPanel != null) {
                this.myGraphPanel.updateGraphics();
            }
        } else if (ev.getID() == 80 || ev.getID() == 70) {
            if (ev.getSource().isValid()) {
                if (this.myGraphPanel != null) {
                    ValueMember val;
                    if (this.myGraphPanel.isAttrEditorActivated() && this.bArc.getContext().getAttrContext() != null && (val = ((ValueTuple)this.bArc.getAttribute()).getValueMemberAt(ev.getIndex())).isSet() && val.getExpr().isVariable()) {
                        ContextView viewContext = (ContextView)((ValueTuple)val.getHoldingTuple()).getContext();
                        VarTuple variable = (VarTuple)viewContext.getVariables();
                        VarMember var = variable.getVarMemberAt(val.getExprAsText());
                        if (var == null) {
                            return;
                        }
                        if (this.bArc.getContext().isNacGraph()) {
                            var.setMark(2);
                        } else if (viewContext.doesAllowComplexExpressions()) {
                            var.setMark(1);
                        } else {
                            var.setMark(0);
                        }
                    }
                    this.myGraphPanel.updateGraphics();
                }
            } else {
                ValueMember am;
                ValueTuple attr = (ValueTuple)this.bArc.getAttribute();
                for (int i = 0; i < attr.getSize() && (am = (ValueMember)attr.getMemberAt(i)).isValid(); ++i) {
                }
            }
        }
    }

    public void setGraphPanel(GraphPanel gp) {
        this.myGraphPanel = gp;
    }

    public void dispose() {
        if (this.isAttrObserver() && this.bArc != null && this.bArc.getAttribute() != null) {
            this.getView().removeObserver(this, this.bArc.getAttribute());
            this.getView().getOpenView().removeObserver(this, this.bArc.getAttribute());
            this.getView().getMaskedView().removeObserver(this, this.bArc.getAttribute());
            this.getView().getOpenView().dispose();
            this.getView().getMaskedView().dispose();
            this.getView().dispose();
        }
        this.bArc = null;
    }

    private void showMoveAnchorOfLine(Graphics grs) {
        Graphics2D g = (Graphics2D)grs;
        Color lastColor = g.getColor();
        g.setPaint(Color.black);
        g.fill(new Rectangle(this.getX() - 4, this.getY() - 4, 8, 8));
        g.setPaint(lastColor);
    }

    private void showMoveAnchorOfLoop(Graphics grs) {
        Loop loop = new Loop(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        loop.drawMoveAnchor(grs, this.anchorID);
    }

    protected void showErrorAnchor(Graphics g) {
        if (!this.from.equals(this.to)) {
            this.showErrorAnchorOfLine(g);
        } else {
            this.showErrorAnchorOfLoop(g);
        }
    }

    private void showErrorAnchorOfLine(Graphics grs) {
        Graphics2D g = (Graphics2D)grs;
        Color lastColor = g.getColor();
        g.setPaint(Color.green);
        g.fill(new Rectangle2D.Double(this.x - 6, this.y - 6, 12.0, 12.0));
        g.setPaint(lastColor);
    }

    private void showErrorAnchorOfLoop(Graphics grs) {
        Graphics2D g = (Graphics2D)grs;
        Color lastColor = g.getColor();
        g.setPaint(Color.green);
        Loop loop = new Loop(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        if (this.anchorID == 1) {
            g.fill(new Rectangle2D.Double(loop.anch1.x - 6, loop.anch1.y - 6, 12.0, 12.0));
        }
        g.setPaint(lastColor);
    }

    private void eraseMoveAnchorOfLine(Graphics grs) {
        Graphics2D g = (Graphics2D)grs;
        Color lastColor = g.getColor();
        g.setPaint(Color.white);
        g.fill(new Rectangle2D.Double(this.x - 5, this.y - 5, 10.0, 10.0));
        g.setPaint(lastColor);
    }

    private void eraseMoveAnchorOfLoop(Graphics grs) {
        Graphics2D g = (Graphics2D)grs;
        Color lastColor = g.getColor();
        g.setPaint(Color.white);
        Loop loop = new Loop(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        if (this.anchorID == 1) {
            g.fill(new Rectangle2D.Double(loop.anch1.x - 5, loop.anch1.y - 5, 10.0, 10.0));
        }
        g.setPaint(lastColor);
    }

    private void drawArcAsLine(Graphics grs, double scale, boolean withText) {
        if (!(this.from.isVisible() && this.to.isVisible() && this.isVisible())) {
            return;
        }
        Graphics2D g = (Graphics2D)grs;
        boolean needAnchorTuning = true;
        int x1 = this.from.getX();
        int y1 = this.from.getY();
        int x2 = this.to.getX();
        int y2 = this.to.getY();
        Line line = this.toLine();
        if (this.anchor != null) {
            line.setAnchor(new Point(this.anchor.x, this.anchor.y));
            needAnchorTuning = false;
        }
        this.setXY(line.getAnchor().x, line.getAnchor().y);
        if (this.getWidth() == this.getHeight() && this.getHeight() == 0) {
            this.setWidth(14);
            this.setHeight(14);
        }
        line.setColor(g.getColor());
        int sh = this.getShape();
        switch (sh) {
            case 61: {
                line.drawColorSolidLine(g);
                break;
            }
            case 63: {
                line.drawColorDotLine(g);
                break;
            }
            case 62: {
                line.drawColorDashLine(g);
                break;
            }
        }
        Arrow arrow = new Arrow(scale, line.getAnchor().x, line.getAnchor().y, x2, y2, this.to.getWidth(), this.to.getHeight());
        if (this.bArc.isInheritance()) {
            arrow.draw(g, false);
        } else if (this.isDirected()) {
            arrow.draw(g);
        }
        Arrow tmpBackArrow = new Arrow(scale, line.getAnchor().x, line.getAnchor().y, x1, y1, this.from.getWidth(), this.from.getHeight());
        if (needAnchorTuning) {
            Point beg = tmpBackArrow.getHeadEnd();
            Point end = arrow.getHeadEnd();
            if (beg != null && end != null) {
                int anchX = beg.x + (end.x - beg.x) / 2;
                int anchY = beg.y + (end.y - beg.y) / 2;
                line.setAnchor(new Point(anchX, anchY));
                this.setXY(anchX, anchY);
            }
        }
        if (this.elemOfTG) {
            Point p = new Point();
            if (arrow.getRightEnd() != null && y2 > line.getAnchor().y) {
                p.y = arrow.getRightEnd().y - 5;
                p.x = arrow.getRightEnd().x;
            } else if (arrow.getLeftEnd() != null) {
                p.y = arrow.getLeftEnd().y + 5;
                p.x = arrow.getLeftEnd().x;
            }
            if (!this.bArc.isInheritance()) {
                this.drawMultiplicity(g, "target", p, this.eType.getBasisType().getTargetMin(this.bArc.getSource().getType(), this.bArc.getTarget().getType()), this.eType.getBasisType().getTargetMax(this.bArc.getSource().getType(), this.bArc.getTarget().getType()));
            }
            if (tmpBackArrow.getRightEnd() != null && y1 > line.getAnchor().y) {
                p.y = tmpBackArrow.getRightEnd().y - 5;
                p.x = tmpBackArrow.getRightEnd().x;
            } else if (tmpBackArrow.getLeftEnd() != null) {
                p.y = tmpBackArrow.getLeftEnd().y + 5;
                p.x = tmpBackArrow.getLeftEnd().x;
            }
            if (!this.bArc.isInheritance()) {
                this.drawMultiplicity(g, "source", p, this.eType.getBasisType().getSourceMin(this.bArc.getSource().getType(), this.bArc.getTarget().getType()), this.eType.getBasisType().getSourceMax(this.bArc.getSource().getType(), this.bArc.getTarget().getType()));
            }
        }
        if (withText) {
            g.setPaint(this.getColor());
            this.textLocation.x = this.getX() + this.textOffset.x;
            this.textLocation.y = this.getY() + this.textOffset.y;
            this.showText(g, this.textLocation.x, this.textLocation.y);
        }
    }

    private void drawBackgroundLine(Graphics grs) {
        if (!(this.from.isVisible() && this.to.isVisible() && this.isVisible())) {
            return;
        }
        Graphics2D g = (Graphics2D)grs;
        g.setColor(this.backgroundColor);
        g.setStroke(new BasicStroke(5.0f));
        int x1 = this.from.getX();
        int y1 = this.from.getY();
        int x2 = this.to.getX();
        int y2 = this.to.getY();
        Line line = this.toLine();
        if (this.anchor != null) {
            line.setAnchor(new Point(this.anchor.x, this.anchor.y));
        }
        if (this.getWidth() == this.getHeight() && this.getHeight() == 0) {
            this.setWidth(14);
            this.setHeight(14);
        }
        line.setColor(g.getColor());
        line.drawColorSolidLine(g);
        g.setStroke(stroke);
    }

    private void eraseArcAsLine(Graphics grs, double scale, boolean withText) {
        Graphics2D g = (Graphics2D)grs;
        int[] nX = new int[6];
        int[] nY = new int[6];
        int n = 5;
        int n1 = 5;
        nX[0] = this.from.getX();
        nY[0] = this.from.getY() - n;
        nX[1] = this.getX();
        nY[1] = this.getY() - n;
        nX[2] = this.to.getX();
        nY[2] = this.to.getY() - (n + n1);
        nX[3] = this.to.getX();
        nY[3] = this.to.getY() + (n + n1);
        nX[4] = this.getX();
        nY[4] = this.getY() + n;
        nX[5] = this.from.getX();
        nY[5] = this.from.getY() + n;
        int nP = 6;
        g.fillPolygon(nX, nY, nP);
        if (withText) {
            Rectangle r = this.getTextRectangle(g.getFontMetrics());
            g.fillRect(r.x, r.y, r.width, r.height);
        }
    }

    private void drawArcAsLoop(Graphics grs, double scale, boolean withText) {
        if (!(this.from.isVisible() && this.to.isVisible() && this.isVisible())) {
            return;
        }
        Graphics2D g = (Graphics2D)grs;
        if (!this.from.isNode()) {
            return;
        }
        int fromWidth = this.from.getWidth();
        int fromHeight = this.from.getHeight();
        if (((EdNode)this.from).getShape() == 52) {
            fromHeight = fromWidth = (int)(Math.acos(0.0) * (double)(this.from.getWidth() / 2));
        } else if (((EdNode)this.from).getShape() == 53) {
            int nn = 0;
            nn = fromWidth < fromHeight ? fromWidth - (fromHeight - fromWidth) / 2 : fromHeight - (fromWidth - fromHeight) / 2;
            fromWidth = nn;
            fromHeight = nn;
        }
        int w1 = 0;
        int h1 = 0;
        int x1 = 0;
        int y1 = 0;
        boolean w2 = false;
        boolean h2 = false;
        boolean x2 = false;
        boolean y2 = false;
        int offsetX = 0;
        int offsetY = 0;
        if (this.getWidth() == this.getHeight() && this.getHeight() == 0) {
            h1 = w1 = this.getWidthOfLoop();
            offsetX = fromWidth / 2 + w1 / 2 + w1 / 4;
            offsetY = fromHeight / 2 + h1 / 2 + h1 / 4;
            x1 = this.from.getX() - offsetX;
            y1 = this.from.getY() - offsetY;
            this.setXY(x1, y1);
            this.setWidth(w1);
            this.setHeight(h1);
        } else {
            w1 = this.getWidth();
            h1 = this.getHeight();
            offsetX = fromWidth / 2 + w1 / 2 + w1 / 4;
            offsetY = fromHeight / 2 + h1 / 2 + h1 / 4;
            x1 = this.from.getX() - offsetX;
            y1 = this.from.getY() - offsetY;
            int difX = 0;
            int difY = 0;
            if (x1 + w1 <= this.from.getX() - fromWidth / 2) {
                difX = this.from.getX() - fromWidth / 2 - (x1 + w1);
                x1 = x1 + difX + 5;
            } else if (x1 >= this.from.getX() + fromWidth / 2) {
                difX = x1 - (this.from.getX() + fromWidth / 2);
                x1 = x1 - difX - 5;
            }
            if (y1 + h1 <= this.from.getY() - fromHeight / 2) {
                difY = this.from.getY() - fromHeight / 2 - (y1 + h1);
                y1 = y1 + difY + 5;
            } else if (y1 >= this.from.getY() + fromHeight / 2) {
                difY = y1 - (this.from.getY() + fromHeight / 2);
                y1 = y1 - difY - 5;
            }
            Loop tLoop = new Loop(x1, y1, w1, h1);
            if (!tLoop.outside(((EdNode)this.from).toRectangle(), tLoop.anch1, tLoop.anch2, tLoop.anch3, tLoop.anch4)) {
                x1 = this.from.getX() - fromWidth / 2 - w1 / 2 - w1 / 4;
                y1 = this.from.getY() - fromHeight / 2 - h1 / 2 - h1 / 4;
            }
        }
        Loop loop = new Loop(x1, y1, w1, h1);
        this.setXY(x1, y1);
        this.setWidth(w1);
        this.setHeight(h1);
        loop.setColor(g.getColor());
        int sh = this.getShape();
        switch (sh) {
            case 61: {
                loop.drawColorSolidLoop(g);
                break;
            }
            case 63: {
                loop.drawColorDotLoop(g);
                break;
            }
            case 62: {
                loop.drawColorDashLoop(g);
                break;
            }
        }
        Arrow arrow = new Arrow(scale, loop.anch4.x, loop.anch4.y, loop.anch3.x, loop.anch3.y, (loop.anch3.x - (this.from.getX() - fromWidth / 2)) * 2, (loop.anch3.y - (this.from.getY() - fromHeight / 2)) * 2);
        arrow.draw(g);
        if (this.elemOfTG) {
            Arrow tmp;
            if (arrow.getRightEnd() != null) {
                this.drawMultiplicity(g, "target", arrow.getRightEnd(), this.eType.getBasisType().getTargetMin(this.bArc.getSource().getType(), this.bArc.getTarget().getType()), this.eType.getBasisType().getTargetMax(this.bArc.getSource().getType(), this.bArc.getTarget().getType()));
            }
            if ((tmp = new Arrow(scale, loop.anch2.x, loop.anch2.y, loop.anch3.x, loop.anch3.y, (loop.anch3.x - (this.from.getX() - fromWidth / 2)) * 2, (loop.anch3.y - (this.from.getY() - fromHeight / 2)) * 2)).getLeftEnd() != null) {
                Point p = new Point(tmp.getLeftEnd().x, tmp.getLeftEnd().y - 10);
                this.drawMultiplicity(g, "source", p, this.eType.getBasisType().getSourceMin(this.bArc.getSource().getType(), this.bArc.getTarget().getType()), this.eType.getBasisType().getSourceMax(this.bArc.getSource().getType(), this.bArc.getTarget().getType()));
            }
        }
        if (withText) {
            g.setPaint(this.getColor());
            int tx = x1;
            int ty = y1;
            this.textLocation.x = x1 + this.textOffset.x;
            this.textLocation.y = y1 + this.textOffset.y;
            this.showText(g, this.textLocation.x, this.textLocation.y);
        }
    }

    private void drawBackgroundLoop(Graphics grs) {
        if (!(this.from.isVisible() && this.to.isVisible() && this.isVisible())) {
            return;
        }
        if (!this.from.isNode()) {
            return;
        }
        Graphics2D g = (Graphics2D)grs;
        g.setColor(this.backgroundColor);
        g.setStroke(new BasicStroke(5.0f));
        int fromWidth = this.from.getWidth();
        int fromHeight = this.from.getHeight();
        int w1 = 0;
        int h1 = 0;
        int x1 = 0;
        int y1 = 0;
        boolean w2 = false;
        boolean h2 = false;
        boolean x2 = false;
        boolean y2 = false;
        boolean offsetX = false;
        boolean offsetY = false;
        if (this.getWidth() == this.getHeight() && this.getHeight() == 0) {
            h1 = w1 = this.getWidthOfLoop();
            x1 = this.from.getX() - (fromWidth / 2 + w1);
            y1 = this.from.getY() - (fromHeight / 2 + h1);
        } else {
            w1 = this.getWidth();
            h1 = this.getHeight();
            x1 = this.from.getX() - (fromWidth / 2 + w1);
            y1 = this.from.getY() - (fromHeight / 2 + h1);
        }
        Loop loop = new Loop(x1, y1, w1, h1);
        loop.setColor(g.getColor());
        loop.drawColorSolidLoop(g);
        g.setStroke(stroke);
    }

    private void eraseArcAsLoop(Graphics grs, double scale, boolean withText) {
        Graphics2D g = (Graphics2D)grs;
        g.fillRect(this.getX(), this.getY(), this.getWidth() + 2, this.getHeight() + 5);
        if (withText) {
            Rectangle r = this.getTextRectangle(g.getFontMetrics());
            g.fillRect(r.x, r.y, r.width, r.height);
        }
    }

    private void showText(Graphics grs, int X, int Y) {
        int ty;
        Graphics2D g = (Graphics2D)grs;
        boolean underlined = false;
        int tx = X;
        if (tx <= 0) {
            tx = 2;
        }
        if ((ty = Y) <= 0) {
            ty = 2;
        }
        FontMetrics fm = g.getFontMetrics();
        int tw = this.getTextWidth(fm);
        String typeStr = this.getTypeString();
        int ty1 = ty + fm.getAscent();
        g.drawString(typeStr, tx, ty1);
        if (this.myGraphPanel != null && this.myGraphPanel.getCanvas().getFontSize() == 0) {
            return;
        }
        Vector attrs = this.getAttributes();
        if (attrs != null && !attrs.isEmpty()) {
            for (int i = 0; i < attrs.size(); ++i) {
                int lastY;
                String attrStr;
                Vector attr = (Vector)attrs.elementAt(i);
                if (!this.elemOfTG && ((String)attr.elementAt(2)).length() != 0) {
                    attrStr = (String)attr.elementAt(1);
                    attrStr = (String)attr.elementAt(1) + "=";
                    attrStr = attrStr + (String)attr.elementAt(2);
                    if (!underlined) {
                        g.drawLine(tx, ty += fm.getHeight(), tx + tw, ty);
                        ty += 2;
                        underlined = true;
                    }
                    lastY = ty;
                    ty1 = ty + fm.getAscent();
                    g.drawString(attrStr, tx, ty1);
                    ty += fm.getHeight();
                    continue;
                }
                if (!this.elemOfTG || attr.elementAt(1) == null) continue;
                attrStr = (String)attr.elementAt(0);
                attrStr = attrStr + "  ";
                attrStr = attrStr + (String)attr.elementAt(1);
                if (!underlined) {
                    g.drawLine(tx, ty += fm.getHeight(), tx + tw, ty);
                    ty += 2;
                    underlined = true;
                }
                lastY = ty;
                ty1 = ty + fm.getAscent();
                g.drawString(attrStr, tx, ty1);
                ty += fm.getHeight();
            }
        }
    }

    private void drawMultiplicity(Graphics grs, String key, Point p, int min, int max) {
        Graphics2D g = (Graphics2D)grs;
        String s = "";
        if (min != -1) {
            s = s.concat(String.valueOf(min));
            s = s.concat("..");
            if (max == -1) {
                s = s.concat("*");
            }
        } else {
            s = max != -1 ? s.concat("0..") : "*";
        }
        if (max != -1) {
            s = min != max ? s.concat(String.valueOf(max)) : String.valueOf(max);
        }
        int w1 = g.getFontMetrics().stringWidth(s);
        int h1 = g.getFontMetrics().getHeight();
        if (key.equals("source")) {
            if (this.srcMultiplicityOffset.x == 0 && this.srcMultiplicityOffset.y == 0) {
                this.srcMultiplicityOffset.x = this.isLine() ? -w1 : 5;
                this.srcMultiplicityOffset.y = h1;
            }
            this.srcMultiplicityLocation.x = p.x;
            this.srcMultiplicityLocation.y = p.y;
            this.srcMultiplicitySize.setSize(new Dimension(w1, h1));
            g.drawString(s, this.srcMultiplicityLocation.x + this.srcMultiplicityOffset.x, this.srcMultiplicityLocation.y + this.srcMultiplicityOffset.y);
        } else if (key.equals("target")) {
            if (this.trgMultiplicityOffset.x == 0 && this.trgMultiplicityOffset.y == 0) {
                this.trgMultiplicityOffset.x = -w1;
                this.trgMultiplicityOffset.y = h1 / 2;
            }
            this.trgMultiplicityLocation.x = p.x;
            this.trgMultiplicityLocation.y = p.y;
            this.trgMultiplicitySize.setSize(new Dimension(w1, h1));
            g.drawString(s, this.trgMultiplicityLocation.x + this.trgMultiplicityOffset.x, this.trgMultiplicityLocation.y + this.trgMultiplicityOffset.y);
        }
    }

    public void drawNameAttrOnly(Graphics grs, double scale) {
        if (!(this.from.isVisible() && this.to.isVisible() && this.isVisible())) {
            return;
        }
        Graphics2D g = (Graphics2D)grs;
        g.setStroke(stroke);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setPaint(this.getColor());
        if (!this.from.equals(this.to)) {
            boolean needAnchorTuning = true;
            int x1 = this.from.getX();
            int y1 = this.from.getY();
            int x2 = this.to.getX();
            int y2 = this.to.getY();
            Line line = this.toLine();
            if (this.anchor != null) {
                line.setAnchor(new Point(this.anchor.x, this.anchor.y));
                needAnchorTuning = false;
            }
            this.setXY(line.getAnchor().x, line.getAnchor().y);
            if (this.getWidth() == this.getHeight() && this.getHeight() == 0) {
                this.setWidth(14);
                this.setHeight(14);
            }
            line.setColor(this.getType().getColor());
            int sh = this.getShape();
            switch (sh) {
                case 61: {
                    line.drawColorSolidLine(g);
                    break;
                }
                case 63: {
                    line.drawColorDotLine(g);
                    break;
                }
                case 62: {
                    line.drawColorDashLine(g);
                    break;
                }
            }
            Arrow arrow = new Arrow(scale, line.getAnchor().x, line.getAnchor().y, x2, y2, this.to.getWidth(), this.to.getHeight());
            if (this.isDirected()) {
                arrow.draw(g);
            }
            Arrow tmpBackArrow = new Arrow(scale, line.getAnchor().x, line.getAnchor().y, x1, y1, this.from.getWidth(), this.from.getHeight());
            if (needAnchorTuning) {
                Point beg = tmpBackArrow.getHeadEnd();
                Point end = arrow.getHeadEnd();
                if (beg != null && end != null) {
                    int anchX = beg.x + (end.x - beg.x) / 2;
                    int anchY = beg.y + (end.y - beg.y) / 2;
                    line.setAnchor(new Point(anchX, anchY));
                    this.setXY(anchX, anchY);
                }
            }
            this.textLocation.x = this.getX() + this.textOffset.x;
            this.textLocation.y = this.getY() + this.textOffset.y;
            this.showNameAttrOnly(g, this.textLocation.x, this.textLocation.y);
        } else {
            int fromWidth = this.from.getWidth();
            int fromHeight = this.from.getHeight();
            int w1 = 0;
            int h1 = 0;
            int x1 = 0;
            int y1 = 0;
            boolean w2 = false;
            boolean h2 = false;
            boolean x2 = false;
            boolean y2 = false;
            int offsetX = 0;
            int offsetY = 0;
            if (this.getWidth() == this.getHeight() && this.getHeight() == 0) {
                h1 = w1 = this.getWidthOfLoop();
                offsetX = fromWidth / 2 + w1 / 2 + w1 / 4;
                offsetY = fromHeight / 2 + h1 / 2 + h1 / 4;
                x1 = this.from.getX() - offsetX;
                y1 = this.from.getY() - offsetY;
                this.setXY(x1, y1);
                this.setWidth(w1);
                this.setHeight(h1);
            } else {
                w1 = this.getWidth();
                h1 = this.getHeight();
                offsetX = fromWidth / 2 + w1 / 2 + w1 / 4;
                offsetY = fromHeight / 2 + h1 / 2 + h1 / 4;
                x1 = this.from.getX() - offsetX;
                y1 = this.from.getY() - offsetY;
                int difX = 0;
                int difY = 0;
                if (x1 + w1 <= this.from.getX() - fromWidth / 2) {
                    difX = this.from.getX() - fromWidth / 2 - (x1 + w1);
                    x1 = x1 + difX + 5;
                } else if (x1 >= this.from.getX() + fromWidth / 2) {
                    difX = x1 - (this.from.getX() + fromWidth / 2);
                    x1 = x1 - difX - 5;
                }
                if (y1 + h1 <= this.from.getY() - fromHeight / 2) {
                    difY = this.from.getY() - fromHeight / 2 - (y1 + h1);
                    y1 = y1 + difY + 5;
                } else if (y1 >= this.from.getY() + fromHeight / 2) {
                    difY = y1 - (this.from.getY() + fromHeight / 2);
                    y1 = y1 - difY - 5;
                }
                Loop tLoop = new Loop(x1, y1, w1, h1);
                if (!tLoop.outside(((EdNode)this.from).toRectangle(), tLoop.anch1, tLoop.anch2, tLoop.anch3, tLoop.anch4)) {
                    x1 = this.from.getX() - fromWidth / 2 - w1 / 2 - w1 / 4;
                    y1 = this.from.getY() - fromHeight / 2 - h1 / 2 - h1 / 4;
                }
            }
            Loop loop = new Loop(x1, y1, w1, h1);
            this.setXY(x1, y1);
            this.setWidth(w1);
            this.setHeight(h1);
            loop.setColor(this.getType().getColor());
            int sh = this.getShape();
            switch (sh) {
                case 61: {
                    loop.drawColorSolidLoop(g);
                    break;
                }
                case 63: {
                    loop.drawColorDotLoop(g);
                    break;
                }
                case 62: {
                    loop.drawColorDashLoop(g);
                    break;
                }
            }
            Arrow arrow = new Arrow(scale, loop.anch4.x, loop.anch4.y, loop.anch3.x, loop.anch3.y, (loop.anch3.x - (this.from.getX() - fromWidth / 2)) * 2, (loop.anch3.y - (this.from.getY() - fromHeight / 2)) * 2);
            arrow.draw(g);
            int tx = x1;
            int ty = y1;
            this.textLocation.x = x1 + this.textOffset.x;
            this.textLocation.y = y1 + this.textOffset.y;
            this.showNameAttrOnly(g, this.textLocation.x, this.textLocation.y);
        }
        g.setPaint(this.getColor());
        g.setStroke(stroke);
    }

    private void showNameAttrOnly(Graphics grs, int X, int Y) {
        int ty;
        Graphics2D g = (Graphics2D)grs;
        int tx = X;
        if (tx <= 0) {
            tx = 2;
        }
        if ((ty = Y) <= 0) {
            ty = 2;
        }
        FontMetrics fm = g.getFontMetrics();
        Vector attrs = this.getAttributes();
        if (attrs != null && !attrs.isEmpty()) {
            for (int i = 0; i < attrs.size(); ++i) {
                Vector attr = (Vector)attrs.elementAt(i);
                if (((String)attr.elementAt(2)).length() == 0 || !((String)attr.elementAt(1)).equals("name")) continue;
                String attrStr = (String)attr.elementAt(2);
                if (!attrStr.equals("\"\"")) {
                    int ty1 = ty + fm.getAscent();
                    g.drawString(attrStr, tx, ty1);
                }
                return;
            }
        }
    }

    public void XwriteObject(XMLHelper h) {
        if (h.openObject(this.bArc, this)) {
            h.openSubTag("EdgeLayout");
            h.addAttr("textOffsetX", this.textOffset.x);
            h.addAttr("textOffsetY", this.textOffset.y);
            if (this.isLine()) {
                if (this.hasDefaultAnchor) {
                    h.addAttr("bendX", 0);
                    h.addAttr("bendY", 0);
                } else {
                    h.addAttr("bendX", this.x);
                    h.addAttr("bendY", this.y);
                }
            } else {
                h.addAttr("bendX", this.x);
                h.addAttr("bendY", this.y);
                h.addAttr("loopW", this.w);
                h.addAttr("loopH", this.h);
            }
            if (this.isElementOfTypeGraph()) {
                h.addAttr("sourceMultiplicityOffsetX", this.srcMultiplicityOffset.x);
                h.addAttr("sourceMultiplicityOffsetY", this.srcMultiplicityOffset.y);
                h.addAttr("targetMultiplicityOffsetX", this.trgMultiplicityOffset.x);
                h.addAttr("targetMultiplicityOffsetY", this.trgMultiplicityOffset.y);
            }
            h.close();
            if (this.lArc != null) {
                h.addObject("", this.lArc, true);
            }
            h.close();
        }
    }

    public void XreadObject(XMLHelper h) {
        int loopW = 0;
        int loopH = 0;
        h.peekObject(this.bArc, this);
        if (h.readSubTag("EdgeLayout")) {
            this.textOffset = new Point();
            String s = h.readAttr("textOffsetX");
            this.textOffset.x = s.length() == 0 ? 0 : new Integer(s);
            s = h.readAttr("textOffsetY");
            this.textOffset.y = s.length() == 0 ? 0 : new Integer(s);
            s = h.readAttr("bendX");
            this.x = s.length() == 0 || s.equals("0") ? 0 : new Integer(s);
            s = h.readAttr("bendY");
            this.y = s.length() == 0 || s.equals("0") ? 0 : new Integer(s);
            if (!this.isLine()) {
                s = h.readAttr("loopW");
                loopW = s.length() == 0 ? 0 : new Integer(s);
                s = h.readAttr("loopH");
                loopH = s.length() == 0 ? 0 : new Integer(s);
            }
            this.srcMultiplicityOffset.x = (s = h.readAttr("sourceMultiplicityOffsetX")).length() == 0 ? 0 : new Integer(s);
            s = h.readAttr("sourceMultiplicityOffsetY");
            this.srcMultiplicityOffset.y = s.length() == 0 ? 0 : new Integer(s);
            s = h.readAttr("targetMultiplicityOffsetX");
            this.trgMultiplicityOffset.x = s.length() == 0 ? 0 : new Integer(s);
            s = h.readAttr("targetMultiplicityOffsetY");
            this.trgMultiplicityOffset.y = s.length() == 0 ? 0 : new Integer(s);
            h.close();
            if (this.isLine()) {
                Line line = this.toLine();
                Point p = line.getAnchor();
                if (this.x == 0 && this.y == 0 || p.x == this.x && p.y == this.y) {
                    this.hasDefaultAnchor = true;
                } else {
                    this.hasDefaultAnchor = false;
                    this.setAnchor(new Point(this.x, this.y));
                }
            } else if (h.getDocumentVersion().equals("1.0")) {
                if (loopW != 0 && loopH != 0) {
                    this.anchor = new Point(this.x, this.y);
                    this.anchorID = 1;
                    this.hasDefaultAnchor = false;
                    this.setXY(this.x, this.y);
                    this.setWidth(loopW);
                    this.setHeight(loopH);
                } else {
                    this.setAnchor(new Point(this.x, this.y));
                    this.hasDefaultAnchor = true;
                }
            } else {
                this.setAnchor(new Point(this.x, this.y));
                this.hasDefaultAnchor = true;
            }
        }
        h.enrichObject(this.lArc);
        h.close();
    }
}

