/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.attribute.impl.CondTuple;
import agg.cons.AtomConstraint;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdRule;
import agg.editor.impl.EdTypeSet;
import agg.util.XMLHelper;
import agg.xt_basis.Graph;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import java.util.Enumeration;
import java.util.Vector;

public class EdAtomic
extends EdRule {
    protected OrdinaryMorphism morph;
    private Vector conclusions;
    protected boolean isParent;
    protected EdAtomic parent;

    public EdAtomic(AtomConstraint a, EdTypeSet ty, String name) {
        super(ty);
        this.eLeft = new EdGraph(a.getOriginal(), this.typeSet);
        this.eRight = new EdGraph(a.getImage(), this.typeSet);
        this.morph = a;
        this.morph.addObserver(this.eLeft);
        this.morph.addObserver(this.eRight);
        if (name != null && !name.equals("")) {
            a.setAtomicName(name);
        }
        this.conclusions = new Vector(1);
        this.conclusions.addElement(this);
        this.isParent = true;
        this.parent = this;
        Enumeration e = a.getConclusions();
        e.nextElement();
        while (e.hasMoreElements()) {
            AtomConstraint c = (AtomConstraint)e.nextElement();
            this.createNextConclusion(c);
        }
    }

    private EdAtomic(EdGraph orig, EdGraph img, AtomConstraint a, EdTypeSet ty) {
        super(ty);
        this.eLeft = orig;
        this.eRight = img;
        this.morph = a;
        this.morph.addObserver(this.eLeft);
        this.morph.addObserver(this.eRight);
        this.conclusions = new Vector(1);
        this.conclusions.addElement(this);
        this.isParent = true;
        this.parent = this;
    }

    public OrdinaryMorphism getMorph() {
        return this.morph;
    }

    public Rule getBasisRule() {
        return null;
    }

    public AtomConstraint getBasisAtomic() {
        return (AtomConstraint)this.morph;
    }

    public EdAtomic createNextConclusion(String name) {
        Graph g = new Graph(this.eLeft.getBasisGraph().getTypeSet());
        EdGraph img = new EdGraph(g, this.eLeft.getTypeSet());
        AtomConstraint a = ((AtomConstraint)this.morph).createNextConclusion(img.getBasisGraph());
        EdAtomic conclusion = new EdAtomic(this.eLeft, img, a, this.eLeft.getTypeSet());
        conclusion.isParent = false;
        conclusion.parent = this;
        conclusion.setGraGra(this.getGraGra());
        conclusion.getMorph().setName(name);
        this.conclusions.addElement(conclusion);
        this.isParent = true;
        if (this.getGraGra() != null) {
            this.getGraGra().setChanged(true);
        }
        return conclusion;
    }

    public EdAtomic createNextConclusion(AtomConstraint a) {
        EdGraph img = new EdGraph(a.getTarget(), this.eLeft.getTypeSet());
        EdAtomic conclusion = new EdAtomic(this.eLeft, img, a, this.eLeft.getTypeSet());
        conclusion.isParent = false;
        conclusion.parent = this;
        if (this.getGraGra() != null) {
            conclusion.setGraGra(this.getGraGra());
        }
        this.conclusions.addElement(conclusion);
        if (this.getGraGra() != null) {
            this.getGraGra().setChanged(true);
        }
        return conclusion;
    }

    public EdAtomic createNextConclusion(EdGraph img) {
        AtomConstraint a = ((AtomConstraint)this.morph).createNextConclusion(img.getBasisGraph());
        EdAtomic conclusion = new EdAtomic(a, this.eLeft.getTypeSet(), "");
        conclusion.isParent = false;
        conclusion.parent = this;
        if (this.getGraGra() != null) {
            conclusion.setGraGra(this.getGraGra());
        }
        this.conclusions.addElement(conclusion);
        if (this.getGraGra() != null) {
            this.getGraGra().setChanged(true);
        }
        return conclusion;
    }

    public EdAtomic addConclusion(EdAtomic conclusion) {
        conclusion.isParent = false;
        conclusion.parent = this;
        if (this.getGraGra() != null) {
            conclusion.setGraGra(this.getGraGra());
        }
        this.conclusions.addElement(conclusion);
        if (this.getGraGra() != null) {
            this.getGraGra().setChanged(true);
        }
        return conclusion;
    }

    public void destroyConclusion(EdAtomic conclusion) {
        if (this.conclusions.contains(conclusion)) {
            this.conclusions.removeElement(conclusion);
            this.getBasisAtomic().destroyConclusion(conclusion.getBasisAtomic());
            if (this.getGraGra() != null) {
                this.getGraGra().setChanged(true);
            }
        }
    }

    public boolean removeConclusion(EdAtomic conclusion) {
        if (this.conclusions.contains(conclusion)) {
            this.conclusions.removeElement(conclusion);
            if (this.getGraGra() != null) {
                this.getGraGra().setChanged(true);
            }
            return true;
        }
        return false;
    }

    public void removeConclusions() {
        for (int i = this.conclusions.size() - 1; i >= 0; --i) {
            EdAtomic conclusion = (EdAtomic)this.conclusions.elementAt(i);
            this.removeConclusion(conclusion);
        }
    }

    public Vector getConclusions() {
        return this.conclusions;
    }

    public EdAtomic getConclusion(int indx) {
        if (indx >= 0 && indx < this.conclusions.size()) {
            return (EdAtomic)this.conclusions.elementAt(indx);
        }
        return null;
    }

    public Vector getAttrConditions() {
        Vector<String> conds = new Vector<String>(1);
        CondTuple ct = (CondTuple)this.morph.getAttrContext().getConditions();
        for (int i = 0; i < ct.getSize(); ++i) {
            conds.add(ct.getCondMemberAt(i).getExprAsText());
        }
        return conds;
    }

    public boolean isParent() {
        return this.isParent;
    }

    public EdAtomic getParent() {
        return this.parent;
    }

    public void XwriteObject(XMLHelper h) {
        h.addObject("", this.eLeft, true);
        if (this.conclusions.size() > 0) {
            for (int i = 0; i < this.conclusions.size(); ++i) {
                EdAtomic concl = (EdAtomic)this.conclusions.elementAt(i);
                h.addObject("", concl.getRight(), true);
            }
        }
    }

    public void XreadObject(XMLHelper h) {
        h.enrichObject(this.eLeft);
        for (int i = 0; i < this.conclusions.size(); ++i) {
            EdAtomic concl = (EdAtomic)this.conclusions.elementAt(i);
            h.enrichObject(concl.getRight());
        }
    }
}

