/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.attribute.AttrContext;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.cons.AtomConstraint;
import agg.cons.Formula;
import agg.editor.impl.EdArc;
import agg.editor.impl.EdAtomic;
import agg.editor.impl.EdConstraint;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNAC;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdRule;
import agg.editor.impl.EdType;
import agg.editor.impl.EdTypeSet;
import agg.layout.LayoutPattern;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.Arc;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import agg.xt_basis.TypeError;
import agg.xt_basis.TypeException;
import java.awt.Color;
import java.awt.Point;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdGraGra
implements XMLObject {
    private String name;
    private GraGra bGraGra;
    private EdTypeSet typeSet;
    private EdGraph eGraph;
    private transient EdGraph startGraph;
    private transient Hashtable undoGraphs;
    private Vector eGraphs;
    private Vector eRules;
    private Vector eAtomics;
    private Vector eConstraints;
    private String dirName = "";
    private String fileName = "";
    private boolean isChanged = false;
    private Hashtable<Type, Vector<LayoutPattern>> layoutPatterns;

    public EdGraGra(String name) {
        this.name = name;
        this.dirName = "";
        this.fileName = "";
        this.bGraGra = BaseFactory.theFactory().createGraGra();
        this.bGraGra.setName(name);
        this.bGraGra.setDirName("");
        this.bGraGra.setFileName("");
        this.typeSet = new EdTypeSet(this.bGraGra);
        this.eGraph = new EdGraph(this.bGraGra.getGraph(), this.typeSet);
        this.eGraph.setGraGra(this);
        this.eGraphs = new Vector();
        this.eGraphs.add(this.eGraph);
        this.startGraph = null;
        this.eRules = new Vector();
        this.createRule("Rule");
        this.eAtomics = new Vector();
        this.eConstraints = new Vector();
        this.undoGraphs = new Hashtable(5);
        this.layoutPatterns = new Hashtable();
    }

    public EdGraGra(GraGra basis) {
        this.bGraGra = basis;
        this.bGraGra.setDirName("");
        this.bGraGra.setFileName("");
        this.name = basis.getName();
        this.dirName = "";
        this.fileName = "";
        this.typeSet = new EdTypeSet(this.bGraGra);
        this.eGraphs = new Vector();
        Enumeration e = this.bGraGra.getGraphs();
        while (e.hasMoreElements()) {
            EdGraph g = new EdGraph((Graph)e.nextElement(), this.typeSet);
            g.setGraGra(this);
            this.eGraphs.add(g);
        }
        this.eGraph = (EdGraph)this.eGraphs.firstElement();
        this.startGraph = null;
        this.eRules = this.createRules(this.bGraGra.getRules());
        this.eAtomics = this.createAtomics(this.bGraGra.getAtomics());
        this.eConstraints = this.createConstraints(this.bGraGra.getConstraints());
        this.undoGraphs = new Hashtable(5);
        this.layoutPatterns = new Hashtable();
    }

    public void dispose() {
        this.eRules.clear();
        this.eAtomics.clear();
        this.eConstraints.clear();
        if (this.startGraph != null) {
            this.startGraph.dispose();
        }
        for (int i = 0; i < this.undoGraphs.size(); ++i) {
            EdGraph ug = (EdGraph)this.undoGraphs.get(i);
            if (ug == null) continue;
            ug.dispose();
        }
        this.undoGraphs.clear();
        this.eGraphs.clear();
        this.eGraph.dispose();
        BaseFactory.theFactory().destroyGraGra(this.bGraGra);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String str) {
        this.name = str;
        this.bGraGra.setName(str);
    }

    public String getDirName() {
        return this.dirName;
    }

    public void setDirName(String str) {
        this.dirName = str;
        this.bGraGra.setDirName(str);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String str) {
        this.fileName = str;
        this.bGraGra.setFileName(str);
    }

    public GraGra getBasisGraGra() {
        return this.bGraGra;
    }

    public void setBasisGraGra(GraGra gra) {
        this.bGraGra = gra;
    }

    public EdGraph getGraph() {
        return this.eGraph;
    }

    public int getIndexOfGraph() {
        return this.eGraphs.indexOf(this.eGraph);
    }

    public Vector getGraphs() {
        return this.eGraphs;
    }

    public EdGraph getTypeGraph() {
        return this.typeSet.getTypeGraph();
    }

    public Vector getRules() {
        return this.eRules;
    }

    public Vector getRulesForLayer(int l) {
        Vector<EdRule> v = new Vector<EdRule>(5);
        for (int i = 0; i < this.eRules.size(); ++i) {
            EdRule r = (EdRule)this.eRules.get(i);
            if (r.getBasisRule().getLayer() != l) continue;
            v.add(r);
        }
        return v;
    }

    public Vector getAtomics() {
        return this.eAtomics;
    }

    public Vector getAtomicNames() {
        Vector<String> ret = new Vector<String>();
        for (int i = 0; i < this.eAtomics.size(); ++i) {
            ret.add(((EdAtomic)this.eAtomics.get(i)).getBasisAtomic().getAtomicName());
        }
        return ret;
    }

    public Vector getConstraints() {
        return this.eConstraints;
    }

    public Vector getConstraintsForLayer(int l) {
        Vector<EdConstraint> v = new Vector<EdConstraint>(5);
        for (int i = 0; i < this.eConstraints.size(); ++i) {
            EdConstraint c = (EdConstraint)this.eConstraints.get(i);
            Vector layer = c.getBasisConstraint().getLayer();
            for (int j = 0; j < layer.size(); ++j) {
                if ((Integer)layer.get(j) != l) continue;
                v.add(c);
            }
        }
        return v;
    }

    public Vector getGraTraOptions() {
        return this.bGraGra.getGraTraOptions();
    }

    public boolean addGraph(EdGraph g) {
        if (g.getTypeSet().getBasisTypeSet().compareTo(this.typeSet.getBasisTypeSet())) {
            if (this.bGraGra.addGraph(g.getBasisGraph())) {
                Vector v = g.getBasisGraph().getUsedTypes();
                this.bGraGra.getTypeSet().adaptTypes(v.elements(), false);
                this.typeSet.refreshTypes();
                g.update();
                g.setGraGra(this);
                this.eGraphs.add(g);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeGraph(EdGraph g) {
        if (this.bGraGra == null) {
            return false;
        }
        if (g != null && g.getBasisGraph() != null && this.bGraGra.removeGraph(g.getBasisGraph())) {
            this.eGraphs.removeElement(g);
            this.isChanged = true;
            return true;
        }
        return false;
    }

    public synchronized boolean importTypeGraph(EdGraph g, boolean rewrite) {
        if (!g.isTypeGraph()) {
            return false;
        }
        boolean selectAll = false;
        if (this.typeSet.getTypeGraph() == null) {
            this.typeSet.createTypeGraph();
            selectAll = true;
        }
        if (this.bGraGra.importTypeGraph(g.getBasisGraph(), rewrite)) {
            this.typeSet.refreshTypes();
            this.typeSet.getTypeGraph().updateGraph(true, true);
            if (selectAll) {
                this.typeSet.getTypeGraph().selectAll();
            }
            this.typeSet.getTypeGraph().setLayout(g, true);
            this.update(true);
            return true;
        }
        return false;
    }

    public synchronized boolean importGraph(EdGraph g) {
        if (this.bGraGra.importGraph(g.getBasisGraph())) {
            this.typeSet.refreshTypes();
            int indx = this.eGraphs.indexOf(this.eGraph);
            if (indx != -1) {
                this.eGraphs.remove(this.eGraph);
                this.eGraph.dispose();
            }
            EdGraph impG = new EdGraph(this.bGraGra.getGraph(), this.typeSet, true);
            impG.setGraGra(this);
            impG.setLayout(g, true);
            if (indx != -1) {
                this.eGraphs.add(indx, impG);
            } else {
                this.eGraphs.add(impG);
            }
            this.eGraph = impG;
            return true;
        }
        return false;
    }

    public synchronized boolean addImportGraph(EdGraph g) {
        if (this.bGraGra.addImportGraph(g.getBasisGraph())) {
            this.typeSet.refreshTypes();
            EdGraph impG = new EdGraph(this.bGraGra.getGraph(), this.typeSet, true);
            impG.setGraGra(this);
            impG.setLayout(g, true);
            this.eGraphs.add(impG);
            this.eGraph = impG;
            return true;
        }
        return false;
    }

    public synchronized boolean importGraph(EdGraph g, boolean adapt) {
        if (this.bGraGra.importGraph(g.getBasisGraph(), adapt)) {
            this.typeSet.refreshTypes(true);
            int indx = this.eGraphs.indexOf(this.eGraph);
            if (indx != -1) {
                this.eGraphs.remove(this.eGraph);
            }
            EdGraph impG = new EdGraph(this.bGraGra.getGraph(), this.typeSet, true);
            impG.setGraGra(this);
            impG.setLayout(g, true);
            if (indx != -1) {
                this.eGraphs.add(indx, impG);
            } else {
                this.eGraphs.add(impG);
            }
            this.eGraph = impG;
            return true;
        }
        return false;
    }

    public synchronized boolean addImportGraph(EdGraph g, boolean adapt) {
        if (this.bGraGra.importGraph(g.getBasisGraph(), adapt)) {
            this.typeSet.refreshTypes(true);
            EdGraph impG = new EdGraph(this.bGraGra.getGraph(), this.typeSet, true);
            impG.setGraGra(this);
            impG.setLayout(g, true);
            this.eGraphs.add(impG);
            this.eGraph = impG;
            return true;
        }
        return false;
    }

    public synchronized boolean resetGraph() {
        if (this.startGraph == null || this.startGraph == this.eGraph) {
            return false;
        }
        if (this.typeSet != null && this.startGraph.getTypeSet() != null && this.typeSet.equals(this.startGraph.getTypeSet())) {
            EdGraph eg = this.startGraph.copy();
            eg.setGraGra(this);
            if (this.bGraGra.resetGraph(eg.getBasisGraph())) {
                int indx = this.eGraphs.indexOf(this.eGraph);
                this.eGraphs.remove(this.eGraph);
                this.eGraph = eg;
                if (indx != -1) {
                    this.eGraphs.add(indx, this.eGraph);
                } else {
                    this.eGraphs.add(this.eGraph);
                }
                this.isChanged = true;
                return true;
            }
            return false;
        }
        return false;
    }

    public synchronized boolean resetGraph(EdGraph g) {
        if (g.getGraGra() == this) {
            if (this.bGraGra.resetGraph(g.getBasisGraph())) {
                int indxOther = this.eGraphs.indexOf(g);
                int indx = this.eGraphs.indexOf(this.eGraph);
                if (indxOther == -1 && indx != -1) {
                    this.eGraphs.remove(this.eGraph);
                }
                this.eGraph = g;
                this.eGraph.setGraGra(this);
                if (!this.eGraphs.contains(this.eGraph)) {
                    if (indx != -1) {
                        this.eGraphs.add(indx, this.eGraph);
                    } else {
                        this.eGraphs.add(this.eGraph);
                    }
                }
                this.isChanged = true;
                return true;
            }
            return false;
        }
        return false;
    }

    public synchronized boolean resetGraphWithoutGuarantee(EdGraph g) {
        if (g != null) {
            if (this.bGraGra.resetGraphWithoutGuarantee(g.getBasisGraph())) {
                int indx = this.eGraphs.indexOf(this.eGraph);
                this.eGraphs.remove(this.eGraph);
                this.eGraph = new EdGraph(this.bGraGra.getGraph(), true);
                this.eGraph.setLayout(g, true);
                this.eGraph.setGraGra(this);
                if (indx != -1) {
                    this.eGraphs.add(indx, this.eGraph);
                } else {
                    this.eGraphs.add(this.eGraph);
                }
                this.isChanged = true;
                return true;
            }
            return false;
        }
        return false;
    }

    public EdGraph getStartGraph() {
        return this.startGraph;
    }

    public void destroyStartGraph() {
        if (this.startGraph != null) {
            this.startGraph.dispose();
        }
        this.startGraph = null;
    }

    public void setUndoGraph(EdGraph g) {
        if (g == null) {
            EdGraph ug = (EdGraph)this.undoGraphs.get(this.eGraph);
            if (ug != null) {
                this.undoGraphs.remove(this.eGraph);
                ug.dispose();
            }
        } else if (this.typeSet != null && g.getTypeSet() != null && this.typeSet.equals(g.getTypeSet()) && this.eGraph != null) {
            this.undoGraphs.put(this.eGraph, g);
        }
    }

    public EdGraph getUndoGraph() {
        return (EdGraph)this.undoGraphs.get(this.eGraph);
    }

    public void destroyUndoGraph() {
        EdGraph ug = (EdGraph)this.undoGraphs.get(this.eGraph);
        if (ug != null) {
            this.undoGraphs.remove(this.eGraph);
            ug.dispose();
        }
    }

    public Collection setLevelOfTypeGraphCheck(int level) {
        Collection baseResult = this.getBasisGraGra().setLevelOfTypeGraphCheck(level);
        WeakHashMap base2ed = new WeakHashMap();
        this.putAllGraphObjectsInMap(base2ed, this.eGraph);
        this.putAllGraphObjectsInMap(base2ed, this.typeSet.getTypeGraph());
        for (EdRule actRule : this.eRules) {
            this.putAllGraphObjectsInMap(base2ed, actRule.getLeft());
            this.putAllGraphObjectsInMap(base2ed, actRule.getRight());
            for (EdNAC actNAC : actRule.getNACs()) {
                this.putAllGraphObjectsInMap(base2ed, actNAC);
            }
        }
        for (EdAtomic actAtomic : this.eAtomics) {
            this.putAllGraphObjectsInMap(base2ed, actAtomic.getLeft());
            Iterator subIter = actAtomic.getConclusions().iterator();
            while (subIter.hasNext()) {
                EdGraph actGraph = ((EdAtomic)subIter.next()).getRight();
                this.putAllGraphObjectsInMap(base2ed, actGraph);
            }
        }
        if (baseResult.isEmpty()) {
            return baseResult;
        }
        for (TypeError baseError : baseResult) {
            GraphObject baseObject = baseError.getGraphObject();
            if (baseObject == null) continue;
            EdGraphObject edObject = (EdGraphObject)base2ed.get(baseObject);
            edObject.setErrorMode(true);
        }
        this.update();
        return baseResult;
    }

    public void disableTypeGraphCheck() {
        this.typeSet.getBasisTypeSet().setLevelOfTypeGraphCheck(0);
    }

    public int getLevelOfTypeGraphCheck() {
        return this.typeSet.getBasisTypeSet().getLevelOfTypeGraphCheck();
    }

    private void putAllGraphObjectsInMap(Map map, EdGraph graph) {
        for (EdArc actArc : graph.getArcs()) {
            map.put(actArc.getBasisArc(), actArc);
            actArc.setErrorMode(false);
        }
        for (EdNode actNode : graph.getNodes()) {
            map.put(actNode.getBasisNode(), actNode);
            actNode.setErrorMode(false);
        }
    }

    public EdRule createRule(String name) {
        if (name != null) {
            EdRule eRule = new EdRule(this.bGraGra.createRule(), this.typeSet);
            eRule.getBasisRule().setName(name);
            eRule.setGraGra(this);
            eRule.getLeft().setEditable(this.eGraph.isEditable());
            eRule.getRight().setEditable(this.eGraph.isEditable());
            this.eRules.addElement(eRule);
            this.isChanged = true;
            return eRule;
        }
        return null;
    }

    public boolean addRule(EdRule r) {
        if (r.getTypeSet().getBasisTypeSet().compareTo(this.typeSet.getBasisTypeSet())) {
            if (this.bGraGra.addRule(r.getBasisRule())) {
                Vector v = r.getBasisRule().getUsedTypes();
                this.bGraGra.getTypeSet().adaptTypes(v.elements(), false);
                this.typeSet.refreshTypes();
                r.update();
                this.eRules.add(r);
                r.setGraGra(this);
                return true;
            }
            return false;
        }
        return false;
    }

    public EdGraph cloneGraph() {
        return this.cloneGraph(true);
    }

    public EdGraph cloneGraph(boolean doInsert) {
        Graph graph = this.bGraGra.cloneGraph();
        if (graph == null) {
            return null;
        }
        graph.setName(this.eGraph.getBasisGraph().getName() + "_clone");
        EdGraph clone = new EdGraph(graph, this.typeSet);
        clone.setGraGra(this);
        clone.setLayout(this.eGraph, true);
        if (doInsert) {
            this.bGraGra.addGraph(graph);
            this.eGraphs.add(clone);
            this.isChanged = true;
        }
        return clone;
    }

    public EdRule cloneRule(EdRule r) {
        return this.cloneRule(r, true);
    }

    public EdRule cloneRule(EdRule r, boolean doInsert) {
        Rule rule = this.bGraGra.createRule();
        if (rule == null) {
            return null;
        }
        rule.setName(r.getBasisRule().getName() + "_clone");
        rule.setLayer(r.getBasisRule().getLayer());
        EdRule ruleClone = new EdRule(rule, this.typeSet);
        this.bGraGra.getRulesVec().removeElement(rule);
        if (doInsert) {
            this.bGraGra.getRulesVec().insertElementAt(rule, this.bGraGra.getRulesVec().indexOf(r.getBasisRule()) + 1);
            this.eRules.insertElementAt(ruleClone, this.eRules.indexOf(r) + 1);
            this.isChanged = true;
        }
        AttrContext ac = ruleClone.getBasisRule().getAttrContext();
        VarTuple avt = (VarTuple)ac.getVariables();
        AttrContext acOther = r.getBasisRule().getAttrContext();
        VarTuple avtOther = (VarTuple)acOther.getVariables();
        for (int i = 0; i < avtOther.getSize(); ++i) {
            VarMember varOther = avtOther.getVarMemberAt(i);
            VarMember var = avt.getVarMemberAt(varOther.getName());
            if (var != null) {
                var.setMark(varOther.getMark());
                var.setInputParameter(varOther.isInputParameter());
                continue;
            }
            avt.declare(varOther.getHandler(), varOther.getDeclaration().getTypeName(), varOther.getName());
            var = avt.getVarMemberAt(varOther.getName());
            if (var == null) continue;
            var.setMark(varOther.getMark());
            var.setInputParameter(varOther.isInputParameter());
        }
        Graph lgraph = r.getBasisRule().getLeft();
        Graph rgraph = r.getBasisRule().getRight();
        Graph left = rule.getLeft();
        Graph right = rule.getRight();
        Hashtable<GraphObject, GraphObject> ltable = new Hashtable<GraphObject, GraphObject>();
        Hashtable<GraphObject, GraphObject> rtable = new Hashtable<GraphObject, GraphObject>();
        Enumeration rnodes = rgraph.getNodes();
        while (rnodes.hasMoreElements()) {
            Node rNode = (Node)rnodes.nextElement();
            Node itsRNode = null;
            try {
                itsRNode = right.createNode(rNode);
                rtable.put(rNode, itsRNode);
                EdNode n = r.getRight().findNode(rNode);
                EdNode nClone = ruleClone.getRight().addNode(right, itsRNode, n.getType());
                nClone.setXY(n.getX(), n.getY());
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
        }
        Enumeration lnodes = lgraph.getNodes();
        while (lnodes.hasMoreElements()) {
            Node lNode = (Node)lnodes.nextElement();
            Node itsLNode = null;
            try {
                itsLNode = left.createNode(lNode);
                ltable.put(lNode, itsLNode);
                EdNode n = r.getLeft().findNode(lNode);
                EdNode nClone = ruleClone.getLeft().addNode(left, itsLNode, n.getType());
                nClone.setXY(n.getX(), n.getY());
                GraphObject rn = r.getBasisRule().getImage(lNode);
                if (rn == null) continue;
                rule.addMapping(itsLNode, (GraphObject)rtable.get(rn));
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
        }
        Enumeration rarcs = rgraph.getArcs();
        while (rarcs.hasMoreElements()) {
            Arc rArc = (Arc)rarcs.nextElement();
            Node itsRSource = (Node)rtable.get(rArc.getSource());
            Node itsRTarget = (Node)rtable.get(rArc.getTarget());
            Arc itsRArc = null;
            try {
                itsRArc = right.createArc(rArc, itsRSource, itsRTarget);
                rtable.put(rArc, itsRArc);
                EdArc a = r.getRight().findArc(rArc);
                EdArc aClone = ruleClone.getRight().addArc(right, itsRArc, a.getType());
                if (!a.hasAnchor()) continue;
                aClone.setAnchor(new Point(a.getAnchor()));
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
        }
        Enumeration larcs = lgraph.getArcs();
        while (larcs.hasMoreElements()) {
            Arc lArc = (Arc)larcs.nextElement();
            Node itsLSource = (Node)ltable.get(lArc.getSource());
            Node itsLTarget = (Node)ltable.get(lArc.getTarget());
            Arc itsLArc = null;
            try {
                itsLArc = left.createArc(lArc, itsLSource, itsLTarget);
                ltable.put(lArc, itsLArc);
                GraphObject ra = r.getBasisRule().getImage(lArc);
                if (ra != null) {
                    rule.addMapping(itsLArc, (GraphObject)rtable.get(ra));
                }
                EdArc a = r.getLeft().findArc(lArc);
                EdArc aClone = ruleClone.getLeft().addArc(left, itsLArc, a.getType());
                if (!a.hasAnchor()) continue;
                aClone.setAnchor(new Point(a.getAnchor()));
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
        }
        Enumeration nacs = r.getNACs().elements();
        while (nacs.hasMoreElements()) {
            Arc itsNACArc;
            EdNAC nacClone;
            EdNAC aNAC = (EdNAC)nacs.nextElement();
            OrdinaryMorphism aNACMorph = aNAC.getMorphism();
            Graph aNACGraph = aNAC.getBasisGraph();
            EdNAC nacCloneGraph = nacClone = ruleClone.createNAC(aNACGraph.getName(), false);
            OrdinaryMorphism itsNACMorph = nacClone.getMorphism();
            Graph itsNACGraph = nacCloneGraph.getBasisGraph();
            Hashtable<GraphObject, GraphObject> nactable = new Hashtable<GraphObject, GraphObject>();
            Enumeration aNACNodes = aNACGraph.getNodes();
            while (aNACNodes.hasMoreElements()) {
                Node nacNode = (Node)aNACNodes.nextElement();
                Node itsNACNode = null;
                try {
                    itsNACNode = itsNACGraph.createNode(nacNode);
                    nactable.put(nacNode, itsNACNode);
                    EdNode n = aNAC.findNode(nacNode);
                    EdNode nClone = nacCloneGraph.addNode(itsNACGraph, itsNACNode, n.getType());
                    nClone.setXY(n.getX(), n.getY());
                }
                catch (TypeException e) {
                    e.printStackTrace();
                }
            }
            Enumeration aNACArcs = aNACGraph.getArcs();
            while (aNACArcs.hasMoreElements()) {
                Arc nacArc = (Arc)aNACArcs.nextElement();
                Node itsNACSource = (Node)nactable.get(nacArc.getSource());
                Node itsNACTarget = (Node)nactable.get(nacArc.getTarget());
                itsNACArc = null;
                try {
                    itsNACArc = itsNACGraph.createArc(nacArc, itsNACSource, itsNACTarget);
                    nactable.put(nacArc, itsNACArc);
                    EdArc a = aNAC.findArc(nacArc);
                    EdArc aClone = nacCloneGraph.addArc(itsNACGraph, itsNACArc, a.getType());
                    if (!a.hasAnchor()) continue;
                    aClone.setAnchor(new Point(a.getAnchor()));
                }
                catch (TypeException e) {
                    e.printStackTrace();
                }
            }
            lnodes = lgraph.getNodes();
            while (lnodes.hasMoreElements()) {
                Node lNode = (Node)lnodes.nextElement();
                GraphObject nacNode = aNACMorph.getImage(lNode);
                if (nacNode == null) continue;
                Node itsLNode = (Node)ltable.get(lNode);
                Node itsNACNode = (Node)nactable.get(nacNode);
                itsNACMorph.addMapping(itsLNode, itsNACNode);
            }
            larcs = lgraph.getArcs();
            while (larcs.hasMoreElements()) {
                Arc lArc = (Arc)larcs.nextElement();
                GraphObject nacArc = aNACMorph.getImage(lArc);
                if (nacArc == null) continue;
                Arc itsLArc = (Arc)ltable.get(lArc);
                itsNACArc = (Arc)nactable.get(nacArc);
                itsNACMorph.addMapping(itsLArc, itsNACArc);
            }
        }
        CondTuple act = (CondTuple)ac.getConditions();
        CondTuple actOther = (CondTuple)acOther.getConditions();
        for (int i = 0; i < actOther.getSize(); ++i) {
            CondMember condOther = actOther.getCondMemberAt(i);
            CondMember cond = (CondMember)act.addCondition(condOther.getExprAsText());
            cond.setMark(condOther.getMark());
        }
        ruleClone.setGraGra(this);
        ruleClone.update();
        ruleClone.getLeft().setEditable(this.eGraph.isEditable());
        ruleClone.getRight().setEditable(this.eGraph.isEditable());
        return ruleClone;
    }

    public void sortRulesByLayer() {
        Vector v = (Vector)this.eRules.clone();
        this.eRules.removeAllElements();
        this.bGraGra.sortRulesByLayer();
        Vector rules = this.bGraGra.getRulesVec();
        block0: for (int i = 0; i < rules.size(); ++i) {
            Rule r = (Rule)rules.elementAt(i);
            for (int j = 0; j < v.size(); ++j) {
                EdRule er = (EdRule)v.elementAt(j);
                if (!er.getBasisRule().equals(r)) continue;
                this.eRules.addElement(er);
                continue block0;
            }
        }
        v.removeAllElements();
        v = null;
    }

    public void sortConstraintsByLayer() {
        Vector v = (Vector)this.eConstraints.clone();
        this.eConstraints.removeAllElements();
        this.bGraGra.sortConstraintsByLayer();
        Vector constraints = this.bGraGra.getConstraintsVec();
        block0: for (int i = 0; i < constraints.size(); ++i) {
            Formula f = (Formula)constraints.elementAt(i);
            for (int j = 0; j < v.size(); ++j) {
                EdConstraint c = (EdConstraint)v.elementAt(j);
                if (!c.getBasisConstraint().equals(f)) continue;
                this.eConstraints.addElement(c);
                continue block0;
            }
        }
        v.removeAllElements();
        v = null;
    }

    public EdAtomic createAtomic(String name) {
        EdAtomic e = null;
        if (name != null) {
            e = new EdAtomic(this.bGraGra.createAtomic("Conclusion"), this.typeSet, name);
            e.setGraGra(this);
            e.getLeft().setEditable(this.eGraph.isEditable());
            e.getRight().setEditable(this.eGraph.isEditable());
            this.eAtomics.addElement(e);
            this.isChanged = true;
        }
        return e;
    }

    public boolean addAtomic(EdAtomic c) {
        if (c.getTypeSet().getBasisTypeSet().compareTo(this.typeSet.getBasisTypeSet())) {
            if (this.bGraGra.addAtomic(c.getBasisAtomic())) {
                Vector v = c.getBasisAtomic().getUsedTypes();
                this.bGraGra.getTypeSet().adaptTypes(v.elements(), false);
                this.typeSet.refreshTypes();
                c.update();
                c.setGraGra(this);
                c.getLeft().setEditable(this.eGraph.isEditable());
                c.getRight().setEditable(this.eGraph.isEditable());
                this.eAtomics.addElement(c);
                this.isChanged = true;
                return true;
            }
            return false;
        }
        return false;
    }

    public EdConstraint createConstraint(String name) {
        EdConstraint e = null;
        if (name != null) {
            e = new EdConstraint(this.bGraGra.createConstraint(name), name);
            e.setVarSet(this.getBasisGraGra().getAtomicsVec(), this.getAtomicNames());
            e.setGraGra(this);
            this.eConstraints.addElement(e);
            this.isChanged = true;
        }
        return e;
    }

    public boolean addConstraint(EdConstraint c) {
        if (this.bGraGra.addConstraint(c.getBasisConstraint())) {
            c.setVarSet(this.getBasisGraGra().getAtomicsVec(), this.getAtomicNames());
            c.setGraGra(this);
            this.eConstraints.addElement(c);
            this.isChanged = true;
            return true;
        }
        return false;
    }

    public Vector createRules(Enumeration basisRules) {
        Vector<EdRule> rules = new Vector<EdRule>();
        while (basisRules.hasMoreElements()) {
            EdRule r = new EdRule((Rule)basisRules.nextElement(), this.typeSet);
            r.setGraGra(this);
            r.getLeft().setEditable(this.eGraph.isEditable());
            r.getRight().setEditable(this.eGraph.isEditable());
            rules.addElement(r);
        }
        return rules;
    }

    public Vector createAtomics(Enumeration basisAtomics) {
        Vector<EdAtomic> r = new Vector<EdAtomic>();
        while (basisAtomics.hasMoreElements()) {
            EdAtomic a = new EdAtomic((AtomConstraint)basisAtomics.nextElement(), this.typeSet, "");
            a.setGraGra(this);
            a.getLeft().setEditable(this.eGraph.isEditable());
            a.getRight().setEditable(this.eGraph.isEditable());
            r.addElement(a);
        }
        return r;
    }

    public Vector createConstraints(Enumeration formulas) {
        Vector<EdConstraint> r = new Vector<EdConstraint>();
        while (formulas.hasMoreElements()) {
            r.addElement(new EdConstraint((Formula)formulas.nextElement(), ""));
        }
        return r;
    }

    public EdRule getRule(int i) {
        return (EdRule)this.eRules.elementAt(i);
    }

    public EdRule getRule(Rule r) {
        for (int i = 0; i < this.eRules.size(); ++i) {
            EdRule er = (EdRule)this.eRules.elementAt(i);
            if (!er.getBasisRule().equals(r)) continue;
            return er;
        }
        return null;
    }

    public EdAtomic getAtomic(int i) {
        return (EdAtomic)this.eAtomics.elementAt(i);
    }

    public EdConstraint getConstraint(int i) {
        return (EdConstraint)this.eConstraints.elementAt(i);
    }

    public void removeTypeGraph() {
        if (this.bGraGra == null) {
            return;
        }
        if (this.typeSet.getTypeGraph() == null) {
            return;
        }
        this.typeSet.removeTypeGraph();
    }

    public void destroyTypeGraph() {
        if (this.bGraGra == null) {
            return;
        }
        if (this.typeSet.getTypeGraph() == null) {
            return;
        }
        this.bGraGra.destroyTypeGraph();
        this.typeSet.removeTypeGraph();
    }

    public void removeRule(EdRule er) {
        this.removeRule(er, false);
    }

    public boolean removeRule(EdRule er, boolean dispose) {
        if (this.bGraGra == null) {
            return false;
        }
        if (er != null && er.getBasisRule() != null && this.bGraGra.removeRule(er.getBasisRule())) {
            this.eRules.removeElement(er);
            if (dispose) {
                er.dispose();
                this.bGraGra.destroyRule(er.getBasisRule());
                er.unsetBasisRule();
            }
            this.isChanged = true;
            return true;
        }
        return false;
    }

    public void destroyRule(EdRule er) {
        if (this.bGraGra == null) {
            return;
        }
        if (er != null && er.getBasisRule() != null) {
            this.eRules.removeElement(er);
            this.bGraGra.removeRule(er.getBasisRule());
            er.dispose();
            this.bGraGra.destroyRule(er.getBasisRule());
            er.unsetBasisRule();
            this.isChanged = true;
        }
    }

    public void removeRules() {
        while (this.eRules.size() != 0) {
            this.removeRule((EdRule)this.eRules.elementAt(0));
        }
    }

    public boolean removeAtomic(EdAtomic atom) {
        if (this.bGraGra == null) {
            return false;
        }
        if (atom == null) {
            return false;
        }
        if (atom.getMorph() != null) {
            this.bGraGra.removeAtomic(atom.getBasisAtomic());
            this.eAtomics.removeElement(atom);
            this.isChanged = true;
            return true;
        }
        return false;
    }

    public void destroyAtomic(EdAtomic atom) {
        if (this.bGraGra == null) {
            return;
        }
        if (atom == null) {
            return;
        }
        if (atom.getMorph() != null) {
            if (this.eAtomics.contains(atom)) {
                this.eAtomics.removeElement(atom);
            }
            this.bGraGra.destroyAtomic(atom.getBasisAtomic());
            this.isChanged = true;
        }
    }

    public void removeAtomics() {
        while (this.eAtomics.size() != 0) {
            this.removeAtomic((EdAtomic)this.eAtomics.elementAt(0));
        }
    }

    public void destroyConstraint(EdConstraint constr) {
        if (this.bGraGra == null) {
            return;
        }
        if (constr == null) {
            return;
        }
        if (constr.getBasisConstraint() != null) {
            this.eConstraints.removeElement(constr);
            this.bGraGra.destroyConstraint(constr.getBasisConstraint());
            this.isChanged = true;
        }
    }

    public boolean removeConstraint(EdConstraint constr) {
        if (this.bGraGra == null) {
            return false;
        }
        if (constr == null) {
            return false;
        }
        if (constr.getBasisConstraint() != null) {
            this.bGraGra.removeConstraint(constr.getBasisConstraint());
            this.eConstraints.removeElement(constr);
            this.isChanged = true;
            return true;
        }
        return false;
    }

    public void removeConstraints() {
        while (this.eConstraints.size() != 0) {
            this.removeConstraint((EdConstraint)this.eConstraints.elementAt(0));
        }
    }

    public void clear() {
        this.eGraph.clearSelected();
        for (int i = 0; i < this.eRules.size(); ++i) {
            EdRule r = (EdRule)this.eRules.elementAt(i);
            if (r == null) continue;
            r.destroyMatch();
            r.setMatch(null);
            r.update();
            r.getLeft().clearSelected();
            r.getRight().clearSelected();
            for (int j = 0; j < r.getNACs().size(); ++j) {
                ((EdNAC)r.getNACs().elementAt(j)).clearSelected();
            }
        }
    }

    public synchronized void update() {
        if (this.typeSet.getTypeGraph() != null) {
            this.typeSet.getTypeGraph().setGraGra(this);
            this.typeSet.getTypeGraph().markTypeGraph(true);
            this.typeSet.getTypeGraph().updateGraph();
        }
        for (int i = 0; i < this.eGraphs.size(); ++i) {
            EdGraph g = (EdGraph)this.eGraphs.get(i);
            g.setTypeSet(this.typeSet);
            g.updateGraph();
        }
        this.updateRules();
        this.updateConstraints();
    }

    public synchronized void update(boolean attrsVisible) {
        if (this.typeSet.getTypeGraph() == null && this.typeSet.getBasisTypeSet().getTypeGraph() != null) {
            this.typeSet.createTypeGraph();
        }
        if (this.typeSet.getTypeGraph() != null) {
            this.typeSet.getTypeGraph().setGraGra(this);
            this.typeSet.getTypeGraph().markTypeGraph(true);
            this.typeSet.getTypeGraph().updateGraph();
        }
        for (int i = 0; i < this.eGraphs.size(); ++i) {
            EdGraph g = (EdGraph)this.eGraphs.get(i);
            g.setTypeSet(this.typeSet);
            g.updateGraph(attrsVisible);
        }
        this.updateRules();
        this.updateConstraints();
    }

    public synchronized void updateRules() {
        for (int i = 0; i < this.eRules.size(); ++i) {
            if ((EdRule)this.eRules.elementAt(i) == null) continue;
            EdRule er = (EdRule)this.eRules.elementAt(i);
            er.setTypeSet(this.typeSet);
            er.update();
            for (int j = 0; j < er.getNACs().size(); ++j) {
                EdNAC nac = (EdNAC)er.getNACs().elementAt(j);
                nac.setTypeSet(this.typeSet);
                nac.update();
            }
        }
    }

    public synchronized void updateConstraints() {
        int i;
        for (i = 0; i < this.eAtomics.size(); ++i) {
            EdAtomic a = this.getAtomic(i);
            if (a == null) continue;
            a.setTypeSet(this.typeSet);
            a.update();
        }
        for (i = 0; i < this.eConstraints.size(); ++i) {
            EdConstraint c = this.getConstraint(i);
            if (c == null) continue;
            c.update();
        }
    }

    public EdTypeSet getTypeSet() {
        return this.typeSet;
    }

    void setTypeSet(EdTypeSet types) {
        this.typeSet = types;
    }

    public Vector getNodeTypes() {
        return this.typeSet.getNodeTypes();
    }

    public void setNodeTypes(Vector nTypes) {
        this.typeSet.setNodeTypes(nTypes);
    }

    public Vector getArcTypes() {
        return this.typeSet.getArcTypes();
    }

    public void setArcTypes(Vector aTypes) {
        this.typeSet.setArcTypes(aTypes);
    }

    public EdType getSelectedNodeType() {
        return this.typeSet.getSelectedNodeType();
    }

    public void setSelectedNodeType(EdType et) {
        this.typeSet.setSelectedNodeType(et);
    }

    public EdType getSelectedArcType() {
        return this.typeSet.getSelectedArcType();
    }

    public void setSelectedArcType(EdType et) {
        this.typeSet.setSelectedArcType(et);
    }

    public EdType newNodeType(String name, int shape, Color color) {
        return this.typeSet.createNodeType(name, shape, color);
    }

    public EdType newNodeType(Type baseType, String name, int shape, Color color) {
        return this.typeSet.createNodeType(baseType, name, shape, color);
    }

    public EdType createDefaultNodeType(Type baseType) {
        return this.typeSet.createDefaultNodeType(baseType);
    }

    public EdType newArcType(String name, int shape, Color color) {
        return this.typeSet.createArcType(name, shape, color);
    }

    public EdType newArcType(Type baseType, String name, int shape, Color color) {
        return this.typeSet.createArcType(baseType, name, shape, color);
    }

    public EdType createDefaultArcType(Type baseType) {
        return this.typeSet.createDefaultArcType(baseType);
    }

    public void removeLayout() {
        this.typeSet.getNodeTypes().removeAllElements();
        this.typeSet.getArcTypes().removeAllElements();
        this.eGraph.getArcs().removeAllElements();
        this.eGraph.getNodes().removeAllElements();
        for (int i = 0; i < this.eRules.size(); ++i) {
            EdRule r = (EdRule)this.eRules.elementAt(i);
            if (r == null) continue;
            r.getLeft().getArcs().removeAllElements();
            r.getLeft().getNodes().removeAllElements();
            r.getRight().getArcs().removeAllElements();
            r.getRight().getNodes().removeAllElements();
            for (int j = 0; j < r.getNACs().size(); ++j) {
                EdNAC nac = (EdNAC)r.getNACs().elementAt(j);
                nac.getArcs().removeAllElements();
                nac.getNodes().removeAllElements();
            }
        }
    }

    public boolean compareTo(EdGraGra gra) {
        if (this.bGraGra == null || gra.getBasisGraGra() == null) {
            return false;
        }
        return this.bGraGra.compareTo(gra.getBasisGraGra());
    }

    public boolean compareTo(EdGraGra gra, boolean transOption) {
        if (this.bGraGra == null || gra.getBasisGraGra() == null) {
            return false;
        }
        return this.bGraGra.compareTo(gra.getBasisGraGra(), transOption);
    }

    public void setEditable(boolean b) {
        int i;
        if (this.typeSet.getTypeGraph() != null) {
            this.typeSet.getTypeGraph().setEditable(b);
        }
        this.eGraph.setEditable(b);
        for (i = 0; i < this.eRules.size(); ++i) {
            EdRule r = (EdRule)this.eRules.elementAt(i);
            r.getLeft().setEditable(b);
            r.getRight().setEditable(b);
            for (int j = 0; j < r.getNACs().size(); ++j) {
                EdNAC nac = (EdNAC)r.getNACs().elementAt(j);
                nac.setEditable(b);
            }
        }
        for (i = 0; i < this.eAtomics.size(); ++i) {
            EdAtomic a = (EdAtomic)this.eAtomics.elementAt(i);
            a.getLeft().setEditable(b);
            a.getRight().setEditable(b);
        }
    }

    public void setChanged(boolean b) {
        this.isChanged = b;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public Vector getApplicableRules(MorphCompletionStrategy strategy) {
        boolean changed = this.isChanged;
        Vector applicableRules = this.bGraGra.getApplicableRules(strategy);
        this.isChanged = changed;
        return applicableRules;
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        int j;
        h.addTopObject(this.bGraGra);
        h.openObject(this.bGraGra, this);
        Enumeration<Type> types = this.layoutPatterns.keys();
        while (types.hasMoreElements()) {
            Type t = types.nextElement();
            Vector<LayoutPattern> lpatternsVec = this.layoutPatterns.get(t);
            if (lpatternsVec == null || lpatternsVec.isEmpty()) continue;
            h.openSubTag("Layout");
            h.addObject("type", t, false);
            h.addEnumeration("", lpatternsVec.elements(), true);
            h.close();
        }
        h.close();
        for (j = 0; j < this.eGraphs.size(); ++j) {
            h.addObject("", (EdGraph)this.eGraphs.elementAt(j), true);
        }
        for (j = 0; j < this.eRules.size(); ++j) {
            h.addObject("", (EdRule)this.eRules.elementAt(j), true);
        }
        for (j = 0; j < this.getAtomics().size(); ++j) {
            h.addObject("", this.getAtomic(j), true);
        }
        for (j = 0; j < this.getConstraints().size(); ++j) {
            h.addObject("", this.getConstraint(j), true);
        }
        if (this.typeSet.getTypeGraph() != null) {
            h.addObject("", this.typeSet.getTypeGraph(), true);
        }
    }

    @Override
    public void XreadObject(XMLHelper h) {
        int j;
        h.peekObject(this.bGraGra, this);
        while (h.readSubTag("Layout")) {
            Type t = (Type)h.getObject("type", null, false);
            if (t != null) {
                EdType et = this.typeSet.getTypeForName(t);
                Enumeration en = h.getEnumeration("", null, true, "LayoutPattern");
                while (en.hasMoreElements()) {
                    h.peekElement(en.nextElement());
                    LayoutPattern lp = new LayoutPattern(t);
                    h.loadObject(lp);
                    this.addLayoutPattern(t, lp);
                    h.close();
                }
            }
            h.close();
        }
        Vector<Arc> inheritArcs = this.typeSet.getBasisTypeSet().getInheritanceArcs();
        this.createInheritancePattern(inheritArcs);
        h.close();
        for (j = 0; j < this.eGraphs.size(); ++j) {
            EdGraph g = (EdGraph)this.eGraphs.elementAt(j);
            h.enrichObject(g);
            g.setGraGra(this);
        }
        this.eGraph = (EdGraph)this.eGraphs.firstElement();
        for (j = 0; j < this.eRules.size(); ++j) {
            EdRule r = (EdRule)this.eRules.elementAt(j);
            h.enrichObject(r);
            r.setGraGra(this);
        }
        for (j = 0; j < this.getAtomics().size(); ++j) {
            h.enrichObject(this.getAtomic(j));
            for (int i = 0; i < this.getAtomic(j).getConclusions().size(); ++i) {
                EdAtomic c = (EdAtomic)this.getAtomic(j).getConclusions().elementAt(i);
                c.setGraGra(this);
            }
        }
        for (j = 0; j < this.getConstraints().size(); ++j) {
            EdConstraint c = this.getConstraint(j);
            h.enrichObject(c);
            c.setVarSet(this.bGraGra.getAtomicsVec(), this.getAtomicNames());
            c.setGraGra(this);
        }
        if (this.typeSet.getTypeGraph() != null) {
            EdGraphObject e;
            int i;
            h.enrichObject(this.typeSet.getTypeGraph());
            this.typeSet.getTypeGraph().setGraGra(this);
            this.typeSet.getTypeGraph().markTypeGraph(true);
            for (i = 0; i < this.typeSet.getTypeGraph().getNodes().size(); ++i) {
                e = (EdNode)this.typeSet.getTypeGraph().getNodes().elementAt(i);
                e.markElementOfTypeGraph(true);
            }
            for (i = 0; i < this.typeSet.getTypeGraph().getArcs().size(); ++i) {
                e = (EdArc)this.typeSet.getTypeGraph().getArcs().elementAt(i);
                e.markElementOfTypeGraph(true);
            }
        }
        this.startGraph = this.eGraph.copy();
        this.startGraph.setGraGra(this);
        this.getBasisGraGra().setStartGraph(this.startGraph.getBasisGraph());
        this.isChanged = false;
    }

    public void createInheritancePattern(Vector<Arc> inheritanceArcs) {
        for (int i = 0; i < inheritanceArcs.size(); ++i) {
            Arc inharc = inheritanceArcs.get(i);
            Vector<LayoutPattern> v = this.getLayoutPatternsForType(inharc.getType());
            if (!v.isEmpty()) {
                v.clear();
            }
            this.createLayoutPattern("ver_tree", "edge", inharc.getType(), 'y', -1);
            this.createLayoutPattern("edge_length", "edge", inharc.getType(), 150);
        }
    }

    private Vector<LayoutPattern> getInheritancePattern(EdArc edge) {
        Object v = null;
        if (edge.getBasisArc().isInheritance()) {
            return this.getLayoutPatternsForType(edge.getBasisArc().getType());
        }
        return null;
    }

    public void createLayoutPattern(String name, String pType, Type type, char offsetType, int offset) {
        LayoutPattern lp = new LayoutPattern(name, pType, type, offsetType, offset);
        Vector<LayoutPattern> v = this.layoutPatterns.get(type);
        if (v == null) {
            v = new Vector();
        }
        for (int i = 0; i < v.size(); ++i) {
            if (!v.get(i).isSimilarTo(lp)) continue;
            v.remove(i);
            --i;
        }
        v.add(lp);
        this.layoutPatterns.put(type, v);
    }

    public void createLayoutPattern(String name, String pType, Type type, int length) {
        LayoutPattern lp = new LayoutPattern(name, pType, type, length);
        Vector<LayoutPattern> v = this.layoutPatterns.get(type);
        if (v == null) {
            v = new Vector();
        }
        for (int i = 0; i < v.size(); ++i) {
            if (!v.get(i).isSimilarTo(lp)) continue;
            v.remove(i);
            --i;
        }
        v.add(lp);
        this.layoutPatterns.put(type, v);
    }

    public void createLayoutPattern(String name, String pType, Type type, boolean frozen) {
        LayoutPattern lp = new LayoutPattern(name, pType, type, frozen);
        Vector<LayoutPattern> v = this.layoutPatterns.get(type);
        if (v == null) {
            v = new Vector();
        }
        for (int i = 0; i < v.size(); ++i) {
            if (!v.get(i).isSimilarTo(lp)) continue;
            v.remove(i);
            --i;
        }
        v.add(lp);
        this.layoutPatterns.put(type, v);
    }

    public void addLayoutPattern(Type type, LayoutPattern lp) {
        Vector<LayoutPattern> v = this.layoutPatterns.get(type);
        if (v == null) {
            v = new Vector();
        }
        for (int i = 0; i < v.size(); ++i) {
            if (!v.get(i).isSimilarTo(lp)) continue;
            v.remove(i);
            --i;
        }
        v.add(lp);
        this.layoutPatterns.put(type, v);
    }

    public void removeLayoutPattern(Type type) {
        this.layoutPatterns.remove(type);
    }

    public void removeLayoutPattern(Type type, String patternName) {
        Vector<LayoutPattern> v = this.layoutPatterns.get(type);
        if (v == null || v.isEmpty()) {
            return;
        }
        for (int i = 0; i < v.size(); ++i) {
            LayoutPattern lp = v.get(i);
            if (!lp.getName().equals(patternName)) continue;
            v.remove(lp);
            --i;
        }
        this.layoutPatterns.put(type, v);
    }

    public void removeAllLayoutPattern() {
        this.layoutPatterns.clear();
    }

    public Hashtable<Type, Vector<LayoutPattern>> getLayoutPatterns() {
        return this.layoutPatterns;
    }

    public void clearLayoutPatterns() {
        this.layoutPatterns.clear();
    }

    public Vector<LayoutPattern> getLayoutPatternsForType(Type type) {
        Vector<LayoutPattern> v = this.layoutPatterns.get(type);
        if (v == null) {
            v = new Vector();
            this.layoutPatterns.put(type, v);
        }
        return v;
    }

    public LayoutPattern getLayoutPatternForType(Type type, String patternName) {
        Vector<LayoutPattern> v = this.layoutPatterns.get(type);
        if (v == null) {
            return null;
        }
        for (int i = 0; i < v.size(); ++i) {
            LayoutPattern lp = v.get(i);
            if (!lp.getName().equals(patternName)) continue;
            return lp;
        }
        return null;
    }

    public void setLayoutPatterns(Hashtable<Type, Vector<LayoutPattern>> table) {
        this.layoutPatterns = table;
    }
}

