/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.attribute.AttrContext;
import agg.attribute.AttrInstance;
import agg.attribute.facade.impl.DefaultInformationFacade;
import agg.attribute.handler.AttrHandler;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.DeclTuple;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.view.AttrViewSetting;
import agg.editor.impl.BoundingBox;
import agg.editor.impl.CenterOfPoints;
import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdRule;
import agg.editor.impl.EdType;
import agg.editor.impl.EdTypeSet;
import agg.editor.impl.Line;
import agg.editor.impl.Loop;
import agg.layout.Layouter;
import agg.util.Change;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Morphism;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.TypeException;
import agg.xt_basis.TypeSet;
import com.objectspace.jgl.HashMap;
import com.objectspace.jgl.Pair;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class EdGraph
implements XMLObject,
Observer {
    private Graph bGraph;
    private EdTypeSet typeSet;
    private Vector nodes;
    private Vector arcs;
    private boolean editable = true;
    private boolean isTG;
    private boolean isCPA;
    private int spaceBetweenParallelArcs = 20;
    private transient int mark = 1;
    private transient EdGraGra eGra;
    private transient Vector selectedNodes;
    private transient Vector selectedArcs;
    private transient EdNode selectedNode;
    private transient EdArc selectedArc;
    private transient EdGraphObject pickedObj;
    private transient EdGraph gCopy;
    private transient String errMsg = "";
    private transient EdRule transRule;
    private transient EdRule lastTransRule;
    private transient boolean sameRule = false;
    private transient Morphism coMatch;
    private transient Vector lastNewObjects;
    private transient Point lastCenterG = new Point(0, 0);
    private transient Point centerG;
    private transient Point upper_left = new Point(0, 0);
    private transient int realWidthOfGraphPanel;
    private transient int rowLength = 10;
    private transient int rowHeight = 50;
    private transient boolean hasOnlyDefaultNodeLayout = true;
    private transient boolean hasDefaultLayout = true;
    private transient Vector changedGraphObjects = new Vector();
    private transient boolean changed = false;
    private Vector inheritanceArcs;
    private EdType inheritanceType;
    private transient Dimension gDim;
    private transient int ggen;
    private transient int lastnodeid;
    private transient Vector<Integer> reservedNodeIDs = new Vector();

    public EdGraph() {
        this.typeSet = new EdTypeSet();
        this.nodes = new Vector();
        this.arcs = new Vector();
        this.inheritanceArcs = new Vector();
        this.selectedNodes = new Vector();
        this.selectedArcs = new Vector();
        this.changedGraphObjects = new Vector();
        this.lastNewObjects = new Vector();
    }

    public EdGraph(EdTypeSet types) {
        this();
        this.typeSet = types;
    }

    public EdGraph(Graph graph) {
        this();
        this.bGraph = graph;
        this.bGraph.addObserver(this);
        this.typeSet = new EdTypeSet(this.bGraph);
        if (this.typeSet.getBasisTypeSet().getTypeGraph() != this.bGraph) {
            this.doDefaultGraphLayout(true);
        }
    }

    public EdGraph(Graph graph, boolean attrsVisible) {
        this();
        this.bGraph = graph;
        this.bGraph.addObserver(this);
        this.typeSet = new EdTypeSet(this.bGraph);
        if (this.typeSet.getBasisTypeSet().getTypeGraph() != this.bGraph) {
            this.doDefaultGraphLayout(attrsVisible);
        }
    }

    public EdGraph(Graph graph, EdTypeSet types) {
        this();
        this.bGraph = graph;
        this.bGraph.addObserver(this);
        this.typeSet = types;
        if (this.typeSet.getBasisTypeSet().getTypeGraph() != this.bGraph) {
            this.doDefaultGraphLayout(true);
        }
    }

    public EdGraph(Graph graph, EdTypeSet types, boolean attrsVisible) {
        this();
        this.bGraph = graph;
        this.bGraph.addObserver(this);
        this.typeSet = types;
        if (this.typeSet.getBasisTypeSet().getTypeGraph() != this.bGraph) {
            this.doDefaultGraphLayout(attrsVisible);
        }
    }

    public Graph getBasisGraph() {
        return this.bGraph;
    }

    public EdGraGra getGraGra() {
        return this.eGra;
    }

    public void setGraGra(EdGraGra egra) {
        if (egra == null) {
            return;
        }
        this.eGra = egra;
        if (this.eGra.getTypeSet() != null) {
            this.setTypeSet(egra.getTypeSet());
        }
        if (this.isTG) {
            this.eGra.setChanged(true);
        }
    }

    public EdTypeSet getTypeSet() {
        return this.typeSet;
    }

    public void setTypeSet(EdTypeSet types) {
        if (this.typeSet != null && types != null) {
            EdType t;
            int i;
            for (i = 0; i < this.typeSet.getNodeTypes().size(); ++i) {
                t = (EdType)this.typeSet.getNodeTypes().elementAt(i);
                if (!types.isNewType(types.getNodeTypes(), t)) continue;
                types.getNodeTypes().addElement(t);
            }
            for (i = 0; i < this.typeSet.getArcTypes().size(); ++i) {
                t = (EdType)this.typeSet.getArcTypes().elementAt(i);
                if (!types.isNewType(types.getArcTypes(), t)) continue;
                types.getArcTypes().addElement(t);
            }
        }
        this.typeSet = types;
    }

    public Vector getNodes() {
        return this.nodes;
    }

    public void setNodes(Vector v) {
        this.nodes = v;
    }

    public Vector getArcs() {
        return this.arcs;
    }

    public void setArcs(Vector v) {
        this.arcs = v;
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isGraph(EdGraph eg) {
        if (eg == null) {
            return false;
        }
        boolean badGraph = false;
        for (int i = 0; i < eg.arcs.size(); ++i) {
            EdArc ea = (EdArc)eg.arcs.elementAt(i);
            if (eg.nodes.contains((EdNode)ea.getSource()) && eg.nodes.contains((EdNode)ea.getTarget())) continue;
            return false;
        }
        return true;
    }

    public boolean isTypeGraph() {
        return this.isTG;
    }

    public void markTypeGraph(boolean val) {
        this.isTG = val;
    }

    public boolean isCPAgraph() {
        return this.isCPA;
    }

    public void setCPAgraph(boolean b) {
        this.isCPA = b;
    }

    public void clear() {
        this.nodes.removeAllElements();
        this.arcs.removeAllElements();
        this.mark = 1;
        this.selectedNodes.removeAllElements();
        this.selectedArcs.removeAllElements();
        this.selectedNode = null;
        this.selectedArc = null;
        this.pickedObj = null;
        this.lastNewObjects.clear();
        this.changedGraphObjects.clear();
    }

    public void clearSelected() {
        int i;
        for (i = 0; i < this.selectedNodes.size(); ++i) {
            EdNode en = (EdNode)this.selectedNodes.elementAt(i);
            en.setSelected(false);
        }
        this.selectedNodes.removeAllElements();
        this.selectedNode = null;
        for (i = 0; i < this.selectedArcs.size(); ++i) {
            EdArc ea = (EdArc)this.selectedArcs.elementAt(i);
            ea.setSelected(false);
        }
        this.selectedArcs.removeAllElements();
        this.selectedArc = null;
    }

    public EdNode addNode(Graph gr, int x, int y, boolean visible) throws TypeException {
        if (!this.bGraph.equals(gr)) {
            this.errMsg = "Bad base graph!";
            return null;
        }
        if (this.typeSet.getSelectedNodeType() == null) {
            this.errMsg = "No node type selected!";
            return null;
        }
        EdNode eNode = new EdNode(gr, this.typeSet.getSelectedNodeType());
        eNode.setReps(x, y, visible, false);
        this.nodes.addElement(eNode);
        eNode.setMyKey(this.mark++);
        if (this.isTG) {
            eNode.markElementOfTypeGraph(true);
        }
        return eNode;
    }

    public EdNode addNode(Graph gr, int x, int y, EdType eType, boolean visible) throws TypeException {
        if (!this.bGraph.equals(gr)) {
            this.errMsg = "Bad base graph!";
            return null;
        }
        EdNode eNode = new EdNode(gr, eType);
        eNode.setReps(x, y, visible, false);
        this.nodes.addElement(eNode);
        eNode.setMyKey(this.mark++);
        if (this.isTG) {
            eNode.markElementOfTypeGraph(true);
        }
        return eNode;
    }

    private EdNode newNode(Graph gr, Node bNode, Vector eNodes) {
        int i;
        if (!this.bGraph.equals(gr)) {
            this.errMsg = "Bad base graph!";
            return null;
        }
        EdType et = null;
        if (this.typeSet == null) {
            this.typeSet = new EdTypeSet();
            if (this.eGra != null) {
                this.typeSet.setBasisGraGra(this.eGra.getBasisGraGra());
            } else if (this.bGraph != null) {
                this.typeSet.setBasisGraph(this.bGraph);
            }
        }
        if (this.typeSet.isEmpty()) {
            for (i = 0; i < eNodes.size(); ++i) {
                EdNode en = (EdNode)eNodes.elementAt(i);
                if (!bNode.getType().compareTo(en.getType().getBasisType())) continue;
                et = en.getType();
                this.typeSet.addNodeType(et);
                i = eNodes.size();
            }
            if (et == null) {
                et = this.typeSet.createNodeType(bNode.getType());
            }
        } else {
            for (i = 0; i < this.typeSet.getNodeTypes().size(); ++i) {
                EdType t = (EdType)this.typeSet.getNodeTypes().elementAt(i);
                if (!t.getBasisType().compareTo(bNode.getType())) continue;
                et = t;
                i = this.typeSet.getNodeTypes().size();
            }
            if (et == null) {
                et = this.typeSet.createNodeType(bNode.getType());
            }
        }
        if (et == null) {
            System.out.println(">>> Creating of the node type is failed!");
            this.errMsg = "Bad node type!";
            return null;
        }
        EdNode eNode = new EdNode(bNode, et);
        eNode.setReps(100, 100, true, false);
        eNode.myUpdate(null);
        eNode.setMyKey(this.mark++);
        if (this.isTG) {
            eNode.markElementOfTypeGraph(true);
        }
        eNodes.addElement(eNode);
        return eNode;
    }

    public EdNode addNode(Graph gr, Node bNode, EdType et) {
        if (!this.bGraph.equals(gr)) {
            this.errMsg = "Bad base graph!";
            return null;
        }
        EdNode eNode = new EdNode(bNode, et);
        eNode.setReps(100, 100, true, false);
        eNode.myUpdate(null);
        eNode.setMyKey(this.mark++);
        if (this.isTG) {
            eNode.markElementOfTypeGraph(true);
        }
        this.nodes.addElement(eNode);
        return eNode;
    }

    public EdArc addArc(Graph gr, EdGraphObject from, EdGraphObject to, Point anchor, boolean directed) throws TypeException {
        if (!this.bGraph.equals(gr)) {
            this.errMsg = "Bad base graph!";
            return null;
        }
        if (this.typeSet.getSelectedArcType() == null) {
            this.errMsg = "No node type selected!";
            return null;
        }
        EdArc eArc = new EdArc(gr, this.typeSet.getSelectedArcType(), from, to, anchor);
        if (eArc != null) {
            eArc.setReps(true, true, false);
            this.resizeArc(eArc, this.spaceBetweenParallelArcs);
            this.arcs.addElement(eArc);
            eArc.setMyKey(this.mark++);
            if (this.isTG) {
                eArc.markElementOfTypeGraph(true);
            }
            eArc.setDirected(directed);
        }
        return eArc;
    }

    public EdArc addArc(Graph gr, EdType eType, EdGraphObject from, EdGraphObject to, Point anchor, boolean directed) throws TypeException {
        if (!this.bGraph.equals(gr)) {
            this.errMsg = "Bad base graph!";
            return null;
        }
        EdArc eArc = new EdArc(gr, eType, from, to, anchor);
        if (eArc != null) {
            eArc.setReps(true, true, false);
            this.resizeArc(eArc, this.spaceBetweenParallelArcs);
            this.arcs.addElement(eArc);
            eArc.setMyKey(this.mark++);
            if (this.isTG) {
                eArc.markElementOfTypeGraph(true);
            }
            eArc.setDirected(directed);
        }
        return eArc;
    }

    public EdArc newArc(Graph gr, Arc bArc, Vector eArcs) {
        EdGraphObject eTar;
        int i;
        if (!this.bGraph.equals(gr)) {
            this.errMsg = "Bad base graph!";
            return null;
        }
        this.errMsg = "";
        EdArc eArc = null;
        EdType et = null;
        if (this.typeSet == null) {
            this.typeSet = new EdTypeSet();
            if (this.eGra != null) {
                this.typeSet.setBasisGraGra(this.eGra.getBasisGraGra());
            } else if (this.bGraph != null) {
                this.typeSet.setBasisGraph(this.bGraph);
            }
        }
        if (this.typeSet.isEmpty()) {
            for (i = 0; i < eArcs.size(); ++i) {
                EdArc ea = (EdArc)eArcs.elementAt(i);
                if (!bArc.getType().compareTo(ea.getType().getBasisType())) continue;
                et = ea.getType();
                this.typeSet.addArcType(et);
                i = eArcs.size();
            }
            if (et == null) {
                et = this.typeSet.createArcType(bArc.getType());
            }
        } else {
            for (i = 0; i < this.typeSet.getArcTypes().size(); ++i) {
                EdType t = (EdType)this.typeSet.getArcTypes().elementAt(i);
                if (!t.getBasisType().compareTo(bArc.getType())) continue;
                et = t;
                i = this.typeSet.getArcTypes().size();
            }
            if (et == null) {
                et = this.typeSet.createArcType(bArc.getType());
            }
        }
        if (et == null) {
            this.errMsg = "Bad edge type!";
            System.out.println(">>> Creation of the arc type is failed!");
            return null;
        }
        GraphObject bSrc = bArc.getSource();
        GraphObject bTar = bArc.getTarget();
        EdGraphObject eSrc = this.findNode(bSrc);
        if (eSrc == null) {
            eSrc = this.findArc(bSrc, eArcs);
        }
        if ((eTar = this.findNode(bTar)) == null) {
            eTar = this.findArc(bTar, eArcs);
        }
        if (eSrc != null && eTar != null) {
            eArc = new EdArc(bArc, et, eSrc, eTar);
            eArc.setReps(bArc.isDirected(), true, false);
            this.resizeArc(eArc, this.spaceBetweenParallelArcs);
            eArcs.addElement(eArc);
            eArc.setMyKey(this.mark++);
            if (this.isTG) {
                eArc.markElementOfTypeGraph(true);
            }
            return eArc;
        }
        this.errMsg = "Bad edge!";
        return null;
    }

    public EdArc newInheritanceArc(Graph gr, Arc bArc, Vector eArcs) {
        EdGraphObject eTar;
        if (!this.bGraph.equals(gr)) {
            this.errMsg = "Bad base graph!";
            return null;
        }
        this.errMsg = "";
        EdArc eArc = null;
        if (this.inheritanceType == null) {
            this.inheritanceType = new EdType(bArc.getType(), 61, new Color(0, 0, 0), "");
        }
        GraphObject bSrc = bArc.getSource();
        GraphObject bTar = bArc.getTarget();
        EdGraphObject eSrc = this.findNode(bSrc);
        if (eSrc == null) {
            eSrc = this.findArc(bSrc, eArcs);
        }
        if ((eTar = this.findNode(bTar)) == null) {
            eTar = this.findArc(bTar, eArcs);
        }
        if (eSrc != null && eTar != null) {
            eArc = new EdArc(bArc, this.inheritanceType, eSrc, eTar);
            eArc.setReps(true, true, false);
            this.resizeArc(eArc, this.spaceBetweenParallelArcs);
            eArcs.addElement(eArc);
            eArc.setMyKey(this.mark++);
            if (this.isTG) {
                eArc.markElementOfTypeGraph(true);
            }
            return eArc;
        }
        this.errMsg = "Bad edge!";
        return null;
    }

    public EdArc addArc(Graph gr, Arc bArc, EdType et) {
        EdGraphObject eTar;
        if (!this.bGraph.equals(gr)) {
            this.errMsg = "Bad base graph!";
            return null;
        }
        this.errMsg = "";
        EdArc eArc = null;
        GraphObject bSrc = bArc.getSource();
        GraphObject bTar = bArc.getTarget();
        EdGraphObject eSrc = this.findNode(bSrc);
        if (eSrc == null) {
            eSrc = this.findArc(bSrc);
        }
        if ((eTar = this.findNode(bTar)) == null) {
            eTar = this.findArc(bTar);
        }
        if (eSrc != null && eTar != null) {
            eArc = new EdArc(bArc, et, eSrc, eTar);
            eArc.setReps(bArc.isDirected(), true, false);
            this.arcs.addElement(eArc);
            eArc.setMyKey(this.mark++);
            if (this.isTG) {
                eArc.markElementOfTypeGraph(true);
            }
        } else {
            this.errMsg = "Bad edge!";
        }
        return eArc;
    }

    public Node findBasisNode(EdNode eNode) {
        return eNode.getBasisNode();
    }

    public EdNode findNode(GraphObject bNode) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            EdNode eNode = (EdNode)this.nodes.elementAt(i);
            if (eNode.getBasisNode() == null || !eNode.getBasisNode().equals(bNode)) continue;
            return eNode;
        }
        return null;
    }

    public Arc findBasisArc(EdArc eArc) {
        return eArc.getBasisArc();
    }

    public EdArc findArc(GraphObject bArc) {
        for (int i = 0; i < this.arcs.size(); ++i) {
            EdArc eArc = (EdArc)this.arcs.elementAt(i);
            if (eArc.getBasisArc() == null || !eArc.getBasisArc().equals(bArc)) continue;
            return eArc;
        }
        return null;
    }

    private EdArc findArc(GraphObject bArc, Vector eArcs) {
        for (int i = 0; i < eArcs.size(); ++i) {
            EdArc eArc = (EdArc)eArcs.elementAt(i);
            if (eArc.getBasisArc() == null || !eArc.getBasisArc().equals(bArc)) continue;
            return eArc;
        }
        return null;
    }

    public EdGraphObject findGraphObject(GraphObject obj) {
        EdNode en = this.findNode(obj);
        if (en != null) {
            return en;
        }
        EdArc ea = this.findArc(obj);
        if (ea != null) {
            return ea;
        }
        return null;
    }

    public EdGraphObject getPicked(int x, int y) {
        int i;
        this.pickedObj = null;
        for (i = this.nodes.size() - 1; i >= 0; --i) {
            EdNode en = (EdNode)this.nodes.elementAt(i);
            if (!en.inside(x, y)) continue;
            this.pickedObj = en;
            return this.pickedObj;
        }
        if (this.pickedObj == null) {
            for (i = this.arcs.size() - 1; i >= 0; --i) {
                EdArc ea = (EdArc)this.arcs.elementAt(i);
                if (!ea.inside(x, y)) continue;
                this.pickedObj = ea;
                return this.pickedObj;
            }
        }
        return this.pickedObj;
    }

    public EdGraphObject getPicked() {
        return this.pickedObj;
    }

    public EdNode getPickedNode(int x, int y) {
        EdGraphObject eo = this.getPicked(x, y);
        if (eo != null && eo.isNode()) {
            return eo.getNode();
        }
        return null;
    }

    public EdArc getPickedArc(int x, int y) {
        EdGraphObject eo = this.getPicked(x, y);
        if (eo != null && eo.isArc()) {
            return eo.getArc();
        }
        return null;
    }

    public EdArc getPickedTextOfArc(int x, int y, FontMetrics fm) {
        for (int i = 0; i < this.arcs.size(); ++i) {
            EdArc ea = (EdArc)this.arcs.elementAt(i);
            if (!ea.insideTextOfArc(x, y, fm)) continue;
            return ea;
        }
        return null;
    }

    public void moveNode(EdNode pickedNode, int dx, int dy) {
        if (pickedNode != null) {
            EdArc ea;
            int i;
            Vector in = this.getIncomingArcs(pickedNode);
            Vector out = this.getOutgoingArcs(pickedNode);
            pickedNode.x += dx;
            pickedNode.y += dy;
            for (i = 0; i < in.size(); ++i) {
                ea = (EdArc)in.elementAt(i);
                if (!ea.isSelected() && ea.hasAnchor() && !ea.isLine()) continue;
            }
            for (i = 0; i < out.size(); ++i) {
                ea = (EdArc)out.elementAt(i);
                if (ea.isSelected()) continue;
                if (!ea.hasAnchor() || ea.isLine()) {
                    // empty if block
                }
                if (ea.isLine()) continue;
                Loop loop = ea.toLoop();
                loop.move(((EdNode)ea.getSource()).toRectangle(), 0, dx, dy);
                ea.setAnchor(1, new Point(loop.x, loop.y));
                ea.setWidth(loop.w);
                ea.setHeight(loop.h);
            }
        }
    }

    public void moveNodeOnly(EdNode pickedNode, int dx, int dy) {
        if (pickedNode != null) {
            Vector in = this.getIncomingArcs(pickedNode);
            pickedNode.x += dx;
            pickedNode.y += dy;
            for (int i = 0; i < in.size(); ++i) {
                EdArc ea = (EdArc)in.elementAt(i);
                if (ea.isLine()) continue;
                Loop loop = ea.toLoop();
                loop.move(((EdNode)ea.getSource()).toRectangle(), 0, dx, dy);
                ea.setAnchor(1, new Point(loop.x, loop.y));
                ea.setWidth(loop.w);
                ea.setHeight(loop.h);
            }
        }
    }

    public void moveArc(EdArc pickedArc, int dx, int dy) {
        if (pickedArc != null) {
            if (pickedArc.isLine()) {
                pickedArc.setAnchor(new Point(pickedArc.getAnchor().x + dx, pickedArc.getAnchor().y + dy));
            } else {
                Loop loop = pickedArc.toLoop();
                loop.move(((EdNode)pickedArc.getSource()).toRectangle(), pickedArc.getAnchorID(), dx, dy);
                pickedArc.setAnchor(1, new Point(loop.x, loop.y));
                pickedArc.setWidth(loop.w);
                pickedArc.setHeight(loop.h);
            }
        }
    }

    public void moveTextOfArc(EdArc pickedTextOfArc, int dx, int dy) {
        pickedTextOfArc.translateTextOffset(dx, dy);
    }

    public void moveObject(EdGraphObject go, int dx, int dy) {
        if (go instanceof EdNode) {
            this.moveNode((EdNode)go, dx, dy);
        } else if (go instanceof EdArc) {
            this.moveArc((EdArc)go, dx, dy);
        }
    }

    public void moveObjects(Vector objects, int dx, int dy) {
        if (objects == null) {
            return;
        }
        Enumeration objs = objects.elements();
        while (objs.hasMoreElements()) {
            EdGraphObject go = (EdGraphObject)objs.nextElement();
            if (go instanceof EdNode) {
                this.moveNode((EdNode)go, dx, dy);
                continue;
            }
            if (!(go instanceof EdArc)) continue;
            EdArc ea = (EdArc)go;
            this.moveArc(ea, dx, dy);
        }
    }

    public void setCritical(EdGraphObject obj) {
        obj.setCritical(true);
    }

    public void unsetCritical(EdGraphObject obj) {
        obj.setCritical(false);
    }

    public boolean isCritical(EdGraphObject obj) {
        return obj.isCritical();
    }

    public EdNode getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(EdNode en) {
        if (this.nodes.contains(en)) {
            if (!this.selectedNodes.contains(en)) {
                en.setSelected(true);
                this.selectedNodes.addElement(en);
            }
            this.selectedNode = en;
        }
    }

    public Vector getSelectedNodes() {
        return this.selectedNodes;
    }

    public EdGraphObject selectNode(int x, int y) {
        boolean sel = false;
        EdNode selEdNode = null;
        this.selectedNode = null;
        for (int i = 0; i < this.nodes.size(); ++i) {
            EdNode eNode = (EdNode)this.nodes.elementAt(i);
            if (!eNode.inside(x, y)) continue;
            sel = true;
            selEdNode = eNode;
            selEdNode.setSelected(true);
            if (selEdNode.isSelected()) {
                this.selectedNodes.addElement(selEdNode);
                this.selectedNode = selEdNode;
                continue;
            }
            this.selectedNodes.removeElement(selEdNode);
        }
        if (selEdNode != null) {
            return selEdNode;
        }
        return null;
    }

    public EdArc getSelectedArc() {
        return this.selectedArc;
    }

    public void setSelectedArc(EdArc ea) {
        if (this.arcs.contains(ea)) {
            if (!this.selectedArcs.contains(ea)) {
                ea.setSelected(true);
                this.selectedArcs.addElement(ea);
            }
            this.selectedArc = ea;
        }
    }

    public Vector getSelectedArcs() {
        return this.selectedArcs;
    }

    public EdGraphObject selectArc(int x, int y) {
        boolean sel = false;
        Object line = null;
        Object loop = null;
        EdArc selEdArc = null;
        this.selectedArc = null;
        for (int i = 0; i < this.arcs.size(); ++i) {
            EdArc eArc = (EdArc)this.arcs.elementAt(i);
            if (eArc.getSource().equals(eArc.getTarget())) {
                if (!eArc.inside(x, y) && !eArc.insideTextOfArc(x, y, null)) continue;
                sel = true;
                selEdArc = eArc;
                selEdArc.setSelected(true);
                if (selEdArc.isSelected()) {
                    this.selectedArcs.addElement(selEdArc);
                    this.selectedArc = selEdArc;
                    continue;
                }
                this.selectedArcs.removeElement(selEdArc);
                continue;
            }
            if (!eArc.inside(x, y) && !eArc.insideTextOfArc(x, y, null)) continue;
            sel = true;
            selEdArc = eArc;
            selEdArc.setSelected(true);
            if (selEdArc.isSelected()) {
                this.selectedArcs.addElement(selEdArc);
                this.selectedArc = selEdArc;
                continue;
            }
            this.selectedArcs.removeElement(selEdArc);
        }
        if (selEdArc != null) {
            return selEdArc;
        }
        return null;
    }

    public EdGraphObject select(int x, int y) {
        EdGraphObject eObj = null;
        eObj = this.selectNode(x, y);
        if (eObj == null) {
            eObj = this.selectArc(x, y);
            if (eObj == null) {
                return null;
            }
            return eObj;
        }
        return eObj;
    }

    public void select(EdGraphObject obj) {
        if (obj == null) {
            return;
        }
        obj.setSelected(true);
        if (obj.isNode()) {
            this.selectedNodes.addElement((EdNode)obj);
        } else {
            this.selectedArcs.addElement((EdArc)obj);
        }
    }

    public synchronized void selectAll() {
        this.deselectAll();
        for (int i = 0; i < this.nodes.size(); ++i) {
            EdNode eNode = (EdNode)this.nodes.elementAt(i);
            if (eNode.isSelected()) continue;
            eNode.setSelected(true);
            this.selectedNodes.addElement(eNode);
        }
        for (int j = 0; j < this.arcs.size(); ++j) {
            EdArc eArc = (EdArc)this.arcs.elementAt(j);
            if (eArc.isSelected()) continue;
            eArc.setSelected(true);
            this.selectedArcs.addElement(eArc);
        }
    }

    public synchronized void selectObjectsOfSelectedNodeType() {
        EdType t = this.typeSet.getSelectedNodeType();
        this.selectObjectsOfType(t);
    }

    public synchronized void selectObjectsOfSelectedArcType() {
        EdType t = this.typeSet.getSelectedArcType();
        this.selectObjectsOfType(t);
    }

    public synchronized void selectObjectsOfType(EdType t) {
        this.deselectAll();
        for (int i = 0; i < this.nodes.size(); ++i) {
            EdNode eNode = (EdNode)this.nodes.elementAt(i);
            if (!eNode.getType().equals(t) || this.selectedNodes.contains(eNode)) continue;
            eNode.setSelected(true);
            this.selectedNodes.addElement(eNode);
        }
        for (int j = 0; j < this.arcs.size(); ++j) {
            EdArc eArc = (EdArc)this.arcs.elementAt(j);
            if (!eArc.getType().equals(t) || this.selectedArcs.contains(eArc)) continue;
            eArc.setSelected(true);
            this.selectedArcs.addElement(eArc);
        }
    }

    public void deselect(EdGraphObject ego) {
        if (ego == null) {
            return;
        }
        ego.setSelected(false);
        if (ego.isNode()) {
            this.selectedNodes.removeElement((EdNode)ego);
        } else if (ego.isArc()) {
            this.selectedArcs.removeElement((EdArc)ego);
        }
    }

    public synchronized void deselectAll() {
        if (this.selectedArcs != null) {
            for (int j = 0; j < this.selectedArcs.size(); ++j) {
                EdArc ea = (EdArc)this.selectedArcs.elementAt(j);
                ea.setSelected(false);
            }
            this.selectedArcs.removeAllElements();
        }
        if (this.selectedNodes != null) {
            for (int i = 0; i < this.selectedNodes.size(); ++i) {
                EdNode en = (EdNode)this.selectedNodes.elementAt(i);
                en.setSelected(false);
            }
            this.selectedNodes.removeAllElements();
        }
    }

    public Vector getSelectedObjs() {
        int i;
        Vector<EdGraphObject> sel = new Vector<EdGraphObject>();
        for (i = 0; i < this.selectedNodes.size(); ++i) {
            EdNode en = (EdNode)this.selectedNodes.elementAt(i);
            sel.addElement(en);
        }
        for (i = 0; i < this.selectedArcs.size(); ++i) {
            EdArc ea = (EdArc)this.selectedArcs.elementAt(i);
            sel.addElement(ea);
        }
        return sel;
    }

    public EdGraph getSelectedAsGraphCopy() {
        int i;
        if (this.selectedNodes == null || this.selectedNodes.size() == 0 || !this.selectedArcsOK()) {
            return null;
        }
        TypeSet ts = new TypeSet();
        Graph bResult = new Graph(ts);
        HashMap hmap = new HashMap();
        EdGraph result = new EdGraph(bResult, new EdTypeSet(bResult));
        Vector simpleNodes = (Vector)this.selectedNodes.clone();
        for (i = 0; i < this.selectedArcs.size(); ++i) {
            EdArc copy;
            EdArc ea = (EdArc)this.selectedArcs.elementAt(i);
            EdNode src = (EdNode)((EdGraphObject)hmap.get(ea.getSource()));
            if (src == null && (src = result.copyNode((EdNode)ea.getSource(), ea.getSource().getX(), ea.getSource().getY())) != null) {
                hmap.put(ea.getSource(), src);
            }
            EdNode trg = src;
            if (!ea.getSource().equals(ea.getTarget()) && (trg = (EdNode)((EdGraphObject)hmap.get(ea.getTarget()))) == null && (trg = result.copyNode((EdNode)ea.getTarget(), ea.getTarget().getX(), ea.getTarget().getY())) != null) {
                hmap.put(ea.getTarget(), trg);
            }
            if (src == null || trg == null || (copy = result.copyArc(ea, src, trg)) == null) continue;
            copy.setSelected(true);
            if (!src.isSelected()) {
                src.setSelected(true);
            }
            if (!trg.isSelected()) {
                trg.setSelected(true);
            }
            simpleNodes.removeElement((EdNode)ea.getSource());
            simpleNodes.removeElement((EdNode)ea.getTarget());
        }
        for (i = 0; i < simpleNodes.size(); ++i) {
            EdNode en = (EdNode)simpleNodes.elementAt(i);
            EdNode copy = result.copyNode(en, en.getX(), en.getY());
            if (copy == null) continue;
            copy.setSelected(true);
        }
        return result;
    }

    public void setGraphToCopy(EdGraph g) {
        this.gCopy = g;
    }

    private void addGraph(EdGraph eg, int x, int y) {
        int newY;
        int newX;
        int i;
        int i2;
        if (!this.isGraph(eg)) {
            return;
        }
        if (eg.getNodes() == null || eg.getNodes().size() == 0) {
            return;
        }
        HashMap hmap = new HashMap();
        Vector simpleNodes = (Vector)eg.getNodes().clone();
        for (i2 = 0; i2 < eg.getArcs().size(); ++i2) {
            EdArc copy;
            EdArc ea = (EdArc)eg.getArcs().elementAt(i2);
            EdNode src = null;
            EdNode trg = null;
            src = (EdNode)((EdGraphObject)hmap.get(ea.getSource()));
            if (src == null && (src = this.copyNode((EdNode)ea.getSource(), ea.getSource().getX(), ea.getSource().getY())) != null) {
                hmap.put(ea.getSource(), src);
            }
            if ((trg = (EdNode)((EdGraphObject)hmap.get(ea.getTarget()))) == null && (trg = this.copyNode((EdNode)ea.getTarget(), ea.getTarget().getX(), ea.getTarget().getY())) != null) {
                hmap.put(ea.getTarget(), trg);
            }
            if (src != null && trg != null && (copy = this.copyArc(ea, src, trg)) != null) {
                copy.setSelected(true);
                this.selectedArcs.addElement(copy);
                if (!src.isSelected()) {
                    src.setSelected(true);
                    this.selectedNodes.addElement(src);
                }
                if (!src.equals(trg) && !trg.isSelected()) {
                    trg.setSelected(true);
                    this.selectedNodes.addElement(trg);
                }
            }
            simpleNodes.removeElement((EdNode)ea.getSource());
            simpleNodes.removeElement((EdNode)ea.getTarget());
        }
        for (i2 = 0; i2 < simpleNodes.size(); ++i2) {
            EdNode en = (EdNode)simpleNodes.elementAt(i2);
            EdNode copy = this.copyNode(en, en.getX(), en.getY());
            if (copy == null) continue;
            copy.setSelected(true);
            this.selectedNodes.addElement(copy);
        }
        Point p = this.findCenter(this.selectedNodes);
        int dx = 0;
        int dy = 0;
        for (i = 0; i < this.selectedNodes.size(); ++i) {
            EdNode en = (EdNode)this.selectedNodes.elementAt(i);
            dx = en.getX() - p.x;
            dy = en.getY() - p.y;
            newX = x + dx;
            newY = y + dy;
            if (newX <= 0) {
                newX = newX - newX + en.getWidth() * 2;
            }
            if (newY <= 0) {
                newY = newY - newY + en.getHeight() * 2;
            }
            if (newX > this.realWidthOfGraphPanel) {
                newX = newX - this.realWidthOfGraphPanel + en.getWidth();
            }
            en.setX(newX);
            en.setY(newY);
        }
        for (i = 0; i < this.selectedArcs.size(); ++i) {
            EdArc ea = (EdArc)this.selectedArcs.elementAt(i);
            if (!ea.isLine() || !ea.hasAnchor()) continue;
            dx = ea.getAnchor().x - p.x;
            dy = ea.getAnchor().y - p.y;
            newX = x + dx;
            newY = y + dy;
            if (newX <= 0) {
                newX = newX - newX + 10;
            }
            if (newY <= 0) {
                newY = newY - newY + 10;
            }
            if (newX > this.realWidthOfGraphPanel) {
                newX = this.realWidthOfGraphPanel - 10;
            }
            ea.setAnchor(new Point(newX, newY));
        }
        this.typeSet.fireTypeChangedEvent();
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean hasOneSelection() {
        int nn = 0;
        if (this.selectedNodes != null) {
            nn += this.selectedNodes.size();
        }
        if (this.selectedArcs != null) {
            nn += this.selectedArcs.size();
        }
        return nn == 1;
    }

    private boolean nothingSelected() {
        int nn = 0;
        if (this.selectedNodes != null) {
            nn += this.selectedNodes.size();
        }
        if (this.selectedArcs != null) {
            nn += this.selectedArcs.size();
        }
        return nn == 0;
    }

    public boolean hasSelection() {
        return !this.nothingSelected();
    }

    private boolean selectedArcsOK() {
        for (int i = 0; i < this.selectedArcs.size(); ++i) {
            EdArc selObj = (EdArc)this.selectedArcs.elementAt(i);
            if (this.selectedNodes.contains((EdNode)selObj.getSource()) && this.selectedNodes.contains((EdNode)selObj.getTarget())) continue;
            return false;
        }
        return true;
    }

    private boolean isObjSelected(EdGraphObject obj) {
        if (obj.isNode() && obj.isSelected()) {
            return true;
        }
        if (obj.isArc() && obj.isSelected()) {
            return this.isObjSelected(obj.getArc().getSource()) && this.isObjSelected(obj.getArc().getTarget());
        }
        return false;
    }

    private void deselectObject(EdGraphObject eObj) {
        if (eObj.isNode()) {
            EdNode eNode = eObj.getNode();
            eNode.setSelected(false);
            this.selectedNodes.removeElement(eNode);
        } else if (eObj.isArc()) {
            EdArc eArc = eObj.getArc();
            eArc.setSelected(false);
            this.selectedArcs.removeElement(eArc);
        }
    }

    public EdGraph copy() {
        int i;
        int tglevel = this.getBasisGraph().getTypeSet().getLevelOfTypeGraphCheck();
        if (tglevel == 30) {
            this.getBasisGraph().getTypeSet().setLevelOfTypeGraphCheck(20);
        }
        EdGraph clone = new EdGraph(new Graph(this.getBasisGraph().getTypeSet(), true), this.typeSet);
        clone.getBasisGraph().setName(this.getBasisGraph().getName());
        if (this.getBasisGraph().getAttrContext() != null && ((ContextView)this.getBasisGraph().getAttrContext()).getAllowedMapping() == 2) {
            AttrContext aGraphContext = AttrTupleManager.getDefaultManager().newContext(2);
            clone.getBasisGraph().setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(aGraphContext));
        }
        Hashtable<EdNode, EdNode> table = new Hashtable<EdNode, EdNode>();
        for (i = 0; i < this.nodes.size(); ++i) {
            EdNode node = (EdNode)this.nodes.elementAt(i);
            try {
                Node n = clone.getBasisGraph().createNode(node.getBasisNode());
                if (n == null) continue;
                EdNode cnode = clone.addNode(clone.getBasisGraph(), n, node.getType());
                cnode.setXY(node.getX(), node.getY());
                cnode.getLNode().setFrozen(node.getLNode().isFrozen());
                if (this.addReservedNodeID(node.getNodeID())) {
                    cnode.setNodeID(node.getNodeID());
                }
                table.put(node, cnode);
                continue;
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
        }
        for (i = 0; i < this.arcs.size(); ++i) {
            EdArc arc = (EdArc)this.arcs.elementAt(i);
            EdNode src = (EdNode)arc.getSource();
            EdNode trg = (EdNode)arc.getTarget();
            EdNode csrc = (EdNode)table.get(src);
            EdNode ctrg = (EdNode)table.get(trg);
            try {
                Arc a = clone.getBasisGraph().createArc(arc.getBasisArc(), csrc.getBasisNode(), ctrg.getBasisNode());
                if (a == null) continue;
                EdArc carc = clone.addArc(clone.getBasisGraph(), a, arc.getType());
                if (arc.isLine()) {
                    if (arc.hasAnchor()) {
                        carc.setAnchor(new Point(arc.getAnchor()));
                    }
                } else if (arc.hasAnchor()) {
                    carc.setAnchor(1, new Point(arc.getAnchor()));
                    carc.setWidth(arc.getWidthOfLoop());
                    carc.setHeight(arc.getHeightOfLoop());
                }
                carc.setTextOffset(arc.getTextOffset().x, arc.getTextOffset().y);
                continue;
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
        }
        this.update();
        if (tglevel == 30) {
            this.getBasisGraph().getTypeSet().setLevelOfTypeGraphCheck(30);
        }
        table.clear();
        table = null;
        return clone;
    }

    public void dispose() {
        if (this.bGraph != null) {
            this.bGraph.deleteObserver(this);
        }
        this.nodes.removeAllElements();
        this.arcs.removeAllElements();
        this.selectedNodes.removeAllElements();
        this.selectedArcs.removeAllElements();
        this.lastTransRule = null;
        this.selectedNode = null;
        this.selectedArc = null;
        this.pickedObj = null;
        if (this.lastNewObjects != null) {
            this.lastNewObjects.clear();
        }
        this.changedGraphObjects.clear();
        this.gCopy = null;
        this.typeSet = null;
        this.eGra = null;
    }

    public void delArc(Arc bArc) throws TypeException {
        EdArc eArc = this.findArc(bArc);
        if (eArc != null) {
            this.delSelectedArc(eArc);
        }
    }

    public void delNode(Node bNode) throws TypeException {
        Vector<EdArc> inArcs = new Vector<EdArc>();
        Vector<EdArc> outArcs = new Vector<EdArc>();
        EdArc eArc = null;
        EdNode eNode = this.findNode(bNode);
        if (eNode != null) {
            int j;
            for (j = 0; j < this.arcs.size(); ++j) {
                eArc = (EdArc)this.arcs.elementAt(j);
                if (eNode.equals(eArc.getSource())) {
                    outArcs.addElement(eArc);
                    continue;
                }
                if (!eNode.equals(eArc.getTarget()) || !eArc.isLine()) continue;
                inArcs.addElement(eArc);
            }
            if (!inArcs.isEmpty()) {
                for (j = 0; j < inArcs.size(); ++j) {
                    eArc = (EdArc)inArcs.elementAt(j);
                    this.arcs.removeElement(eArc);
                }
                inArcs.removeAllElements();
            }
            if (!outArcs.isEmpty()) {
                for (j = 0; j < outArcs.size(); ++j) {
                    eArc = (EdArc)outArcs.elementAt(j);
                    this.arcs.removeElement(eArc);
                }
                outArcs.removeAllElements();
            }
            this.delSelectedNode(eNode);
        }
    }

    public void delSelectedNode(EdNode eNode) throws TypeException {
        this.delSelectedNode(eNode, false);
    }

    public void delSelectedNode(EdNode eNode, boolean forceDelete) throws TypeException {
        boolean canDelete = true;
        if (this.bGraph != null) {
            canDelete = false;
            try {
                if (!forceDelete) {
                    this.bGraph.destroyNode(eNode.getBasisNode(), true);
                } else {
                    this.bGraph.destroyNode(eNode.getBasisNode(), true, true);
                }
                canDelete = true;
            }
            catch (TypeException e) {
                throw new TypeException(e.getTypeError());
            }
        }
        if (canDelete) {
            this.nodes.removeElement(eNode);
            if (this.lastNewObjects != null && !this.lastNewObjects.isEmpty() && this.lastNewObjects.contains(eNode)) {
                this.lastNewObjects.removeElement(eNode);
            }
            eNode.dispose();
            eNode = null;
        }
    }

    public void delSelectedArc(EdArc eArc) throws TypeException {
        this.delSelectedArc(eArc, false);
    }

    public void delSelectedArc(EdArc eArc, boolean forceDelete) throws TypeException {
        boolean canDelete = true;
        if (this.bGraph != null) {
            canDelete = false;
            try {
                if (!forceDelete) {
                    this.bGraph.destroyArc(eArc.getBasisArc(), true);
                } else {
                    this.bGraph.destroyArc(eArc.getBasisArc(), true, true);
                }
                canDelete = true;
            }
            catch (TypeException e) {
                throw new TypeException(e.getTypeError());
            }
        }
        if (canDelete) {
            this.arcs.removeElement(eArc);
            if (this.lastNewObjects != null && !this.lastNewObjects.isEmpty() && this.lastNewObjects.contains(eArc)) {
                this.lastNewObjects.removeElement(eArc);
            }
            eArc.dispose();
            eArc = null;
        }
    }

    public synchronized void deleteSelectedNodes() throws TypeException {
        if (this.selectedNodes == null) {
            return;
        }
        for (int i = 0; i < this.selectedNodes.size(); ++i) {
            EdNode eNode = (EdNode)this.selectedNodes.elementAt(i);
            this.delSelectedNode(eNode);
        }
        this.selectedNodes.removeAllElements();
    }

    public synchronized void deleteSelectedArcs() throws TypeException {
        if (this.selectedArcs == null) {
            return;
        }
        for (int i = 0; i < this.selectedArcs.size(); ++i) {
            EdArc eArc = (EdArc)this.selectedArcs.elementAt(i);
            this.delSelectedArc(eArc);
        }
        this.selectedArcs.removeAllElements();
    }

    public synchronized void deleteSelected() throws TypeException {
        this.deleteSelectedArcs();
        this.deleteSelectedNodes();
        this.update();
    }

    public void deleteAll() throws TypeException {
        this.selectAll();
        this.deleteSelected();
    }

    public boolean deleteObj(int x, int y) throws TypeException {
        EdGraphObject obj = this.getPicked(x, y);
        if (obj != null) {
            if (obj.isNode()) {
                EdNode en = obj.getNode();
                this.delSelectedNode(en);
            } else {
                EdArc ea = obj.getArc();
                this.delSelectedArc(ea);
            }
            this.update();
            return true;
        }
        return false;
    }

    public void deleteObj(EdGraphObject ego) throws TypeException {
        if (ego == null) {
            return;
        }
        if (ego.isNode()) {
            EdNode en = ego.getNode();
            this.delSelectedNode(en);
        } else {
            EdArc ea = ego.getArc();
            this.delSelectedArc(ea);
        }
        this.update();
    }

    public void forceDeleteObj(EdGraphObject ego) throws TypeException {
        if (ego == null) {
            return;
        }
        if (ego.isNode()) {
            EdNode en = ego.getNode();
            this.delSelectedNode(en, true);
        } else {
            EdArc ea = ego.getArc();
            this.delSelectedArc(ea, true);
        }
        this.update();
    }

    public void deleteObjects(EdGraphObject typeGraphObject) throws TypeException {
        if (typeGraphObject == null) {
            return;
        }
        if (typeGraphObject.isNode()) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                EdNode en = (EdNode)this.nodes.elementAt(i);
                if (!en.getType().equals(typeGraphObject.getType())) continue;
                this.delSelectedNode(en);
                --i;
            }
        } else {
            for (int i = 0; i < this.arcs.size(); ++i) {
                EdArc ea = (EdArc)this.arcs.elementAt(i);
                if (!ea.getType().equals(((EdArc)typeGraphObject).getType()) || !ea.getSource().getType().equals(((EdArc)typeGraphObject).getSource().getType()) || !ea.getTarget().getType().equals(((EdArc)typeGraphObject).getTarget().getType())) continue;
                this.delSelectedArc(ea);
                --i;
            }
        }
        this.update();
    }

    public synchronized void deleteObjects(EdType t) throws TypeException {
        int i;
        if (t == null) {
            return;
        }
        boolean nodeType = false;
        for (i = 0; i < this.nodes.size(); ++i) {
            EdNode en = (EdNode)this.nodes.elementAt(i);
            if (!en.getType().isParentOf(t)) continue;
            nodeType = true;
            this.delSelectedNode(en);
            --i;
        }
        if (!nodeType) {
            for (i = 0; i < this.arcs.size(); ++i) {
                EdArc ea = (EdArc)this.arcs.elementAt(i);
                if (!ea.getType().isParentOf(t)) continue;
                this.delSelectedArc(ea);
                --i;
            }
        }
        this.update();
    }

    public synchronized void straightSelectedArcs() {
        if (this.selectedArcs == null) {
            return;
        }
        if (this.selectedArcs.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.selectedArcs.size(); ++i) {
            EdArc ea = (EdArc)this.selectedArcs.elementAt(i);
            if (!ea.isLine()) continue;
            ea.setAnchor(null);
        }
    }

    public void straightArc(EdGraphObject ego) {
        EdArc ea;
        if (ego == null) {
            return;
        }
        if (ego.isArc() && (ea = ego.getArc()).isLine()) {
            ea.setAnchor(null);
        }
    }

    public void copySelected(int x, int y) {
        EdGraphObject eo;
        int i;
        if (this.nothingSelected()) {
            if (this.gCopy != null) {
                this.addGraph(this.gCopy, x, y);
                this.gCopy = null;
                return;
            }
            this.errMsg = "bad selection";
            this.gCopy = null;
            return;
        }
        if (!this.selectedArcsOK()) {
            this.errMsg = "bad selection";
            return;
        }
        Vector<EdGraphObject> sel = new Vector<EdGraphObject>();
        Vector<EdGraphObject> selCopy = new Vector<EdGraphObject>();
        for (i = 0; i < this.selectedNodes.size(); ++i) {
            EdNode en = (EdNode)this.selectedNodes.elementAt(i);
            sel.addElement(en);
        }
        for (i = 0; i < this.selectedArcs.size(); ++i) {
            EdArc ea = (EdArc)this.selectedArcs.elementAt(i);
            sel.addElement(ea);
        }
        if (sel.isEmpty()) {
            this.errMsg = "bad selection";
            return;
        }
        for (i = 0; i < sel.size(); ++i) {
            eo = (EdGraphObject)sel.elementAt(i);
            EdGraphObject eoCopy = this.copyGraphObject(eo, x, y);
            if (eoCopy == null) continue;
            selCopy.addElement(eoCopy);
        }
        for (i = 0; i < this.selectedNodes.size(); ++i) {
            ((EdNode)this.selectedNodes.elementAt(i)).setSelected(false);
            ((EdNode)this.selectedNodes.elementAt(i)).setCopy(null);
        }
        this.selectedNodes.removeAllElements();
        if (this.selectedArcs != null) {
            for (i = 0; i < this.selectedArcs.size(); ++i) {
                ((EdArc)this.selectedArcs.elementAt(i)).setSelected(false);
                ((EdArc)this.selectedArcs.elementAt(i)).setCopy(null);
            }
            this.selectedArcs.removeAllElements();
        }
        for (i = 0; i < selCopy.size(); ++i) {
            eo = (EdGraphObject)selCopy.elementAt(i);
            eo.setSelected(true);
            if (eo.isNode()) {
                this.selectedNodes.addElement(eo.getNode());
                continue;
            }
            this.selectedArcs.addElement(eo.getArc());
        }
    }

    private EdGraphObject copyGraphObject(EdGraphObject srcObj, int x, int y) {
        EdGraphObject eoCopy = null;
        EdGraphObject src = null;
        EdGraphObject tar = null;
        Point p = this.findCenter(this.selectedNodes);
        if (srcObj.isNode() && srcObj.getCopy() == null) {
            eoCopy = this.copyNode(srcObj.getNode(), x, y, p);
            srcObj.setCopy(eoCopy);
        } else if (srcObj.isArc() && srcObj.getCopy() == null) {
            src = srcObj.getArc().getSource().getCopy() == null ? this.copyGraphObject(srcObj.getArc().getSource(), x, y) : srcObj.getArc().getSource().getCopy();
            tar = srcObj.getArc().getTarget().getCopy() == null ? this.copyGraphObject(srcObj.getArc().getTarget(), x, y) : srcObj.getArc().getTarget().getCopy();
            if (src != null && tar != null) {
                int dx = tar.getX() - srcObj.getArc().getTarget().getX();
                int dy = tar.getY() - srcObj.getArc().getTarget().getY();
                eoCopy = this.copyArc(srcObj.getArc(), src, tar, dx, dy);
                srcObj.setCopy(eoCopy);
            }
        }
        return eoCopy;
    }

    private EdNode copyNode(EdNode en, int x, int y, Point p) {
        EdNode cn = null;
        if (this.bGraph != null) {
            Node bn = null;
            try {
                bn = this.bGraph.createNode(en.getBasisNode());
                cn = new EdNode(bn, en.getType());
                cn.setMyKey(this.mark++);
                this.nodes.addElement(cn);
                if (this.isTG) {
                    cn.markElementOfTypeGraph(true);
                }
            }
            catch (TypeException e) {}
        } else {
            try {
                cn = this.addNode(this.bGraph, x, y, en.getType(), true);
            }
            catch (TypeException e) {
                // empty catch block
            }
        }
        if (cn != null) {
            int dx = x - p.x;
            int dy = y - p.y;
            int newX = en.getX() + dx;
            int newY = en.getY() + dy;
            if (newX <= 0) {
                newX = newX - newX + cn.getWidth() * 2;
            }
            if (newY <= 0) {
                newY = newY - newY + cn.getHeight() * 2;
            }
            if (newX >= 700) {
                newX = 700 - cn.getWidth();
            }
            if (newY >= 600) {
                newY = 600 - cn.getHeight();
            }
            cn.setReps(newX, newY, true, false);
        }
        return cn;
    }

    public EdNode copyNode(EdNode en, int x, int y) {
        EdNode cn = null;
        EdType t = null;
        if (this.typeSet.getBasisTypeSet().containsType(en.getType().getBasisType())) {
            t = this.typeSet.createNodeType(en.getType().getBasisType(), en.getType().getName(), en.getType().getShape(), en.getType().getColor());
        } else {
            t = this.typeSet.createNodeType(en.getType().getName(), en.getType().getShape(), en.getType().getColor());
            if (t != null) {
                DeclTuple decl = (DeclTuple)en.getType().getBasisType().getAttrType();
                AttrHandler javaHandler = DefaultInformationFacade.self().getJavaHandler();
                int num = decl.getNumberOfEntries();
                for (int i = 0; i < num; ++i) {
                    DeclMember mem = (DeclMember)decl.getMemberAt(i);
                    t.getBasisType().getAttrType().addMember(javaHandler, mem.getTypeName(), mem.getName());
                }
            }
        }
        if (t == null) {
            t = this.typeSet.getType(this.typeSet.getNodeTypes(), en.getType().getName(), en.getType().getShape(), en.getType().getColor());
        }
        if (t != null) {
            this.typeSet.setSelectedNodeType(t);
            try {
                cn = this.addNode(this.bGraph, x, y, t, true);
                cn.getBasisNode().copyAttributes(en.getBasisNode());
            }
            catch (TypeException e) {
                // empty catch block
            }
        }
        return cn;
    }

    public EdArc copyArc(EdArc ea, EdGraphObject src, EdGraphObject tar) {
        EdArc ca = null;
        EdType t = this.typeSet.createArcType(ea.getType().getBasisType(), ea.getType().getName(), ea.getType().getShape(), ea.getType().getColor());
        if (t == null) {
            t = this.typeSet.getType(this.typeSet.getArcTypes(), ea.getType().getName(), ea.getType().getShape(), ea.getType().getColor());
        }
        if (t != null) {
            this.typeSet.setSelectedArcType(t);
            try {
                ca = this.addArc(this.bGraph, t, src, tar, null, ea.isDirected());
                if (ca != null) {
                    ca.getBasisArc().copyAttributes(ea.getBasisArc());
                    if (ea.isLine()) {
                        if (ea.hasAnchor()) {
                            ca.setAnchor(new Point(ea.getX(), ea.getY()));
                        }
                    } else if (ea.hasAnchor()) {
                        ca.setAnchor(1, new Point(ea.getX(), ea.getY()));
                        ca.setWidth(ea.getWidthOfLoop());
                        ca.setHeight(ea.getHeightOfLoop());
                    }
                    ca.setTextOffset(ea.getTextOffset().x, ea.getTextOffset().y);
                    ca.setReps(ea.isDirected(), true, false);
                }
            }
            catch (TypeException e) {
                // empty catch block
            }
        }
        return ca;
    }

    private EdArc copyArc(EdArc ea, EdGraphObject src, EdGraphObject tar, int dx, int dy) {
        EdArc ca = null;
        if (this.bGraph != null) {
            Arc ba = null;
            try {
                ba = this.bGraph.createArc(ea.getBasisArc(), (Node)src.getBasisObject(), (Node)tar.getBasisObject());
                ca = new EdArc(ba, ea.getType(), src, tar);
                this.arcs.addElement(ca);
                ca.setMyKey(this.mark++);
                if (this.isTG) {
                    ca.markElementOfTypeGraph(true);
                }
            }
            catch (TypeException e) {}
        } else {
            try {
                ca = this.addArc(this.bGraph, ea.getType(), src, tar, null, ea.isDirected());
            }
            catch (TypeException e) {
                // empty catch block
            }
        }
        if (ca != null) {
            if (ea.isLine()) {
                if (ea.hasAnchor()) {
                    ca.setAnchor(new Point(ea.getX() + dx, ea.getY() + dy));
                }
            } else if (ea.hasAnchor()) {
                ca.setAnchor(1, new Point(ea.getX() + dx, ea.getY() + dy));
                ca.setWidth(ea.getWidth());
                ca.setHeight(ea.getHeight());
            }
            ca.setTextOffset(ea.getTextOffset().x, ea.getTextOffset().y);
            ca.setReps(ea.isDirected(), true, false);
        }
        return ca;
    }

    private Point findCenter(Vector v) {
        if (v == null) {
            return new Point(0, 0);
        }
        if (v.size() == 0) {
            return new Point(0, 0);
        }
        Vector<Point> points = new Vector<Point>();
        for (int i = 0; i < v.size(); ++i) {
            EdGraphObject o = (EdGraphObject)v.elementAt(i);
            if (o == null) continue;
            points.addElement(new Point(o.getX(), o.getY()));
        }
        CenterOfPoints centerOfPoints = new CenterOfPoints(points);
        return centerOfPoints.getCenter();
    }

    public void setMorphismMarks(HashMap marks, boolean all) {
        String m;
        GraphObject go;
        int i;
        if (all) {
            this.clearMarks();
        }
        for (i = 0; i < this.nodes.size(); ++i) {
            EdNode n = (EdNode)this.nodes.elementAt(i);
            go = n.getBasisNode();
            m = (String)marks.get(go);
            if (m == null || m.length() <= 0 || !all && (all || !n.getMorphismMark().equals(""))) continue;
            n.addMorphismMark(m);
            marks.remove(go);
        }
        for (i = 0; i < this.arcs.size(); ++i) {
            EdArc a = (EdArc)this.arcs.elementAt(i);
            go = a.getBasisArc();
            m = (String)marks.get(go);
            if (m == null || m.length() <= 0 || !all && (all || !a.getMorphismMark().equals(""))) continue;
            a.addMorphismMark(m);
            marks.remove(go);
        }
    }

    public synchronized void doDefaultGraphLayout(boolean attrsVisible) {
        if (this.bGraph == null || this.bGraph.isEmpty()) {
            return;
        }
        if (!this.nodes.isEmpty()) {
            this.nodes.removeAllElements();
        }
        if (!this.arcs.isEmpty()) {
            this.arcs.removeAllElements();
        }
        Enumeration enumNodes = this.bGraph.getNodes();
        while (enumNodes.hasMoreElements()) {
            Node bn = (Node)enumNodes.nextElement();
            EdNode n = this.newNode(this.bGraph, bn, this.nodes);
            if (n.getView() != null) {
                AttrViewSetting mvs = n.getView().getOpenView();
                AttrInstance ai = n.getBasisNode().getAttribute();
                mvs.setVisible(ai);
            }
            n.myUpdate(null);
        }
        int offsetX = 0;
        int offsetY = 0;
        int space = 50;
        int xPos = 10;
        int yPos = 10;
        int w = 700;
        offsetY = ((EdNode)this.nodes.elementAt(0)).getHeight() / 2;
        if (this.realWidthOfGraphPanel > 0) {
            w = this.realWidthOfGraphPanel;
        }
        if (this.nodes.size() > 0) {
            boolean down = false;
            for (int i = 0; i < this.nodes.size(); ++i) {
                EdNode n = (EdNode)this.nodes.elementAt(i);
                offsetX = n.getWidth() / 2;
                offsetY = n.getHeight() / 2;
                if (xPos + offsetX > w) {
                    xPos = 10;
                    yPos = yPos + offsetY * 2 + space * 2;
                    down = false;
                }
                int xp = xPos + offsetX;
                int yp = yPos + offsetY;
                if (down) {
                    yp += space;
                }
                n.setXY(xp, yp);
                xPos = xPos + offsetX + space;
                down = !down;
            }
        }
        Enumeration enumArcs = this.bGraph.getArcs();
        while (enumArcs.hasMoreElements()) {
            Arc ba = (Arc)enumArcs.nextElement();
            EdArc a = this.newArc(this.bGraph, ba, this.arcs);
            if (a.getView() == null) continue;
            AttrViewSetting mvs = a.getView().getOpenView();
            AttrInstance ai = a.getBasisArc().getAttribute();
            mvs.setVisible(ai);
        }
    }

    public void doDefaultEvolutionaryGraphLayout(Layouter layouter, int spaceBetweenParallelEdges) {
        int i;
        if (layouter == null) {
            return;
        }
        this.updateNodePosEtoL();
        Vector nodes = this.getNodes();
        for (i = 0; i < nodes.size(); ++i) {
            EdNode node = (EdNode)nodes.get(i);
            if (node.getNodeID() != -1) continue;
            this.incLastNodeID();
            node.setNodeID(this.getLastNodeID());
        }
        for (i = 0; i < this.getNodes().size(); ++i) {
            ((EdNode)this.getNodes().get(i)).calculateCluster(layouter.getLayoutMetrics().getEpsilon(), this.getNodes());
        }
        Dimension neededpanel = layouter.getNeededPanelSize(this);
        layouter.setPanelSize(neededpanel);
        layouter.newNodesRandomLayout(this);
        layouter.layoutGraph(this);
        if (layouter.doCenter()) {
            layouter.centerLayout(this);
        }
        this.resolveArcOverlappings(spaceBetweenParallelEdges);
        this.hasDefaultLayout = false;
    }

    public final void update(Observable o, Object arg) {
        if (this.bGraph == null) {
            return;
        }
        if (arg == null) {
            return;
        }
        if (arg instanceof Change) {
            GraphObject go = null;
            Change ch = (Change)arg;
            if (ch.getEvent() == 10 || ch.getEvent() == 12 || ch.getEvent() == 13 || ch.getEvent() == 20 || ch.getEvent() == 21) {
                if (ch.getItem() instanceof Node) {
                    go = (Node)ch.getItem();
                } else if (ch.getItem() instanceof Arc) {
                    go = (Arc)ch.getItem();
                } else if (ch.getItem() instanceof Pair) {
                    Pair p = (Pair)ch.getItem();
                    Object obj = p.first;
                    go = obj instanceof Node && this.bGraph.isElement((Node)obj) ? (Node)obj : (obj instanceof Arc && this.bGraph.isElement((Arc)obj) ? (Arc)obj : null);
                }
            } else if (ch.getEvent() == 11 && ch.getItem() instanceof Pair) {
                Pair p = (Pair)ch.getItem();
                Object obj = p.first;
                go = obj instanceof Node && this.bGraph.isElement((Node)obj) ? (Node)obj : (obj instanceof Arc && this.bGraph.isElement((Arc)obj) ? (Arc)obj : null);
            }
            if (go != null) {
                if (this.changedGraphObjects == null) {
                    this.changedGraphObjects = new Vector();
                }
                if (!this.changedGraphObjects.contains(go)) {
                    this.changedGraphObjects.addElement(go);
                }
                this.changed = true;
                if (this.eGra != null) {
                    this.eGra.setChanged(true);
                }
            }
        }
    }

    public Vector getChangedGraphObjects() {
        if (this.changed) {
            Vector<EdGraphObject> v = new Vector<EdGraphObject>();
            for (int i = 0; i < this.changedGraphObjects.size(); ++i) {
                EdGraphObject go = this.findGraphObject((GraphObject)this.changedGraphObjects.elementAt(i));
                if (go == null) continue;
                v.addElement(go);
            }
            this.changed = false;
            this.changedGraphObjects.removeAllElements();
            return v;
        }
        return new Vector(1);
    }

    public boolean hasDefaultLayout() {
        return this.hasDefaultLayout;
    }

    public void update() {
        this.updateGraph();
    }

    public void updateGraph(boolean attrsVisible) {
        if (this.bGraph == null) {
            return;
        }
        if (this.nodes.isEmpty()) {
            this.doDefaultGraphLayout(attrsVisible);
            return;
        }
        this.doUpdateGraph(false);
    }

    public void updateGraph(boolean attrsVisible, boolean selectNewObjects) {
        if (this.bGraph == null) {
            return;
        }
        if (this.nodes.isEmpty() && this.arcs.isEmpty() && this.coMatch == null) {
            this.doDefaultGraphLayout(attrsVisible);
            return;
        }
        this.doUpdateGraph(selectNewObjects);
    }

    public void updateGraph() {
        if (this.bGraph == null) {
            return;
        }
        if (this.nodes.isEmpty() && this.arcs.isEmpty() && this.coMatch == null) {
            this.doDefaultGraphLayout(true);
            return;
        }
        this.doUpdateGraph(false);
    }

    private synchronized void doUpdateGraph(boolean selectNewObjects) {
        Vector<EdGraphObject> newObjects = new Vector<EdGraphObject>();
        Vector<EdNode> newLocalObjects = new Vector<EdNode>();
        Point centerRRS = new Point(0, 0);
        Vector<EdNode> updatedNodes = new Vector<EdNode>();
        Vector<EdArc> updatedArcs = new Vector<EdArc>();
        Enumeration enumNodes = this.bGraph.getNodes();
        Enumeration enumArcs = this.bGraph.getArcs();
        if (this.nodes.isEmpty()) {
            this.upper_left = new Point(0, 0);
        }
        int w = 700;
        if (this.realWidthOfGraphPanel > 0) {
            w = this.realWidthOfGraphPanel;
        }
        while (enumNodes.hasMoreElements()) {
            Node bn = (Node)enumNodes.nextElement();
            EdNode en = this.findNode(bn);
            if (en != null) {
                this.hasOnlyDefaultNodeLayout = false;
                en.setAttributes(en.getBasisNode());
                updatedNodes.addElement(en);
                continue;
            }
            if (bn == null) continue;
            Vector<EdNode> rightPoints = new Vector<EdNode>();
            Vector<EdNode> graphPoints = new Vector<EdNode>();
            if (this.transRule != null) {
                for (int i = 0; i < this.transRule.getRight().getNodes().size(); ++i) {
                    EdNode elem = (EdNode)this.transRule.getRight().getNodes().elementAt(i);
                    if (elem.getMorphismMark().equals("")) continue;
                    rightPoints.addElement(elem);
                    if (this.coMatch == null) continue;
                    GraphObject elemI = this.coMatch.getImage(elem.getBasisObject());
                    EdNode elemImage = this.findNode((Node)elemI);
                    graphPoints.addElement(elemImage);
                }
            }
            centerRRS = this.findCenter(rightPoints);
            this.centerG = this.findCenter(graphPoints);
            if (this.lastCenterG == null) {
                this.lastCenterG = new Point(0, 0);
            } else if (this.lastCenterG.x == 0 && this.lastCenterG.y == 0 && this.centerG != null) {
                this.lastCenterG.x = this.centerG.x;
                this.lastCenterG.y = this.centerG.y;
            }
            EdNode enImage = this.newNode(this.bGraph, bn, updatedNodes);
            if (selectNewObjects) {
                enImage.setSelected(true);
            }
            EdNode enOrig = (EdNode)this.getOrigAfterStep(bn, this.coMatch, this.transRule);
            enImage.setWidth(enImage.getTextWidth(null));
            enImage.setHeight(enImage.getTextHeight(null));
            if (enOrig != null) {
                if (centerRRS.x == 0 && centerRRS.y == 0) {
                    enImage.setX(enOrig.getX());
                    enImage.setY(enOrig.getY());
                } else if (this.centerG != null) {
                    if (this.centerG.x == 0 && this.centerG.y == 0) {
                        enImage.setXY(enOrig.getX(), enOrig.getY());
                    } else if (this.centerG.x + (enOrig.getX() - centerRRS.x) >= 0) {
                        enImage.setX(this.centerG.x + (enOrig.getX() - centerRRS.x));
                    } else if (enImage.getWidth() != 0) {
                        enImage.setX(enImage.getWidth() / 2);
                    } else {
                        enImage.setX(10);
                    }
                    if (this.centerG.y + (enOrig.getY() - centerRRS.y) >= 0) {
                        enImage.setY(this.centerG.y + (enOrig.getY() - centerRRS.y));
                    } else if (enImage.getHeight() != 0) {
                        enImage.setY(enImage.getHeight() / 2);
                    } else {
                        enImage.setY(10);
                    }
                }
                if (enImage.getX() > w) {
                    enImage.setX(20);
                    enImage.setY(enImage.getY() + enOrig.getWidth() / 2 + 20 + 10);
                }
            } else {
                this.setNodePosition(enImage, updatedNodes.size());
            }
            newObjects.addElement(enImage);
        }
        boolean onlyNewObjs = true;
        Enumeration oldNodes = this.nodes.elements();
        while (oldNodes.hasMoreElements()) {
            EdNode n = (EdNode)oldNodes.nextElement();
            if (!updatedNodes.contains(n)) {
                if (this.lastNewObjects != null && !this.lastNewObjects.isEmpty() && this.lastNewObjects.contains(n)) continue;
                n.dispose();
                n = null;
                continue;
            }
            onlyNewObjs = false;
        }
        this.nodes.removeAllElements();
        this.nodes = (Vector)updatedNodes.clone();
        if (selectNewObjects) {
            for (int i = 0; i < updatedNodes.size(); ++i) {
                if (!((EdNode)updatedNodes.get(i)).isSelected()) continue;
                ((EdNode)this.nodes.get(i)).setSelected(false);
                this.select((EdNode)this.nodes.get(i));
            }
        }
        EdGraphObject src = null;
        EdGraphObject tar = null;
        while (enumArcs.hasMoreElements()) {
            boolean wasLine = false;
            Arc ba = (Arc)enumArcs.nextElement();
            EdArc ea = this.findArc(ba);
            if (ea != null) {
                if (ea.isLine()) {
                    wasLine = true;
                }
                ea.setAttributes(ea.getBasisArc());
                src = this.findGraphObject(ea.getBasisArc().getSource());
                tar = this.findGraphObject(ea.getBasisArc().getTarget());
                ea.setSource(src);
                ea.setTarget(tar);
                if (!ea.isLine() && wasLine) {
                    ea.setWidth(0);
                    ea.setHeight(0);
                }
                updatedArcs.addElement(ea);
                continue;
            }
            EdArc eaImage = this.newArc(this.bGraph, ba, updatedArcs);
            if (selectNewObjects) {
                eaImage.setSelected(true);
            }
            EdArc eaOrig = (EdArc)this.getOrigAfterStep(ba, this.coMatch, this.transRule);
            Point dxyAnchorSrc = null;
            Point dxyTarAnchor = null;
            Point dxyTarSrc = null;
            if (eaOrig == null) continue;
            if (eaOrig.isLine() && eaOrig.hasAnchor()) {
                Point p;
                dxyAnchorSrc = new Point(eaOrig.getAnchor().x - eaOrig.getSource().getX(), eaOrig.getAnchor().y - eaOrig.getSource().getY());
                dxyTarAnchor = new Point(eaOrig.getTarget().getX() - eaOrig.getAnchor().x, eaOrig.getTarget().getY() - eaOrig.getAnchor().y);
                dxyTarSrc = new Point(eaOrig.getTarget().getX() - eaOrig.getSource().getX(), eaOrig.getTarget().getY() - eaOrig.getSource().getY());
                if (this.objectsContainSourceAndTargetOfArc(eaImage, newObjects)) {
                    newObjects.addElement(eaImage);
                    p = new Point(eaImage.getSource().getX() + dxyAnchorSrc.x, eaImage.getSource().getY() + dxyAnchorSrc.y);
                    if (p.x < 0 || p.y < 0) {
                        eaImage.setAnchor(null);
                    } else {
                        eaImage.setAnchor(p);
                    }
                } else if (newObjects.contains(eaImage.getSource())) {
                    p = new Point(eaImage.getTarget().getX() - dxyTarAnchor.x, eaImage.getTarget().getY() - dxyTarAnchor.y);
                    if (p.x < 0 || p.y < 0) {
                        eaImage.setAnchor(null);
                    } else {
                        eaImage.setAnchor(p);
                    }
                    eaImage.getSource().setX(eaImage.getTarget().getX() - dxyTarSrc.x);
                    eaImage.getSource().setY(eaImage.getTarget().getY() - dxyTarSrc.y);
                    if (eaImage.getSource().getX() < 0) {
                        eaImage.getSource().setX(20);
                    }
                    if (eaImage.getSource().getY() < 0) {
                        eaImage.getSource().setY(20);
                    }
                    if (eaImage.getSource().getX() > w + 50) {
                        eaImage.getSource().setX(w + 50);
                    }
                    newObjects.removeElement((EdNode)eaImage.getSource());
                    newLocalObjects.addElement((EdNode)eaImage.getSource());
                } else if (newObjects.contains(eaImage.getTarget())) {
                    p = new Point(eaImage.getSource().getX() + dxyAnchorSrc.x, eaImage.getSource().getY() + dxyAnchorSrc.y);
                    if (p.x < 0 || p.y < 0) {
                        eaImage.setAnchor(null);
                    } else {
                        eaImage.setAnchor(p);
                    }
                    eaImage.getTarget().setX(eaImage.getSource().getX() + dxyTarSrc.x);
                    eaImage.getTarget().setY(eaImage.getSource().getY() + dxyTarSrc.y);
                    if (eaImage.getTarget().getX() < 0) {
                        eaImage.getTarget().setX(20);
                    }
                    if (eaImage.getTarget().getY() < 0) {
                        eaImage.getTarget().setY(20);
                    }
                    if (eaImage.getSource().getX() > w + 50) {
                        eaImage.getSource().setX(w + 50);
                    }
                    newObjects.removeElement((EdNode)eaImage.getTarget());
                    newLocalObjects.addElement((EdNode)eaImage.getTarget());
                }
            } else if (eaOrig.isLine() && !eaOrig.hasAnchor()) {
                eaImage.setAnchor(null);
            } else if (!eaOrig.isLine()) {
                if (this.centerG != null && centerRRS != null) {
                    eaImage.setAnchor(1, new Point(this.centerG.x + (eaOrig.getAnchor((int)1).x - centerRRS.x), this.centerG.y + (eaOrig.getAnchor((int)1).y - centerRRS.y)));
                }
                eaImage.setWidth(eaOrig.getWidth());
                eaImage.setHeight(eaOrig.getHeight());
            }
            eaImage.setTextOffset(eaOrig.getTextOffset().x, eaOrig.getTextOffset().y);
        }
        Enumeration oldArcs = this.arcs.elements();
        while (oldArcs.hasMoreElements()) {
            EdArc a = (EdArc)oldArcs.nextElement();
            if (updatedArcs.contains(a)) continue;
            if (this.lastNewObjects != null && !this.lastNewObjects.isEmpty() && this.lastNewObjects.contains(a)) {
                this.lastNewObjects.removeElement(a);
                continue;
            }
            if (!a.getBasisArc().isInheritance()) {
                a.dispose();
            }
            a = null;
        }
        if (this.isTG) {
            Vector oldInhArcs = new Vector(this.inheritanceArcs);
            this.inheritanceArcs.clear();
            Enumeration<Arc> bInhArcs = this.typeSet.getBasisTypeSet().getInheritanceArcs().elements();
            while (bInhArcs.hasMoreElements()) {
                Arc bArc = bInhArcs.nextElement();
                boolean found = false;
                for (EdArc currentArc : oldInhArcs) {
                    if (currentArc.getBasisArc() != bArc) continue;
                    this.inheritanceArcs.add(currentArc);
                    found = true;
                    break;
                }
                if (found) continue;
                this.newInheritanceArc(this.bGraph, bArc, this.inheritanceArcs);
            }
        }
        this.arcs.removeAllElements();
        this.arcs = (Vector)updatedArcs.clone();
        if (selectNewObjects) {
            for (int i = 0; i < updatedArcs.size(); ++i) {
                if (!((EdArc)updatedArcs.get(i)).isSelected()) continue;
                ((EdArc)this.arcs.get(i)).setSelected(false);
                ((EdArc)this.arcs.get(i)).setAnchor(null);
                this.select((EdArc)this.arcs.get(i));
            }
        }
        this.arcs.addAll(this.inheritanceArcs);
        this.doLocalGraphLayout(newLocalObjects, new Point(0, 0));
        this.testOverlapping(newObjects);
    }

    public synchronized void updateGraph(OrdinaryMorphism m1, OrdinaryMorphism m2) {
        GraphObject bImage;
        GraphObject bOrig;
        if (m1 == null || m2 == null) {
            return;
        }
        EdGraph eImageGraph = this;
        eImageGraph.clearMarks();
        EdNode enI = null;
        EdArc eaI = null;
        EdGraph eOrigGraph = new EdGraph(m1.getOriginal());
        EdNode enO = null;
        EdArc eaO = null;
        eOrigGraph.clearMarks();
        Enumeration domain = m1.getDomain();
        while (domain.hasMoreElements()) {
            bOrig = (GraphObject)domain.nextElement();
            bImage = m1.getImage(bOrig);
            enI = eImageGraph.findNode(bImage);
            if (enI != null) {
                if (enI.isMorphismMarkEmpty()) {
                    enI.addMorphismMark(enI.getMyKey());
                }
                if ((enO = eOrigGraph.findNode(bOrig)) == null) continue;
                enO.addMorphismMark(enI.getMorphismMark());
                continue;
            }
            eaI = eImageGraph.findArc(bImage);
            if (eaI == null) continue;
            if (eaI.isMorphismMarkEmpty()) {
                eaI.addMorphismMark(eaI.getMyKey());
            }
            if ((eaO = eOrigGraph.findArc(bOrig)) == null) continue;
            eaO.addMorphismMark(eaI.getMorphismMark());
        }
        domain = m2.getDomain();
        while (domain.hasMoreElements()) {
            bOrig = (GraphObject)domain.nextElement();
            bImage = m2.getImage(bOrig);
            enI = eImageGraph.findNode(bImage);
            if (enI != null) {
                if (enI.isMorphismMarkEmpty()) {
                    enI.addMorphismMark(enI.getMyKey());
                }
                if ((enO = eOrigGraph.findNode(bOrig)) == null) continue;
                enO.addMorphismMark(enI.getMorphismMark());
                continue;
            }
            eaI = eImageGraph.findArc(bImage);
            if (eaI == null) continue;
            if (eaI.isMorphismMarkEmpty()) {
                eaI.addMorphismMark(eaI.getMyKey());
            }
            if ((eaO = eOrigGraph.findArc(bOrig)) == null) continue;
            eaO.addMorphismMark(eaI.getMorphismMark());
        }
    }

    public void setLayoutForSameBasisGraph(EdGraph layout) {
        Vector lNodes = layout.getNodes();
        for (int i = 0; i < lNodes.size(); ++i) {
            EdNode other = (EdNode)lNodes.elementAt(i);
            EdNode obj = this.findNode(other.getBasisNode());
            if (obj == null) continue;
            obj.setXY(other.getX(), other.getY());
            break;
        }
        Vector lArcs = layout.getArcs();
        for (int i = 0; i < lArcs.size(); ++i) {
            EdArc other = (EdArc)lArcs.elementAt(i);
            EdArc obj = this.findArc(other.getBasisArc());
            if (obj == null) continue;
            if (!other.hasAnchor()) break;
            other.setAnchor(1, new Point(other.getAnchor()));
            other.setWidth(other.getWidthOfLoop());
            other.setHeight(other.getHeightOfLoop());
            break;
        }
    }

    public void setLayout(EdGraph layout) {
        this.setLayoutFrom(layout, true, true);
    }

    private void setLayoutFrom(EdGraph layout, boolean ofNodes, boolean ofArcs) {
        EdGraphObject copy;
        int i;
        if (ofNodes) {
            Vector lNodes = layout.getNodes();
            for (i = 0; i < lNodes.size(); ++i) {
                copy = ((EdNode)lNodes.elementAt(i)).copy();
                this.nodes.add(0, copy);
            }
        }
        if (ofArcs) {
            Vector lArcs = layout.getArcs();
            for (i = 0; i < lArcs.size(); ++i) {
                copy = ((EdArc)lArcs.elementAt(i)).copy();
                this.arcs.add(0, copy);
            }
        }
        this.filterLayout();
    }

    public void setLayout(EdGraph layout, boolean foreignLayout) {
        this.setLayout(layout, foreignLayout, false);
    }

    public void setLayout(EdGraph layout, boolean foreignLayout, boolean nodesOnly) {
        if (foreignLayout) {
            Vector lNodes = layout.getNodes();
            block0: for (int i = 0; i < lNodes.size(); ++i) {
                EdNode oi = (EdNode)lNodes.elementAt(i);
                for (int j = 0; j < this.nodes.size(); ++j) {
                    EdNode oj = (EdNode)this.nodes.elementAt(j);
                    if (!oi.getBasisNode().getContextUsage().equals(oj.getBasisNode().getContextUsage())) continue;
                    oj.setXY(oi.getX(), oi.getY());
                    continue block0;
                }
            }
            if (nodesOnly) {
                return;
            }
            Vector lArcs = layout.getArcs();
            block2: for (int i = 0; i < lArcs.size(); ++i) {
                EdArc oi = (EdArc)lArcs.elementAt(i);
                for (int j = 0; j < this.arcs.size(); ++j) {
                    EdArc oj = (EdArc)this.arcs.elementAt(j);
                    if (!oi.getBasisArc().getContextUsage().equals(oj.getBasisArc().getContextUsage())) continue;
                    if (oi.isLine()) {
                        if (oi.hasAnchor()) {
                            oj.setAnchor(new Point(oi.getAnchor()));
                        }
                    } else if (oi.hasAnchor()) {
                        oj.setAnchor(1, new Point(oi.getAnchor()));
                        oj.setWidth(oi.getWidthOfLoop());
                        oj.setHeight(oi.getHeightOfLoop());
                    }
                    oj.setTextOffset(oi.getTextOffset().x, oi.getTextOffset().y);
                    continue block2;
                }
            }
        } else {
            this.setLayout(layout);
        }
    }

    public synchronized void updateLayout(OrdinaryMorphism om, EdGraph layout) {
        int i;
        Vector lNodes = layout.getNodes();
        for (i = 0; i < lNodes.size(); ++i) {
            EdNode copy = ((EdNode)lNodes.elementAt(i)).copy();
            EdNode n = (EdNode)lNodes.elementAt(i);
            this.nodes.add(0, copy);
        }
        for (i = 0; i < this.nodes.size(); ++i) {
            EdNode edNode = (EdNode)this.nodes.elementAt(i);
            Node node = edNode.getBasisNode();
            if (node == null) continue;
            Node newNode = (Node)om.getImage(node);
            edNode.changeBasisNode(newNode);
        }
        this.filterLayout();
    }

    protected void filterLayout() {
        int i;
        int i2;
        Vector<EdNode> removeNodes = new Vector<EdNode>();
        for (i2 = 0; i2 < this.nodes.size(); ++i2) {
            EdNode en = (EdNode)this.nodes.elementAt(i2);
            Node n = this.findBasisNode(en);
            if (n == null) {
                removeNodes.addElement(en);
                continue;
            }
            if (this.bGraph.isElement(n)) continue;
            removeNodes.addElement(en);
        }
        for (i2 = 0; i2 < removeNodes.size(); ++i2) {
            this.nodes.remove(removeNodes.elementAt(i2));
        }
        Vector<EdArc> removeArcs = new Vector<EdArc>();
        for (i = 0; i < this.arcs.size(); ++i) {
            EdArc ea = (EdArc)this.arcs.elementAt(i);
            Arc n = this.findBasisArc(ea);
            if (n == null) {
                removeArcs.addElement(ea);
                continue;
            }
            if (this.bGraph.isElement(n)) continue;
            removeArcs.addElement(ea);
        }
        for (i = 0; i < removeArcs.size(); ++i) {
            this.arcs.remove(removeArcs.elementAt(i));
        }
    }

    public void setCoMatch(Morphism coMorph, EdRule er) {
        this.transRule = er;
        this.coMatch = coMorph;
        this.sameRule = false;
        if (coMorph != null && er != null) {
            if (this.lastTransRule == null) {
                this.lastTransRule = this.transRule;
            } else if (this.transRule != null && this.lastTransRule.equals(this.transRule)) {
                this.sameRule = true;
            } else if (this.transRule != null && !this.lastTransRule.equals(this.transRule)) {
                this.lastTransRule = this.transRule;
                if (this.lastCenterG == null) {
                    this.lastCenterG = new Point(0, 0);
                }
                this.lastCenterG.x = 0;
                this.lastCenterG.y = 0;
            }
        }
    }

    public synchronized void updateWithCoMatch() {
        if (this.coMatch != null && this.transRule != null) {
            this.deselectAll();
            Enumeration e = this.coMatch.getDomain();
            while (e.hasMoreElements()) {
                EdGraphObject go;
                GraphObject o = (GraphObject)e.nextElement();
                GraphObject img = this.coMatch.getImage(o);
                Enumeration inverse = this.transRule.getBasisRule().getInverseImage(o);
                if (inverse.hasMoreElements() || (go = this.findGraphObject(img)) == null) continue;
                go.setSelected(true);
                if (go.isNode()) {
                    this.selectedNodes.addElement((EdNode)go);
                    continue;
                }
                this.selectedArcs.addElement((EdArc)go);
            }
        }
    }

    public synchronized void updateWithMatch(Morphism match) {
        if (match != null) {
            this.deselectAll();
            Enumeration e = match.getDomain();
            while (e.hasMoreElements()) {
                GraphObject o = (GraphObject)e.nextElement();
                GraphObject img = match.getImage(o);
                EdGraphObject go = this.findGraphObject(img);
                if (go == null) continue;
                go.setSelected(true);
                if (go.isNode()) {
                    this.selectedNodes.addElement((EdNode)go);
                    continue;
                }
                this.selectedArcs.addElement((EdArc)go);
            }
        }
    }

    private EdGraphObject getOrigAfterStep(GraphObject image, Morphism coMorph, EdRule er) {
        Enumeration origs;
        if (image == null || coMorph == null || coMorph.getImage() == null || er == null) {
            return null;
        }
        GraphObject orig = null;
        if (coMorph.getImage().isElement(image) && (origs = coMorph.getInverseImage(image)).hasMoreElements()) {
            orig = (GraphObject)origs.nextElement();
        }
        if (orig != null && er.getRight().getBasisGraph().isElement(orig)) {
            if (orig.isNode()) {
                EdNode enOrig = er.getRight().findNode((Node)orig);
                return enOrig;
            }
            EdArc eaOrig = er.getRight().findArc((Arc)orig);
            return eaOrig;
        }
        return null;
    }

    public synchronized void updateSelection() {
        int i;
        this.selectedNodes.removeAllElements();
        this.selectedArcs.removeAllElements();
        for (i = 0; i < this.nodes.size(); ++i) {
            EdNode en = (EdNode)this.nodes.elementAt(i);
            if (!en.isSelected()) continue;
            this.selectedNodes.addElement(en);
        }
        for (i = 0; i < this.arcs.size(); ++i) {
            EdArc ea = (EdArc)this.arcs.elementAt(i);
            if (!ea.isSelected()) continue;
            this.selectedArcs.addElement(ea);
        }
    }

    public void clearMarks() {
        int i;
        for (i = 0; i < this.nodes.size(); ++i) {
            EdNode en = (EdNode)this.nodes.elementAt(i);
            en.clearMorphismMark();
        }
        for (i = 0; i < this.arcs.size(); ++i) {
            EdArc ea = (EdArc)this.arcs.elementAt(i);
            ea.clearMorphismMark();
        }
    }

    public int nextMark() {
        return this.mark++;
    }

    public String getMsg() {
        if (this.errMsg == null) {
            this.errMsg = "";
        }
        return this.errMsg;
    }

    public Dimension getGraphDimension() {
        int offset;
        EdGraphObject elem;
        int i;
        if (this.nodes == null || this.nodes.size() == 0) {
            return new Dimension(0, 0);
        }
        int maxX = 0;
        int maxY = 0;
        for (i = 0; i < this.nodes.size(); ++i) {
            elem = (EdNode)this.nodes.elementAt(i);
            offset = 0;
            offset = elem.getWidth() > elem.getHeight() ? elem.getWidth() : elem.getHeight();
            if (elem.getX() + offset > maxX) {
                maxX = elem.getX() + offset;
            }
            if (elem.getY() + offset <= maxY) continue;
            maxY = elem.getY() + offset;
        }
        for (i = 0; i < this.arcs.size(); ++i) {
            elem = (EdArc)this.arcs.elementAt(i);
            offset = 0;
            offset = elem.getWidth() > elem.getHeight() ? elem.getWidth() : elem.getHeight();
            if (elem.getX() + offset > maxX) {
                maxX = elem.getX() + offset;
            }
            if (elem.getY() + offset <= maxY) continue;
            maxY = elem.getY() + offset;
        }
        return new Dimension(maxX, maxY);
    }

    public Dimension getGraphDimension(double scale) {
        Dimension dim = this.getGraphDimension();
        return new Dimension((int)(scale * (double)dim.width), (int)(scale * (double)dim.height));
    }

    public void setRowLengthOfDefaultLayout(int length) {
        this.rowLength = length;
    }

    public void setRowHeightOfDefaultLayout(int height) {
        this.rowHeight = height;
    }

    public void setRealWidthOfGraphPanel(int w) {
        this.realWidthOfGraphPanel = w;
    }

    private void setNodePosition(EdNode node, int size) {
        int rowWidth = this.realWidthOfGraphPanel;
        if (rowWidth <= 0) {
            rowWidth = 700;
        }
        if (this.rowLength == 0) {
            this.rowLength = 10;
        }
        if (this.rowHeight == 0) {
            this.rowHeight = 50;
        }
        int nn = size;
        int row = 1;
        while (nn - this.rowLength >= 1) {
            ++row;
            nn -= this.rowLength;
        }
        int y = this.rowHeight * (row - 1) + this.rowHeight / 2;
        int column = size - this.rowLength * (row - 1);
        int columnWidth = rowWidth / this.rowLength;
        int x = columnWidth * (column - 1) + columnWidth / 2;
        node.setXY(x, y);
    }

    public void disposeUnusedGraphObjects() {
        if (this.lastNewObjects != null) {
            for (int j = 0; j < this.lastNewObjects.size(); ++j) {
                EdGraphObject o = (EdGraphObject)this.lastNewObjects.elementAt(j);
                if (this.bGraph.isElement(o.getBasisObject())) continue;
                this.lastNewObjects.removeElement(o);
                if (o.isNode()) {
                    ((EdNode)o).dispose();
                } else {
                    ((EdArc)o).dispose();
                }
                this.lastNewObjects.removeElement(o);
                Object var2_2 = null;
            }
        }
    }

    public synchronized void drawGraphics(Graphics g, double scale, boolean all) {
        EdNode n;
        int i;
        for (i = 0; i < this.nodes.size(); ++i) {
            n = (EdNode)this.nodes.elementAt(i);
            if (this.isCPA) {
                n.myNameAttrUpdateOnly(g.getFontMetrics());
                continue;
            }
            if (!all && !n.isSelected()) continue;
            n.myUpdate(g.getFontMetrics());
        }
        for (i = 0; i < this.arcs.size(); ++i) {
            EdArc a = (EdArc)this.arcs.elementAt(i);
            if (this.isCPA) {
                a.drawNameAttrOnly(g, scale);
                continue;
            }
            if (!all && !a.isSelected()) continue;
            a.drawGraphic(g, scale);
        }
        for (i = 0; i < this.nodes.size(); ++i) {
            n = (EdNode)this.nodes.elementAt(i);
            if (this.isCPA) {
                n.drawNameAttrOnly(g, scale);
                continue;
            }
            if (!all && !n.isSelected()) continue;
            n.drawGraphic(g, scale);
        }
    }

    public synchronized void redrawGraphics(Graphics g, double scale) {
        this.drawGraphics(g, scale, true);
    }

    public void drawNode(Graphics g, double scale, EdNode n) {
        n.drawGraphic(g, scale);
    }

    public void drawArc(Graphics g, double scale, EdArc a) {
        a.drawGraphic(g, scale);
        ((EdNode)a.getSource()).drawGraphic(g, scale);
        ((EdNode)a.getTarget()).drawGraphic(g, scale);
    }

    public void drawObj(Graphics g, double scale, EdGraphObject o) {
        if (o.isNode()) {
            ((EdNode)o).drawGraphic(g, scale);
        } else {
            ((EdArc)o).drawGraphic(g, scale);
        }
    }

    public synchronized void drawNodes(Graphics g, double scale, Vector v) {
        for (int j = 0; j < v.size(); ++j) {
            EdNode n = (EdNode)v.elementAt(j);
            this.drawNode(g, scale, n);
        }
    }

    public synchronized void drawArcs(Graphics g, double scale, Vector v) {
        for (int j = 0; j < v.size(); ++j) {
            EdArc a = (EdArc)v.elementAt(j);
            this.drawArc(g, scale, a);
        }
    }

    public synchronized void drawSelected(Graphics g, double scale) {
        for (int j = 0; j < this.selectedArcs.size(); ++j) {
            EdArc a = (EdArc)this.selectedArcs.elementAt(j);
            a.drawGraphic(g, scale);
            EdNode src = (EdNode)a.getSource();
            EdNode trg = (EdNode)a.getTarget();
            if (!this.selectedNodes.contains(src)) {
                src.drawGraphic(g, scale);
            }
            if (this.selectedNodes.contains(trg)) continue;
            trg.drawGraphic(g, scale);
        }
        this.drawNodes(g, scale, this.selectedNodes);
    }

    public void eraseNode(Graphics g, double scale, EdNode n) {
        this.eraseArcs(g, scale, this.getIncomingArcs(n));
        this.eraseArcs(g, scale, this.getOutgoingArcs(n));
        n.eraseGraphic(g, scale);
    }

    public synchronized void eraseNodes(Graphics g, double scale, Vector v) {
        for (int j = 0; j < v.size(); ++j) {
            EdNode n = (EdNode)v.elementAt(j);
            this.eraseNode(g, scale, n);
        }
    }

    public synchronized void eraseArc(Graphics g, double scale, EdArc a) {
        a.eraseGraphic(g, scale);
        ((EdNode)a.getSource()).drawGraphic(g, scale);
        ((EdNode)a.getTarget()).drawGraphic(g, scale);
    }

    public void eraseArcs(Graphics g, double scale, Vector v) {
        for (int j = 0; j < v.size(); ++j) {
            EdArc a = (EdArc)v.elementAt(j);
            this.eraseArc(g, scale, a);
        }
    }

    public void eraseObj(Graphics g, double scale, EdGraphObject o) {
        if (o.isNode()) {
            this.eraseNode(g, scale, (EdNode)o);
        } else {
            this.eraseArc(g, scale, (EdArc)o);
        }
    }

    public synchronized void eraseSelected(Graphics g, double scale, boolean redraw) {
        int j;
        for (j = 0; j < this.selectedArcs.size(); ++j) {
            EdArc a = (EdArc)this.selectedArcs.elementAt(j);
            if (redraw) {
                a.setSelected(false);
                this.drawArc(g, scale, a);
            } else {
                a.eraseGraphic(g, scale);
            }
            EdNode src = (EdNode)a.getSource();
            EdNode trg = (EdNode)a.getTarget();
            if (!this.selectedNodes.contains(src)) {
                this.drawNode(g, scale, src);
            }
            if (this.selectedNodes.contains(trg)) continue;
            this.drawNode(g, scale, trg);
        }
        for (j = 0; j < this.selectedNodes.size(); ++j) {
            EdNode n = (EdNode)this.selectedNodes.elementAt(j);
            if (redraw) {
                n.setSelected(false);
                this.drawNode(g, scale, n);
                continue;
            }
            n.eraseGraphic(g, scale);
        }
    }

    public Vector getIncomingArcs(EdNode en) {
        Vector<EdArc> in = new Vector<EdArc>();
        for (int i = 0; i < this.arcs.size(); ++i) {
            if (!((EdArc)this.arcs.elementAt(i)).getTarget().equals(en)) continue;
            in.addElement((EdArc)this.arcs.elementAt(i));
        }
        return in;
    }

    public Vector getOutgoingArcs(EdNode en) {
        Vector<EdArc> out = new Vector<EdArc>();
        for (int i = 0; i < this.arcs.size(); ++i) {
            if (!((EdArc)this.arcs.elementAt(i)).getSource().equals(en)) continue;
            out.addElement((EdArc)this.arcs.elementAt(i));
        }
        return out;
    }

    private Vector getIncomingArcs(EdArc ea) {
        Vector<EdArc> in = new Vector<EdArc>();
        for (int i = 0; i < this.arcs.size(); ++i) {
            if (!((EdArc)this.arcs.elementAt(i)).getTarget().equals(ea)) continue;
            in.addElement((EdArc)this.arcs.elementAt(i));
        }
        return in;
    }

    private Vector getOutgoingArcs(EdArc ea) {
        Vector<EdArc> out = new Vector<EdArc>();
        for (int i = 0; i < this.arcs.size(); ++i) {
            if (!((EdArc)this.arcs.elementAt(i)).getSource().equals(ea)) continue;
            out.addElement((EdArc)this.arcs.elementAt(i));
        }
        return out;
    }

    public boolean isUsingVariable(VarMember v) {
        return this.bGraph.isUsingVariable(v);
    }

    public void XwriteObject(XMLHelper h) {
        int j;
        if (h.openObject(this.bGraph, this) && this.ggen > 0) {
            h.addAttr("age", this.ggen);
        }
        for (j = 0; j < this.nodes.size(); ++j) {
            EdNode n = (EdNode)this.nodes.elementAt(j);
            h.addObject("", n, true);
        }
        for (j = 0; j < this.arcs.size(); ++j) {
            EdArc a = (EdArc)this.arcs.elementAt(j);
            h.addObject("", a, true);
        }
    }

    public void XreadObject(XMLHelper h) {
        EdArc a;
        int j;
        h.peekObject(this.bGraph, this);
        String age = h.readAttr("age");
        if (age != null && !age.equals("")) {
            this.ggen = new Integer(age);
        }
        for (j = 0; j < this.nodes.size(); ++j) {
            EdNode n = (EdNode)this.nodes.elementAt(j);
            h.enrichObject(n);
        }
        for (j = 0; j < this.arcs.size(); ++j) {
            a = (EdArc)this.arcs.elementAt(j);
            h.enrichObject(a);
        }
        for (j = 0; j < this.arcs.size(); ++j) {
            a = (EdArc)this.arcs.elementAt(j);
            if (a.hasAnchor()) continue;
            this.resizeArc(a, this.spaceBetweenParallelArcs);
        }
        this.hasDefaultLayout = false;
    }

    private synchronized void testOverlapping(Vector objs) {
        int i;
        if (objs == null || objs.isEmpty()) {
            return;
        }
        int w = 700;
        if (this.realWidthOfGraphPanel > 0) {
            w = this.realWidthOfGraphPanel;
        }
        Vector<EdGraphObject> newObjs = new Vector<EdGraphObject>();
        Vector<EdGraphObject> otherArcs = new Vector<EdGraphObject>();
        for (i = 0; i < objs.size(); ++i) {
            boolean srcNew = false;
            boolean trgNew = false;
            EdGraphObject elem = (EdGraphObject)objs.elementAt(i);
            if (elem.isArc()) {
                if (this.objectsContainSourceAndTargetOfArc(elem, objs)) {
                    newObjs.addElement(elem);
                    continue;
                }
                otherArcs.addElement(elem);
                continue;
            }
            newObjs.addElement(elem);
        }
        if (!newObjs.isEmpty()) {
            Dimension d = new Dimension(0, 0);
            int maxDX = 0;
            int maxDY = 0;
            boolean overlap = false;
            if (this.sameRule) {
                if (this.lastNewObjects != null && !this.lastNewObjects.isEmpty()) {
                    BoundingBox bb;
                    int i2;
                    EdGraphObject newObj;
                    boolean sameMatch = false;
                    if (this.lastCenterG.equals(this.centerG)) {
                        sameMatch = true;
                        newObj = null;
                        for (i2 = 0; i2 < this.lastNewObjects.size(); ++i2) {
                            EdGraphObject lastObj = (EdGraphObject)this.lastNewObjects.elementAt(i2);
                            if (i2 < newObjs.size()) {
                                newObj = (EdGraphObject)newObjs.elementAt(i2);
                            }
                            if (lastObj.isNode() && newObj.isNode()) {
                                newObj.setXY(lastObj.getX(), lastObj.getY());
                                if (newObj.getWidth() == 0) {
                                    newObj.setWidth(lastObj.getWidth());
                                }
                                if (newObj.getHeight() == 0) {
                                    newObj.setHeight(lastObj.getHeight());
                                }
                                d = newObj.getNode().ifOverlapFrom(lastObj.getNode());
                                if (d.width == 0 && d.height == 0) continue;
                                if (Math.abs(d.width) > maxDX) {
                                    maxDX = Math.abs(d.width);
                                }
                                if (Math.abs(d.height) > maxDY) {
                                    maxDY = Math.abs(d.height);
                                }
                                overlap = true;
                                continue;
                            }
                            if (newObj.isArc() && newObj.getArc().isLine()) {
                                if (((EdArc)newObj).getBasisArc().isInheritance()) continue;
                                if (newObj.getArc().hasAnchor()) {
                                    newObj.getArc().setAnchor(new Point(lastObj.getArc().getAnchor().x, lastObj.getArc().getAnchor().y));
                                }
                                overlap = true;
                                continue;
                            }
                            if (!newObj.isArc() || newObj.getArc().isLine()) continue;
                            newObj.getArc().setAnchor(1, new Point(lastObj.getArc().getAnchor((int)1).x, lastObj.getArc().getAnchor((int)1).y));
                        }
                    } else {
                        sameMatch = false;
                        newObj = null;
                        for (i2 = 0; i2 < newObjs.size(); ++i2) {
                            newObj = (EdGraphObject)newObjs.elementAt(i2);
                            if (newObj.isNode()) {
                                for (int j = 0; j < this.nodes.size(); ++j) {
                                    EdNode oldObj = (EdNode)this.nodes.elementAt(j);
                                    if (oldObj.equals(newObj.getNode())) continue;
                                    d = oldObj.getNode().ifOverlapFrom(newObj.getNode());
                                    if (d.width == 0 && d.height == 0) continue;
                                    overlap = true;
                                    j = this.nodes.size();
                                }
                            }
                            if (!overlap) continue;
                            i2 = newObjs.size();
                        }
                        if (overlap) {
                            for (i2 = 0; i2 < this.lastNewObjects.size(); ++i2) {
                                EdGraphObject lastObj = (EdGraphObject)this.lastNewObjects.elementAt(i2);
                                if (i2 < newObjs.size()) {
                                    newObj = (EdGraphObject)newObjs.elementAt(i2);
                                }
                                if (lastObj.isNode()) {
                                    newObj.setXY(lastObj.getX(), lastObj.getY());
                                    d = newObj.getNode().ifOverlapFrom(lastObj.getNode());
                                    if (d.width == 0 && d.height == 0) continue;
                                    if (Math.abs(d.width) > maxDX) {
                                        maxDX = Math.abs(d.width);
                                    }
                                    if (Math.abs(d.height) > maxDY) {
                                        maxDY = Math.abs(d.height);
                                    }
                                    overlap = true;
                                    continue;
                                }
                                if (newObj.isArc() && newObj.getArc().isLine()) {
                                    if (((EdArc)newObj).getBasisArc().isInheritance() || !newObj.getArc().hasAnchor()) continue;
                                    newObj.getArc().setAnchor(new Point(lastObj.getArc().getAnchor().x, lastObj.getArc().getAnchor().y));
                                    continue;
                                }
                                if (!newObj.isArc() || newObj.getArc().isLine()) continue;
                                newObj.getArc().setAnchor(1, new Point(lastObj.getArc().getAnchor((int)1).x, lastObj.getArc().getAnchor((int)1).y));
                            }
                        }
                    }
                    if (overlap && sameMatch) {
                        bb = new BoundingBox(newObjs, new Point(this.upper_left.x, this.upper_left.y));
                        bb.setMaxX(w);
                        bb.compute();
                        this.upper_left = bb.getUpperRight();
                        overlap = false;
                    } else if (overlap && !sameMatch) {
                        bb = new BoundingBox(newObjs, new Point(this.upper_left.x, this.upper_left.y));
                        bb.setMaxX(w);
                        bb.compute();
                        this.upper_left = bb.getUpperRight();
                        overlap = false;
                    }
                    if (this.lastCenterG != null && this.centerG != null) {
                        this.lastCenterG.x = this.centerG.x;
                        this.lastCenterG.y = this.centerG.y;
                    }
                } else {
                    this.doLocalGraphLayout(newObjs, new Point(this.upper_left.x, this.upper_left.y));
                }
            } else if (!this.sameRule) {
                BoundingBox bb = new BoundingBox(newObjs, new Point(this.upper_left.x, this.upper_left.y));
                bb.setMaxX(w + 50);
                bb.compute();
                this.upper_left = bb.getUpperRight();
                overlap = true;
            }
            if (this.lastNewObjects == null) {
                this.lastNewObjects = new Vector();
            } else {
                this.disposeUnusedGraphObjects();
                this.lastNewObjects.removeAllElements();
            }
            for (int i3 = 0; i3 < newObjs.size(); ++i3) {
                EdGraphObject elem = (EdGraphObject)newObjs.elementAt(i3);
                this.lastNewObjects.addElement(elem);
            }
        }
        for (i = 0; i < this.arcs.size(); ++i) {
            EdGraphObject elem = (EdGraphObject)this.arcs.elementAt(i);
            this.resizeArc(elem.getArc(), this.spaceBetweenParallelArcs);
        }
    }

    private synchronized void doLocalDefaultGraphLayout(EdGraphObject startGO) {
        if (this.bGraph == null) {
            return;
        }
        int w = 700;
        if (this.realWidthOfGraphPanel > 0) {
            w = this.realWidthOfGraphPanel;
        }
        int offsetX = 0;
        int offsetY = 0;
        for (int i = 0; i < this.nodes.size(); ++i) {
            EdNode n = (EdNode)this.nodes.elementAt(i);
            if (n.getWidth() > offsetX) {
                offsetX = n.getWidth();
            }
            if (n.getHeight() <= offsetY) continue;
            offsetY = n.getHeight();
        }
        offsetX /= 2;
        offsetY /= 2;
        int space = 50;
        int xPos = startGO.getX() + startGO.getWidth() / 2 + space;
        int yPos = startGO.getY();
        int start = this.nodes.indexOf((EdNode)startGO);
        for (int i = start + 1; i < this.nodes.size(); ++i) {
            EdNode n = (EdNode)this.nodes.elementAt(i);
            if (xPos + offsetX > w) {
                xPos = 10;
                yPos = yPos + offsetY + space + offsetY;
            }
            n.setXY(xPos += offsetX, yPos);
            xPos = xPos + offsetX + space;
        }
    }

    private synchronized void doLocalGraphLayout(Vector objs, Point upper_left) {
        int w = 700;
        if (this.realWidthOfGraphPanel > 0) {
            w = this.realWidthOfGraphPanel;
        }
        int c = 0;
        boolean overlap = true;
        Dimension d = new Dimension(0, 0);
        while (overlap && c < 50) {
            overlap = false;
            int maxDX = 0;
            int maxDY = 0;
            for (int i = 0; i < objs.size(); ++i) {
                EdGraphObject obj = (EdGraphObject)objs.elementAt(i);
                if (!obj.isNode()) continue;
                for (int j = 0; j < this.nodes.size(); ++j) {
                    EdNode oldObj = (EdNode)this.nodes.elementAt(j);
                    if (oldObj.equals(obj)) continue;
                    d = oldObj.ifOverlapFrom(obj.getNode());
                    if (d.width == 0 && d.height == 0) continue;
                    if (Math.abs(d.width) > maxDX) {
                        maxDX = Math.abs(d.width) + 10;
                    }
                    if (Math.abs(d.height) > maxDY) {
                        maxDY = Math.abs(d.height);
                    }
                    overlap = true;
                    ++c;
                    j = this.nodes.size();
                }
            }
            BoundingBox bb = new BoundingBox(objs, new Point(upper_left.x, upper_left.y));
            bb.setMaxX(w + 50);
            bb.setOverlap(maxDX, maxDY);
            bb.compute();
            upper_left = bb.getUpperRight();
        }
    }

    private boolean objectsContainSourceAndTargetOfArc(EdGraphObject ego, Vector objs) {
        boolean srcOK = false;
        boolean trgOK = false;
        for (int j = 0; j < objs.size(); ++j) {
            EdGraphObject elem_j = (EdGraphObject)objs.elementAt(j);
            if (!elem_j.isNode()) continue;
            if (elem_j.getNode().equals(ego.getArc().getSource())) {
                srcOK = true;
            }
            if (!elem_j.getNode().equals(ego.getArc().getTarget())) continue;
            trgOK = true;
        }
        return srcOK && trgOK;
    }

    public void resolveArcOverlappings(int space) {
        for (int j = 0; j < this.arcs.size(); ++j) {
            EdArc a = (EdArc)this.arcs.elementAt(j);
            if (a.hasAnchor()) continue;
            this.resizeArc(a, space);
        }
    }

    private void resizeArc(EdArc ea, int space) {
        if (ea.getBasisArc().isInheritance()) {
            return;
        }
        int step = space;
        if (step < 10) {
            step = 10;
        }
        int nb = 0;
        for (int i = 0; i < this.arcs.size(); ++i) {
            EdArc elem = (EdArc)this.arcs.elementAt(i);
            if (elem.equals(ea)) continue;
            if (elem.isLine() && ea.isLine()) {
                if (elem.getSource().equals(ea.getSource()) && elem.getTarget().equals(ea.getTarget()) || elem.getSource().equals(ea.getTarget()) && elem.getTarget().equals(ea.getSource())) {
                    ++nb;
                    Point p1 = new Point(elem.getSource().getX(), elem.getSource().getY());
                    Point p2 = new Point(elem.getTarget().getX(), elem.getTarget().getY());
                    Point p = new Point(p1.x + (p2.x - p1.x) / 2, p1.y + (p2.y - p1.y) / 2);
                    int aa = (p.x - p1.x) * (p.x - p1.x) + (p.y - p1.y) * (p.y - p1.y);
                    int k0 = 2;
                    try {
                        int a = (int)Math.sqrt(aa);
                        k0 = a / step;
                    }
                    catch (ArithmeticException aex) {
                        aex.printStackTrace();
                    }
                    if (k0 == 0) {
                        k0 = 2;
                    }
                    if (!elem.hasAnchor() && !ea.hasAnchor()) {
                        Point p3 = new Point(p.x + (p.y - p1.y) / k0, p.y - (p.x - p1.x) / k0);
                        ea.setAnchor(p3);
                        continue;
                    }
                    if (elem.hasAnchor() && !ea.hasAnchor() || !elem.hasAnchor() && ea.hasAnchor()) continue;
                    if (elem.getAnchor().x == ea.getAnchor().x && elem.getAnchor().y == ea.getAnchor().y) {
                        Point p3 = new Point(p.x + nb * (p.y - p1.y) / k0, p.y - nb * (p.x - p1.x) / k0);
                        ea.setAnchor(p3);
                        continue;
                    }
                    if (ea.getX() > 0 || ea.getY() > 0) continue;
                    ea.setAnchor(null);
                    Line l = ea.toLine();
                    ea.setXY(l.getAnchor().x, l.getAnchor().y);
                    continue;
                }
                if (ea.getX() > 0 || ea.getY() > 0) continue;
                ea.setAnchor(null);
                Line l = ea.toLine();
                ea.setXY(l.getAnchor().x, l.getAnchor().y);
                continue;
            }
            if (elem.isLine() || ea.isLine() || !elem.getSource().equals(ea.getSource())) continue;
            Loop loop = null;
            if (ea.getWidth() == ea.getHeight() && ea.getHeight() == 0) {
                if (ea.getSource().isNode()) {
                    int w1;
                    int h1 = w1 = ea.getWidthOfLoop();
                    int x1 = ea.getSource().getX() - ea.getSource().getNode().getWidth() / 2 - w1 / 2 - w1 / 4;
                    int y1 = ea.getSource().getY() - ea.getSource().getNode().getHeight() / 2 - h1 / 2 - h1 / 4;
                    loop = new Loop(x1, y1, w1, h1);
                }
            } else {
                loop = ea.toLoop();
            }
            if ((elem.getAnchor((int)1).x != loop.getAnchor((int)1).x || elem.getAnchor((int)1).y != loop.getAnchor((int)1).y) && (elem.getWidth() != loop.w || elem.getHeight() != loop.h)) continue;
            ea.setAnchor(1, new Point(elem.getAnchor((int)1).x - step, elem.getAnchor((int)1).y - step));
            ea.setWidth(elem.getWidthOfLoop() + step);
            ea.setHeight(elem.getHeightOfLoop() + step);
        }
    }

    private void showAttrs(AttrInstance attr) {
        System.out.println("Attribute Value:");
        ValueTuple vt = (ValueTuple)attr;
        for (int k = 0; k < vt.getSize(); ++k) {
            ValueMember vm = vt.getValueMemberAt(k);
            System.out.println(vm);
        }
        System.out.println("----------------");
    }

    public void updateNodePosLtoE() {
        for (int i = 0; i < this.nodes.size(); ++i) {
            EdNode e = (EdNode)this.nodes.get(i);
            e.setXY(e.getLNode().getAkt().x, e.getLNode().getAkt().y);
        }
    }

    public void updateNodePosEtoL() {
        for (int i = 0; i < this.nodes.size(); ++i) {
            EdNode e = (EdNode)this.nodes.get(i);
            e.getLNode().setAkt(new Point(e.getX(), e.getY()));
        }
    }

    public void updateLengthOfLayoutEdge(int l) {
        for (int i = 0; i < this.arcs.size(); ++i) {
            EdArc e = (EdArc)this.arcs.get(i);
            e.getLArc().setAktLength(l);
            e.getLArc().setPrefLength(l);
        }
    }

    public Dimension getMaxNodeDim() {
        int w = 0;
        int h = 0;
        for (int i = 0; i < this.nodes.size(); ++i) {
            EdNode e = (EdNode)this.nodes.get(i);
            w = Math.max(w, e.getWidth());
            h = Math.max(h, e.getHeight());
        }
        Dimension d = new Dimension(w, h);
        return d;
    }

    public Dimension getAverageNodeDim() {
        float aw = 0.0f;
        float ah = 0.0f;
        for (int i = 0; i < this.nodes.size(); ++i) {
            EdNode e = (EdNode)this.nodes.get(i);
            aw += (float)e.getWidth();
            ah += (float)e.getHeight();
        }
        if (!this.nodes.isEmpty()) {
            aw /= (float)this.nodes.size();
            ah /= (float)this.nodes.size();
        }
        Dimension d = new Dimension((int)(aw + 1.0f), (int)(ah + 1.0f));
        return d;
    }

    public Dimension getGraphDim() {
        return this.gDim;
    }

    public void setGraphDim(Dimension d) {
        this.gDim = new Dimension(d);
    }

    public int getGraphGen() {
        return this.ggen;
    }

    public void incGraphGen() {
        ++this.ggen;
        for (int i = 0; i < this.nodes.size(); ++i) {
            ((EdNode)this.nodes.get(i)).getLNode().incAge();
        }
    }

    private boolean addReservedNodeID(int reservedID) {
        for (int i = 0; i < this.reservedNodeIDs.size(); ++i) {
            if (this.reservedNodeIDs.get(i) != reservedID) continue;
            return false;
        }
        this.reservedNodeIDs.add(new Integer(reservedID));
        return true;
    }

    private boolean isReservedNodeID(int nodeID) {
        for (int i = 0; i < this.reservedNodeIDs.size(); ++i) {
            if (this.reservedNodeIDs.get(i) != nodeID) continue;
            return true;
        }
        return false;
    }

    public int getLastNodeID() {
        return this.lastnodeid;
    }

    public void incLastNodeID() {
        ++this.lastnodeid;
        while (this.isReservedNodeID(this.lastnodeid)) {
            ++this.lastnodeid;
        }
    }
}

