/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.attribute.facade.impl.DefaultEditorFacade;
import agg.attribute.gui.AttrTopEditor;
import agg.attribute.view.AttrViewSetting;
import agg.editor.impl.EdArc;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdType;
import agg.editor.impl.GraphPanel;
import agg.xt_basis.GraphObject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.util.Vector;

public abstract class EdGraphObject {
    protected EdType eType;
    protected int x = 0;
    protected int y = 0;
    protected int w;
    protected int h;
    protected boolean elemOfTG = false;
    protected boolean errorMode = false;
    protected boolean visible = true;
    protected Color selectColor = Color.green;
    protected Color backgroundColor = Color.white;
    protected Color criticalColor = Color.green;
    protected int myKey = 0;
    protected transient Vector marks;
    protected transient EdGraphObject myCopy;
    protected transient boolean selected = false;
    protected boolean critical;
    protected transient GraphPanel myGraphPanel;
    protected transient boolean attrObserver = false;
    protected static AttrViewSetting view;
    protected static transient AttrTopEditor topEditor;
    protected static transient boolean init;

    public EdGraphObject(EdType eType) {
        this.eType = eType;
        if (eType != null) {
            eType.setIsUsed(true);
        }
        this.marks = new Vector();
        this.selected = false;
        this.visible = true;
    }

    public abstract GraphObject getBasisObject();

    public abstract boolean isNode();

    public abstract boolean isArc();

    public abstract EdNode getNode();

    public abstract EdArc getArc();

    public abstract Vector getAttributes();

    public abstract void setGraphPanel(GraphPanel var1);

    public abstract Vector setAttributes(GraphObject var1);

    public boolean isAttrObserver() {
        return this.attrObserver;
    }

    public void setAttrObserver(boolean obs) {
        this.attrObserver = obs;
        init = true;
    }

    public EdGraphObject getCopy() {
        return this.myCopy;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public EdType getType() {
        return this.eType;
    }

    public String getTypename() {
        return this.eType.getTypeName();
    }

    public int getMyKey() {
        return this.myKey;
    }

    public String getMorphismMark() {
        if (this.marks == null) {
            this.marks = new Vector();
        }
        StringBuffer markBuf = new StringBuffer();
        for (int i = 0; i < this.marks.size(); ++i) {
            if (i > 0) {
                markBuf.append(',');
            }
            markBuf.append((String)this.marks.elementAt(i));
        }
        return markBuf.toString();
    }

    public int getTextHeight(FontMetrics fm) {
        Vector attrs = this.getAttributes();
        int nn = 0;
        int h1 = 0;
        h1 = fm == null ? 17 : fm.getHeight();
        if (this.myGraphPanel != null && this.myGraphPanel.getCanvas().getFontSize() == 0) {
            return h1;
        }
        if (attrs != null) {
            nn = attrs.size();
            for (int i = 0; i < attrs.size(); ++i) {
                Vector attr = (Vector)attrs.elementAt(i);
                if (!this.elemOfTG && ((String)attr.elementAt(2)).length() == 0) {
                    --nn;
                    continue;
                }
                if (!this.elemOfTG || attr.elementAt(1) != null) continue;
                --nn;
            }
        }
        int h = h1 * nn;
        return h += h1;
    }

    public int getTextWidth(FontMetrics fm) {
        int nn = 6;
        String typeStr = "";
        typeStr = this.getTypeString();
        if (this.isNode() && this.elemOfTG) {
            if (this.getType().getBasisType().isAbstract()) {
                typeStr = !typeStr.equals("") ? "{" + typeStr + "}" : "{ }";
            }
            typeStr = typeStr + " " + ((EdNode)this).getMultiplicityString();
        }
        int w = 0;
        w = fm == null ? nn * typeStr.length() : fm.stringWidth(typeStr);
        if (this.myGraphPanel != null && this.myGraphPanel.getCanvas().getFontSize() == 0) {
            return w;
        }
        Vector attrs = this.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.size(); ++i) {
                String tstStr;
                Vector attr = (Vector)attrs.elementAt(i);
                if (!this.elemOfTG && ((String)attr.elementAt(2)).length() != 0) {
                    tstStr = (String)attr.elementAt(1) + "=" + (String)attr.elementAt(2);
                    if (fm == null) {
                        if (nn * tstStr.length() <= w) continue;
                        w = nn * tstStr.length();
                        continue;
                    }
                    if (fm.stringWidth(tstStr) <= w) continue;
                    w = fm.stringWidth(tstStr);
                    continue;
                }
                if (!this.elemOfTG || attr.elementAt(1) == null) continue;
                tstStr = (String)attr.elementAt(0) + "  " + (String)attr.elementAt(1);
                if (fm == null) {
                    if (nn * tstStr.length() <= w) continue;
                    w = nn * tstStr.length();
                    continue;
                }
                if (fm.stringWidth(tstStr) <= w) continue;
                w = fm.stringWidth(tstStr);
            }
        }
        return w;
    }

    public String getTypeString() {
        String typeStr = this.getMorphismMark().length() == 0 ? this.eType.getTypeName() : this.getMorphismMark() + ":" + this.eType.getTypeName();
        return typeStr;
    }

    public int getShape() {
        return this.eType.shape;
    }

    public Color getColor() {
        return this.eType.color;
    }

    public Color getSelectColor() {
        return this.selectColor;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isElementOfTypeGraph() {
        return this.elemOfTG;
    }

    public boolean hasSimilarType(EdGraphObject eObj) {
        return this.eType.isParentOf(eObj.getType());
    }

    public abstract boolean inside(int var1, int var2);

    public Dimension ifOverlapFrom(EdGraphObject eObj) {
        Point p1 = new Point(this.x - this.w / 2, this.y - this.h / 2);
        Point p2 = new Point(this.x + this.w / 2, this.y - this.h / 2);
        Point p3 = new Point(this.x + this.w / 2, this.y + this.h / 2);
        Point p4 = new Point(this.x - this.w / 2, this.y + this.h / 2);
        Point p11 = new Point(eObj.getX() - eObj.getWidth() / 2, eObj.getY() - eObj.getHeight() / 2);
        Point p12 = new Point(eObj.getX() + eObj.getWidth() / 2, eObj.getY() - eObj.getHeight() / 2);
        Point p13 = new Point(eObj.getX() + eObj.getWidth() / 2, eObj.getY() + eObj.getHeight() / 2);
        Point p14 = new Point(eObj.getX() - eObj.getWidth() / 2, eObj.getY() + eObj.getHeight() / 2);
        int minDist = 10;
        Dimension overlapSize = new Dimension(p3.x + eObj.getWidth() / 2 + minDist - this.x, p3.y + eObj.getHeight() / 2 + minDist - this.y);
        boolean overlap = false;
        if (p1.equals(p11) && p2.equals(p12) && p3.equals(p13) && p4.equals(p14)) {
            overlap = true;
        } else if (this.inside(eObj.getX(), eObj.getY()) || this.inside(p11.x, p11.y) || this.inside(p12.x, p12.y) || this.inside(p13.x, p13.y) || this.inside(p14.x, p14.y) || eObj.inside(this.getX(), this.getY()) || eObj.inside(p1.x, p1.y) || eObj.inside(p2.x, p2.y) || eObj.inside(p3.x, p3.y) || eObj.inside(p4.x, p4.y)) {
            overlap = true;
        }
        if (overlap) {
            return overlapSize;
        }
        return new Dimension(0, 0);
    }

    public void markElementOfTypeGraph(boolean val) {
        this.elemOfTG = val;
    }

    public void setXY(int X, int Y) {
        this.x = X;
        this.y = Y;
    }

    public void setX(int X) {
        this.x = X;
    }

    public void setY(int Y) {
        this.y = Y;
    }

    public void setWidth(int W) {
        this.w = W;
    }

    public void setHeight(int H) {
        this.h = H;
    }

    public void setSelected(boolean sel) {
        this.selected = !this.isSelected() && sel;
    }

    public void setCritical(boolean b) {
        this.critical = b;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public void setBackground(Color c) {
        this.backgroundColor = c;
    }

    public void setType(EdType eType) {
        this.eType = eType;
    }

    public void setMyKey(int m) {
        this.myKey = m;
    }

    public void createMorphismMark() {
        this.marks = new Vector();
    }

    public void addMorphismMark(int m) {
        if (this.marks == null) {
            this.marks = new Vector();
        }
        this.marks.addElement(String.valueOf(m));
    }

    public void addMorphismMark(String m) {
        if (this.marks == null) {
            this.marks = new Vector();
        }
        this.marks.addElement(m);
    }

    public boolean isMorphismMarkEmpty() {
        if (this.marks == null) {
            this.marks = new Vector();
            return true;
        }
        return this.marks.isEmpty();
    }

    public void clearMorphismMark() {
        if (!this.isMorphismMarkEmpty()) {
            this.marks.removeAllElements();
        }
    }

    public void setVisible(boolean vis) {
        this.visible = vis;
    }

    public void setCopy(EdGraphObject ec) {
        this.myCopy = ec;
    }

    public void setAttrViewSetting(AttrViewSetting aView) {
        view = aView;
        init = true;
    }

    protected AttrViewSetting getView() {
        if (!init) {
            topEditor = DefaultEditorFacade.self().getTopEditor();
            view = topEditor.getViewSetting();
            init = true;
        }
        return view;
    }

    protected AttrTopEditor getTopEditor() {
        if (!init) {
            topEditor = DefaultEditorFacade.self().getTopEditor();
            view = topEditor.getViewSetting();
            init = true;
        }
        return topEditor;
    }

    public void setErrorMode(boolean errorMode) {
        this.errorMode = errorMode;
    }

    static {
        init = false;
    }
}

