/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.attribute.AttrInstance;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.attribute.view.AttrViewEvent;
import agg.attribute.view.AttrViewObserver;
import agg.attribute.view.AttrViewSetting;
import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdType;
import agg.editor.impl.GraphPanel;
import agg.layout.LayoutNode;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.TypeException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdNode
extends EdGraphObject
implements AttrViewObserver,
XMLObject {
    private static final transient BasicStroke stroke = new BasicStroke(1.0f);
    private Node bNode;
    private LayoutNode lNode;
    private int nodeid;
    private Vector<Integer> cluster;
    private Vector<Integer> oldcluster;

    public EdNode(Node bNode, EdType eType) {
        super(eType);
        this.bNode = bNode;
        this.setCritical(bNode.isCritical());
        if (this.bNode != null && this.getView() != null) {
            this.getView().addObserver(this, this.bNode.getAttribute());
            this.setAttrObserver(true);
        }
        this.lNode = new LayoutNode(this);
        this.nodeid = -1;
    }

    public EdNode(Graph bGraph, EdType eType) throws TypeException {
        this(bGraph != null ? bGraph.createNode(eType.bType) : null, eType);
    }

    public LayoutNode getLNode() {
        return this.lNode;
    }

    public Node getBasisNode() {
        return this.bNode;
    }

    @Override
    public GraphObject getBasisObject() {
        return this.bNode;
    }

    @Override
    public boolean isNode() {
        return true;
    }

    @Override
    public boolean isArc() {
        return false;
    }

    @Override
    public boolean isVisible() {
        if (this.bNode != null) {
            this.visible = this.bNode.isVisible();
            return this.visible;
        }
        return this.visible;
    }

    @Override
    public EdNode getNode() {
        return this;
    }

    @Override
    public EdArc getArc() {
        return null;
    }

    public int getInOutArcsCount() {
        Arc a;
        int c = 0;
        Enumeration e = this.bNode.getIncomingArcs();
        while (e.hasMoreElements()) {
            a = (Arc)e.nextElement();
            if (a.getSource() == a.getTarget()) continue;
            ++c;
        }
        e = this.bNode.getOutgoingArcs();
        while (e.hasMoreElements()) {
            a = (Arc)e.nextElement();
            if (a.getSource() == a.getTarget()) continue;
            ++c;
        }
        return c;
    }

    public int getInOutLoopsCount() {
        int c = 0;
        Enumeration e = this.bNode.getIncomingArcs();
        while (e.hasMoreElements()) {
            Arc a = (Arc)e.nextElement();
            if (a.getSource() != a.getTarget()) continue;
            ++c;
        }
        return c;
    }

    @Override
    public Vector getAttributes() {
        Vector attrs = new Vector();
        if (this.bNode != null) {
            AttrInstance attributes = this.bNode.getAttribute();
            if (this.getView() != null) {
                AttrViewSetting mvs = this.getView().getMaskedView();
                int number = mvs.getSize(attributes);
                for (int i = 0; i < number; ++i) {
                    Vector<String> tmpAttrVector = new Vector<String>();
                    int index = mvs.convertSlotToIndex(attributes, i);
                    DeclMember currentMember = (DeclMember)attributes.getType().getMemberAt(index);
                    if (this.elemOfTG && currentMember != null && currentMember.getHoldingTuple() != attributes.getType()) continue;
                    tmpAttrVector.addElement(attributes.getTypeAsString(index));
                    tmpAttrVector.addElement(attributes.getNameAsString(index));
                    tmpAttrVector.addElement(attributes.getValueAsString(index));
                    attrs.addElement(tmpAttrVector);
                }
            } else {
                attrs = this.setAttributes(this.bNode);
            }
        }
        return attrs;
    }

    public Vector setAttributes(Node bNode) {
        Vector attrs = new Vector();
        if (bNode == null) {
            return attrs;
        }
        int nattrs = bNode.getAttribute().getNumberOfEntries();
        if (nattrs != 0) {
            for (int i = 0; i < nattrs; ++i) {
                Vector<String> attr = new Vector<String>();
                attr.addElement(bNode.getAttribute().getTypeAsString(i));
                attr.addElement(bNode.getAttribute().getNameAsString(i));
                attr.addElement(bNode.getAttribute().getValueAsString(i));
                attrs.addElement(attr);
            }
        }
        return attrs;
    }

    @Override
    public Vector setAttributes(GraphObject obj) {
        return this.setAttributes((Node)obj);
    }

    public void setBasisNode(Node bNode) {
        this.bNode = bNode;
    }

    public void changeBasisNode(Node newNode) {
        this.bNode = newNode;
    }

    public void setReps(int nX, int nY, boolean nVisible, boolean nSelect) {
        this.setXY(nX, nY);
        this.setVisible(nVisible);
        this.setSelected(nSelect);
    }

    public EdNode copy() {
        EdNode newNode = new EdNode(this.bNode, this.eType);
        newNode.myGraphPanel = this.myGraphPanel;
        newNode.x = this.x;
        newNode.y = this.y;
        newNode.w = this.w;
        newNode.h = this.h;
        return newNode;
    }

    @Override
    public boolean inside(int X, int Y) {
        Rectangle r = new Rectangle(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h);
        return r.contains(X, Y);
    }

    public void drawGraphic(Graphics grs, double scale) {
        ImageIcon icon;
        String fname;
        URL url;
        if (!this.isVisible()) {
            return;
        }
        Graphics2D g = (Graphics2D)grs;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setStroke(stroke);
        this.myUpdate(g.getFontMetrics());
        if (this.getType().isIconable() && (url = ClassLoader.getSystemResource(fname = this.getType().imageFileName)) != null && (icon = new ImageIcon(url)) != null) {
            if (this.isSelected()) {
                g.setPaint(this.getSelectColor());
                g.fill(new Rectangle2D.Double(this.x - this.w / 2 - 2, this.y - this.h / 2 - 2, this.w + 4, this.h + 4));
            } else if (this.isCritical()) {
                g.setPaint(this.criticalColor);
                g.fill(new Rectangle2D.Double(this.x - this.w / 2 - 2, this.y - this.h / 2 - 2, this.w + 4, this.h + 4));
            }
            g.setPaint(this.getColor());
            g.drawImage(icon.getImage(), this.x - this.w / 2, this.y - this.h / 2, null);
            return;
        }
        if (this.backgroundColor != Color.white) {
            g.setPaint(this.backgroundColor);
            g.fill(new Rectangle2D.Double(this.x - this.w / 2, this.y - this.h / 2, this.w + 6, this.h + 6));
        }
        int sh = this.getShape();
        switch (sh) {
            case 51: {
                if (this.isSelected()) {
                    g.setPaint(this.getSelectColor());
                    g.fill(new Rectangle2D.Double(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h));
                } else if (this.isCritical()) {
                    g.setPaint(this.criticalColor);
                    g.fill(new Rectangle2D.Double(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h));
                } else {
                    g.setPaint(Color.white);
                    g.fill(new Rectangle2D.Double(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h));
                }
                g.setPaint(this.getColor());
                g.draw(new Rectangle2D.Double(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h));
                break;
            }
            case 54: {
                if (this.isSelected()) {
                    g.setPaint(this.getSelectColor());
                    g.fillRoundRect(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h, 10, 10);
                } else if (this.isCritical()) {
                    g.setPaint(this.criticalColor);
                    g.fillRoundRect(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h, 10, 10);
                } else {
                    g.setPaint(Color.white);
                    g.fillRoundRect(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h, 10, 10);
                }
                g.setPaint(this.getColor());
                g.drawRoundRect(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h, 10, 10);
                break;
            }
            case 52: {
                int d = this.w;
                if (this.isSelected()) {
                    g.setPaint(this.getSelectColor());
                    g.fillOval(this.x - d / 2, this.y - d / 2, d, d);
                } else if (this.isCritical()) {
                    g.setPaint(this.criticalColor);
                    g.fillOval(this.x - d / 2, this.y - d / 2, d, d);
                } else {
                    g.setPaint(Color.white);
                    g.fillOval(this.x - d / 2, this.y - d / 2, d, d);
                }
                g.setPaint(this.getColor());
                g.drawOval(this.x - d / 2, this.y - d / 2, d, d);
                break;
            }
            case 53: {
                if (this.isSelected()) {
                    g.setPaint(this.getSelectColor());
                    g.fillOval(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h);
                } else if (this.isCritical()) {
                    g.setPaint(this.criticalColor);
                    g.fillOval(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h);
                } else {
                    g.setPaint(Color.white);
                    g.fillOval(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h);
                }
                g.setPaint(this.getColor());
                g.drawOval(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h);
                break;
            }
        }
        Color lastColor = g.getColor();
        if (this.errorMode) {
            g.setPaint(Color.green);
        }
        int fontstyle = g.getFont().getStyle();
        if (this.bNode.getType().isAbstract()) {
            g.setFont(new Font("Dialog", 2, g.getFont().getSize()));
        }
        this.showText(g, this.x, this.y);
        g.setFont(new Font("Dialog", fontstyle, g.getFont().getSize()));
        g.setPaint(lastColor);
    }

    public void myUpdate(FontMetrics fm) {
        this.prepareGraphics(fm);
    }

    public void eraseGraphic(Graphics grs, double scale) {
        Color c = grs.getColor();
        grs.setColor(Color.white);
        grs.fillRect(this.x - this.w / 2 - 1, this.y - this.h / 2 - 1, this.w + 2, this.h + 2);
        grs.setColor(c);
    }

    @Override
    public void attributeChanged(AttrViewEvent ev) {
        if (ev.getID() == 0 || ev.getID() == 20 || ev.getID() == 60 || ev.getID() == 50 || ev.getID() == 220 || ev.getID() == 210) {
            if (this.myGraphPanel != null) {
                this.myGraphPanel.updateGraphics();
            }
        } else if (ev.getID() == 80 || ev.getID() == 70) {
            if (ev.getSource().isValid()) {
                if (this.myGraphPanel != null) {
                    ValueMember val;
                    if (this.myGraphPanel.isAttrEditorActivated() && this.bNode.getContext().getAttrContext() != null && (val = ((ValueTuple)this.bNode.getAttribute()).getValueMemberAt(ev.getIndex())).isSet() && val.getExpr().isVariable()) {
                        ContextView viewContext = (ContextView)((ValueTuple)val.getHoldingTuple()).getContext();
                        VarTuple variable = (VarTuple)viewContext.getVariables();
                        VarMember var = variable.getVarMemberAt(val.getExprAsText());
                        if (var == null) {
                            return;
                        }
                        if (this.bNode.getContext().isNacGraph()) {
                            var.setMark(2);
                        } else if (viewContext.doesAllowComplexExpressions()) {
                            var.setMark(1);
                        } else {
                            var.setMark(0);
                        }
                    }
                    this.myGraphPanel.updateGraphics();
                }
            } else {
                ValueMember am;
                ValueTuple attr = (ValueTuple)this.bNode.getAttribute();
                for (int i = 0; i < attr.getSize() && (am = (ValueMember)attr.getMemberAt(i)).isValid(); ++i) {
                }
            }
        }
    }

    @Override
    public void setGraphPanel(GraphPanel gp) {
        this.myGraphPanel = gp;
    }

    public Rectangle toRectangle() {
        return new Rectangle(this.getX() - this.getWidth() / 2, this.getY() - this.getHeight() / 2, this.getWidth(), this.getHeight());
    }

    public void dispose() {
        if (this.isAttrObserver() && this.bNode != null && this.bNode.getAttribute() != null) {
            this.getView().removeObserver(this, this.bNode.getAttribute());
            this.getView().getOpenView().removeObserver(this, this.bNode.getAttribute());
            this.getView().getMaskedView().removeObserver(this, this.bNode.getAttribute());
            this.getView().getOpenView().dispose();
            this.getView().getMaskedView().dispose();
            this.getView().dispose();
        }
        this.bNode = null;
    }

    private void prepareGraphics(FontMetrics fm) {
        ImageIcon icon;
        String fname;
        URL url;
        int w1;
        int h1 = this.getTextHeight(fm) + 4;
        if (h1 < 20) {
            h1 = 20;
        }
        if ((w1 = this.getTextWidth(fm) + 6) < 20) {
            w1 = h1;
        }
        this.setWidth(w1);
        this.setHeight(h1);
        if (this.getType().isIconable() && (url = ClassLoader.getSystemResource(fname = this.getType().imageFileName)) != null && (icon = new ImageIcon(url)) != null) {
            h1 = icon.getIconHeight();
            w1 = icon.getIconWidth();
            this.setWidth(w1);
            this.setHeight(h1);
            return;
        }
        int sh = this.getShape();
        switch (sh) {
            case 51: {
                break;
            }
            case 54: {
                break;
            }
            case 52: {
                int d1 = (int)Math.sqrt((double)(this.w * this.w) + (double)(this.h * this.h));
                int d2 = this.w;
                if (this.h > this.w) {
                    d2 = this.h;
                }
                int d = (d1 + d2) / 2;
                this.setWidth(d);
                this.setHeight(d);
                break;
            }
            case 53: {
                int hor = 0;
                int ver = 0;
                hor = (int)Math.sqrt((double)(this.w * this.w) + (double)(this.h * this.h));
                if (this.w == this.h) {
                    ver = hor - hor / 4;
                } else if (this.h > this.w) {
                    ver = hor;
                    hor = ver + ver / 4;
                } else if (this.w > this.h) {
                    ver = hor - hor / 4;
                }
                this.setWidth(hor);
                this.setHeight(ver);
                break;
            }
        }
    }

    protected String getMultiplicityString() {
        String s = "";
        int min = this.bNode.getType().getSourceMin();
        int max = this.bNode.getType().getSourceMax();
        if (min != -1) {
            s = s.concat(String.valueOf(min));
            s = s.concat("..");
            if (max == -1) {
                s = s.concat("*");
            }
        } else {
            s = max != -1 ? s.concat("0..") : "*";
        }
        if (max != -1) {
            s = min != max ? s.concat(String.valueOf(max)) : String.valueOf(max);
        }
        return s;
    }

    private void showText(Graphics g, int centerX, int centerY) {
        int ty1;
        int tx1;
        boolean underlined = false;
        FontMetrics fm = g.getFontMetrics();
        int tw = this.getTextWidth(fm);
        int th = this.getTextHeight(fm);
        int tx = centerX - tw / 2;
        int ty = centerY - th / 2;
        String typeStr = this.getTypeString();
        if (this.bNode.getType().isAbstract()) {
            typeStr = !typeStr.equals("") ? "{" + typeStr + "}" : "{ }";
        }
        String multiplicityStr = "";
        if (this.elemOfTG && !(multiplicityStr = this.getMultiplicityString()).equals("")) {
            tx1 = centerX + tw / 2 - fm.stringWidth(multiplicityStr);
            ty1 = ty + fm.getHeight() / 2 + fm.getDescent() / 2;
            g.drawString(multiplicityStr, tx1, ty1);
        }
        if (!typeStr.equals("")) {
            tx1 = tx;
            ty1 = ty + (fm.getHeight() - fm.getDescent());
            g.drawString(typeStr, tx1, ty1);
            ty += fm.getHeight();
        } else {
            ty = ty + fm.getHeight() + fm.getDescent() / 4;
        }
        if (this.myGraphPanel != null && this.myGraphPanel.getCanvas().getFontSize() == 0) {
            return;
        }
        Vector attrs = this.getAttributes();
        if (attrs != null && !attrs.isEmpty()) {
            for (int i = 0; i < attrs.size(); ++i) {
                String attrStr;
                Vector attr = (Vector)attrs.elementAt(i);
                if (!this.elemOfTG && ((String)attr.elementAt(2)).length() != 0) {
                    attrStr = (String)attr.elementAt(1);
                    attrStr = (String)attr.elementAt(1) + "=";
                    attrStr = attrStr + (String)attr.elementAt(2);
                    if (!underlined) {
                        g.drawLine(tx, ty, tx + tw, ty);
                        underlined = true;
                    }
                    ty1 = ty + (fm.getHeight() - fm.getDescent());
                    g.drawString(attrStr, tx, ty1);
                    ty += fm.getHeight();
                    continue;
                }
                if (!this.elemOfTG || attr.elementAt(1) == null) continue;
                attrStr = (String)attr.elementAt(0);
                attrStr = attrStr + "  ";
                attrStr = attrStr + (String)attr.elementAt(1);
                if (!underlined) {
                    g.drawLine(tx, ty, tx + tw, ty);
                    underlined = true;
                }
                ty1 = ty + (fm.getHeight() - fm.getDescent());
                g.drawString(attrStr, tx, ty1);
                ty += fm.getHeight();
            }
        }
    }

    public void drawNameAttrOnly(Graphics grs, double scale) {
        if (!this.isVisible()) {
            return;
        }
        Graphics2D g = (Graphics2D)grs;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setStroke(new BasicStroke(2.0f));
        this.myNameAttrUpdateOnly(g.getFontMetrics());
        int sh = this.getShape();
        g.setPaint(Color.white);
        g.fillRoundRect(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h, 10, 10);
        g.setPaint(this.getColor());
        g.drawRoundRect(this.x - this.w / 2, this.y - this.h / 2, this.w, this.h, 10, 10);
        this.showNameAttrOnly(g, this.x, this.y);
        g.setStroke(stroke);
    }

    public void myNameAttrUpdateOnly(FontMetrics fm) {
        Vector attrs = this.getAttributes();
        int nn = 1;
        int h1 = 0;
        h1 = fm == null ? 17 : fm.getHeight();
        if (h1 < 20) {
            h1 = 30;
        }
        nn = 6;
        int w1 = 0;
        if (attrs != null) {
            for (int i = 0; i < attrs.size(); ++i) {
                Vector attr = (Vector)attrs.elementAt(i);
                if (!((String)attr.elementAt(1)).equals("name") || ((String)attr.elementAt(2)).length() == 0) continue;
                String tstStr = (String)attr.elementAt(2);
                w1 = fm == null ? nn * tstStr.length() + 6 : fm.stringWidth(tstStr) + 6;
            }
        }
        if (w1 < 20) {
            w1 = h1;
        }
        this.setWidth(w1);
        this.setHeight(h1);
    }

    private void showNameAttrOnly(Graphics grs, int centerX, int centerY) {
        Graphics2D g = (Graphics2D)grs;
        g.setStroke(new BasicStroke(2.0f));
        FontMetrics fm = g.getFontMetrics();
        Vector attrs = this.getAttributes();
        int th = this.getHeight();
        int tw = this.getWidth();
        int tx = centerX - tw / 2 + 9;
        int ty = centerY - th / 2 + 5;
        ty += fm.getHeight();
        if (attrs != null && !attrs.isEmpty()) {
            for (int i = 0; i < attrs.size(); ++i) {
                Vector attr = (Vector)attrs.elementAt(i);
                if (!((String)attr.elementAt(1)).equals("name") || ((String)attr.elementAt(2)).length() == 0) continue;
                String attrStr = (String)attr.elementAt(2);
                g.drawString(attrStr.substring(1, attrStr.length() - 1), tx, ty);
                return;
            }
        }
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        if (h.openObject(this.bNode, this)) {
            h.openSubTag("NodeLayout");
            h.addAttr("X", this.x);
            h.addAttr("Y", this.y);
            h.close();
            if (this.lNode != null) {
                h.addObject("", this.lNode, true);
            }
            h.close();
        }
    }

    @Override
    public void XreadObject(XMLHelper h) {
        h.peekObject(this.bNode, this);
        if (h.readSubTag("NodeLayout")) {
            String s = h.readAttr("X");
            this.x = s.length() == 0 ? 20 : new Integer(s);
            s = h.readAttr("Y");
            this.y = s.length() == 0 ? 20 : new Integer(s);
            h.close();
        }
        h.enrichObject(this.lNode);
        h.close();
    }

    public boolean equalByBasisNode(EdNode enode) {
        return this.getBasisNode().equals(enode.getBasisNode());
    }

    public int isInVectorByBasisNode(Vector enodes) {
        int ret = -1;
        for (int i = 0; i < enodes.size(); ++i) {
            EdNode node = (EdNode)enodes.get(i);
            if (this.getNodeID() != node.getNodeID()) continue;
            ret = i;
            break;
        }
        return ret;
    }

    public void setNodeID(int id) {
        this.nodeid = id;
    }

    public int getNodeID() {
        return this.nodeid;
    }

    public void setCluster(Vector<Integer> clus) {
        this.cluster = new Vector<Integer>(clus);
    }

    public Vector<Integer> getCluster() {
        return this.cluster;
    }

    public void calculateCluster(int epsilon, Vector<EdNode> nodes) {
        this.oldcluster = this.cluster;
        this.cluster = new Vector();
        for (int i = 0; i < nodes.size(); ++i) {
            int ydist;
            int xdist;
            int dist;
            EdNode node = nodes.get(i);
            if (this.equals(node) || (dist = (int)Math.round(Math.sqrt((xdist = Math.abs(node.getX() - this.getX())) * xdist + (ydist = Math.abs(node.getY() - this.getY())) * ydist))) > epsilon) continue;
            this.cluster.addElement(node.getNodeID());
        }
    }

    public Vector<Integer> getOldCluster() {
        return this.oldcluster;
    }
}

