/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.attribute.impl.CondTuple;
import agg.editor.impl.EdArc;
import agg.editor.impl.EdAtomic;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNAC;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdTypeSet;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.TypeException;
import com.objectspace.jgl.HashMap;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;

public class EdRule
implements XMLObject {
    protected Rule bRule;
    protected EdGraph eLeft;
    protected EdGraph eRight;
    protected Vector myNACs;
    protected EdTypeSet typeSet;
    protected transient EdGraGra eGra;
    protected transient Match match;
    protected transient boolean badMapping = false;
    protected transient String errMsg = "";
    public static String ERROR_NO_COMPLETION = "The main reason of the failed match completion may be fact\nthe structure of the rule's LHS is not found in the graph.\nThere may be some other reasons you have to check:\n  - different type of source and target objects \n  - only injective mappings are allowed\n  - dangling condition not satisfied\n  - NAC not satisfied\n  - post application condition not satisfied\n  - type graph check (edge type multiplicity ) is failed\n  - invalid attribute settings\n    (all attributes of the target object have to be set)\n  - attribute conditions are not satisfied.";
    public static String ERROR_NOT_VALID = "No valid match found";

    public EdRule() {
        this.bRule = null;
        this.typeSet = new EdTypeSet();
        this.eLeft = new EdGraph(this.typeSet);
        this.eRight = new EdGraph(this.typeSet);
        this.myNACs = new Vector();
    }

    public EdRule(EdTypeSet types) {
        this();
        this.typeSet = types;
    }

    public EdRule(Rule rule) {
        this.bRule = rule;
        this.typeSet = new EdTypeSet(this.bRule.getLeft());
        this.eLeft = new EdGraph(this.bRule.getLeft(), this.typeSet);
        this.eRight = new EdGraph(this.bRule.getRight(), this.typeSet);
        this.myNACs = new Vector();
        Enumeration nacs = this.bRule.getNACs();
        if (nacs != null) {
            while (nacs.hasMoreElements()) {
                this.createNAC((OrdinaryMorphism)nacs.nextElement());
            }
        }
        this.bRule.getLeft().addObserver(this.eLeft);
        this.bRule.getRight().addObserver(this.eRight);
    }

    public EdRule(Rule rule, EdTypeSet types) {
        this.bRule = rule;
        this.typeSet = types;
        this.eLeft = new EdGraph(this.bRule.getLeft(), this.typeSet);
        this.eRight = new EdGraph(this.bRule.getRight(), this.typeSet);
        this.myNACs = new Vector();
        Enumeration nacs = this.bRule.getNACs();
        if (nacs != null) {
            while (nacs.hasMoreElements()) {
                this.createNAC((OrdinaryMorphism)nacs.nextElement());
            }
        }
        this.bRule.getLeft().addObserver(this.eLeft);
        this.bRule.getRight().addObserver(this.eRight);
    }

    public void unsetBasisRule() {
        this.bRule = null;
    }

    public void dispose() {
        if (this.bRule != null) {
            this.bRule.deleteObserver(this.eLeft);
            this.bRule.deleteObserver(this.eRight);
        }
        this.eLeft.dispose();
        this.eRight.dispose();
        for (int i = 0; i < this.myNACs.size(); ++i) {
            ((EdNAC)this.myNACs.elementAt(i)).dispose();
        }
        this.match = null;
        this.typeSet = null;
        this.eGra = null;
    }

    public void clear() {
        this.eLeft.clear();
        this.eRight.clear();
        for (int i = 0; i < this.myNACs.size(); ++i) {
            ((EdNAC)this.myNACs.elementAt(i)).clear();
        }
    }

    public Rule getBasisRule() {
        return this.bRule;
    }

    public OrdinaryMorphism getMorph() {
        return this.bRule;
    }

    public EdGraph getLeft() {
        return this.eLeft;
    }

    public EdGraph getRight() {
        return this.eRight;
    }

    public EdGraGra getGraGra() {
        return this.eGra;
    }

    public void setGraGra(EdGraGra egra) {
        this.eGra = egra;
        if (egra != null) {
            this.eLeft.setGraGra(egra);
            this.eRight.setGraGra(egra);
            for (int i = 0; i < this.myNACs.size(); ++i) {
                EdNAC nac = (EdNAC)this.myNACs.elementAt(i);
                nac.setGraGra(egra);
                nac.setTypeSet(egra.getTypeSet());
            }
            this.typeSet = egra.getTypeSet();
        }
    }

    public EdTypeSet getTypeSet() {
        return this.typeSet;
    }

    public void setTypeSet(EdTypeSet types) {
        this.typeSet = types;
        if (types != null) {
            this.eLeft.setTypeSet(types);
            this.eRight.setTypeSet(types);
            for (int i = 0; i < this.myNACs.size(); ++i) {
                EdNAC nac = (EdNAC)this.myNACs.elementAt(i);
                nac.setTypeSet(types);
            }
            this.typeSet = types;
        }
    }

    public boolean isApplicable() {
        return this.bRule.isApplicable();
    }

    public void setApplicable(boolean applicable) {
        this.bRule.setApplicable(applicable);
    }

    public Match getMatch() {
        return this.match;
    }

    public void setMatch(Match m) {
        this.match = m;
    }

    public Vector getAttrConditions() {
        Vector<String> conds = new Vector<String>(1);
        CondTuple ct = (CondTuple)this.bRule.getAttrContext().getConditions();
        for (int i = 0; i < ct.getSize(); ++i) {
            conds.add(ct.getCondMemberAt(i).getExprAsText());
        }
        return conds;
    }

    public Vector getNACs() {
        return this.myNACs;
    }

    public EdNAC getNAC(int nn) {
        for (int i = 0; i < this.myNACs.size(); ++i) {
            if (i != nn) continue;
            return (EdNAC)this.myNACs.elementAt(i);
        }
        return null;
    }

    public EdNAC createNAC(String nameStr, boolean isIdentic) {
        EdNAC eNAC = new EdNAC(this.bRule.createNAC(), this.typeSet);
        eNAC.getBasisGraph().setName(nameStr);
        eNAC.setName(nameStr);
        eNAC.setRule(this);
        eNAC.setGraGra(this.eGra);
        eNAC.setEditable(this.eLeft.isEditable());
        if (isIdentic && eNAC.isEditable()) {
            this.identicNAC(eNAC);
        }
        this.myNACs.addElement(eNAC);
        if (this.eGra != null) {
            this.eGra.setChanged(true);
        }
        return eNAC;
    }

    public EdNAC createNAC(OrdinaryMorphism nac) {
        EdNAC eNAC = new EdNAC(nac, this.typeSet);
        eNAC.getBasisGraph().setName(nac.getName());
        eNAC.setName(nac.getName());
        eNAC.setRule(this);
        eNAC.setGraGra(this.eGra);
        this.myNACs.addElement(eNAC);
        if (this.eGra != null) {
            this.eGra.setChanged(true);
        }
        return eNAC;
    }

    public boolean addNAC(EdNAC nac) {
        if (nac.getTypeSet().getBasisTypeSet().compareTo(this.typeSet.getBasisTypeSet())) {
            if (this.bRule.addNAC(nac.getMorphism())) {
                Vector v = nac.getMorphism().getUsedTypes();
                this.bRule.getLeft().getTypeSet().adaptTypes(v.elements(), false);
                this.typeSet.refreshTypes();
                nac.update();
                nac.setRule(this);
                nac.setGraGra(this.eGra);
                this.myNACs.addElement(nac);
                if (this.eGra != null) {
                    this.eGra.setChanged(true);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void destroyNAC(EdNAC enac) {
        if (this.getBasisRule() == null || enac.getMorphism() == null) {
            return;
        }
        enac.getMorphism().deleteObserver(enac);
        this.myNACs.removeElement(enac);
        this.getBasisRule().destroyNAC(enac.getMorphism());
        if (this.eGra != null) {
            this.eGra.setChanged(true);
        }
    }

    public void identicNAC(EdNAC enac) {
        OrdinaryMorphism morph = enac.getMorphism();
        morph.clear();
        morph.getImage().clear();
        enac.clear();
        for (int i = 0; i < this.eLeft.getNodes().size(); ++i) {
            EdNode en = (EdNode)this.eLeft.getNodes().elementAt(i);
            this.identicNode(en, enac, morph);
        }
        for (int j = 0; j < this.eLeft.getArcs().size(); ++j) {
            EdArc ea = (EdArc)this.eLeft.getArcs().elementAt(j);
            this.identicArc(ea, enac, morph);
        }
        this.update();
    }

    public void addIdenticToNAC(Vector graphObjects, EdNAC enac) {
        for (int i = 0; i < graphObjects.size(); ++i) {
            EdGraphObject go = (EdGraphObject)graphObjects.elementAt(i);
            if (go.isNode()) {
                this.identicNode((EdNode)go, enac, enac.getMorphism());
                continue;
            }
            this.identicArc((EdArc)go, enac, enac.getMorphism());
        }
        this.update();
    }

    public void addIdenticToNAC(EdGraphObject graphObject, EdNAC enac) {
        if (graphObject.isNode()) {
            this.identicNode((EdNode)graphObject, enac, enac.getMorphism());
        } else {
            this.identicArc((EdArc)graphObject, enac, enac.getMorphism());
        }
        this.update();
    }

    private void identicNode(EdNode en, EdGraph eg, OrdinaryMorphism morph) {
        this.badMapping = false;
        this.errMsg = "";
        EdNode cn = null;
        Node bn = null;
        try {
            bn = eg.getBasisGraph().createNode(en.getBasisNode());
        }
        catch (TypeException e) {
            // empty catch block
        }
        if (bn != null) {
            cn = eg.addNode(eg.getBasisGraph(), bn, en.getType());
            cn.setReps(en.getX(), en.getY(), en.isVisible(), false);
            try {
                morph.addMapping(en.getBasisNode(), bn);
            }
            catch (BadMappingException ex) {
                this.badMapping = true;
                this.errMsg = ex.getMessage();
            }
        }
    }

    private void identicArc(EdArc ea, EdGraph eg, OrdinaryMorphism morph) {
        this.badMapping = false;
        this.errMsg = "";
        EdArc ca = null;
        Arc ba = null;
        GraphObject bSrc = morph.getImage(ea.getBasisArc().getSource());
        GraphObject bTar = morph.getImage(ea.getBasisArc().getTarget());
        try {
            ba = eg.getBasisGraph().createArc(ea.getBasisArc(), (Node)bSrc, (Node)bTar);
        }
        catch (TypeException e) {
            e.printStackTrace();
        }
        if (ba != null) {
            ca = eg.addArc(eg.getBasisGraph(), ba, ea.getType());
            ca.setReps(ea.isDirected(), ea.isVisible(), false);
            ca.setTextOffset(ea.getTextOffset().x, ea.getTextOffset().y);
            if (ea.isLine()) {
                if (ea.hasAnchor()) {
                    ca.setAnchor(ea.getAnchor());
                }
            } else if (ea.hasAnchor()) {
                ca.setXY(ea.getX(), ea.getY());
                ca.setWidth(ea.getWidth());
                ca.setHeight(ea.getHeight());
            }
            this.errMsg = "";
            try {
                morph.addMapping(ea.getBasisArc(), ba);
            }
            catch (BadMappingException ex) {
                this.badMapping = true;
                this.errMsg = ex.getMessage();
            }
        }
    }

    private void identicNode(EdNode en) {
        this.badMapping = false;
        this.errMsg = "";
        EdNode cn = null;
        Node bn = null;
        try {
            bn = this.eRight.getBasisGraph().createNode(en.getBasisNode());
        }
        catch (TypeException e) {
            // empty catch block
        }
        if (bn != null) {
            cn = this.eRight.addNode(this.eRight.getBasisGraph(), bn, en.getType());
            cn.setReps(en.getX(), en.getY(), en.isVisible(), false);
            OrdinaryMorphism morph = this.getMorph();
            try {
                morph.addMapping(en.getBasisNode(), bn);
            }
            catch (BadMappingException ex) {
                this.badMapping = true;
                this.errMsg = ex.getMessage();
            }
        }
    }

    private void identicArc(EdArc ea) {
        this.badMapping = false;
        this.errMsg = "";
        EdArc ca = null;
        Arc ba = null;
        OrdinaryMorphism morph = this.getMorph();
        GraphObject bSrc = morph.getImage(ea.getBasisArc().getSource());
        GraphObject bTar = morph.getImage(ea.getBasisArc().getTarget());
        try {
            ba = this.eRight.getBasisGraph().createArc(ea.getBasisArc(), (Node)bSrc, (Node)bTar);
        }
        catch (TypeException e) {
            e.printStackTrace();
        }
        if (ba != null) {
            ca = this.eRight.addArc(this.eRight.getBasisGraph(), ba, ea.getType());
            ca.setReps(ea.isDirected(), ea.isVisible(), false);
            ca.setTextOffset(ea.getTextOffset().x, ea.getTextOffset().y);
            if (ea.isLine()) {
                if (ea.hasAnchor()) {
                    ca.setAnchor(ea.getAnchor());
                }
            } else if (ea.hasAnchor()) {
                ca.setXY(ea.getX(), ea.getY());
                ca.setWidth(ea.getWidth());
                ca.setHeight(ea.getHeight());
            }
            try {
                morph.addMapping(ea.getBasisArc(), ba);
            }
            catch (BadMappingException ex) {
                this.badMapping = true;
                this.errMsg = ex.getMessage();
            }
        }
    }

    public void identicRule() {
        if (!this.eRight.isEditable()) {
            return;
        }
        OrdinaryMorphism morph = this.getMorph();
        morph.clear();
        this.eRight.getBasisGraph().clear();
        this.eRight.clear();
        for (int i = 0; i < this.eLeft.getNodes().size(); ++i) {
            EdNode en = (EdNode)this.eLeft.getNodes().elementAt(i);
            this.identicNode(en);
        }
        for (int j = 0; j < this.eLeft.getArcs().size(); ++j) {
            EdArc ea = (EdArc)this.eLeft.getArcs().elementAt(j);
            this.identicArc(ea);
        }
        this.update();
    }

    public void addIdenticToRule(Vector graphObjects) {
        if (!this.eRight.isEditable()) {
            return;
        }
        for (int i = 0; i < graphObjects.size(); ++i) {
            EdGraphObject go = (EdGraphObject)graphObjects.get(i);
            this.addIdentic(go);
        }
        this.update();
    }

    public void addIdenticToRule(EdGraphObject graphObject) {
        if (!this.eRight.isEditable()) {
            return;
        }
        this.addIdentic(graphObject);
        this.update();
    }

    private void addIdentic(EdGraphObject graphObject) {
        if (graphObject.isNode()) {
            this.identicNode((EdNode)graphObject);
        } else {
            this.identicArc((EdArc)graphObject);
        }
    }

    public void interactRule(EdGraphObject leftObj, EdGraphObject rightObj) {
        this.badMapping = false;
        this.errMsg = "";
        if (!leftObj.hasSimilarType(rightObj)) {
            this.badMapping = true;
            this.errMsg = "Bad mapping";
            return;
        }
        OrdinaryMorphism morph = this.getMorph();
        if (morph == null) {
            return;
        }
        try {
            morph.addMapping(leftObj.getBasisObject(), rightObj.getBasisObject());
            this.update();
        }
        catch (BadMappingException ex) {
            this.badMapping = true;
            this.errMsg = ex.getMessage();
        }
    }

    public void removeRuleMapping(EdGraphObject leftObj) {
        if (this instanceof EdAtomic) {
            return;
        }
        OrdinaryMorphism morph = this.getMorph();
        if (morph.getImage(leftObj.getBasisObject()) != null) {
            morph.removeMapping(leftObj.getBasisObject());
            this.updateOrig(leftObj);
            this.update();
        }
    }

    public void interactNAC(EdGraphObject leftObj, EdGraphObject nacObj, OrdinaryMorphism morph) {
        if (this instanceof EdAtomic) {
            return;
        }
        this.badMapping = false;
        this.errMsg = "";
        if (!leftObj.hasSimilarType(nacObj)) {
            this.badMapping = true;
            this.errMsg = "Bad mapping";
            return;
        }
        try {
            morph.addMapping(leftObj.getBasisObject(), nacObj.getBasisObject());
            this.update();
        }
        catch (BadMappingException ex) {
            this.badMapping = true;
            this.errMsg = ex.getMessage();
        }
    }

    public void removeNACMapping(EdGraphObject leftObj, OrdinaryMorphism morph) {
        if (this instanceof EdAtomic) {
            return;
        }
        if (morph.getImage(leftObj.getBasisObject()) != null) {
            morph.removeMapping(leftObj.getBasisObject());
            this.updateOrig(leftObj);
            this.update();
        }
    }

    public boolean removeNAC(EdNAC nac) {
        if (this instanceof EdAtomic) {
            return false;
        }
        if (this.bRule.removeNAC(nac.getMorphism())) {
            this.myNACs.removeElement(nac);
            return true;
        }
        return false;
    }

    public void autoMatch(Match match) {
        if (match == null) {
            this.errMsg = "Match is NULL.";
            return;
        }
        this.badMapping = false;
        this.errMsg = "";
        if (match.nextCompletion()) {
            if (match.isValid()) {
                this.updateMatch(match, this.eLeft, this.eGra.getGraph());
            } else {
                this.autoMatch(match);
                this.badMapping = true;
                this.errMsg = match.getErrorMsg();
            }
        } else {
            this.badMapping = true;
            this.errMsg = match.getErrorMsg();
        }
    }

    public void interactMatch(EdGraphObject leftObj, EdGraphObject graphObj) {
        Enumeration origs;
        if (this.match == null) {
            return;
        }
        this.badMapping = false;
        this.errMsg = "";
        if (!leftObj.hasSimilarType(graphObj)) {
            this.badMapping = true;
            this.errMsg = "Bad mapping!\nSource and target objects of the mapping have to have the same type.";
            return;
        }
        MorphCompletionStrategy strategy = this.match.getCompletionStrategy();
        BitSet activebits = strategy.getProperties();
        if (activebits.get(0) && (origs = this.match.getInverseImage(graphObj.getBasisObject())).hasMoreElements()) {
            this.badMapping = true;
            this.errMsg = "Bad mapping!\nOnly injective mappings are allowed.";
            return;
        }
        try {
            this.match.addMapping(leftObj.getBasisObject(), graphObj.getBasisObject());
            if (this.eGra.getGraph() != null) {
                this.updateMatch(this.match, this.eLeft, this.eGra.getGraph());
            }
        }
        catch (BadMappingException ex) {
            this.badMapping = true;
            this.errMsg = "Bad mapping!\n" + ex.getMessage();
        }
    }

    public void removeMatchMapping(EdGraphObject leftObj) {
        if (this.match == null) {
            return;
        }
        if (this.match.getImage(leftObj.getBasisObject()) != null) {
            this.match.removeMapping(leftObj.getBasisObject());
            if (this.eGra != null) {
                this.updateMatch(this.match, this.eLeft, this.eGra.getGraph());
                this.updateOrig(leftObj);
            }
            this.update();
        }
    }

    public void destroyMatch() {
        if (this.match == null) {
            return;
        }
        this.match.deleteObserver(this.eLeft);
        this.eGra.getBasisGraGra().destroyMatch(this.match);
        if (this.eGra != null) {
            this.eGra.getGraph().clearMarks();
            for (int i = 0; i < this.eLeft.getNodes().size(); ++i) {
                EdNode en = (EdNode)this.eLeft.getNodes().elementAt(i);
                this.updateOrig(en);
            }
            for (int j = 0; j < this.eLeft.getArcs().size(); ++j) {
                EdArc ea = (EdArc)this.eLeft.getArcs().elementAt(j);
                this.updateOrig(ea);
            }
        }
        this.match = null;
    }

    public void removeMapping(EdGraphObject imageObj, OrdinaryMorphism m) {
        if (imageObj == null || m == null) {
            return;
        }
        Enumeration originals = m.getInverseImage(imageObj.getBasisObject());
        while (originals.hasMoreElements()) {
            GraphObject original = (GraphObject)originals.nextElement();
            m.removeMapping(original);
            this.update();
        }
    }

    public void update() {
        this.eLeft.clearMarks();
        this.eLeft.update();
        this.eRight.clearMarks();
        this.eRight.update();
        this.updateMorphism();
        this.updateNAC();
        if (this.eGra != null) {
            this.updateMatch(this.match, this.eLeft, this.eGra.getGraph());
        }
    }

    public void updateMorphism() {
        EdNode enL = null;
        EdNode enR = null;
        EdArc eaL = null;
        EdArc eaR = null;
        OrdinaryMorphism bm = this.getMorph();
        if (bm == null) {
            return;
        }
        Enumeration domain = bm.getDomain();
        while (domain.hasMoreElements()) {
            GraphObject bOrig = (GraphObject)domain.nextElement();
            GraphObject bImage = bm.getImage(bOrig);
            enL = this.eLeft.findNode(bOrig);
            if (enL != null) {
                if (enL.isMorphismMarkEmpty()) {
                    enL.addMorphismMark(enL.getMyKey());
                }
                if ((enR = this.eRight.findNode(bImage)) != null) {
                    enR.addMorphismMark(enL.getMorphismMark());
                } else {
                    enL.clearMorphismMark();
                }
            }
            if ((eaL = this.eLeft.findArc(bOrig)) == null) continue;
            if (eaL.isMorphismMarkEmpty()) {
                eaL.addMorphismMark(eaL.getMyKey());
            }
            if ((eaR = this.eRight.findArc(bImage)) != null) {
                eaR.addMorphismMark(eaL.getMorphismMark());
                continue;
            }
            eaL.clearMorphismMark();
        }
    }

    public void updateNAC() {
        for (int i = 0; i < this.myNACs.size(); ++i) {
            EdNode enL = null;
            EdNode enNAC = null;
            EdArc eaL = null;
            EdArc eaNAC = null;
            EdNAC eNAC = (EdNAC)this.myNACs.elementAt(i);
            eNAC.clearMarks();
            eNAC.update();
            OrdinaryMorphism nacMorph = eNAC.getMorphism();
            Enumeration domain = nacMorph.getDomain();
            while (domain.hasMoreElements()) {
                GraphObject bOrig = (GraphObject)domain.nextElement();
                GraphObject bImage = nacMorph.getImage(bOrig);
                enL = this.eLeft.findNode(bOrig);
                if (enL != null) {
                    if (enL.isMorphismMarkEmpty()) {
                        enL.addMorphismMark(enL.getMyKey());
                    }
                    if ((enNAC = eNAC.findNode(bImage)) != null) {
                        enNAC.addMorphismMark(enL.getMorphismMark());
                    }
                }
                if ((eaL = this.eLeft.findArc(bOrig)) == null) continue;
                if (eaL.isMorphismMarkEmpty()) {
                    eaL.addMorphismMark(eaL.getMyKey());
                }
                if ((eaNAC = eNAC.findArc(bImage)) == null) continue;
                eaNAC.addMorphismMark(eaL.getMorphismMark());
            }
        }
    }

    private void updateOrig(EdGraphObject leftObj) {
        boolean isOrig = false;
        OrdinaryMorphism bm = this.getMorph();
        Enumeration domain = bm.getDomain();
        while (domain.hasMoreElements()) {
            GraphObject bOrig = (GraphObject)domain.nextElement();
            if (!leftObj.getBasisObject().equals(bOrig)) continue;
            isOrig = true;
        }
        if (!isOrig) {
            leftObj.clearMorphismMark();
        }
    }

    private void updateMatch(Match m, EdGraph eOrigGraph, EdGraph eImageGraph) {
        if (eImageGraph == null) {
            return;
        }
        EdNode enO = null;
        EdNode enI = null;
        EdArc eaO = null;
        EdArc eaI = null;
        eImageGraph.clearMarks();
        if (m == null) {
            return;
        }
        Enumeration domain = m.getDomain();
        while (domain.hasMoreElements()) {
            GraphObject bOrig = (GraphObject)domain.nextElement();
            GraphObject bImage = m.getImage(bOrig);
            enO = eOrigGraph.findNode(bOrig);
            if (enO != null) {
                if (enO.isMorphismMarkEmpty()) {
                    enO.addMorphismMark(enO.getMyKey());
                }
                if ((enI = eImageGraph.findNode(bImage)) == null) continue;
                enI.addMorphismMark(enO.getMorphismMark());
                continue;
            }
            eaO = eOrigGraph.findArc(bOrig);
            if (eaO == null) continue;
            if (eaO.isMorphismMarkEmpty()) {
                eaO.addMorphismMark(eaO.getMyKey());
            }
            if ((eaI = eImageGraph.findArc(bImage)) == null) continue;
            eaI.addMorphismMark(eaO.getMorphismMark());
        }
    }

    public void setMorphismMarks(HashMap marks, EdNAC nacGraph) {
        EdGraphObject o1;
        GraphObject img;
        EdGraphObject o;
        this.eLeft.setMorphismMarks(marks, true);
        this.eRight.clearMarks();
        Enumeration e = this.eLeft.getNodes().elements();
        while (e.hasMoreElements()) {
            o = (EdNode)e.nextElement();
            img = this.bRule.getImage(((EdNode)o).getBasisNode());
            if (img == null || (o1 = this.eRight.findGraphObject(img)) == null) continue;
            o1.addMorphismMark(o.getMorphismMark());
        }
        e = this.eLeft.getArcs().elements();
        while (e.hasMoreElements()) {
            o = (EdArc)e.nextElement();
            img = this.bRule.getImage(((EdArc)o).getBasisArc());
            if (img == null || (o1 = this.eRight.findGraphObject(img)) == null) continue;
            o1.addMorphismMark(o.getMorphismMark());
        }
        this.eRight.setMorphismMarks(marks, false);
        if (nacGraph != null) {
            nacGraph.clearMarks();
            OrdinaryMorphism nacMorph = nacGraph.getMorphism();
            e = nacMorph.getCodomain();
            while (e.hasMoreElements()) {
                GraphObject obj = (GraphObject)e.nextElement();
                if (!nacMorph.getInverseImage(obj).hasMoreElements()) continue;
                GraphObject objL = (GraphObject)nacMorph.getInverseImage(obj).nextElement();
                EdGraphObject goL = this.eLeft.findGraphObject(objL);
                EdGraphObject goN = nacGraph.findGraphObject(obj);
                goN.clearMorphismMark();
                goN.addMorphismMark(goL.getMorphismMark());
            }
            nacGraph.setMorphismMarks(marks, false);
        }
    }

    public boolean isBadMapping() {
        return this.badMapping;
    }

    public String getMsg() {
        if (this.errMsg == null) {
            this.errMsg = "";
        }
        return this.errMsg;
    }

    public void XwriteObject(XMLHelper h) {
        h.addObject("", this.eLeft, true);
        h.addObject("", this.eRight, true);
        for (int j = 0; j < this.myNACs.size(); ++j) {
            h.addObject("", (EdNAC)this.myNACs.elementAt(j), true);
        }
    }

    public void XreadObject(XMLHelper h) {
        h.enrichObject(this.eLeft);
        h.enrichObject(this.eRight);
        for (int j = 0; j < this.myNACs.size(); ++j) {
            h.enrichObject((EdNAC)this.myNACs.elementAt(j));
            EdNAC nac = (EdNAC)this.myNACs.elementAt(j);
            nac.setName(nac.getBasisGraph().getName());
            nac.setGraGra(this.eGra);
            nac.setRule(this);
            nac.setTypeSet(this.typeSet);
        }
        Enumeration e = this.eGra.getBasisGraGra().getMatches(this.bRule);
        if (e.hasMoreElements()) {
            this.match = (Match)e.nextElement();
        }
    }
}

