/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.xt_basis.Type;
import java.awt.Color;
import java.util.Vector;

public class EdType {
    public String name = "";
    public int shape = 51;
    public Color color = Color.black;
    public String imageFileName = "";
    public boolean isUsed = false;
    public boolean iconable = true;
    public String resourcesPath = System.getProperty("user.dir");
    protected Type bType;

    public EdType(String name, int shape, Color color, String iconFileName, Type bType) {
        this.name = name;
        this.shape = shape;
        this.color = color;
        this.imageFileName = iconFileName;
        this.bType = bType;
        if (bType != null) {
            this.bType.setStringRepr(name);
            this.setAdditionalReprOfBasisType(this.shape, this.color, this.imageFileName);
        }
    }

    public EdType() {
        this("", 51, Color.black, "", null);
    }

    public EdType(String name) {
        this(name, 51, Color.black, "", null);
    }

    public EdType(String name, int shape, Color color, String iconFileName) {
        this(name, shape, color, iconFileName, null);
    }

    public EdType(String name, Type bType) {
        this(name, 51, Color.black, "", bType);
    }

    public EdType(Type bType) {
        this(bType, 51, Color.black, "");
    }

    public EdType(Type bType, int shape, Color color, String iconFileName) {
        this(bType != null ? bType.getStringRepr() : "", shape, color, iconFileName, bType);
    }

    public String getName() {
        return this.name;
    }

    public int getShape() {
        return this.shape;
    }

    public Color getColor() {
        return this.color;
    }

    public String getImageFileName() {
        return this.imageFileName;
    }

    public Type getBasisType() {
        return this.bType;
    }

    public String getTypeName() {
        if (this.bType != null) {
            return this.bType.getStringRepr();
        }
        return this.name;
    }

    public boolean isNodeType() {
        return this.bType.getAdditionalRepr().indexOf(":[NODE]:") >= 0;
    }

    public boolean isArcType() {
        return this.bType.getAdditionalRepr().indexOf(":[EDGE]:") >= 0;
    }

    public boolean isUsed() {
        return this.isUsed;
    }

    public void setName(String name) {
        this.name = name;
        if (this.bType != null) {
            this.bType.setStringRepr(name);
        }
    }

    public void setShape(int shape) {
        this.shape = shape;
    }

    public void setColor(Color col) {
        this.color = col;
    }

    public void setImageFileName(String fname) {
        this.imageFileName = fname;
    }

    public void setBasisType(Type bType) {
        this.bType = bType;
    }

    public void setAdditionalReprOfBasisType() {
        this.setAdditionalReprOfBasisType(this.shape, this.color);
    }

    public void setAdditionalReprOfBasisType(int shape, Color color) {
        this.shape = shape;
        this.color = color;
        String shapeStr = "";
        String colorStr = this.color.toString();
        String markStr = "[]";
        switch (this.shape) {
            case 51: {
                shapeStr = "RECT";
                markStr = "[NODE]";
                break;
            }
            case 54: {
                shapeStr = "ROUNDRECT";
                markStr = "[NODE]";
                break;
            }
            case 52: {
                shapeStr = "CIRCLE";
                markStr = "[NODE]";
                break;
            }
            case 53: {
                shapeStr = "OVAL";
                markStr = "[NODE]";
                break;
            }
            case 55: {
                shapeStr = "ICON";
                markStr = "[NODE]";
                break;
            }
            case 61: {
                shapeStr = "SOLID_LINE";
                markStr = "[EDGE]";
                break;
            }
            case 62: {
                shapeStr = "DASH_LINE";
                markStr = "[EDGE]";
                break;
            }
            case 63: {
                shapeStr = "DOT_LINE";
                markStr = "[EDGE]";
                break;
            }
            default: {
                shapeStr = "RECT";
                markStr = "[NODE]";
            }
        }
        this.bType.setAdditionalRepr(":" + shapeStr + ":" + colorStr + ":" + this.imageFileName + ":" + markStr + ":");
    }

    public void setAdditionalReprOfBasisType(int shape, Color color, String imageFilename) {
        this.setAdditionalReprOfBasisType(shape, color);
        this.imageFileName = imageFilename;
    }

    public Vector getAdditionalReprOfBasisType() {
        Vector<String> v = new Vector<String>(3);
        String addRepr = this.bType.getAdditionalRepr();
        String shapeStr = "";
        String colorStr = "";
        String imageFileNameStr = "";
        String markStr = "[]";
        int begin = 0;
        while (addRepr.length() != 0) {
            String helpStr;
            int indx;
            int l = addRepr.length();
            if (addRepr.charAt(0) == ':') {
                String helpStr2;
                addRepr = helpStr2 = addRepr.substring(1, l);
            }
            String testStr = "";
            if (addRepr.length() != 0 && (indx = addRepr.indexOf(":")) != -1) {
                testStr = addRepr.substring(begin, indx);
                if (testStr.indexOf("RECT") != -1 || testStr.indexOf("ROUND") != -1 || testStr.indexOf("CIRCLE") != -1 || testStr.indexOf("OVAL") != -1 || testStr.indexOf("IMAGE") != -1 || testStr.indexOf("SOLID_LINE") != -1 || testStr.indexOf("DASH_LINE") != -1 || testStr.indexOf("DOT_LINE") != -1) {
                    shapeStr = testStr;
                } else if (testStr.indexOf("Color") != -1) {
                    colorStr = testStr;
                } else if (testStr.indexOf(".jpg") != -1 || testStr.indexOf(".gif") != -1 || testStr.indexOf(".xpm") != -1) {
                    imageFileNameStr = testStr;
                } else if (testStr.indexOf("[NODE]") != -1 || testStr.indexOf("[EDGE]") != -1) {
                    markStr = testStr;
                }
            }
            addRepr = helpStr = addRepr.substring(begin + testStr.length(), l - 1);
        }
        v.add(shapeStr);
        v.add(colorStr);
        v.add(imageFileNameStr);
        v.add(markStr);
        return v;
    }

    public boolean hasOldAdditionalRepr() {
        if (this.bType == null) {
            return false;
        }
        if (!this.bType.getAdditionalRepr().equals("")) {
            return this.bType.getAdditionalRepr().indexOf("51:") != -1 || this.bType.getAdditionalRepr().indexOf("52:") != -1 || this.bType.getAdditionalRepr().indexOf("53:") != -1 || this.bType.getAdditionalRepr().indexOf("54:") != -1 || this.bType.getAdditionalRepr().indexOf("55:") != -1 || this.bType.getAdditionalRepr().indexOf("61:") != -1 || this.bType.getAdditionalRepr().indexOf("62:") != -1 || this.bType.getAdditionalRepr().indexOf("63:") != -1;
        }
        return true;
    }

    public void setIconable(boolean iconable) {
        this.iconable = iconable;
    }

    public boolean isIconable() {
        return !this.imageFileName.equals("") && this.iconable;
    }

    public void setResourcesPath(String path) {
        this.resourcesPath = path;
    }

    public String getResourcesPath() {
        return this.resourcesPath;
    }

    public void setIsUsed(boolean used) {
        this.isUsed = used;
    }

    public boolean redefineType(String newName, int newShape, Color newColor, String newImageFileName) {
        if (!(this.name.equals(newName) && this.shape == newShape && this.color.equals(newColor) && this.imageFileName.equals(newImageFileName))) {
            this.name = newName;
            this.shape = newShape;
            this.color = newColor;
            this.imageFileName = newImageFileName;
            if (this.bType != null) {
                this.bType.setStringRepr(this.name);
                this.setAdditionalReprOfBasisType(this.shape, this.color, this.imageFileName);
            }
            return true;
        }
        return false;
    }

    public boolean compareTo(EdType t) {
        return this.bType.compareTo(t.getBasisType());
    }

    public boolean isParentOf(EdType t) {
        return this.bType.isParentOf(t.getBasisType());
    }
}

