/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.cons.AtomApplCond;
import agg.cons.AtomConstraint;
import agg.cons.EvalSet;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdType;
import agg.gui.event.TypeEvent;
import agg.gui.event.TypeEventListener;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import agg.xt_basis.TypeException;
import agg.xt_basis.TypeSet;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;

public class EdTypeSet {
    private Vector nodeTypes;
    private Vector arcTypes;
    private EdType selectedNodeType;
    private EdType selectedArcType;
    private EdType defaultNodeType;
    private EdType defaultArcType;
    private boolean iconable;
    private String resourcesPath = System.getProperty("user.dir");
    private Vector typeEventListeners;
    private EdGraph edTypeGraph = null;
    private transient GraGra bGraGra;
    private transient Graph bGraph;
    private transient TypeSet bTypeSet = null;

    public EdTypeSet() {
        this.nodeTypes = new Vector();
        this.arcTypes = new Vector();
    }

    public EdTypeSet(TypeSet baseTypeSet) {
        this.bTypeSet = baseTypeSet;
        this.initTypesFromTypeSet();
    }

    public EdTypeSet(GraGra baseGraGra) {
        this(baseGraGra.getTypeSet());
        this.bGraGra = baseGraGra;
    }

    public EdTypeSet(Graph baseGraph) {
        this(baseGraph.getTypeSet());
        this.bGraph = baseGraph;
    }

    private void createDefaultTypeSet() {
        this.nodeTypes = new Vector();
        this.arcTypes = new Vector();
        this.defaultNodeType = this.createNodeType("", 51, Color.black);
        this.defaultArcType = this.createArcType("", 61, Color.black);
    }

    public GraGra getBasisGraGra() {
        return this.bGraGra;
    }

    public void setBasisGraGra(GraGra gra) {
        if (this.bGraGra != gra) {
            this.bGraGra = gra;
            this.bGraph = gra.getGraph();
            this.bTypeSet = gra.getTypeSet();
            this.initTypesFromTypeSet();
        }
    }

    public Graph getBasisGraph() {
        return this.bGraph;
    }

    public void setBasisGraph(Graph g) {
        if (this.bGraph == null) {
            this.bGraph = g;
        } else if (this.bGraph != g) {
            this.bGraGra = null;
            this.bGraph = g;
        }
        this.bTypeSet = g.getTypeSet();
        this.initTypesFromTypeSet();
    }

    public TypeSet getBasisTypeSet() {
        return this.bTypeSet;
    }

    public void setBasisTypeSet(TypeSet typeSet) {
        this.bTypeSet = typeSet;
        this.initTypesFromTypeSet();
    }

    public EdGraph getTypeGraph() {
        return this.edTypeGraph;
    }

    public boolean setTypeGraph(EdGraph typeGraphLayout) {
        if (typeGraphLayout != null) {
            if (this.bTypeSet.compareTo(typeGraphLayout.getTypeSet().getBasisTypeSet())) {
                Vector v = typeGraphLayout.getBasisGraph().getUsedTypes();
                this.bTypeSet.adaptTypes(v.elements(), false);
                this.refreshTypes();
                this.edTypeGraph = typeGraphLayout;
                this.bTypeSet.setTypeGraph(this.edTypeGraph.getBasisGraph());
                this.edTypeGraph.update();
                return true;
            }
            return false;
        }
        return false;
    }

    public EdGraph createTypeGraph() {
        Graph typeGraph = this.bTypeSet.getTypeGraph();
        if (typeGraph == null) {
            typeGraph = this.bTypeSet.createTypeGraph();
        }
        this.edTypeGraph = new EdGraph(typeGraph, this);
        this.edTypeGraph.markTypeGraph(true);
        return this.edTypeGraph;
    }

    public void removeTypeGraph() {
        this.edTypeGraph = null;
    }

    public void destroyTypeGraph() {
        this.edTypeGraph.dispose();
        this.edTypeGraph = null;
    }

    public EdType createType(Type baseType) {
        if (baseType == null) {
            return null;
        }
        String addRepr = baseType.getAdditionalRepr();
        if (addRepr.equals("")) {
            if (baseType.getStringRepr().equals("default") || baseType.getStringRepr().equals("")) {
                return null;
            }
            baseType.setAdditionalRepr(":RECT:java.awt.Color[r=0,g=0,b=0]::[NODE]:");
        }
        String name = baseType.getStringRepr();
        Vector v = this.getAdditionalReprOfBasisType(baseType);
        String shapeStr = (String)v.elementAt(0);
        String colorStr = (String)v.elementAt(1);
        String imageFileNameStr = (String)v.elementAt(2);
        String markStr = (String)v.elementAt(3);
        int shape = -1;
        shape = shapeStr.equals("RECT") ? 51 : (shapeStr.equals("ROUNDRECT") ? 54 : (shapeStr.equals("CIRCLE") ? 52 : (shapeStr.equals("OVAL") ? 53 : (shapeStr.equals("SOLID_LINE") ? 61 : (shapeStr.equals("DASH_LINE") ? 62 : (shapeStr.equals("DOT_LINE") ? 63 : 51))))));
        String r_str = colorStr.substring(colorStr.indexOf("r=") + 2, colorStr.indexOf(",g="));
        String g_str = colorStr.substring(colorStr.indexOf("g=") + 2, colorStr.indexOf(",b="));
        String b_str = colorStr.substring(colorStr.indexOf("b=") + 2, colorStr.indexOf("]"));
        Color color = new Color(new Integer(r_str), new Integer(g_str), new Integer(b_str));
        EdType eType = new EdType(baseType, shape, color, imageFileNameStr);
        eType.setResourcesPath(this.resourcesPath);
        eType.setImageFileName(imageFileNameStr);
        if (markStr.equals("[NODE]")) {
            eType.setIconable(this.iconable);
            this.addSorted(eType, this.nodeTypes);
            this.fireTypeEvent(new TypeEvent(this, eType, 1));
        } else if (markStr.equals("[EDGE]")) {
            this.addSorted(eType, this.arcTypes);
            this.fireTypeEvent(new TypeEvent(this, eType, 2));
        }
        return eType;
    }

    public EdType createNodeType(String name, int shape, Color color) {
        Type bType = null;
        EdType eType = null;
        if (this.isNewType(this.nodeTypes, name, shape, color)) {
            if (this.bTypeSet != null) {
                bType = this.bTypeSet.createType();
                eType = new EdType(name, shape, color, "", bType);
            } else {
                eType = new EdType(name, shape, color, "");
            }
            if (eType != null) {
                eType.setIconable(this.iconable);
                this.addSorted(eType, this.nodeTypes);
                this.fireTypeEvent(new TypeEvent(this, eType, 1));
            }
        }
        return eType;
    }

    public EdType createNodeType(Type baseType) {
        if (baseType == null) {
            return null;
        }
        if (baseType.getAdditionalRepr().equals("")) {
            return this.createDefaultNodeType(baseType);
        }
        String name = baseType.getStringRepr();
        String addRepr = baseType.getAdditionalRepr();
        String shapeStr = "";
        String colorStr = "";
        String imageFileNameStr = "";
        int shape = -1;
        Vector v = this.getAdditionalReprOfBasisType(baseType);
        shapeStr = (String)v.elementAt(0);
        colorStr = (String)v.elementAt(1);
        imageFileNameStr = (String)v.elementAt(2);
        String markStr = (String)v.elementAt(3);
        shape = shapeStr.equals("RECT") ? 51 : (shapeStr.equals("ROUNDRECT") ? 54 : (shapeStr.equals("CIRCLE") ? 52 : (shapeStr.equals("OVAL") ? 53 : 51)));
        String r_str = colorStr.substring(colorStr.indexOf("r=") + 2, colorStr.indexOf(",g="));
        String g_str = colorStr.substring(colorStr.indexOf("g=") + 2, colorStr.indexOf(",b="));
        String b_str = colorStr.substring(colorStr.indexOf("b=") + 2, colorStr.indexOf("]"));
        Color color = new Color(new Integer(r_str), new Integer(g_str), new Integer(b_str));
        EdType eType = new EdType(baseType, shape, color, imageFileNameStr);
        eType.setResourcesPath(this.resourcesPath);
        eType.setImageFileName(imageFileNameStr);
        eType.setIconable(this.iconable);
        this.addSorted(eType, this.nodeTypes);
        return eType;
    }

    public EdType getDefaultNodeType() {
        return this.defaultNodeType;
    }

    public EdType createDefaultNodeType(Type baseType) {
        if (baseType == null) {
            return this.defaultNodeType;
        }
        EdType eType = null;
        if (this.isNewType(this.nodeTypes, baseType.getStringRepr(), 51, Color.black)) {
            eType = new EdType(baseType, 51, Color.black, "");
            eType.setIconable(this.iconable);
            this.addSorted(eType, this.nodeTypes);
            this.fireTypeEvent(new TypeEvent(this, eType, 1));
        } else {
            eType = this.getType(this.nodeTypes, baseType.getStringRepr(), 51, Color.black);
        }
        return eType;
    }

    public EdType createNodeType(Type baseType, String name, int shape, Color color) {
        if (this.isNewType(this.nodeTypes, name, shape, color)) {
            EdType eType = new EdType(name, shape, color, "", baseType);
            eType.setIconable(this.iconable);
            this.addSorted(eType, this.nodeTypes);
            return eType;
        }
        return null;
    }

    protected void addNodeType(EdType t) {
        t.setIconable(this.iconable);
        this.addSorted(t, this.nodeTypes);
        this.fireTypeEvent(new TypeEvent(this, t, 1));
    }

    public EdType createArcType(String name, int shape, Color color) {
        Type bType = null;
        EdType eType = null;
        if (this.isNewType(this.arcTypes, name, shape, color)) {
            if (this.bTypeSet != null) {
                bType = this.bTypeSet.createType();
                eType = new EdType(name, shape, color, "", bType);
            } else {
                eType = new EdType(name, shape, color, "");
            }
            this.addSorted(eType, this.arcTypes);
            this.fireTypeEvent(new TypeEvent(this, eType, 2));
        }
        return eType;
    }

    public EdType createArcType(Type baseType) {
        if (baseType == null) {
            return null;
        }
        if (baseType.getAdditionalRepr().equals("")) {
            return this.createDefaultArcType(baseType);
        }
        String name = baseType.getStringRepr();
        String addRepr = baseType.getAdditionalRepr();
        String shapeStr = "";
        String colorStr = "";
        int shape = -1;
        Vector v = this.getAdditionalReprOfBasisType(baseType);
        shapeStr = (String)v.elementAt(0);
        colorStr = (String)v.elementAt(1);
        String markStr = (String)v.elementAt(3);
        shape = shapeStr.equals("SOLID_LINE") ? 61 : (shapeStr.equals("DASH_LINE") ? 62 : (shapeStr.equals("DOT_LINE") ? 63 : 61));
        String r_str = colorStr.substring(colorStr.indexOf("r=") + 2, colorStr.indexOf(",g="));
        String g_str = colorStr.substring(colorStr.indexOf("g=") + 2, colorStr.indexOf(",b="));
        String b_str = colorStr.substring(colorStr.indexOf("b=") + 2, colorStr.indexOf("]"));
        Color color = new Color(new Integer(r_str), new Integer(g_str), new Integer(b_str));
        EdType eType = new EdType(baseType, shape, color, "");
        this.addSorted(eType, this.arcTypes);
        this.fireTypeEvent(new TypeEvent(this, eType, 2));
        return eType;
    }

    public EdType getDefaultArcType() {
        return this.defaultArcType;
    }

    public EdType createDefaultArcType(Type baseType) {
        if (baseType == null) {
            return this.defaultArcType;
        }
        EdType eType = null;
        if (this.isNewType(this.arcTypes, baseType.getStringRepr(), 61, Color.black)) {
            eType = new EdType(baseType, 61, Color.black, "");
            this.addSorted(eType, this.arcTypes);
            this.fireTypeEvent(new TypeEvent(this, eType, 2));
        } else {
            eType = this.getType(this.arcTypes, baseType.getStringRepr(), 61, Color.black);
        }
        return eType;
    }

    public EdType createArcType(Type baseType, String name, int shape, Color color) {
        if (this.isNewType(this.arcTypes, name, shape, color)) {
            EdType eType = new EdType(name, shape, color, "", baseType);
            this.addSorted(eType, this.arcTypes);
            this.fireTypeEvent(new TypeEvent(this, eType, 2));
            return eType;
        }
        return null;
    }

    public void addArcType(EdType t) {
        this.addSorted(t, this.arcTypes);
        this.fireTypeEvent(new TypeEvent(this, t, 2));
    }

    private int addSorted(EdType type, Vector types) {
        int indx = -1;
        String name = type.getName();
        if (types.isEmpty()) {
            types.add(type);
        } else {
            for (int i = 0; i < types.size(); ++i) {
                EdType t = (EdType)types.get(i);
                String n = t.getName();
                if (name.compareTo(n) > 0) continue;
                types.add(i, type);
                break;
            }
            if (types.indexOf(type) == -1) {
                types.add(type);
            }
        }
        indx = types.indexOf(type);
        return indx;
    }

    public boolean isEmpty() {
        return this.nodeTypes.isEmpty() && this.arcTypes.isEmpty();
    }

    public Vector getNodeTypes() {
        return this.nodeTypes;
    }

    public void setNodeTypes(Vector newNodeTypes) {
        this.nodeTypes = newNodeTypes;
    }

    public Vector getArcTypes() {
        return this.arcTypes;
    }

    public void setArcTypes(Vector newArcTypes) {
        this.arcTypes = newArcTypes;
    }

    public EdType getSelectedNodeType() {
        return this.selectedNodeType;
    }

    public void setSelectedNodeType(EdType et) {
        this.selectedNodeType = et;
    }

    public EdType getSelectedArcType() {
        return this.selectedArcType;
    }

    public void setSelectedArcType(EdType et) {
        this.selectedArcType = et;
    }

    public boolean isUsed(EdType aType) {
        Type t = aType.getBasisType();
        if (this.bGraGra != null) {
            aType.setIsUsed(false);
            if (!aType.isUsed()) {
                Graph g;
                if (this.bGraGra.getGraph().getTypeSet().getTypeGraph() != null && this.isTypeUsedInGraph(t, g = this.bGraGra.getGraph().getTypeSet().getTypeGraph())) {
                    aType.setIsUsed(true);
                    return true;
                }
                if (this.isTypeUsedInGraph(t, this.bGraGra.getGraph())) {
                    aType.setIsUsed(true);
                    return true;
                }
                Enumeration rules = this.bGraGra.getRules();
                while (rules.hasMoreElements()) {
                    Rule r = (Rule)rules.nextElement();
                    if (this.isTypeUsedInGraph(t, r.getLeft())) {
                        aType.setIsUsed(true);
                        return true;
                    }
                    if (this.isTypeUsedInGraph(t, r.getRight())) {
                        aType.setIsUsed(true);
                        return true;
                    }
                    Enumeration en = r.getNACs();
                    while (en.hasMoreElements()) {
                        Graph g2 = ((OrdinaryMorphism)en.nextElement()).getTarget();
                        if (!this.isTypeUsedInGraph(t, g2)) continue;
                        aType.setIsUsed(true);
                        return true;
                    }
                    Vector atom_conds = r.getAtomApplConds();
                    for (int i = 0; i < atom_conds.size(); ++i) {
                        Vector v = ((EvalSet)atom_conds.get(i)).getSet();
                        for (int j = 0; j < v.size(); ++j) {
                            Vector v1 = ((EvalSet)v.get(j)).getSet();
                            for (int k = 0; k < v1.size(); ++k) {
                                AtomApplCond aac = (AtomApplCond)v1.get(k);
                                OrdinaryMorphism cond = aac.getPreCondition();
                                OrdinaryMorphism tm = aac.getT();
                                OrdinaryMorphism qm = aac.getQ();
                                Graph g3 = cond.getSource();
                                if (this.isTypeUsedInGraph(t, g3)) {
                                    aType.setIsUsed(true);
                                    return true;
                                }
                                g3 = cond.getTarget();
                                if (this.isTypeUsedInGraph(t, g3)) {
                                    aType.setIsUsed(true);
                                    return true;
                                }
                                g3 = tm.getTarget();
                                if (this.isTypeUsedInGraph(t, g3)) {
                                    aType.setIsUsed(true);
                                    return true;
                                }
                                g3 = qm.getSource();
                                if (!this.isTypeUsedInGraph(t, g3)) continue;
                                aType.setIsUsed(true);
                                return true;
                            }
                        }
                    }
                }
                Enumeration atomics = this.bGraGra.getAtomics();
                while (atomics.hasMoreElements()) {
                    AtomConstraint a = (AtomConstraint)atomics.nextElement();
                    if (this.isTypeUsedInGraph(t, a.getSource())) {
                        aType.setIsUsed(true);
                        return true;
                    }
                    Enumeration concls = a.getConclusions();
                    while (concls.hasMoreElements()) {
                        AtomConstraint con = (AtomConstraint)concls.nextElement();
                        if (!this.isTypeUsedInGraph(t, con.getTarget())) continue;
                        aType.setIsUsed(true);
                        return true;
                    }
                }
                return false;
            }
            return true;
        }
        if (this.bGraph != null) {
            aType.setIsUsed(false);
            if (!aType.isUsed()) {
                if (this.isTypeUsedInGraph(t, this.bGraph)) {
                    aType.setIsUsed(true);
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isTypeUsedInGraph(Type t, Graph g) {
        Enumeration e = g.getElements();
        while (e.hasMoreElements()) {
            GraphObject obj = (GraphObject)e.nextElement();
            if (!obj.getType().compareTo(t)) continue;
            return true;
        }
        return false;
    }

    public void renameType(EdType aType, String newName) {
        aType.setName(newName);
    }

    public boolean redefineType(EdType aType, String newName, int newShape, Color newColor, String newImageFileName) {
        return aType.redefineType(newName, newShape, newColor, newImageFileName);
    }

    public void removeNodeType(EdType aType) throws TypeException {
        if (this.bGraGra != null) {
            this.bGraGra.destroyType(aType.getBasisType());
        }
        this.nodeTypes.removeElement(aType);
    }

    public void removeArcType(EdType aType) throws TypeException {
        if (this.bGraGra != null) {
            this.bGraGra.destroyType(aType.getBasisType());
        }
        this.arcTypes.removeElement(aType);
    }

    public void removeNodeTypes() {
        Enumeration en = this.nodeTypes.elements();
        while (en.hasMoreElements()) {
            try {
                this.removeNodeType((EdType)en.nextElement());
            }
            catch (TypeException e) {
                System.out.println("EdTypeSet: " + e.getMessage());
            }
        }
    }

    public void removeArcTypes() {
        Enumeration en = this.arcTypes.elements();
        while (en.hasMoreElements()) {
            try {
                this.removeArcType((EdType)en.nextElement());
            }
            catch (TypeException e) {
                System.out.println("EdTypeSet: " + e.getMessage());
            }
        }
    }

    public void clear() {
        this.bTypeSet.setLevelOfTypeGraphCheck(0);
        this.removeArcTypes();
        this.removeNodeTypes();
    }

    private void initTypesFromTypeSet() {
        this.nodeTypes = new Vector();
        this.arcTypes = new Vector();
        Enumeration<Type> types = this.bTypeSet.getTypes();
        while (types.hasMoreElements()) {
            Type t = types.nextElement();
            if (t.getStringRepr().equals("") && t.getAdditionalRepr().equals("")) {
                try {
                    this.bTypeSet.destroyType(t);
                }
                catch (TypeException e) {
                    System.out.println("EdTypeSet: " + e.getMessage());
                }
                continue;
            }
            this.createType(t);
        }
        Graph typeGraph = this.bTypeSet.getTypeGraph();
        if (!(typeGraph == null || this.edTypeGraph != null && typeGraph.equals(this.edTypeGraph.getBasisGraph()))) {
            this.edTypeGraph = new EdGraph(typeGraph, this);
            this.edTypeGraph.markTypeGraph(true);
            this.edTypeGraph.updateGraph();
        }
    }

    public void refreshTypes() {
        boolean hasChanged = false;
        Enumeration<Type> types = this.bTypeSet.getTypes();
        while (types.hasMoreElements()) {
            Type t = types.nextElement();
            if (this.getType(t) != null) continue;
            if (t.getAdditionalRepr().indexOf(":[NODE]:") >= 0) {
                this.createNodeType(t);
                hasChanged = true;
                continue;
            }
            if (t.getAdditionalRepr().indexOf(":[EDGE]:") < 0) continue;
            this.createArcType(t);
            hasChanged = true;
        }
        if (hasChanged) {
            this.fireTypeEvent(new TypeEvent(this, 11));
        }
    }

    public void refreshTypes(boolean byNameOnly) {
        boolean hasChanged = false;
        Enumeration<Type> types = this.bTypeSet.getTypes();
        while (types.hasMoreElements()) {
            Type t = types.nextElement();
            EdType type = this.getType(t);
            if (type == null && byNameOnly) {
                type = this.getTypeForName(t);
            }
            if (type != null) continue;
            if (t.getAdditionalRepr().indexOf(":[NODE]:") >= 0) {
                this.createNodeType(t);
                hasChanged = true;
                continue;
            }
            if (t.getAdditionalRepr().indexOf(":[EDGE]:") < 0) continue;
            this.createArcType(t);
            hasChanged = true;
        }
        if (hasChanged) {
            this.fireTypeEvent(new TypeEvent(this, 11));
        }
    }

    public boolean isNewType(Vector types, String name, int shape, Color color) {
        boolean sameName = false;
        boolean sameShape = false;
        boolean sameColor = false;
        boolean result = true;
        for (int i = 0; i < types.size(); ++i) {
            EdType et = (EdType)types.elementAt(i);
            if (et.name.equals(name)) {
                sameName = true;
            }
            if (et.shape == shape) {
                sameShape = true;
            }
            if (et.color.equals(color)) {
                sameColor = true;
            }
            if (sameName && sameShape && sameColor) {
                i = types.size();
                result = false;
                continue;
            }
            sameName = false;
            sameShape = false;
            sameColor = false;
        }
        return result;
    }

    public boolean isNewType(Vector types, EdType t) {
        if (t == null) {
            return false;
        }
        boolean sameName = false;
        boolean sameShape = false;
        boolean sameColor = false;
        boolean result = true;
        String name = t.getBasisType().getStringRepr();
        int shape = t.getShape();
        Color color = t.getColor();
        for (int i = 0; i < types.size(); ++i) {
            EdType et = (EdType)types.elementAt(i);
            if (et.name.equals(name)) {
                sameName = true;
            }
            if (et.shape == shape) {
                sameShape = true;
            }
            if (et.color.equals(color)) {
                sameColor = true;
            }
            if (sameName && sameShape && sameColor) {
                i = types.size();
                result = false;
                continue;
            }
            sameName = false;
            sameShape = false;
            sameColor = false;
        }
        return result;
    }

    public void setAdditionalReprOfBasisType() {
        EdType t;
        int i;
        for (i = 0; i < this.nodeTypes.size(); ++i) {
            t = (EdType)this.nodeTypes.elementAt(i);
            if (t.getBasisType().getAdditionalRepr() != null && !t.getBasisType().getAdditionalRepr().equals("") && !t.hasOldAdditionalRepr()) continue;
            t.setAdditionalReprOfBasisType(t.getShape(), t.getColor());
        }
        for (i = 0; i < this.arcTypes.size(); ++i) {
            t = (EdType)this.arcTypes.elementAt(i);
            if (t.getBasisType().getAdditionalRepr() != null && !t.getBasisType().getAdditionalRepr().equals("") && !t.hasOldAdditionalRepr()) continue;
            t.setAdditionalReprOfBasisType(t.getShape(), t.getColor());
        }
    }

    public boolean basisTypeReprComplete() {
        EdType t;
        int i;
        for (i = 0; i < this.nodeTypes.size(); ++i) {
            t = (EdType)this.nodeTypes.elementAt(i);
            if (t.getBasisType().getAdditionalRepr() != null && !t.getBasisType().getAdditionalRepr().equals("") && !t.hasOldAdditionalRepr()) continue;
            return false;
        }
        for (i = 0; i < this.arcTypes.size(); ++i) {
            t = (EdType)this.arcTypes.elementAt(i);
            if (t.getBasisType().getAdditionalRepr() != null && !t.getBasisType().getAdditionalRepr().equals("") && !t.hasOldAdditionalRepr()) continue;
            return false;
        }
        return true;
    }

    public EdType getType(Vector types, String name, int shape, Color color) {
        for (int i = 0; i < types.size(); ++i) {
            EdType et = (EdType)types.elementAt(i);
            if (!et.name.equals(name) || et.shape != shape || !et.color.equals(color)) continue;
            return et;
        }
        return null;
    }

    public EdType getType(Type t) {
        EdType et;
        int i;
        for (i = 0; i < this.nodeTypes.size(); ++i) {
            et = (EdType)this.nodeTypes.elementAt(i);
            if (!et.getBasisType().compareTo(t)) continue;
            return et;
        }
        for (i = 0; i < this.arcTypes.size(); ++i) {
            et = (EdType)this.arcTypes.elementAt(i);
            if (!et.getBasisType().compareTo(t)) continue;
            return et;
        }
        return null;
    }

    public EdType getTypeForName(Type t) {
        EdType et;
        int i;
        for (i = 0; i < this.nodeTypes.size(); ++i) {
            et = (EdType)this.nodeTypes.elementAt(i);
            if (!et.getBasisType().getName().equals(t.getName())) continue;
            return et;
        }
        for (i = 0; i < this.arcTypes.size(); ++i) {
            et = (EdType)this.arcTypes.elementAt(i);
            if (!et.getBasisType().getName().equals(t.getName())) continue;
            return et;
        }
        return null;
    }

    public EdType getTypeForName(String tname) {
        EdType et;
        int i;
        for (i = 0; i < this.nodeTypes.size(); ++i) {
            et = (EdType)this.nodeTypes.elementAt(i);
            if (!et.getName().equals(tname)) continue;
            return et;
        }
        for (i = 0; i < this.arcTypes.size(); ++i) {
            et = (EdType)this.arcTypes.elementAt(i);
            if (!et.getName().equals(tname)) continue;
            return et;
        }
        return null;
    }

    public Vector getAdditionalReprOfBasisType(Type baseType) {
        Vector<String> v = new Vector<String>();
        String addRepr = baseType.getAdditionalRepr();
        String shapeStr = "";
        String colorStr = "";
        String imageFileNameStr = "";
        String markStr = "[]";
        int begin = 0;
        while (addRepr.length() != 0) {
            String helpStr;
            int indx;
            int l = addRepr.length();
            if (addRepr.charAt(0) == ':') {
                String helpStr2;
                addRepr = helpStr2 = addRepr.substring(1, l);
            }
            String testStr = "";
            if (addRepr.length() != 0 && (indx = addRepr.indexOf(":")) != -1) {
                testStr = addRepr.substring(begin, indx);
                if (testStr.indexOf("RECT") != -1 || testStr.indexOf("ROUND") != -1 || testStr.indexOf("CIRCLE") != -1 || testStr.indexOf("OVAL") != -1 || testStr.indexOf("SOLID_LINE") != -1 || testStr.indexOf("DASH_LINE") != -1 || testStr.indexOf("DOT_LINE") != -1) {
                    shapeStr = testStr;
                } else if (testStr.indexOf("Color") != -1) {
                    colorStr = testStr;
                } else if (testStr.indexOf(".jpg") != -1 || testStr.indexOf(".gif") != -1 || testStr.indexOf(".xpm") != -1) {
                    imageFileNameStr = testStr;
                } else if (testStr.indexOf("[NODE]") != -1 || testStr.indexOf("[EDGE]") != -1) {
                    markStr = testStr;
                }
            }
            addRepr = helpStr = addRepr.substring(begin + testStr.length(), l - 1);
        }
        if (shapeStr.equals("")) {
            if (markStr.equals("[NODE]")) {
                shapeStr = "RECT";
            } else if (markStr.equals("[EDGE]")) {
                shapeStr = "SOLID_LINE";
            }
        }
        if (colorStr.equals("")) {
            colorStr = "java.awt.Color[r=0,g=0,b=0]";
        }
        v.add(shapeStr);
        v.add(colorStr);
        v.add(imageFileNameStr);
        v.add(markStr);
        return v;
    }

    public void deleteGraphObjectsOfType(Type t, boolean fromTypeGraph) {
        if (this.bGraGra != null) {
            this.bGraGra.destroyGraphObjectsOfType(t, fromTypeGraph);
        }
    }

    public void setNodeIconable(boolean iconable) {
        this.iconable = true;
        for (int i = 0; i < this.nodeTypes.size(); ++i) {
            EdType t = (EdType)this.nodeTypes.elementAt(i);
            t.setIconable(iconable);
        }
    }

    public void setResourcesPath(String path) {
        this.resourcesPath = path;
        for (int i = 0; i < this.nodeTypes.size(); ++i) {
            EdType t = (EdType)this.nodeTypes.elementAt(i);
            t.setResourcesPath(this.resourcesPath);
        }
    }

    public synchronized void addTypeEventListener(TypeEventListener l) {
        Vector v;
        Vector vector = v = this.typeEventListeners == null ? new Vector(2) : (Vector)this.typeEventListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.typeEventListeners = v;
        }
    }

    public synchronized void removeTypeEventListener(TypeEventListener l) {
        if (this.typeEventListeners != null && this.typeEventListeners.contains(l)) {
            Vector v = (Vector)this.typeEventListeners.clone();
            v.removeElement(l);
            this.typeEventListeners = v;
        }
    }

    public void fireTypeChangedEvent() {
        this.fireTypeEvent(new TypeEvent(this, 3));
    }

    private void fireTypeEvent(TypeEvent e) {
        if (this.typeEventListeners != null) {
            Vector listeners = this.typeEventListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((TypeEventListener)listeners.elementAt(i)).typeEventOccurred(e);
            }
        }
    }
}

