/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNode;
import agg.editor.impl.GraphPanel;
import agg.editor.impl.Loop;
import agg.gui.GraGraEditor;
import agg.xt_basis.Type;
import agg.xt_basis.TypeError;
import agg.xt_basis.TypeException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;

public class GraphCanvas
extends JPanel
implements MouseListener,
MouseMotionListener {
    public static final int MAX_XWIDTH = 700;
    public static final int MAX_YHEIGHT = 600;
    private static final int DEPEND_ON_LAST_OBJECT = 0;
    private static final int DEPEND_ON_MOVED_SCROLLBAR = 1;
    private static final int DEPEND_ON_MOVED_OBJECT = 2;
    private Toolkit tk;
    private EdGraph eGraph;
    private boolean visible = true;
    private int drawMode = 11;
    private int lastMode = 11;
    private String fontName = "Dialog";
    private int fontStyle = 0;
    private int fontSize = 12;
    private double scale = 1.0;
    private Image offscreen;
    private Dimension offscreensize;
    private Graphics offgraphics;
    private JScrollBar hsb;
    private JScrollBar vsb;
    private int hsbValue;
    private int vsbValue;
    private boolean scrollbarValueSaved;
    private GraphPanel viewport;
    private int realWidth = 100;
    private int realHeight = 100;
    private boolean needResizeAfterMove = false;
    private boolean needResizeAfterStep = false;
    private EdNode pickedNode;
    private EdArc pickedArc;
    private EdArc pickedTextOfArc;
    private EdGraphObject pickedObj;
    private EdGraphObject src;
    private EdGraphObject tar;
    private Point anchor;
    private int x0 = 0;
    private int y0 = 0;
    private int dx = 0;
    private int dy = 0;
    private boolean changed = false;
    private boolean dragged = false;
    private String msg;

    public GraphCanvas() {
        super(new BorderLayout(), true);
        this.setBackground(Color.lightGray);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setFont(new Font(this.fontName, this.fontStyle, this.fontSize));
        this.vsbValue = 0;
        this.hsbValue = 0;
        this.scrollbarValueSaved = false;
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.realWidth, this.realHeight);
    }

    public void setViewport(GraphPanel vp) {
        this.viewport = vp;
        this.hsb = this.viewport.getHorizontalScrollBar();
        this.vsb = this.viewport.getVerticalScrollBar();
    }

    public GraphPanel getViewport() {
        return this.viewport;
    }

    public void saveScrollBarValue() {
        this.hsbValue = this.hsb.getValue();
        this.vsbValue = this.vsb.getValue();
        this.scrollbarValueSaved = true;
    }

    public void setRealWidth(int w) {
        this.realWidth = w;
    }

    public void setRealHeight(int h) {
        this.realHeight = h;
    }

    public void setGraph(EdGraph eg) {
        this.eGraph = eg;
    }

    public void setVisible(boolean vis) {
        this.visible = vis;
    }

    public void setFontStyle(int fstyle) {
        this.fontStyle = fstyle;
        this.setFont(new Font(this.fontName, this.fontStyle, this.fontSize));
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontSize(int fsize) {
        this.fontSize = fsize;
        if (this.fontSize == 0) {
            this.setFont(new Font(this.fontName, this.fontStyle, 8));
        } else {
            this.setFont(new Font(this.fontName, this.fontStyle, this.fontSize));
        }
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setScale(double s) {
        this.scale = s;
        int indx = -1;
        for (int i = 0; i < GraGraEditor.scaleArray.length; ++i) {
            if (GraGraEditor.scaleArray[i] != s) continue;
            indx = i;
            i = GraGraEditor.scaleArray.length;
        }
        if (indx != -1) {
            // empty if block
        }
    }

    public double getScale() {
        return this.scale;
    }

    public void resizeAfterTransform(boolean val) {
        this.needResizeAfterStep = val;
    }

    public int getEditMode() {
        return this.drawMode;
    }

    public void setEditMode(int mode) {
        if (mode != 9) {
            this.scale = 1.0;
        }
        switch (mode) {
            case 9: {
                this.drawMode = mode;
                break;
            }
            case 11: {
                this.drawMode = mode;
                break;
            }
            case 113: {
                this.drawMode = mode;
                break;
            }
            case 15: {
                this.drawMode = mode;
                break;
            }
            case 151: {
                this.drawMode = mode;
                break;
            }
            case 13: {
                this.drawMode = mode;
                break;
            }
            case 12: {
                this.drawMode = mode;
                break;
            }
            case 114: {
                this.drawMode = mode;
                break;
            }
            case 14: {
                this.drawMode = mode;
                break;
            }
            case 16: {
                this.drawMode = mode;
                this.update(this.getGraphics());
                break;
            }
            case 17: 
            case 171: {
                this.drawMode = mode;
                break;
            }
            case 115: 
            case 116: 
            case 117: 
            case 1161: {
                this.drawMode = mode;
                break;
            }
            case 1201: 
            case 1202: {
                this.lastMode = this.drawMode;
                this.drawMode = mode;
                break;
            }
            case 118: 
            case 1181: {
                this.drawMode = mode;
                break;
            }
            case 31: 
            case 42: 
            case 81: {
                this.drawMode = mode;
                break;
            }
            case 32: 
            case 43: 
            case 82: {
                this.drawMode = mode;
                break;
            }
            case 30: 
            case 80: {
                this.drawMode = mode;
                break;
            }
            case 20: {
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                break;
            }
            case 10: {
                this.drawMode = mode;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected mode");
            }
        }
    }

    public String getMsg() {
        return this.msg;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void paintComponent(Graphics grs) {
        if (grs == null) {
            return;
        }
        if (this.eGraph != null) {
            grs.setFont(this.getFont());
            Graphics2D g = (Graphics2D)grs;
            Dimension graphDim = this.getGraphDimension();
            if (graphDim != null) {
                this.realWidth = graphDim.width;
                this.realHeight = graphDim.height;
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.realWidth, this.realHeight);
            } else {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (this.needResizeAfterMove) {
                this.needResizeAfterMove = false;
            } else if (this.needResizeAfterStep) {
                EdNode lastNode = null;
                if (this.eGraph.getNodes().size() != 0) {
                    int newHeight;
                    lastNode = (EdNode)this.eGraph.getNodes().lastElement();
                    for (newHeight = this.getHeight(); lastNode.getY() > newHeight; newHeight += this.viewport.getHeight()) {
                    }
                    if (newHeight > this.getHeight()) {
                        this.setSize(new Dimension(this.getWidth(), newHeight));
                    }
                } else {
                    this.realWidth = this.viewport.getWidth() - this.vsb.getWidth() - 3;
                    this.realHeight = this.viewport.getHeight() - this.hsb.getHeight() - 3;
                    this.setSize(new Dimension(this.realWidth, this.realHeight));
                    this.eGraph.setRealWidthOfGraphPanel(this.realWidth);
                }
                this.resetValueOfScrollbar(0);
                this.needResizeAfterStep = false;
            } else if (this.realWidth != this.getWidth() || this.realHeight != this.getHeight()) {
                if (this.realWidth < this.getWidth()) {
                    this.realWidth = this.getWidth();
                }
                if (this.realHeight < this.getHeight()) {
                    this.realHeight = this.getHeight();
                }
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (this.eGraph.getNodes().size() == 0) {
                    this.realWidth = this.getWidth();
                    this.realHeight = this.getHeight();
                }
                this.eGraph.setRealWidthOfGraphPanel(this.realWidth);
            } else {
                this.eGraph.setRealWidthOfGraphPanel(this.realWidth);
            }
            this.eGraph.drawGraphics(g, this.scale, true);
        } else {
            this.realWidth = this.getWidth();
            this.realHeight = this.getHeight();
            this.setSize(new Dimension(this.realWidth, this.realHeight));
            grs.setColor(Color.lightGray);
            grs.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.eGraph == null) {
            this.errSound();
            return;
        }
        if (e.isPopupTrigger() && this.eGraph.isEditable() || this.drawMode == 13 || !SwingUtilities.isLeftMouseButton(e)) {
            this.pickedObj = null;
            this.x0 = e.getX();
            this.y0 = e.getY();
            this.pickedObj = this.getPickedObject(e.getX(), e.getY(), this.getGraphics().getFontMetrics());
            this.nodeToFront(e.getX(), e.getY());
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.eGraph != null) {
            int x = e.getX();
            int y = e.getY();
            this.changed = false;
            if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                this.src = this.getPickedObject(e.getX(), e.getY(), this.getGraphics().getFontMetrics());
                if (this.src != null && this.src.isArc()) {
                    this.src = null;
                }
            }
            if (SwingUtilities.isMiddleMouseButton(e)) {
                this.x0 = e.getX();
                this.y0 = e.getY();
                this.pickedObj = null;
                this.pickedObj = this.getPickedObject(x, y, this.getGraphics().getFontMetrics());
                if (this.pickedObj == null) {
                    this.errSound();
                }
            } else if (SwingUtilities.isLeftMouseButton(e)) {
                switch (this.drawMode) {
                    case 10: {
                        break;
                    }
                    case 9: {
                        break;
                    }
                    case 11: {
                        if (!this.eGraph.isEditable()) {
                            this.errSound();
                            return;
                        }
                        if (this.eGraph.getGraGra().getSelectedNodeType() == null) {
                            JOptionPane.showMessageDialog(this.getDialogFrame(), "Node type is not selected.");
                            return;
                        }
                        Type t = this.eGraph.getTypeSet().getSelectedNodeType().getBasisType();
                        if (t.isAbstract()) {
                            if (this.eGraph.getTypeSet().getBasisTypeSet().getClan(t).size() == 1) {
                                JOptionPane.showMessageDialog(null, "The node type  <" + this.eGraph.getGraGra().getSelectedNodeType().getName() + ">  is abstract and without descendants." + "\nTo create a node of such type is not allowed.", "Create Node", 0);
                                return;
                            }
                            if (this.eGraph == this.eGraph.getGraGra().getGraph() && this.eGraph.getTypeSet().getBasisTypeSet().getLevelOfTypeGraphCheck() > 0) {
                                JOptionPane.showMessageDialog(null, "The node type  <" + this.eGraph.getGraGra().getSelectedNodeType().getName() + ">  is abstract." + "\nTo create an abstract node of the host graph is not allowed.", "Create Node", 0);
                                return;
                            }
                        }
                        this.src = this.eGraph.getPickedNode(x, y);
                        if (this.src == null && this.eGraph.getPickedArc(x, y) != null) {
                            return;
                        }
                        if (this.src == null) {
                            EdNode en = this.addNode(x, y);
                            if (en == null) {
                                return;
                            }
                            en.drawGraphic(this.getGraphics(), this.scale);
                            this.changed = true;
                            break;
                        }
                        this.setEditMode(113);
                        break;
                    }
                    case 113: {
                        if (this.eGraph.getGraGra().getSelectedArcType() == null) {
                            JOptionPane.showMessageDialog(this.getDialogFrame(), "Edge type is not selected.");
                            return;
                        }
                        this.tar = this.eGraph.getPickedNode(x, y);
                        if (this.src != null && this.tar != null) {
                            EdArc ea = null;
                            if (this.src.isNode() && this.tar.isNode()) {
                                ea = this.addArc(this.src, this.tar, this.anchor);
                            }
                            if (ea != null) {
                                this.eGraph.drawArc(this.getGraphics(), this.scale, ea);
                                this.changed = true;
                            }
                            this.src = null;
                            this.tar = null;
                            this.anchor = null;
                            this.setEditMode(11);
                            break;
                        }
                        this.anchor = new Point(x, y);
                        break;
                    }
                    case 13: {
                        this.x0 = e.getX();
                        this.y0 = e.getY();
                        this.pickedObj = null;
                        this.pickedObj = this.getPickedObject(x, y, this.getGraphics().getFontMetrics());
                        if (this.pickedObj != null) break;
                        this.errSound();
                        break;
                    }
                    case 14: {
                        break;
                    }
                    case 1201: {
                        this.tar = this.getPickedObject(x, y, this.getGraphics().getFontMetrics());
                        if (this.tar == null) {
                            this.errSound();
                            this.viewport.setEditMode(this.lastMode);
                            break;
                        }
                        if (this.src == null) break;
                        TypeError error = this.eGraph.getBasisGraph().getTypeSet().addInheritanceRelation(this.src.getBasisObject().getType(), this.tar.getBasisObject().getType());
                        if (error == null) {
                            this.eGraph.update();
                            this.viewport.updateGraphics();
                        } else {
                            this.errSound();
                            JOptionPane.showMessageDialog(this.getDialogFrame(), error.getMessage(), "Type Graph Error", 0);
                        }
                        this.viewport.setEditMode(this.lastMode);
                        break;
                    }
                    case 1202: {
                        this.tar = this.getPickedObject(x, y, this.getGraphics().getFontMetrics());
                        if (this.tar == null) {
                            this.errSound();
                            this.viewport.setEditMode(this.lastMode);
                            break;
                        }
                        if (this.src == null) break;
                        if (this.eGraph.getBasisGraph().getTypeSet().removeInheritanceRelation(this.src.getBasisObject().getType(), this.tar.getBasisObject().getType())) {
                            this.eGraph.update();
                            this.viewport.updateGraphics();
                        } else {
                            this.errSound();
                        }
                        this.viewport.setEditMode(this.lastMode);
                        break;
                    }
                    case 12: {
                        if (!this.eGraph.isEditable()) {
                            this.errSound();
                            return;
                        }
                        this.pickedObj = null;
                        this.pickedObj = this.eGraph.select(x, y);
                        if (this.pickedObj != null) {
                            if (this.pickedObj.isNode()) {
                                this.eGraph.drawNode(this.getGraphics(), this.scale, (EdNode)this.pickedObj);
                                break;
                            }
                            this.eGraph.drawArc(this.getGraphics(), this.scale, (EdArc)this.pickedObj);
                            break;
                        }
                        this.errSound();
                        break;
                    }
                    case 15: {
                        if (!this.eGraph.isEditable()) {
                            this.errSound();
                            return;
                        }
                        this.msg = "";
                        this.eGraph.eraseSelected(this.getGraphics(), this.scale, true);
                        this.eGraph.copySelected(x, y);
                        if (this.eGraph.getMsg().length() != 0) {
                            this.msg = "Edit / Duplicate : " + this.eGraph.getMsg();
                        }
                        this.eGraph.drawSelected(this.getGraphics(), this.scale);
                        this.pickedObj = null;
                        this.changed = true;
                        break;
                    }
                    case 151: {
                        if (!this.eGraph.isEditable()) {
                            this.errSound();
                            return;
                        }
                        this.msg = "";
                        if (this.src == null) {
                            this.src = this.eGraph.getPickedNode(x, y);
                            break;
                        }
                        if (this.tar != null) break;
                        this.tar = this.eGraph.getPickedNode(x, y);
                        EdArc a = this.eGraph.getSelectedArc();
                        if (this.tar != null && a != null) {
                            EdArc ac = this.eGraph.copyArc(a, this.src, this.tar);
                            if (ac != null) {
                                if (a.isLine()) {
                                    if (a.hasAnchor()) {
                                        if (a.getSource() != ac.getSource() || a.getTarget() != ac.getTarget()) {
                                            Point dxyAnchorSrc = new Point(a.getAnchor().x - a.getSource().getX(), a.getAnchor().y - a.getSource().getY());
                                            Point p = new Point(ac.getSource().getX() + dxyAnchorSrc.x, ac.getSource().getY() + dxyAnchorSrc.y);
                                            if (p.x < 0 || p.y < 0) {
                                                ac.setAnchor(null);
                                            } else {
                                                ac.setAnchor(p);
                                            }
                                        } else {
                                            ac.setAnchor(new Point(a.getAnchor().x + 5, a.getAnchor().y + 5));
                                        }
                                    } else {
                                        Point p = new Point(ac.getSource().getX() + (ac.getTarget().getX() - ac.getSource().getX()) / 2 + 5, ac.getSource().getY() + (ac.getTarget().getY() - ac.getSource().getY()) / 2 + 5);
                                        ac.setAnchor(p);
                                    }
                                } else {
                                    ac.setWidth(a.getWidth() + 10);
                                    ac.setHeight(a.getHeight() + 10);
                                }
                                ac.setTextOffset(a.getTextOffset().x + 5, a.getTextOffset().y + 5);
                                this.eGraph.deselect(a);
                                this.eGraph.select(ac);
                                this.eGraph.drawSelected(this.getGraphics(), this.scale);
                            } else {
                                this.eGraph.deselect(a);
                                JOptionPane.showMessageDialog(null, "Copy of an edge is failed. \nThe cause can be a type incompatibility.", "Copy failed", 2);
                            }
                        } else {
                            JOptionPane.showMessageDialog(null, "Copy of an edge is failed. \nThe second click point must be \na target node of an edge copy.", "Copy failed", 2);
                            this.eGraph.deselect(a);
                        }
                        this.pickedObj = null;
                        this.changed = true;
                        this.src = null;
                        this.tar = null;
                        this.setEditMode(11);
                        break;
                    }
                    case 16: {
                        break;
                    }
                    case 42: 
                    case 115: {
                        break;
                    }
                }
            }
        } else {
            this.errSound();
        }
    }

    private EdNode addNode(int x, int y) {
        EdNode en = null;
        try {
            en = this.eGraph.addNode(this.eGraph.getBasisGraph(), x, y, this.visible);
        }
        catch (TypeException e) {
            JOptionPane.showMessageDialog(this.getDialogFrame(), e.getMessage(), "Type Graph Error", 0);
        }
        return en;
    }

    private EdArc addArc(EdGraphObject s, EdGraphObject t, Point anch) {
        EdArc ea = null;
        try {
            ea = this.eGraph.addArc(this.eGraph.getBasisGraph(), s, t, anch, true);
        }
        catch (TypeException e) {
            JOptionPane.showMessageDialog(this.getDialogFrame(), e.getMessage(), "Type Graph Error", 0);
        }
        return ea;
    }

    public EdGraphObject getPickedObject(int X, int Y, FontMetrics Fm) {
        if (this.eGraph == null) {
            return null;
        }
        this.pickedNode = null;
        this.pickedArc = null;
        this.pickedTextOfArc = null;
        this.pickedNode = this.eGraph.getPickedNode(X, Y);
        if (this.pickedNode != null) {
            return this.pickedNode;
        }
        this.pickedTextOfArc = this.eGraph.getPickedTextOfArc(X, Y, Fm);
        if (this.pickedTextOfArc != null) {
            return this.pickedTextOfArc;
        }
        this.pickedArc = this.eGraph.getPickedArc(X, Y);
        if (this.pickedArc != null) {
            return this.pickedArc;
        }
        return null;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.eGraph == null) {
            return;
        }
        if (SwingUtilities.isMiddleMouseButton(e) || this.drawMode == 13) {
            this.dragged = false;
            this.dx = 0;
            this.dy = 0;
            if (e.getX() > 0 && e.getY() > 0) {
                int x = e.getX();
                int y = e.getY();
                this.dx = x - this.x0;
                this.dy = y - this.y0;
                if (Math.abs(this.dx) > 0 || Math.abs(this.dy) > 0) {
                    this.x0 = x;
                    this.y0 = y;
                    if (this.pickedObj != null) {
                        if (!this.pickedObj.isSelected()) {
                            this.movePicked(this.dx, this.dy);
                            this.dragged = true;
                        } else {
                            this.moveSelected(this.dx, this.dy);
                            this.dragged = true;
                        }
                        this.update(this.getGraphics());
                    }
                } else {
                    this.dx = 0;
                    this.dy = 0;
                }
            }
        }
    }

    public EdGraphObject getDraggedObject() {
        if (this.dragged) {
            return this.pickedObj;
        }
        return null;
    }

    public Dimension getDraggedDimension() {
        if (this.dragged) {
            return new Dimension(this.dx, this.dy);
        }
        return new Dimension(0, 0);
    }

    public void mouseReleased(MouseEvent e) {
        if (this.eGraph == null) {
            return;
        }
        if (this.drawMode == 13 || SwingUtilities.isMiddleMouseButton(e)) {
            if (!this.dragged) {
                return;
            }
            if (this.pickedObj != null) {
                Dimension graphDim;
                if (this.pickedObj.isNode()) {
                    this.nodeToFront(e.getX(), e.getY());
                }
                if ((graphDim = this.getGraphDimension()) != null) {
                    this.realWidth = graphDim.width;
                    this.realHeight = graphDim.height;
                    int vpW = this.getViewportWidth();
                    int vpH = this.getViewportHeight();
                    if (this.realWidth > vpW || this.realHeight > vpH) {
                        this.needResizeAfterMove = true;
                        this.eGraph.setRealWidthOfGraphPanel(this.realWidth);
                        if (this.pickedObj.getX() >= this.hsb.getValue() + this.hsb.getVisibleAmount()) {
                            this.hsbValue = this.pickedObj.getX() + this.pickedObj.getWidth() - this.hsb.getVisibleAmount();
                            this.hsb.setValue(this.hsbValue);
                        }
                        if (this.pickedObj.getY() >= this.vsb.getValue() + this.vsb.getVisibleAmount()) {
                            this.vsbValue = this.pickedObj.getY() + this.pickedObj.getHeight() - this.vsb.getVisibleAmount();
                            this.vsb.setValue(this.vsbValue);
                        }
                    }
                    if (this.realWidth == this.getWidth() && this.realHeight == this.getHeight()) {
                        this.update(this.getGraphics());
                    } else {
                        this.setSize(new Dimension(this.realWidth, this.realHeight));
                    }
                }
            }
            if (this.eGraph.getGraGra() != null) {
                this.eGraph.getGraGra().setChanged(true);
            }
            this.dragged = false;
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.resetScrollBars();
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        int y;
        if (this.eGraph == null) {
            return;
        }
        int x = e.getX();
        EdGraphObject go = this.getPickedObject(x, y = e.getY(), this.getGraphics().getFontMetrics());
        if (go != null && go.isArc() && ((EdArc)go).getSource().isVisible() && ((EdArc)go).getTarget().isVisible() && go.isVisible()) {
            go.getArc().showMoveAnchor(this.getGraphics());
        }
    }

    public void resetScrollBars() {
        if (this.eGraph == null) {
            return;
        }
        if (this.scrollbarValueSaved) {
            this.hsb.setValue(this.hsbValue);
            this.vsb.setValue(this.vsbValue);
            this.scrollbarValueSaved = false;
        }
    }

    public void nodeToFront(int X, int Y) {
        this.pickedNode = this.eGraph.getPickedNode(X, Y);
        if (this.pickedNode != null) {
            this.eGraph.getNodes().removeElement(this.pickedNode);
            this.eGraph.getNodes().addElement(this.pickedNode);
        }
    }

    public Dimension getGraphDimension() {
        if (this.eGraph == null) {
            return null;
        }
        Dimension dim = this.eGraph.getGraphDimension();
        if (dim == null) {
            return null;
        }
        int maxX = dim.width;
        int maxY = dim.height;
        if (this.viewport != null) {
            if (maxX < this.getViewportWidth()) {
                maxX = this.getViewportWidth();
            }
            if (maxY < this.getViewportHeight()) {
                maxY = this.getViewportHeight();
            }
        }
        return new Dimension(maxX, maxY);
    }

    private int getViewportWidth() {
        return this.viewport.getWidth() - this.vsb.getWidth() - 3;
    }

    private int getViewportHeight() {
        return this.viewport.getHeight() - this.hsb.getHeight() - 3;
    }

    private void movePicked(int dx, int dy) {
        if (this.pickedNode != null) {
            this.eGraph.moveNode(this.pickedNode, dx, dy);
        } else if (this.pickedTextOfArc != null) {
            this.eGraph.moveTextOfArc(this.pickedTextOfArc, dx, dy);
        } else if (this.pickedArc != null) {
            this.eGraph.moveArc(this.pickedArc, dx, dy);
        }
    }

    private void moveSelected(int dx, int dy) {
        int i;
        for (i = 0; i < this.eGraph.getSelectedNodes().size(); ++i) {
            EdNode en = (EdNode)this.eGraph.getSelectedNodes().elementAt(i);
            this.eGraph.moveNode(en, dx, dy);
        }
        for (i = 0; i < this.eGraph.getArcs().size(); ++i) {
            EdArc ea = (EdArc)this.eGraph.getArcs().elementAt(i);
            if (ea.isLine() && ea.hasAnchor()) {
                if (!ea.isSelected() && (!ea.getSource().isSelected() || !ea.getTarget().isSelected())) continue;
                ea.setAnchor(new Point(ea.getAnchor().x + dx, ea.getAnchor().y + dy));
                continue;
            }
            if (ea.isLine() || ea != this.pickedArc || ea.getSource().isSelected()) continue;
            Loop loop = ea.toLoop();
            loop.move(((EdNode)ea.getSource()).toRectangle(), ea.getAnchorID(), dx, dy);
            ea.setAnchor(1, new Point(loop.x, loop.y));
            ea.setWidth(loop.w);
            ea.setHeight(loop.h);
        }
    }

    private void resetValueOfScrollbar(int dependOn) {
        if (this.eGraph == null) {
            return;
        }
        if (dependOn == 0 && this.eGraph.getNodes().size() != 0) {
            EdNode go = (EdNode)this.eGraph.getNodes().lastElement();
            if (go.getX() >= this.hsb.getValue() + this.hsb.getVisibleAmount()) {
                this.hsbValue = go.getX() + go.getWidth() - this.hsb.getVisibleAmount();
                this.hsb.setValue(this.hsbValue);
            }
            if (go.getY() >= this.vsb.getValue() + this.vsb.getVisibleAmount()) {
                this.vsbValue = go.getY() + go.getHeight() - this.vsb.getVisibleAmount();
                this.vsb.setValue(this.vsbValue);
            }
        }
    }

    private void errSound() {
        Frame f = new Frame("Test");
        f.pack();
        this.tk = f.getToolkit();
        this.tk.beep();
    }

    private JFrame getDialogFrame() {
        return new JFrame();
    }
}

