/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNode;
import agg.editor.impl.GraphCanvas;
import agg.xt_basis.Arc;
import agg.xt_basis.Node;
import agg.xt_basis.TypeException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class GraphPanel
extends JPanel {
    protected GraphCanvas canvas;
    protected EdGraph eGraph;
    protected JScrollPane jsp;
    protected Cursor lastEditCursor = new Cursor(0);
    private boolean mappedObjDeleted = false;
    private boolean attrEditorOn = false;
    private Cursor editCursor = new Cursor(0);
    private int lastEditMode = 11;

    public GraphPanel() {
        super(new BorderLayout(), true);
        this.canvas = new GraphCanvas();
        try {
            this.jsp = new JScrollPane(this.canvas, 22, 32);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.jsp.setBackground(Color.white);
        this.canvas.setViewport(this);
        this.jsp.getHorizontalScrollBar().setUnitIncrement(30);
        this.jsp.getVerticalScrollBar().setUnitIncrement(30);
        this.jsp.getHorizontalScrollBar().setBlockIncrement(50);
        this.jsp.getVerticalScrollBar().setBlockIncrement(50);
        this.jsp.getHorizontalScrollBar().getModel().setValueIsAdjusting(true);
        this.jsp.getVerticalScrollBar().getModel().setValueIsAdjusting(true);
        this.add((Component)this.jsp, "Center");
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.jsp != null) {
            this.jsp.setBackground(c);
        }
        if (this.canvas != null) {
            this.canvas.setBackground(c);
        }
    }

    public JScrollPane getScrollPane() {
        return this.jsp;
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public Dimension getPreferredSize() {
        return new Dimension(250, 150);
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.jsp.getHorizontalScrollBar();
    }

    public JScrollBar getVerticalScrollBar() {
        return this.jsp.getVerticalScrollBar();
    }

    public void resetScrollBars() {
        this.canvas.resetScrollBars();
    }

    public void setViewportView(GraphCanvas view) {
        this.jsp.setViewportView(view);
    }

    public void updateGraphics() {
        if (this.canvas.getGraphics() != null) {
            this.canvas.update(this.canvas.getGraphics());
        }
    }

    public void updateGraphics(boolean graphDimensionCheck) {
        if (this.eGraph != null) {
            if (graphDimensionCheck) {
                Dimension maxDim = this.getGraphDimension();
                if (maxDim.width != 0 || maxDim.height != 0) {
                    this.canvas.setSize(maxDim);
                    this.canvas.update(this.canvas.getGraphics());
                }
            } else {
                this.canvas.paintComponent(this.canvas.getGraphics());
            }
        }
    }

    public void updateGraphicsAfterDelete() {
        if (this.eGraph != null) {
            Dimension maxDim = this.getGraphDimension();
            if (maxDim.width != 0 || maxDim.height != 0) {
                this.canvas.setSize(maxDim);
                this.canvas.update(this.canvas.getGraphics());
            }
        }
    }

    private Dimension getGraphDimension() {
        if (this.eGraph != null) {
            Dimension maxDim = this.canvas.getGraphDimension();
            if (maxDim != null) {
                this.canvas.setRealWidth(maxDim.width);
                this.canvas.setRealHeight(maxDim.height);
                this.eGraph.setRealWidthOfGraphPanel(maxDim.width);
            } else {
                maxDim = new Dimension(this.getWidth() - this.jsp.getVerticalScrollBar().getWidth() - 3, this.getHeight() - this.jsp.getHorizontalScrollBar().getHeight() - 3);
                this.canvas.setRealWidth(this.canvas.getWidth());
                this.canvas.setRealHeight(this.canvas.getHeight());
            }
            return maxDim;
        }
        return new Dimension(0, 0);
    }

    public void resizeAfterTransform(boolean val) {
        this.canvas.resizeAfterTransform(val);
    }

    public EdGraph getGraph() {
        return this.eGraph;
    }

    public void setGraph(EdGraph eg) {
        this.eGraph = eg;
        this.canvas.setGraph(eg);
        this.setBackground(Color.white);
        if (this.eGraph != null) {
            this.setBackground(Color.white);
            Dimension maxDim = this.canvas.getGraphDimension();
            if (maxDim != null) {
                this.canvas.setSize(new Dimension(maxDim.width, maxDim.height));
                this.canvas.setRealWidth(maxDim.width);
                this.canvas.setRealHeight(maxDim.height);
                this.eGraph.setRealWidthOfGraphPanel(maxDim.width);
            } else {
                this.canvas.setSize(new Dimension(this.getWidth() - this.jsp.getVerticalScrollBar().getWidth() - 3, this.getHeight() - this.jsp.getHorizontalScrollBar().getHeight() - 3));
                this.canvas.setRealWidth(this.canvas.getWidth());
                this.canvas.setRealHeight(this.canvas.getHeight());
            }
        } else {
            this.canvas.setSize(new Dimension(this.getWidth() - this.jsp.getVerticalScrollBar().getWidth() - 3, this.getHeight() - this.jsp.getHorizontalScrollBar().getHeight() - 3));
            this.canvas.setRealWidth(this.canvas.getWidth());
            this.canvas.setRealHeight(this.canvas.getHeight());
        }
        this.jsp.getHorizontalScrollBar().setValue(0);
        this.jsp.getVerticalScrollBar().setValue(0);
    }

    public GraphCanvas getCanvas() {
        return this.canvas;
    }

    public int getEditMode() {
        return this.canvas.getEditMode();
    }

    public void setEditMode(int m) {
        this.canvas.setEditMode(m);
    }

    public void setEditCursor(Cursor cur) {
        this.editCursor = cur;
    }

    public Cursor getEditCursor() {
        return this.editCursor;
    }

    public void setLastEditMode(int m) {
        this.lastEditMode = m;
    }

    public int getLastEditMode() {
        if (this.lastEditMode == 113) {
            return 11;
        }
        return this.lastEditMode;
    }

    public void setLastEditCursor(Cursor cur) {
        this.lastEditCursor = cur;
    }

    public Cursor getLastEditCursor() {
        return this.lastEditCursor;
    }

    public void setVisible(boolean vis) {
        this.canvas.setVisible(vis);
    }

    public void setMappedObjDeleted(boolean b) {
        this.mappedObjDeleted = b;
    }

    public boolean wasMappedObjDeleted() {
        return this.mappedObjDeleted;
    }

    public void setAttrEditorActivated(boolean b) {
        this.attrEditorOn = b;
    }

    public boolean isAttrEditorActivated() {
        return this.attrEditorOn;
    }

    public void delArc(Arc bArc) {
        try {
            this.getGraph().delArc(bArc);
        }
        catch (TypeException e) {
            String msg = "Cannot delete\n";
            JOptionPane.showMessageDialog(null, msg + e.getMessage(), "Type Graph Error", 0);
        }
    }

    public void delNode(Node bNode) {
        try {
            this.getGraph().delNode(bNode);
        }
        catch (TypeException e) {
            String msg = "Cannot delete\n";
            JOptionPane.showMessageDialog(null, msg + e.getMessage(), "Type Graph Error", 0);
        }
    }

    public void delSelectedNode(EdNode eNode) {
        try {
            this.getGraph().delSelectedNode(eNode);
        }
        catch (TypeException e) {
            String msg = "Cannot delete\n";
            JOptionPane.showMessageDialog(null, msg + e.getMessage(), "Type Graph Error", 0);
        }
    }

    public void delSelectedArc(EdArc eArc) {
        try {
            this.getGraph().delSelectedArc(eArc);
        }
        catch (TypeException e) {
            String msg = "Cannot delete\n";
            JOptionPane.showMessageDialog(null, msg + e.getMessage(), "Type Graph Error", 0);
        }
    }

    public void deleteSelectedNodes() {
        try {
            this.getGraph().deleteSelectedNodes();
        }
        catch (TypeException e) {
            String msg = "Cannot delete\n";
            JOptionPane.showMessageDialog(null, msg + e.getMessage(), "Type Graph Error", 0);
        }
    }

    public void deleteSelectedArcs() {
        try {
            this.getGraph().deleteSelectedArcs();
        }
        catch (TypeException e) {
            String msg = "Cannot delete\n";
            JOptionPane.showMessageDialog(null, msg + e.getMessage(), "Type Graph Error", 0);
        }
    }

    public void deleteSelected() {
        try {
            this.getGraph().deleteSelected();
        }
        catch (TypeException e) {
            String msg = "Cannot delete\n";
            JOptionPane.showMessageDialog(null, msg + e.getMessage(), "Type Graph Error", 0);
        }
    }

    public void deleteAll() {
        try {
            this.getGraph().deleteAll();
        }
        catch (TypeException e) {
            String msg = "Cannot delete\n";
            JOptionPane.showMessageDialog(null, msg + e.getMessage(), "Type Graph Error", 0);
        }
    }

    public boolean deleteObj(int x, int y) {
        try {
            return this.getGraph().deleteObj(x, y);
        }
        catch (TypeException e) {
            String msg = "Cannot delete\n";
            JOptionPane.showMessageDialog(null, msg + e.getMessage(), "Type Graph Error", 0);
            return false;
        }
    }

    public void deleteObj(EdGraphObject ego) {
        if (this.getGraph().getBasisGraph().isTypeGraph()) {
            this.deleteTypeObject(ego);
        } else {
            try {
                this.getGraph().deleteObj(ego);
            }
            catch (TypeException e) {
                String msg = "Cannot delete\n";
                JOptionPane.showMessageDialog(null, msg + e.getMessage(), "Type Graph Error", 0);
            }
        }
    }

    private void deleteTypeObject(EdGraphObject obj) {
        if (this.getGraph().getTypeSet().getBasisTypeSet().removeTypeGraphObject(obj.getBasisObject()) == null) {
            try {
                this.getGraph().deleteObj(obj);
            }
            catch (TypeException e) {
                String msg = "Cannot delete\n";
                JOptionPane.showMessageDialog(null, msg + e.getMessage(), "Type Graph Error", 0);
            }
            return;
        }
        if (this.getGraph().getTypeSet().getBasisTypeSet().getLevelOfTypeGraphCheck() != 0) {
            JOptionPane.showMessageDialog(null, "Please disable the type graph before delete a type.", "Type graph enabled", 0);
            return;
        }
        Object[] options = new Object[]{"Delete", "Cancel"};
        int answer = JOptionPane.showOptionDialog(null, "Are you sure you want to delete this type?\nThere are objects of it.", "Warning", -1, 2, null, options, options[0]);
        if (answer == 0) {
            try {
                this.getGraph().deleteObj(obj);
            }
            catch (TypeException e) {
                String msg = "Cannot delete\n";
                JOptionPane.showMessageDialog(null, msg + e.getMessage(), "Type Graph Error", 0);
            }
        }
    }

    public void showMessage(String msg) {
        if (!msg.equals("")) {
            JOptionPane.showMessageDialog(null, msg, "", 0);
        }
    }
}

