/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.editor.impl.DrawLine;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class Line {
    public static final int MOVE_ANCHOR_SIZE = 8;
    public int x1;
    public int y1;
    public int x2;
    public int y2;
    public int xh;
    public int yh;
    private Point anchor;
    private Color col = new Color(0, 0, 0);

    public Line(int x1, int y1, int x2, int y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.xh = x1 - (x1 - x2) / 2;
        this.yh = y2 + (y1 - y2) / 2;
        this.anchor = new Point(this.xh, this.yh);
    }

    public void setAnchor(Point newAnchor) {
        this.anchor = newAnchor;
    }

    public void setColor(Color newColor) {
        this.col = newColor;
    }

    public Point getAnchor() {
        return this.anchor;
    }

    public void drawSolidLine(Graphics g) {
        this.drawLine(g);
    }

    public void drawColorSolidLine(Graphics grs) {
        Graphics2D g = (Graphics2D)grs;
        Point anch = this.myAnchor();
        g.setPaint(this.col);
        DrawLine drawLine1 = new DrawLine(g, 0, this.x1, this.y1, anch.x, anch.y);
        DrawLine drawLine2 = new DrawLine(g, 0, anch.x, anch.y, this.x2, this.y2);
    }

    public void drawColorDotLine(Graphics grs) {
        Graphics2D g = (Graphics2D)grs;
        Point anch = this.myAnchor();
        g.setPaint(this.col);
        DrawLine drawLine1 = new DrawLine(g, 2, this.x1, this.y1, anch.x, anch.y);
        DrawLine drawLine2 = new DrawLine(g, 2, anch.x, anch.y, this.x2, this.y2);
    }

    public void drawColorDashLine(Graphics grs) {
        Graphics2D g = (Graphics2D)grs;
        Point anch = this.myAnchor();
        g.setPaint(this.col);
        DrawLine drawLine1 = new DrawLine(g, 1, this.x1, this.y1, anch.x, anch.y);
        DrawLine drawLine2 = new DrawLine(g, 1, anch.x, anch.y, this.x2, this.y2);
    }

    public void drawColorDotLine(Graphics grs, int dots, int space) {
        Graphics2D g = (Graphics2D)grs;
        Point anch = this.myAnchor();
        if (this.x1 == this.x2) {
            this.drawColorVDotLine(g, dots, space);
        } else if (this.y1 == this.y2) {
            this.drawColorHDotLine(g, dots, space);
        } else {
            g.setPaint(this.col);
            DrawLine drawLine1 = new DrawLine(g, 2, this.x1, this.y1, anch.x, anch.y);
            DrawLine drawLine2 = new DrawLine(g, 2, anch.x, anch.y, this.x2, this.y2);
        }
    }

    public void drawColorDashLine(Graphics grs, int dots, int space) {
        Graphics2D g = (Graphics2D)grs;
        Point anch = this.myAnchor();
        if (this.x1 == this.x2) {
            this.drawColorVDotLine(g, dots, space);
        } else if (this.y1 == this.y2) {
            this.drawColorHDotLine(g, dots, space);
        } else {
            g.setPaint(this.col);
            DrawLine drawLine1 = new DrawLine(g, 1, this.x1, this.y1, anch.x, anch.y);
            DrawLine drawLine2 = new DrawLine(g, 1, anch.x, anch.y, this.x2, this.y2);
        }
    }

    public void drawDotLine(Graphics grs, int dots, int space) {
        Graphics2D g = (Graphics2D)grs;
        Point anch = this.myAnchor();
        if (this.x1 == this.x2) {
            this.drawVDotLine(g, dots, space);
        } else if (this.y1 == this.y2) {
            this.drawHDotLine(g, dots, space);
        } else {
            int y;
            int j;
            int i;
            int anf = this.x1;
            int end = this.x2;
            if (this.x2 < this.x1) {
                anf = this.x2;
                end = this.x1;
            }
            int a = (this.y1 - this.y2) / (this.x1 - this.x2);
            int b = this.y1 - this.x1 * (this.y1 - this.y2) / (this.x1 - this.x2);
            g.setPaint(Color.black);
            for (i = anf; i < anch.x; i += dots + space) {
                for (j = 0; j < dots; ++j) {
                    y = a * (i + j) + b;
                    g.drawLine(i + j, y, i + j, y);
                }
            }
            for (i = anch.x; i < end; i += dots + space) {
                for (j = 0; j < dots; ++j) {
                    y = a * (i + j) + b;
                    g.drawLine(i + j, y, i + j, y);
                }
            }
        }
    }

    public void drawMoveAnchor(Graphics grs) {
        if (this.anchor == null) {
            return;
        }
        Graphics2D g = (Graphics2D)grs;
        Color lastColor = g.getColor();
        g.setPaint(Color.black);
        g.fill(new Rectangle(this.anchor.x - 4, this.anchor.y - 4, 8, 8));
        g.setPaint(lastColor);
    }

    private Point myAnchor() {
        if (this.anchor == null) {
            return new Point(this.xh, this.yh);
        }
        return this.anchor;
    }

    private void drawLine(Graphics grs) {
        Graphics2D g = (Graphics2D)grs;
        Point anch = this.myAnchor();
        g.setColor(Color.black);
        g.setPaint(Color.black);
        g.drawLine(this.x1, this.y1, anch.x, anch.y);
        g.drawLine(anch.x, anch.y, this.x2, this.y2);
    }

    private void drawHDotLine(Graphics grs, int dots, int space) {
        int j;
        Graphics2D g = (Graphics2D)grs;
        Point anch = this.myAnchor();
        int anf = this.x1;
        int end = this.x2;
        if (this.x2 < this.x1) {
            anf = this.x2;
            end = this.x1;
        }
        g.setColor(Color.black);
        g.setPaint(Color.black);
        int i = anf;
        while (i < anch.x) {
            for (j = 0; j < dots; ++j) {
                g.drawLine(i + j, this.y1, i + j, this.y2);
            }
            i = i + dots + space;
        }
        for (i = anch.x; i < end; i += dots + space) {
            for (j = 0; j < dots; ++j) {
                g.drawLine(i + j, this.y1, i + j, this.y2);
            }
        }
    }

    private void drawVDotLine(Graphics grs, int dots, int space) {
        int j;
        int i;
        Graphics2D g = (Graphics2D)grs;
        Point anch = this.myAnchor();
        int anf = this.y1;
        int end = this.y2;
        if (this.y2 < this.y1) {
            anf = this.y2;
            end = this.y1;
        }
        g.setColor(Color.black);
        g.setPaint(Color.black);
        for (i = anf; i < anch.y; i += dots + space) {
            for (j = 0; j < dots; ++j) {
                g.drawLine(this.x1, i + j, this.x2, i + j);
            }
        }
        for (i = anch.y; i < end; i += dots + space) {
            for (j = 0; j < dots; ++j) {
                g.drawLine(this.x1, i + j, this.x2, i + j);
            }
        }
    }

    private void drawColorHDotLine(Graphics grs, int dots, int space) {
        int j;
        int i;
        Graphics2D g = (Graphics2D)grs;
        Point anch = this.myAnchor();
        int anf = this.x1;
        int end = this.x2;
        if (this.x2 < this.x1) {
            anf = this.x2;
            end = this.x1;
        }
        g.setColor(this.col);
        g.setPaint(this.col);
        for (i = anf; i < anch.x; i += dots + space) {
            for (j = 0; j < dots; ++j) {
                g.drawLine(i + j, this.y1, i + j, this.y1);
            }
        }
        for (i = anch.x; i < end; i += dots + space) {
            for (j = 0; j < dots; ++j) {
                g.drawLine(i + j, this.y1, i + j, this.y1);
            }
        }
    }

    private void drawColorVDotLine(Graphics grs, int dots, int space) {
        int j;
        int i;
        Graphics2D g = (Graphics2D)grs;
        Point anch = this.myAnchor();
        int anf = this.y1;
        int end = this.y2;
        if (this.y2 < this.y1) {
            anf = this.y2;
            end = this.y1;
        }
        g.setColor(this.col);
        g.setPaint(this.col);
        for (i = anf; i < anch.y; i += dots + space) {
            for (j = 0; j < dots; ++j) {
                g.drawLine(this.x1, i + j, this.x1, i + j);
            }
        }
        for (i = anch.y; i < end; i += dots + space) {
            for (j = 0; j < dots; ++j) {
                g.drawLine(this.x1, i + j, this.x1, i + j);
            }
        }
    }
}

